/*
 * Copyright 2019 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.widgets.client.cards;

import java.util.function.Function;

import com.google.gwt.dom.client.Style.HasCssName;
import elemental2.dom.HTMLElement;

public interface CardComponent {

    Function<String, Boolean> DEFAULT_FUNCTION = newTitle -> true;

    HasCssName getIcon();

    String getTitle();

    HTMLElement getContent();

    default String getUUID() {
        return "";
    }

    /**
     * This function is invoked when the card title is changing.
     * It must return <code>true</code> for applying the new title, or <code>false</code> for dismissing it.
     */
    default Function<String, Boolean> onTitleChanged() {
        return DEFAULT_FUNCTION;
    }
}
