/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.assets.dropdown;

import elemental2.dom.Element;
import elemental2.dom.HTMLOptionElement;
import elemental2.dom.HTMLSelectElement;
import elemental2.dom.Node;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.widgets.client.assets.dropdown.KieAssetsDropdown;
import org.kie.workbench.common.widgets.client.assets.dropdown.KieAssetsDropdownItem;
import org.uberfire.client.views.pfly.selectpicker.JQuerySelectPicker;
import org.uberfire.client.views.pfly.selectpicker.JQuerySelectPickerEvent;

@Dependent
@Templated
public class KieAssetsDropdownView
implements KieAssetsDropdown.View {
    public static final String HIDDEN_CSS_CLASS = "hidden";
    public static final String SELECT_PICKER_SUBTEXT_ATTRIBUTE = "data-subtext";
    @DataField(value="native-select")
    protected final HTMLSelectElement nativeSelect;
    protected final HTMLOptionElement htmlOptionElement;
    protected final TranslationService translationService;
    protected KieAssetsDropdown presenter;

    @Inject
    public KieAssetsDropdownView(HTMLSelectElement nativeSelect, HTMLOptionElement htmlOptionElement, TranslationService translationService) {
        this.nativeSelect = nativeSelect;
        this.htmlOptionElement = htmlOptionElement;
        this.translationService = translationService;
    }

    public void init(KieAssetsDropdown presenter) {
        this.presenter = presenter;
    }

    @PostConstruct
    public void init() {
        this.nativeSelect.hidden = false;
        this.dropdown().on("hidden.bs.select", this.getOnDropdownChangeHandler());
    }

    @Override
    public void addValue(KieAssetsDropdownItem entry) {
        this.nativeSelect.appendChild((Node)this.entryOption(entry));
    }

    @Override
    public void clear() {
        this.removeChildren((Element)this.nativeSelect);
        this.nativeSelect.appendChild((Node)this.selectOption());
        this.refreshSelectPicker();
    }

    @Override
    public void initialize() {
        this.dropdown().selectpicker("val", "");
        this.dropdown().selectpicker("show");
    }

    @Override
    public void refreshSelectPicker() {
        this.dropdown().selectpicker("refresh");
    }

    @Override
    public String getValue() {
        return this.dropdown().val();
    }

    protected JQuerySelectPicker.CallbackFunction getOnDropdownChangeHandler() {
        return this::onDropdownChangeHandlerMethod;
    }

    protected void onDropdownChangeHandlerMethod(JQuerySelectPickerEvent event) {
        this.presenter.onValueChanged();
    }

    protected HTMLOptionElement selectOption() {
        HTMLOptionElement option = this.makeHTMLOptionElement();
        option.text = this.translationService.format("KieAssetsDropdownView.Select", new Object[0]);
        option.value = "";
        return option;
    }

    protected HTMLOptionElement makeHTMLOptionElement() {
        return (HTMLOptionElement)this.htmlOptionElement.cloneNode(false);
    }

    protected JQuerySelectPicker dropdown() {
        return JQuerySelectPicker.$((Element)this.nativeSelect);
    }

    protected HTMLOptionElement entryOption(KieAssetsDropdownItem entry) {
        HTMLOptionElement option = this.makeHTMLOptionElement();
        option.text = entry.getText();
        option.value = entry.getValue();
        option.setAttribute(SELECT_PICKER_SUBTEXT_ATTRIBUTE, entry.getSubText());
        return option;
    }

    protected void removeChildren(Element element) {
        while (element.firstChild != null) {
            element.removeChild(element.firstChild);
        }
    }
}

