/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.util;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.shared.TimeZone;
import java.util.Date;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;

public class TimeZoneUtils {
    private static final String DATE_FORMAT = ApplicationPreferences.getDroolsDateFormat();
    public static final DateTimeFormat FORMATTER = DateTimeFormat.getFormat((String)DATE_FORMAT);

    public static Date convertFromServerTimeZone(Date date) {
        return FORMATTER.parse(TimeZoneUtils.formatWithServerTimeZone(date));
    }

    public static Date convertToServerTimeZone(Date date) {
        String convertedDate = TimeZoneUtils.internalFormatter().format(date, (TimeZone)com.google.gwt.i18n.client.TimeZone.createTimeZone((int)TimeZoneUtils.getClientOffset(date)));
        return TimeZoneUtils.internalFormatter().parse(convertedDate);
    }

    public static String formatWithServerTimeZone(Date date) {
        return FORMATTER.format(date, (TimeZone)TimeZoneUtils.getTimeZone());
    }

    static int getClientOffset(Date date) {
        int standardOffset = TimeZoneUtils.getTimeZone().getStandardOffset();
        int timezoneOffset = date.getTimezoneOffset();
        int timeZoneOffsetInMinutes = standardOffset - timezoneOffset * 2;
        return -timeZoneOffsetInMinutes;
    }

    public static com.google.gwt.i18n.client.TimeZone getTimeZone() {
        return com.google.gwt.i18n.client.TimeZone.createTimeZone((int)(-TimeZoneUtils.getKieTimezoneOffsetInMinutes()));
    }

    public static DateTimeFormat internalFormatter() {
        return DateTimeFormat.getFormat((String)"MM-dd-yyyy HH:mm:ss");
    }

    private static int getKieTimezoneOffsetInMinutes() {
        int offsetInMilliseconds = ApplicationPreferences.getKieTimezoneOffset();
        return offsetInMilliseconds / 1000 / 60;
    }
}

