/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.popups.launcher;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.workbench.common.widgets.client.popups.launcher.events.AppLauncherAddEvent;
import org.kie.workbench.common.widgets.client.popups.launcher.events.AppLauncherRemoveEvent;
import org.kie.workbench.common.widgets.client.popups.launcher.events.AppLauncherUpdatedEvent;

@ApplicationScoped
public class AppLauncherPresenter {
    @Inject
    private AppLauncherView view;
    @Inject
    private Event<AppLauncherUpdatedEvent> updatedEvent;
    private List<AppLauncherAddEvent> appLauncherAddEvents = new ArrayList<AppLauncherAddEvent>();

    public IsWidget getView() {
        return this.view;
    }

    public void onAppLauncherRemoveEvent(@Observes AppLauncherRemoveEvent event) {
        this.appLauncherAddEvents.stream().filter(e -> e.getAppName().equals(event.getAppName())).findFirst().ifPresent(e -> this.appLauncherAddEvents.remove(e));
        this.view.removeAllAppLauncher();
        this.appLauncherAddEvents.stream().forEach(e -> this.view.addAppLauncher(e.getAppName(), e.getUrl(), e.getIconClass()));
        this.updatedEvent.fire((Object)new AppLauncherUpdatedEvent());
    }

    public void onAppLauncherAddEvent(@Observes AppLauncherAddEvent event) {
        this.appLauncherAddEvents.add(event);
        this.view.addAppLauncher(event.getAppName(), event.getUrl(), event.getIconClass());
        this.updatedEvent.fire((Object)new AppLauncherUpdatedEvent());
    }

    public boolean isAppLauncherEmpty() {
        return this.appLauncherAddEvents.isEmpty();
    }

    public static interface AppLauncherView
    extends IsWidget {
        public void addAppLauncher(String var1, String var2, String var3);

        public void removeAllAppLauncher();
    }
}

