/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.configresource.client.widget.bound;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.soup.project.datamodel.imports.Import;
import org.kie.soup.project.datamodel.imports.Imports;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.datamodel.ImportAddedEvent;
import org.kie.workbench.common.widgets.client.datamodel.ImportRemovedEvent;
import org.kie.workbench.common.widgets.configresource.client.widget.bound.ImportsWidgetView;

public class ImportsWidgetPresenter
implements ImportsWidgetView.Presenter,
IsWidget {
    private ImportsWidgetView view;
    private Event<ImportAddedEvent> importAddedEvent;
    private Event<ImportRemovedEvent> importRemovedEvent;
    private final List<Import> internalFactTypes = new ArrayList<Import>();
    private final List<Import> externalFactTypes = new ArrayList<Import>();
    private final List<Import> modelFactTypes = new ArrayList<Import>();
    private AsyncPackageDataModelOracle dmo;
    private Imports importTypes;

    public ImportsWidgetPresenter() {
    }

    @Inject
    public ImportsWidgetPresenter(ImportsWidgetView view, Event<ImportAddedEvent> importAddedEvent, Event<ImportRemovedEvent> importRemovedEvent) {
        this.view = view;
        this.importAddedEvent = importAddedEvent;
        this.importRemovedEvent = importRemovedEvent;
        view.init(this);
    }

    @Override
    public void setContent(AsyncPackageDataModelOracle dmo, Imports importTypes, boolean isReadOnly) {
        this.dmo = (AsyncPackageDataModelOracle)PortablePreconditions.checkNotNull((String)"dmo", (Object)dmo);
        this.importTypes = (Imports)PortablePreconditions.checkNotNull((String)"importTypes", (Object)importTypes);
        this.getInternalFactTypes().clear();
        this.getExternalFactTypes().clear();
        this.getModelFactTypes().clear();
        for (String importType : dmo.getInternalFactTypes()) {
            this.getInternalFactTypes().add(new Import(importType.replaceAll("\\$", ".")));
        }
        for (String importType : dmo.getExternalFactTypes()) {
            this.getExternalFactTypes().add(new Import(importType.replaceAll("\\$", ".")));
        }
        this.getModelFactTypes().addAll(importTypes.getImports());
        this.getModelFactTypes().removeAll(this.getInternalFactTypes());
        this.getExternalFactTypes().removeAll(this.getModelFactTypes());
        this.view.setContent(this.getInternalFactTypes(), this.getExternalFactTypes(), this.getModelFactTypes(), isReadOnly);
        this.view.updateRenderedColumns();
    }

    @Override
    public boolean isInternalImport(Import importType) {
        return this.getInternalFactTypes().contains(importType);
    }

    @Override
    public void onAddImport(Import importType) {
        this.getExternalFactTypes().remove(importType);
        this.importTypes.getImports().add(importType);
        this.dmo.filter();
        this.importAddedEvent.fire((Object)new ImportAddedEvent(this.dmo, importType));
        this.view.updateRenderedColumns();
    }

    @Override
    public void onRemoveImport(Import importType) {
        this.getExternalFactTypes().add(importType);
        this.importTypes.getImports().remove(importType);
        this.dmo.filter();
        this.importRemovedEvent.fire((Object)new ImportRemovedEvent(this.dmo, importType));
        this.view.updateRenderedColumns();
    }

    @Override
    public Widget asWidget() {
        return this.view.asWidget();
    }

    List<Import> getInternalFactTypes() {
        return this.internalFactTypes;
    }

    List<Import> getExternalFactTypes() {
        return this.externalFactTypes;
    }

    List<Import> getModelFactTypes() {
        return this.modelFactTypes;
    }
}

