/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.configresource.client.widget.unbound;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.cellview.client.TextHeader;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Label;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.gwt.ButtonCell;
import org.gwtbootstrap3.client.ui.gwt.CellTable;
import org.kie.soup.project.datamodel.imports.Import;
import org.kie.workbench.common.widgets.configresource.client.resources.i18n.ImportConstants;
import org.kie.workbench.common.widgets.configresource.client.widget.BuiltInTypeImportHelper;
import org.kie.workbench.common.widgets.configresource.client.widget.Sorters;
import org.kie.workbench.common.widgets.configresource.client.widget.unbound.AddImportPopup;
import org.kie.workbench.common.widgets.configresource.client.widget.unbound.ImportsWidgetView;
import org.uberfire.client.mvp.LockRequiredEvent;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.ext.widgets.common.client.common.popups.YesNoCancelPopup;
import org.uberfire.mvp.ParameterizedCommand;

public class ImportsWidgetViewImpl
extends Composite
implements ImportsWidgetView {
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    @UiField
    Button addImportButton;
    @UiField(provided=true)
    CellTable<Import> table = new CellTable();
    private AddImportPopup addImportPopup;
    private Event<LockRequiredEvent> lockRequired;
    private List<Import> importTypes = new ArrayList<Import>();
    private ListDataProvider<Import> dataProvider = new ListDataProvider();
    private final Command addImportCommand = this.makeAddImportCommand();
    private final ParameterizedCommand<Import> removeImportCommand = this.makeRemoveImportCommand();
    private ImportsWidgetView.Presenter presenter;
    private boolean isReadOnly = false;
    final ButtonCell deleteImportButton = new ButtonCell(IconType.TRASH, ButtonType.DANGER, ButtonSize.SMALL);
    final Column<Import, String> deleteImportColumn = new Column<Import, String>((Cell)this.deleteImportButton){

        public String getValue(Import importType) {
            return ImportConstants.INSTANCE.remove();
        }

        public void render(Cell.Context context, Import object, SafeHtmlBuilder sb) {
            if (!BuiltInTypeImportHelper.isBuiltIn(object)) {
                super.render(context, (Object)object, sb);
            }
        }
    };

    public ImportsWidgetViewImpl() {
    }

    @Inject
    public ImportsWidgetViewImpl(AddImportPopup addImportPopup, Event<LockRequiredEvent> lockRequired) {
        this.addImportPopup = addImportPopup;
        this.lockRequired = lockRequired;
        this.setup();
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.addImportButton.setEnabled(false);
    }

    private void setup() {
        this.table.setStriped(true);
        this.table.setCondensed(true);
        this.table.setBordered(true);
        this.table.setEmptyTableWidget((Widget)new Label(ImportConstants.INSTANCE.noImportsDefined()));
        TextColumn<Import> importTypeColumn = new TextColumn<Import>(){

            public String getValue(Import importType) {
                return importType.getType();
            }
        };
        this.deleteImportColumn.setFieldUpdater((index, importType, value) -> {
            if (this.isReadOnly) {
                return;
            }
            YesNoCancelPopup confirm = YesNoCancelPopup.newYesNoCancelPopup((String)ImportConstants.INSTANCE.remove(), (String)ImportConstants.INSTANCE.promptForRemovalOfImport0(importType.getType()), () -> this.getRemoveImportCommand().execute(importType), () -> {}, null);
            confirm.show();
        });
        this.table.addColumn((Column)importTypeColumn, (Header)new TextHeader(ImportConstants.INSTANCE.importType()));
        this.table.addColumn(this.deleteImportColumn, ImportConstants.INSTANCE.remove());
        this.getDataProvider().addDataDisplay(this.table);
        this.getDataProvider().setList(this.importTypes);
    }

    public void init(ImportsWidgetView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setContent(List<Import> importTypes, boolean isReadOnly) {
        this.importTypes = importTypes;
        this.getDataProvider().setList(importTypes);
        this.getDataProvider().getList().sort(Sorters.sortByFQCN());
        this.addImportButton.setEnabled(!isReadOnly);
        this.isReadOnly = isReadOnly;
    }

    @UiHandler(value={"addImportButton"})
    public void onClickAddImportButton(ClickEvent event) {
        this.addImportPopup.setCommand(this.addImportCommand);
        this.addImportPopup.show();
    }

    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    public void hideBusyIndicator() {
        BusyPopup.close();
    }

    Command makeAddImportCommand() {
        return () -> {
            Import importType = new Import(this.addImportPopup.getImportType());
            this.getDataProvider().getList().add(importType);
            this.getDataProvider().getList().sort(Sorters.sortByFQCN());
            this.lockRequired.fire((Object)new LockRequiredEvent());
            this.updateRenderedColumns();
        };
    }

    Command getAddImportCommand() {
        return this.addImportCommand;
    }

    ParameterizedCommand<Import> makeRemoveImportCommand() {
        return i -> {
            this.getDataProvider().getList().remove(i);
            this.getDataProvider().getList().sort(Sorters.sortByFQCN());
            this.lockRequired.fire((Object)new LockRequiredEvent());
            this.updateRenderedColumns();
        };
    }

    ParameterizedCommand<Import> getRemoveImportCommand() {
        return this.removeImportCommand;
    }

    ListDataProvider<Import> getDataProvider() {
        return this.dataProvider;
    }

    @Override
    public void updateRenderedColumns() {
        boolean isAtLeastOneImportRemovable = this.getDataProvider().getList().stream().anyMatch(iType -> !BuiltInTypeImportHelper.isBuiltIn(iType));
        int columnCount = this.table.getColumnCount();
        if (isAtLeastOneImportRemovable && columnCount == 1) {
            this.table.addColumn(this.deleteImportColumn, ImportConstants.INSTANCE.remove());
        } else if (!isAtLeastOneImportRemovable && columnCount > 1) {
            this.table.removeColumn(this.deleteImportColumn);
        }
    }

    static interface Binder
    extends UiBinder<Widget, ImportsWidgetViewImpl> {
    }
}

