/*
 * Decompiled with CFR 0.152.
 */
package org.kiirun.joda.beans.gradle.tasks;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.DirectoryTree;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.util.GradleVersion;
import org.kiirun.joda.beans.gradle.JodaBeansExtension;

public abstract class AbstractJodaBeansTask
extends DefaultTask {
    private static final Version V1_5 = Version.from(Arrays.asList("1", "5"));
    private static final Version V1_8 = Version.from(Arrays.asList("1", "8"));
    private static final Version V2_7_1 = Version.from(Arrays.asList("2", "7", "1"));
    private static final Collection<String> CONFIGURATIONS_TO_SEARCH = Arrays.asList("compile", "compileClasspath");
    private static final String SOURCE_SETS_PROPERTY = "sourceSets";
    private static final String JODA_BEANS_CODE_GEN_CLASS = "org.joda.beans.gen.BeanCodeGen";
    private static final String DEFAULT_INDENT = "4";
    private static final String DEFAULT_STRING_VALUE = "";
    private static final boolean DEFAULT_STRICT_VALUE = false;
    private static final String DEFAULT_CONFIG_VALUE = "guava";
    private static final String GROUP = "JodaBeans";

    public final String getGroup() {
        return GROUP;
    }

    protected String getSourceDir() {
        String sourceDir = this.getPluginConfiguration().getSourceDir();
        if (sourceDir == null) {
            sourceDir = this.tryFindSourceSetPath("main");
        }
        return sourceDir != null ? sourceDir : DEFAULT_STRING_VALUE;
    }

    protected String getTestSourceDir() {
        String testSourceDir = this.getPluginConfiguration().getTestSourceDir();
        if (testSourceDir == null) {
            testSourceDir = this.tryFindSourceSetPath("test");
        }
        return testSourceDir != null ? testSourceDir : DEFAULT_STRING_VALUE;
    }

    private String tryFindSourceSetPath(String sourceSetName) {
        SourceSetContainer sourceSets;
        if (this.getProject().getPlugins().findPlugin(JavaPlugin.class) != null && (sourceSets = (SourceSetContainer)this.getProject().getProperties().get(SOURCE_SETS_PROPERTY)) != null) {
            return ((DirectoryTree)((SourceSet)sourceSets.getByName(sourceSetName)).getJava().getSrcDirTrees().iterator().next()).getDir().getAbsolutePath();
        }
        return null;
    }

    protected String getIndent() {
        String indent = this.getPluginConfiguration().getIndent();
        return indent != null ? indent : DEFAULT_INDENT;
    }

    protected String getPrefix() {
        String prefix = this.getPluginConfiguration().getPrefix();
        return prefix != null ? prefix : DEFAULT_STRING_VALUE;
    }

    protected String getConfig() {
        String configFile = this.getPluginConfiguration().getConfig();
        return configFile != null ? configFile : DEFAULT_STRING_VALUE;
    }

    protected Integer getVerbose() {
        return this.getPluginConfiguration().getVerbose();
    }

    protected boolean operateRecursive() {
        Boolean recursive = this.getPluginConfiguration().getRecursive();
        return recursive != null ? recursive : true;
    }

    protected boolean isStrict() {
        Boolean strict = this.getPluginConfiguration().isStrict();
        return strict != null ? strict : false;
    }

    protected Boolean getGenerated() {
        return this.getPluginConfiguration().getGenerated();
    }

    private JodaBeansExtension getPluginConfiguration() {
        return (JodaBeansExtension)this.getProject().getExtensions().getByName("jodabeans");
    }

    protected abstract String getExecutionType();

    protected int runBeanGenerator() {
        this.checkGradleVersion();
        this.getLogger().debug("Running JodaBeans " + this.getExecutionType() + " in directory: " + this.getSourceDir() + (this.getTestSourceDir().isEmpty() ? DEFAULT_STRING_VALUE : ", test directory:" + this.getTestSourceDir()));
        return new JodaBeansGenerator().run();
    }

    private void checkGradleVersion() {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"3.4")) < 0) {
            throw new GradleException("This plugin needs at least Gradle version 3.4+.");
        }
    }

    protected List<String> buildGeneratorArguments(Version jodaBeansVersion) {
        ArrayList<String> arguments = new ArrayList<String>();
        if (this.operateRecursive()) {
            arguments.add("-R");
        }
        if (this.getIndent() != null) {
            arguments.add("-indent=" + this.getIndent());
        }
        if (this.getPrefix() != null) {
            arguments.add("-prefix=" + this.getPrefix());
        }
        if (this.getVerbose() != null) {
            arguments.add((jodaBeansVersion.isAtLeast(V1_5) ? "-verbose=" : "-v=") + this.getVerbose());
        }
        if (this.getConfig() != null && !this.getConfig().isEmpty()) {
            if (jodaBeansVersion.isGreaterThan(V1_8)) {
                arguments.add("-config=" + this.getConfig());
            } else {
                this.getLogger().warn("Cannot use -config with Joda-Beans <= " + V1_8 + ", please adjust your dependency configuration accordingly.\n" + "Generator will use default of [" + DEFAULT_CONFIG_VALUE + "]");
            }
        }
        if (this.getGenerated() != null) {
            if (jodaBeansVersion.isAtLeast(V2_7_1)) {
                if (Boolean.TRUE.equals(this.getGenerated())) {
                    arguments.add("-generated");
                }
            } else {
                this.getLogger().warn("Cannot use -generated with Joda-Beans < " + V2_7_1 + ", please adjust your dependency configuration accordingly.\n");
            }
        }
        return arguments;
    }

    public static class Version
    implements Comparable<Version> {
        private int major = 0;
        private int minor = 0;
        private Integer micro = null;

        private Version() {
        }

        public static Version from(List<String> versionParts) {
            Version v = new Version();
            if (versionParts.size() >= 1) {
                v.major = Integer.parseInt(versionParts.get(0));
            }
            if (versionParts.size() >= 2) {
                v.minor = Integer.parseInt(versionParts.get(1));
            }
            if (versionParts.size() >= 3) {
                v.micro = Integer.parseInt(versionParts.get(2));
            }
            return v;
        }

        @Override
        public int compareTo(Version other) {
            int majorResult = Integer.compare(this.major, other.major);
            if (majorResult != 0) {
                return majorResult;
            }
            int minorResult = Integer.compare(this.minor, other.minor);
            if (minorResult != 0) {
                return minorResult;
            }
            return Integer.compare(this.micro != null ? this.micro : 0, other.micro != null ? other.micro : 0);
        }

        public boolean isAtLeast(Version other) {
            return this.compareTo(other) >= 0;
        }

        public boolean isGreaterThan(Version other) {
            return this.compareTo(other) > 0;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.major).append(".").append(this.minor);
            if (this.micro != null) {
                sb.append(".");
                sb.append(this.micro);
            }
            return sb.toString();
        }
    }

    private class JodaBeansGenerator {
        private Class<?> toolClass;
        private Version version;

        public JodaBeansGenerator() {
            ClassLoader classLoader = this.obtainClassLoader();
            try {
                this.toolClass = classLoader.loadClass(AbstractJodaBeansTask.JODA_BEANS_CODE_GEN_CLASS);
                this.version = Version.from(Arrays.asList(this.toolClass.getPackage().getImplementationVersion().replaceAll("-SNAPSHOT", AbstractJodaBeansTask.DEFAULT_STRING_VALUE).split("\\.")));
            }
            catch (Exception ex) {
                AbstractJodaBeansTask.this.getLogger().error("Skipping as Joda-Beans is not in the project compile classpath");
            }
        }

        public boolean isInitialized() {
            return this.toolClass != null;
        }

        private ClassLoader obtainClassLoader() {
            ArrayList<URL> compileClasspath = new ArrayList<URL>();
            for (String configName : CONFIGURATIONS_TO_SEARCH) {
                Configuration config = (Configuration)AbstractJodaBeansTask.this.getProject().getConfigurations().findByName(configName);
                if (config == null || !config.isCanBeResolved()) continue;
                for (File classpathFile : config.getFiles()) {
                    try {
                        compileClasspath.add(classpathFile.toURI().toURL());
                    }
                    catch (MalformedURLException e) {
                        AbstractJodaBeansTask.this.getLogger().debug("Skipping " + classpathFile.getAbsolutePath() + " from the compile classpath.");
                    }
                }
            }
            return new URLClassLoader(compileClasspath.toArray(new URL[compileClasspath.size()]), AbstractJodaBeansTask.class.getClassLoader());
        }

        public int run() {
            if (!this.isInitialized()) {
                return -1;
            }
            AbstractJodaBeansTask.this.getLogger().debug("Running JodaBeans " + this.version + " in directory: " + AbstractJodaBeansTask.this.getSourceDir() + (AbstractJodaBeansTask.this.getTestSourceDir().isEmpty() ? AbstractJodaBeansTask.DEFAULT_STRING_VALUE : ", test directory:" + AbstractJodaBeansTask.this.getTestSourceDir()));
            List<String> arguments = AbstractJodaBeansTask.this.buildGeneratorArguments(this.version);
            AbstractJodaBeansTask.this.getLogger().debug("Using JodaBeans " + this.version + " with arguments " + arguments);
            int result = this.runTool(this.toolClass, arguments);
            AbstractJodaBeansTask.this.getLogger().debug("JodaBeans " + AbstractJodaBeansTask.this.getExecutionType() + " successfully completed.");
            return result;
        }

        private int runTool(Class<?> toolClass, List<String> argsList) {
            String sourceDir = AbstractJodaBeansTask.this.getSourceDir();
            if (sourceDir.isEmpty()) {
                throw new GradleException("Source directory must be given and none could be autodetected!");
            }
            argsList.add(sourceDir);
            int count = this.invoke(toolClass, argsList);
            if (!AbstractJodaBeansTask.this.getTestSourceDir().isEmpty()) {
                argsList.set(argsList.size() - 1, AbstractJodaBeansTask.this.getTestSourceDir());
                count += this.invoke(toolClass, argsList);
            }
            return count;
        }

        private int invoke(Class<?> toolClass, List<String> argsList) {
            Method createFromArgsMethod = this.findCreateFromArgsMethod(toolClass);
            Method processMethod = this.findProcessMethod(toolClass);
            Object beanCodeGen = this.createBuilder(argsList, createFromArgsMethod);
            return this.invokeBuilder(processMethod, beanCodeGen);
        }

        private Object createBuilder(List<String> argsList, Method createFromArgsMethod) throws GradleException {
            String[] args = argsList.toArray(new String[argsList.size()]);
            try {
                return createFromArgsMethod.invoke(null, new Object[]{args});
            }
            catch (IllegalArgumentException ex) {
                throw new GradleException("Error invoking BeanCodeGen.createFromArgs()");
            }
            catch (IllegalAccessException ex) {
                throw new GradleException("Error invoking BeanCodeGen.createFromArgs()");
            }
            catch (InvocationTargetException ex) {
                throw new GradleException("Invalid Joda-Beans configuration: " + ex.getCause().getMessage(), ex.getCause());
            }
        }

        private int invokeBuilder(Method processMethod, Object beanCodeGen) throws GradleException {
            try {
                return (Integer)processMethod.invoke(beanCodeGen, new Object[0]);
            }
            catch (IllegalArgumentException ex) {
                throw new GradleException("Error invoking BeanCodeGen.process()");
            }
            catch (IllegalAccessException ex) {
                throw new GradleException("Error invoking BeanCodeGen.process()");
            }
            catch (InvocationTargetException ex) {
                throw new GradleException("Error while running Joda-Beans tool: " + ex.getCause().getMessage(), ex.getCause());
            }
        }

        private Method findCreateFromArgsMethod(Class<?> toolClass) {
            Method createFromArgsMethod = null;
            try {
                createFromArgsMethod = toolClass.getMethod("createFromArgs", String[].class);
            }
            catch (Exception ex) {
                throw new GradleException("Unable to find method BeanCodeGen.createFromArgs()");
            }
            return createFromArgsMethod;
        }

        private Method findProcessMethod(Class<?> toolClass) throws GradleException {
            Method processMethod = null;
            try {
                processMethod = toolClass.getMethod("process", new Class[0]);
            }
            catch (Exception ex) {
                throw new GradleException("Unable to find method BeanCodeGen.process()");
            }
            return processMethod;
        }
    }
}

