/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.account.api.user;

import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.Subscribe;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.joda.time.DateTimeZone;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.account.AccountTestSuiteWithEmbeddedDB;
import org.killbill.billing.account.AccountTestUtils;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountData;
import org.killbill.billing.account.api.DefaultAccount;
import org.killbill.billing.account.api.DefaultMutableAccountData;
import org.killbill.billing.account.api.MutableAccountData;
import org.killbill.billing.account.dao.AccountModelDao;
import org.killbill.billing.callcontext.DefaultCallContext;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.events.AccountCreationInternalEvent;
import org.killbill.billing.tenant.dao.TenantModelDao;
import org.killbill.billing.tenant.dao.TenantSqlDao;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.billing.util.entity.dao.EntityModelDao;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDefaultAccountUserApi
extends AccountTestSuiteWithEmbeddedDB {
    @Test(groups={"slow"}, description="Test Account search")
    public void testSearch() throws Exception {
        MutableAccountData mutableAccountData1 = AccountTestUtils.createAccountData();
        mutableAccountData1.setEmail("john@acme.com");
        mutableAccountData1.setCompanyName("Acme, Inc.");
        AccountModelDao account1ModelDao = new AccountModelDao(UUID.randomUUID(), (AccountData)mutableAccountData1);
        DefaultAccount accountData1 = new DefaultAccount(account1ModelDao);
        this.accountUserApi.createAccount((AccountData)accountData1, this.callContext);
        MutableAccountData mutableAccountData2 = AccountTestUtils.createAccountData();
        mutableAccountData2.setEmail("bob@gmail.com");
        mutableAccountData2.setCompanyName("Acme, Inc.");
        AccountModelDao account2ModelDao = new AccountModelDao(UUID.randomUUID(), (AccountData)mutableAccountData2);
        DefaultAccount accountData2 = new DefaultAccount(account2ModelDao);
        this.accountUserApi.createAccount((AccountData)accountData2, this.callContext);
        Pagination search1 = this.accountUserApi.searchAccounts("Inc.", Long.valueOf(0L), Long.valueOf(5L), (TenantContext)this.callContext);
        Assert.assertEquals((Object)search1.getCurrentOffset(), (Object)0L);
        Assert.assertNull((Object)search1.getNextOffset());
        Assert.assertEquals((Object)search1.getMaxNbRecords(), (Object)2L);
        Assert.assertEquals((Object)search1.getTotalNbRecords(), (Object)2L);
        Assert.assertEquals((int)ImmutableList.copyOf((Iterator)search1.iterator()).size(), (int)2);
        Pagination search2 = this.accountUserApi.searchAccounts("Inc.", Long.valueOf(0L), Long.valueOf(1L), (TenantContext)this.callContext);
        Assert.assertEquals((Object)search2.getCurrentOffset(), (Object)0L);
        Assert.assertEquals((Object)search2.getNextOffset(), (Object)1L);
        Assert.assertEquals((Object)search2.getMaxNbRecords(), (Object)2L);
        Assert.assertEquals((Object)search2.getTotalNbRecords(), (Object)2L);
        Assert.assertEquals((int)ImmutableList.copyOf((Iterator)search2.iterator()).size(), (int)1);
        Pagination search3 = this.accountUserApi.searchAccounts("acme.com", Long.valueOf(0L), Long.valueOf(5L), (TenantContext)this.callContext);
        Assert.assertEquals((Object)search3.getCurrentOffset(), (Object)0L);
        Assert.assertNull((Object)search3.getNextOffset());
        Assert.assertEquals((Object)search3.getMaxNbRecords(), (Object)2L);
        Assert.assertEquals((Object)search3.getTotalNbRecords(), (Object)1L);
        Assert.assertEquals((int)ImmutableList.copyOf((Iterator)search3.iterator()).size(), (int)1);
        Pagination search4 = this.accountUserApi.searchAccounts("acme.com", Long.valueOf(-1L), Long.valueOf(1L), (TenantContext)this.callContext);
        Assert.assertEquals((Object)search4.getCurrentOffset(), (Object)0L);
        Assert.assertNull((Object)search4.getNextOffset());
        Assert.assertNull((Object)search4.getMaxNbRecords());
        Assert.assertEquals((Object)search4.getTotalNbRecords(), (Object)0L);
        Assert.assertEquals((int)ImmutableList.copyOf((Iterator)search4.iterator()).size(), (int)0);
        Pagination search5 = this.accountUserApi.searchAccounts("john@acme.com", Long.valueOf(-1L), Long.valueOf(1L), (TenantContext)this.callContext);
        Assert.assertEquals((Object)search5.getCurrentOffset(), (Object)0L);
        Assert.assertNull((Object)search5.getNextOffset());
        Assert.assertNull((Object)search5.getMaxNbRecords());
        Assert.assertEquals((Object)search5.getTotalNbRecords(), (Object)1L);
        Assert.assertEquals((int)ImmutableList.copyOf((Iterator)search5.iterator()).size(), (int)1);
    }

    @Test(groups={"slow"}, description="Test Account creation generates an event")
    public void testBusEvents() throws Exception {
        final AccountEventHandler eventHandler = new AccountEventHandler();
        this.bus.register((Object)eventHandler);
        AccountModelDao accountModelDao = AccountTestUtils.createTestAccount();
        DefaultAccount defaultAccount = new DefaultAccount(accountModelDao);
        Account account = this.createAccount((AccountData)defaultAccount);
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return eventHandler.getAccountCreationInternalEvents().size() == 1;
            }
        });
        AccountCreationInternalEvent accountCreationInternalEvent = eventHandler.getAccountCreationInternalEvents().get(0);
        Assert.assertEquals((Object)accountCreationInternalEvent.getId(), (Object)account.getId());
        Assert.assertNotNull((Object)accountCreationInternalEvent.getSearchKey1());
        Assert.assertEquals((Object)accountCreationInternalEvent.getSearchKey2(), (Object)this.internalCallContext.getTenantRecordId());
    }

    @Test(groups={"slow"}, description="Test Account update with null values")
    public void testShouldBeAbleToPassNullForSomeFieldsToAvoidUpdate() throws Exception {
        Account account = this.createAccount((AccountData)new DefaultAccount(AccountTestUtils.createTestAccount()));
        DefaultMutableAccountData mutableAccountData = new DefaultMutableAccountData(null, null, null, 0, null, null, Boolean.valueOf(false), 0, null, null, null, null, null, null, null, null, null, null, null, null, false, false);
        String newAddress1 = UUID.randomUUID().toString();
        mutableAccountData.setAddress1(newAddress1);
        this.accountUserApi.updateAccount(account.getId(), (AccountData)mutableAccountData, this.callContext);
        Account retrievedAccount = this.accountUserApi.getAccountById(account.getId(), (TenantContext)this.callContext);
        Assert.assertEquals((String)retrievedAccount.getAddress1(), (String)newAddress1);
        Assert.assertEquals((String)retrievedAccount.getAddress2(), (String)account.getAddress2());
        Assert.assertEquals((Object)retrievedAccount.getCurrency(), (Object)account.getCurrency());
        Assert.assertEquals((String)retrievedAccount.getExternalKey(), (String)account.getExternalKey());
        Assert.assertEquals((Object)retrievedAccount.getBillCycleDayLocal(), (Object)account.getBillCycleDayLocal());
    }

    @Test(groups={"slow"}, expectedExceptions={IllegalArgumentException.class}, description="Test updating Account BCD does throws an exception")
    public void testShouldntBeAbleToUpdateBillCycleDay() throws Exception {
        Account account = this.createAccount((AccountData)new DefaultAccount(AccountTestUtils.createTestAccount()));
        MutableAccountData otherAccount = new DefaultAccount(account.getId(), (AccountData)account).toMutableAccountData();
        otherAccount.setBillCycleDayLocal(account.getBillCycleDayLocal() + 2);
        this.accountUserApi.updateAccount((Account)new DefaultAccount(account.getId(), (AccountData)otherAccount), this.callContext);
    }

    @Test(groups={"slow"}, expectedExceptions={IllegalArgumentException.class}, description="Test updating Account currency throws an exception")
    public void testShouldntBeAbleToUpdateCurrency() throws Exception {
        Account account = this.createAccount((AccountData)new DefaultAccount(AccountTestUtils.createTestAccount()));
        MutableAccountData otherAccount = new DefaultAccount(account.getId(), (AccountData)account).toMutableAccountData();
        otherAccount.setCurrency(Currency.GBP);
        this.accountUserApi.updateAccount((Account)new DefaultAccount(account.getId(), (AccountData)otherAccount), this.callContext);
    }

    @Test(groups={"slow"}, expectedExceptions={IllegalArgumentException.class}, description="Test updating Account externalKey throws an exception")
    public void testShouldntBeAbleToUpdateExternalKey() throws Exception {
        Account account = this.createAccount((AccountData)new DefaultAccount(AccountTestUtils.createTestAccount()));
        MutableAccountData otherAccount = new DefaultAccount(account.getId(), (AccountData)account).toMutableAccountData();
        otherAccount.setExternalKey(UUID.randomUUID().toString());
        this.accountUserApi.updateAccount((Account)new DefaultAccount(account.getId(), (AccountData)otherAccount), this.callContext);
    }

    @Test(groups={"slow"}, description="Test Account update to reset notes")
    public void testAccountResetAccountNotes() throws Exception {
        Account account = this.createAccount((AccountData)new DefaultAccount(AccountTestUtils.createTestAccount()));
        DefaultMutableAccountData mutableAccountData = new DefaultMutableAccountData((AccountData)account);
        mutableAccountData.setNotes(null);
        DefaultAccount newAccount = new DefaultAccount(account.getId(), (AccountData)mutableAccountData);
        this.accountUserApi.updateAccount((Account)newAccount, this.callContext);
        Account retrievedAccount = this.accountUserApi.getAccountById(account.getId(), (TenantContext)this.callContext);
        Assert.assertEquals((String)retrievedAccount.getName(), (String)account.getName());
        Assert.assertEquals((Object)retrievedAccount.getFirstNameLength(), (Object)account.getFirstNameLength());
        Assert.assertEquals((String)retrievedAccount.getEmail(), (String)account.getEmail());
        Assert.assertEquals((Object)retrievedAccount.getBillCycleDayLocal(), (Object)account.getBillCycleDayLocal());
        Assert.assertEquals((Object)retrievedAccount.getCurrency(), (Object)account.getCurrency());
        Assert.assertEquals((Object)retrievedAccount.getPaymentMethodId(), (Object)account.getPaymentMethodId());
        Assert.assertEquals((Object)retrievedAccount.getTimeZone(), (Object)account.getTimeZone());
        Assert.assertEquals((String)retrievedAccount.getLocale(), (String)account.getLocale());
        Assert.assertEquals((String)retrievedAccount.getAddress1(), (String)account.getAddress1());
        Assert.assertEquals((String)retrievedAccount.getAddress2(), (String)account.getAddress2());
        Assert.assertEquals((String)retrievedAccount.getCompanyName(), (String)account.getCompanyName());
        Assert.assertEquals((String)retrievedAccount.getCity(), (String)account.getCity());
        Assert.assertEquals((String)retrievedAccount.getStateOrProvince(), (String)account.getStateOrProvince());
        Assert.assertEquals((String)retrievedAccount.getPostalCode(), (String)account.getPostalCode());
        Assert.assertEquals((String)retrievedAccount.getCountry(), (String)account.getCountry());
        Assert.assertEquals((String)retrievedAccount.getPhone(), (String)account.getPhone());
        Assert.assertEquals((Object)retrievedAccount.isMigrated(), (Object)account.isMigrated());
        Assert.assertEquals((Object)retrievedAccount.isNotifiedForInvoices(), (Object)account.isNotifiedForInvoices());
        Assert.assertEquals((Object)retrievedAccount.getParentAccountId(), (Object)account.getParentAccountId());
        Assert.assertEquals((Object)retrievedAccount.isPaymentDelegatedToParent(), (Object)account.isPaymentDelegatedToParent());
        Assert.assertNull((Object)retrievedAccount.getNotes());
    }

    @Test(groups={"slow"}, description="Test failure on resetting externalKey", expectedExceptions={IllegalArgumentException.class})
    public void testAccountResetExternalKey() throws Exception {
        Account account = this.createAccount((AccountData)new DefaultAccount(AccountTestUtils.createTestAccount()));
        DefaultMutableAccountData mutableAccountData = new DefaultMutableAccountData((AccountData)account);
        mutableAccountData.setExternalKey(null);
        DefaultAccount newAccount = new DefaultAccount(account.getId(), (AccountData)mutableAccountData);
        this.accountUserApi.updateAccount((Account)newAccount, this.callContext);
    }

    @Test(groups={"slow"}, description="Test failure on changing externalKey", expectedExceptions={IllegalArgumentException.class})
    public void testAccountChangeExternalKey() throws Exception {
        Account account = this.createAccount((AccountData)new DefaultAccount(AccountTestUtils.createTestAccount()));
        DefaultMutableAccountData mutableAccountData = new DefaultMutableAccountData((AccountData)account);
        mutableAccountData.setExternalKey("somethingVeryDifferent");
        DefaultAccount newAccount = new DefaultAccount(account.getId(), (AccountData)mutableAccountData);
        this.accountUserApi.updateAccount((Account)newAccount, this.callContext);
    }

    @Test(groups={"slow"}, description="Test failure on resetting currency", expectedExceptions={IllegalArgumentException.class})
    public void testAccountResetCurrency() throws Exception {
        Account account = this.createAccount((AccountData)new DefaultAccount(AccountTestUtils.createTestAccount()));
        DefaultMutableAccountData mutableAccountData = new DefaultMutableAccountData((AccountData)account);
        mutableAccountData.setCurrency(null);
        DefaultAccount newAccount = new DefaultAccount(account.getId(), (AccountData)mutableAccountData);
        this.accountUserApi.updateAccount((Account)newAccount, this.callContext);
    }

    @Test(groups={"slow"}, description="Test failure on changing currency", expectedExceptions={IllegalArgumentException.class})
    public void testAccountChangeCurrency() throws Exception {
        Account account = this.createAccount((AccountData)new DefaultAccount(AccountTestUtils.createTestAccount()));
        DefaultMutableAccountData mutableAccountData = new DefaultMutableAccountData((AccountData)account);
        mutableAccountData.setCurrency(Currency.AFN);
        DefaultAccount newAccount = new DefaultAccount(account.getId(), (AccountData)mutableAccountData);
        this.accountUserApi.updateAccount((Account)newAccount, this.callContext);
    }

    @Test(groups={"slow"}, description="Test failure on resetting BCD", expectedExceptions={IllegalArgumentException.class})
    public void testAccountResetBCD() throws Exception {
        Account account = this.createAccount((AccountData)new DefaultAccount(AccountTestUtils.createTestAccount()));
        DefaultMutableAccountData mutableAccountData = new DefaultMutableAccountData((AccountData)account);
        mutableAccountData.setBillCycleDayLocal(0);
        DefaultAccount newAccount = new DefaultAccount(account.getId(), (AccountData)mutableAccountData);
        this.accountUserApi.updateAccount((Account)newAccount, this.callContext);
    }

    @Test(groups={"slow"}, description="Test failure on resetting timeZone", expectedExceptions={IllegalArgumentException.class})
    public void testAccountResetTimeZone() throws Exception {
        Account account = this.createAccount((AccountData)new DefaultAccount(AccountTestUtils.createTestAccount()));
        DefaultMutableAccountData mutableAccountData = new DefaultMutableAccountData((AccountData)account);
        mutableAccountData.setTimeZone(null);
        DefaultAccount newAccount = new DefaultAccount(account.getId(), (AccountData)mutableAccountData);
        this.accountUserApi.updateAccount((Account)newAccount, this.callContext);
    }

    @Test(groups={"slow"}, description="Test failure on changing timeZone", expectedExceptions={IllegalArgumentException.class})
    public void testAccountChangingTimeZone() throws Exception {
        Account account = this.createAccount((AccountData)new DefaultAccount(AccountTestUtils.createTestAccount()));
        DefaultMutableAccountData mutableAccountData = new DefaultMutableAccountData((AccountData)account);
        mutableAccountData.setTimeZone(DateTimeZone.UTC);
        DefaultAccount newAccount = new DefaultAccount(account.getId(), (AccountData)mutableAccountData);
        this.accountUserApi.updateAccount((Account)newAccount, this.callContext);
    }

    @Test(groups={"slow"}, description="Test Account create Parent and Child")
    public void testCreateParentAndChildAccounts() throws Exception {
        Account parentAccount = this.accountUserApi.createAccount((AccountData)new DefaultAccount(AccountTestUtils.createTestAccount()), this.callContext);
        AccountModelDao childAccountModel = AccountTestUtils.createTestAccount();
        childAccountModel.setParentAccountId(parentAccount.getId());
        childAccountModel.setIsPaymentDelegatedToParent(Boolean.valueOf(true));
        DefaultAccount childAccountData = new DefaultAccount(childAccountModel);
        Account childAccount = this.accountUserApi.createAccount((AccountData)childAccountData, this.callContext);
        Account retrievedChildAccount = this.accountUserApi.getAccountById(childAccount.getId(), (TenantContext)this.callContext);
        Assert.assertNull((Object)parentAccount.getParentAccountId());
        Assert.assertNotNull((Object)retrievedChildAccount.getParentAccountId());
        Assert.assertEquals((Object)retrievedChildAccount.getId(), (Object)childAccount.getId());
        Assert.assertEquals((Object)retrievedChildAccount.getParentAccountId(), (Object)parentAccount.getId());
        Assert.assertEquals((Object)retrievedChildAccount.isPaymentDelegatedToParent(), (Object)childAccount.isPaymentDelegatedToParent());
    }

    @Test(groups={"slow"}, description="Test Account create Child with a non existing Parent", expectedExceptions={AccountApiException.class}, expectedExceptionsMessageRegExp="Account does not exist for id .*")
    public void testCreateChildAccountWithInvalidParent() throws Exception {
        AccountModelDao childAccountModel = AccountTestUtils.createTestAccount();
        childAccountModel.setParentAccountId(UUID.randomUUID());
        DefaultAccount childAccountData = new DefaultAccount(childAccountModel);
        Account childAccount = this.accountUserApi.createAccount((AccountData)childAccountData, this.callContext);
    }

    @Test(groups={"slow"}, description="Test un- and re-parenting")
    public void testUnAndReParenting() throws Exception {
        AccountModelDao childAccountModelDao1 = AccountTestUtils.createTestAccount();
        Account childAccount1 = this.accountUserApi.createAccount((AccountData)new DefaultAccount(childAccountModelDao1), this.callContext);
        Assert.assertNull((Object)childAccount1.getParentAccountId());
        Assert.assertFalse((boolean)childAccount1.isPaymentDelegatedToParent());
        Account parentAccount = this.accountUserApi.createAccount((AccountData)new DefaultAccount(AccountTestUtils.createTestAccount()), this.callContext);
        Assert.assertNull((Object)parentAccount.getParentAccountId());
        Assert.assertFalse((boolean)parentAccount.isPaymentDelegatedToParent());
        List childrenAccounts = this.accountUserApi.getChildrenAccounts(parentAccount.getId(), (TenantContext)this.callContext);
        Assert.assertEquals((int)childrenAccounts.size(), (int)0);
        childAccountModelDao1.setId(childAccount1.getId());
        childAccountModelDao1.setParentAccountId(parentAccount.getId());
        childAccountModelDao1.setIsPaymentDelegatedToParent(Boolean.valueOf(true));
        this.accountUserApi.updateAccount((Account)new DefaultAccount(childAccountModelDao1), this.callContext);
        childAccount1 = this.accountUserApi.getAccountById(childAccount1.getId(), (TenantContext)this.callContext);
        Assert.assertEquals((Object)childAccount1.getParentAccountId(), (Object)parentAccount.getId());
        Assert.assertTrue((boolean)childAccount1.isPaymentDelegatedToParent());
        childrenAccounts = this.accountUserApi.getChildrenAccounts(parentAccount.getId(), (TenantContext)this.callContext);
        Assert.assertEquals((int)childrenAccounts.size(), (int)1);
        Assert.assertEquals((Object)((Account)childrenAccounts.get(0)).getId(), (Object)childAccount1.getId());
        childAccountModelDao1.setParentAccountId(null);
        childAccountModelDao1.setIsPaymentDelegatedToParent(Boolean.valueOf(false));
        this.accountUserApi.updateAccount((Account)new DefaultAccount(childAccountModelDao1), this.callContext);
        childAccount1 = this.accountUserApi.getAccountById(childAccount1.getId(), (TenantContext)this.callContext);
        Assert.assertNull((Object)childAccount1.getParentAccountId());
        Assert.assertFalse((boolean)childAccount1.isPaymentDelegatedToParent());
        childrenAccounts = this.accountUserApi.getChildrenAccounts(parentAccount.getId(), (TenantContext)this.callContext);
        Assert.assertEquals((int)childrenAccounts.size(), (int)0);
        AccountModelDao childAccountModelDao2 = AccountTestUtils.createTestAccount();
        Account childAccount2 = this.accountUserApi.createAccount((AccountData)new DefaultAccount(childAccountModelDao2), this.callContext);
        Assert.assertNull((Object)childAccount2.getParentAccountId());
        Assert.assertFalse((boolean)childAccount2.isPaymentDelegatedToParent());
        childAccountModelDao2.setId(childAccount2.getId());
        childAccountModelDao2.setParentAccountId(parentAccount.getId());
        childAccountModelDao2.setIsPaymentDelegatedToParent(Boolean.valueOf(true));
        this.accountUserApi.updateAccount((Account)new DefaultAccount(childAccountModelDao2), this.callContext);
        childAccount1 = this.accountUserApi.getAccountById(childAccount1.getId(), (TenantContext)this.callContext);
        Assert.assertNull((Object)childAccount1.getParentAccountId());
        Assert.assertFalse((boolean)childAccount1.isPaymentDelegatedToParent());
        childAccount2 = this.accountUserApi.getAccountById(childAccount2.getId(), (TenantContext)this.callContext);
        Assert.assertEquals((Object)childAccount2.getParentAccountId(), (Object)parentAccount.getId());
        Assert.assertTrue((boolean)childAccount2.isPaymentDelegatedToParent());
        childrenAccounts = this.accountUserApi.getChildrenAccounts(parentAccount.getId(), (TenantContext)this.callContext);
        Assert.assertEquals((int)childrenAccounts.size(), (int)1);
        Assert.assertEquals((Object)((Account)childrenAccounts.get(0)).getId(), (Object)childAccount2.getId());
    }

    @Test(groups={"slow"}, description="Test Account creation with External Key over limit")
    public void testCreateAccountWithExternalKeyOverLimit() throws Exception {
        AccountModelDao accountModelDao = AccountTestUtils.createTestAccount();
        accountModelDao.setExternalKey("Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis,.");
        DefaultAccount accountData = new DefaultAccount(accountModelDao);
        try {
            this.accountUserApi.createAccount((AccountData)accountData, this.callContext);
            Assert.fail();
        }
        catch (AccountApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.EXTERNAL_KEY_LIMIT_EXCEEDED.getCode());
        }
    }

    @Test(groups={"slow"}, description="Test Account creation with same External Key in different tenants")
    public void testCreateAccountWithSameExternalKeyInDifferentTenants() throws Exception {
        MutableAccountData accountData = AccountTestUtils.createAccountData();
        Account account1 = this.accountUserApi.createAccount((AccountData)accountData, this.callContext);
        try {
            this.accountUserApi.createAccount((AccountData)accountData, this.callContext);
            Assert.fail();
        }
        catch (AccountApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.ACCOUNT_ALREADY_EXISTS.getCode());
        }
        TenantSqlDao tenantSqlDao = (TenantSqlDao)this.dbi.onDemand(TenantSqlDao.class);
        TenantModelDao tenant2 = new TenantModelDao();
        tenantSqlDao.create((EntityModelDao)tenant2, (InternalCallContext)this.internalCallContext);
        DefaultCallContext callContext2 = new DefaultCallContext(tenant2.getId(), this.callContext.getUserName(), this.callContext.getCallOrigin(), this.callContext.getUserType(), this.callContext.getUserToken(), this.clock);
        Account account2 = this.accountUserApi.createAccount((AccountData)accountData, (CallContext)callContext2);
        Assert.assertEquals((String)account1.getExternalKey(), (String)account2.getExternalKey());
        Assert.assertNotEquals((Object)account1.getId(), (Object)account2.getId());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AccountEventHandler {
        private final List<AccountCreationInternalEvent> accountCreationInternalEvents = new LinkedList<AccountCreationInternalEvent>();

        private AccountEventHandler() {
        }

        @Subscribe
        public void handleAccountCreationInternalEvent(AccountCreationInternalEvent creationInternalEvent) {
            this.accountCreationInternalEvents.add(creationInternalEvent);
        }

        public List<AccountCreationInternalEvent> getAccountCreationInternalEvents() {
            return this.accountCreationInternalEvents;
        }
    }
}

