/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.account.dao;

import com.google.common.collect.ImmutableList;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import org.joda.time.DateTimeZone;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.AccountTestSuiteWithEmbeddedDB;
import org.killbill.billing.account.AccountTestUtils;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountData;
import org.killbill.billing.account.api.AccountEmail;
import org.killbill.billing.account.api.DefaultAccount;
import org.killbill.billing.account.api.DefaultAccountEmail;
import org.killbill.billing.account.api.DefaultMutableAccountData;
import org.killbill.billing.account.api.MutableAccountData;
import org.killbill.billing.account.dao.AccountEmailModelDao;
import org.killbill.billing.account.dao.AccountModelDao;
import org.killbill.billing.account.dao.AccountSqlDao;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.mock.MockAccountBuilder;
import org.killbill.billing.util.api.AuditLevel;
import org.killbill.billing.util.api.CustomFieldApiException;
import org.killbill.billing.util.api.TagApiException;
import org.killbill.billing.util.api.TagDefinitionApiException;
import org.killbill.billing.util.audit.AuditLog;
import org.killbill.billing.util.audit.ChangeType;
import org.killbill.billing.util.audit.DefaultAccountAuditLogs;
import org.killbill.billing.util.customfield.dao.CustomFieldModelDao;
import org.killbill.billing.util.dao.EntityHistoryModelDao;
import org.killbill.billing.util.dao.TableName;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.billing.util.entity.dao.EntityModelDao;
import org.killbill.billing.util.tag.DescriptiveTag;
import org.killbill.billing.util.tag.Tag;
import org.killbill.billing.util.tag.dao.TagDefinitionModelDao;
import org.killbill.billing.util.tag.dao.TagModelDao;
import org.testng.Assert;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestAccountDao
extends AccountTestSuiteWithEmbeddedDB {
    @Test(groups={"slow"}, description="Test Account: verify minimal set of required fields")
    public void testMinimalFields() throws Exception {
        String email = UUID.randomUUID().toString();
        String name = UUID.randomUUID().toString();
        DefaultMutableAccountData accountData = new DefaultMutableAccountData(null, email, name, 0, null, null, Boolean.valueOf(false), 0, null, null, null, null, null, null, null, null, null, null, null, null, false, true);
        AccountModelDao account = new AccountModelDao(UUID.randomUUID(), (AccountData)accountData);
        this.accountDao.create((EntityModelDao)account, (InternalCallContext)this.internalCallContext);
        AccountModelDao retrievedAccount = (AccountModelDao)this.accountDao.getById(account.getId(), (InternalTenantContext)this.internalCallContext);
        AccountTestUtils.checkAccountsEqual(retrievedAccount, account);
        Assert.assertEquals((String)retrievedAccount.getExternalKey(), (String)retrievedAccount.getId().toString());
        Assert.assertEquals((Object)retrievedAccount.getTimeZone(), (Object)DateTimeZone.UTC);
    }

    @Test(groups={"slow"}, description="Test Account: basic DAO calls")
    public void testBasic() throws AccountApiException {
        AccountModelDao account = AccountTestUtils.createTestAccount();
        this.accountDao.create((EntityModelDao)account, (InternalCallContext)this.internalCallContext);
        AccountModelDao retrievedAccount = this.accountDao.getAccountByKey(account.getExternalKey(), (InternalTenantContext)this.internalCallContext);
        AccountTestUtils.checkAccountsEqual(retrievedAccount, account);
        retrievedAccount = (AccountModelDao)this.accountDao.getById(retrievedAccount.getId(), (InternalTenantContext)this.internalCallContext);
        AccountTestUtils.checkAccountsEqual(retrievedAccount, account);
        Pagination allAccounts = this.accountDao.getAll((InternalTenantContext)this.internalCallContext);
        ImmutableList all = ImmutableList.copyOf((Iterable)allAccounts);
        Assert.assertNotNull((Object)all);
        Assert.assertEquals((int)all.size(), (int)1);
        AccountTestUtils.checkAccountsEqual((AccountModelDao)all.get(0), account);
        List auditLogsForAccount = this.auditDao.getAuditLogsForId(TableName.ACCOUNT, account.getId(), AuditLevel.FULL, (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)auditLogsForAccount.size(), (int)1);
        Assert.assertEquals((Object)((AuditLog)auditLogsForAccount.get(0)).getChangeType(), (Object)ChangeType.INSERT);
    }

    @Test(groups={"slow"}, description="Test Account: verify audits")
    public void testAudits() throws AccountApiException {
        AccountModelDao account1 = AccountTestUtils.createTestAccount();
        this.accountDao.create((EntityModelDao)account1, (InternalCallContext)this.internalCallContext);
        this.refreshCallContext(account1.getId());
        DefaultAccountAuditLogs auditLogsForAccount1ViaAccountRecordId1 = this.auditDao.getAuditLogsForAccountRecordId(AuditLevel.FULL, (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)auditLogsForAccount1ViaAccountRecordId1.getAuditLogsForAccount().size(), (int)1);
        Assert.assertEquals((Object)((AuditLog)auditLogsForAccount1ViaAccountRecordId1.getAuditLogsForAccount().get(0)).getChangeType(), (Object)ChangeType.INSERT);
        this.accountDao.updatePaymentMethod(account1.getId(), UUID.randomUUID(), (InternalCallContext)this.internalCallContext);
        AccountModelDao account2 = AccountTestUtils.createTestAccount();
        this.accountDao.create((EntityModelDao)account2, (InternalCallContext)this.internalCallContext);
        this.refreshCallContext(account2.getId());
        DefaultAccountAuditLogs auditLogsForAccount2ViaAccountRecordId = this.auditDao.getAuditLogsForAccountRecordId(AuditLevel.FULL, (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)auditLogsForAccount2ViaAccountRecordId.getAuditLogsForAccount().size(), (int)1);
        Assert.assertEquals((Object)((AuditLog)auditLogsForAccount2ViaAccountRecordId.getAuditLogsForAccount().get(0)).getChangeType(), (Object)ChangeType.INSERT);
        this.refreshCallContext(account1.getId());
        DefaultAccountAuditLogs auditLogsForAccount1ViaAccountRecordId2 = this.auditDao.getAuditLogsForAccountRecordId(AuditLevel.FULL, (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)auditLogsForAccount1ViaAccountRecordId2.getAuditLogsForAccount().size(), (int)2);
        Assert.assertEquals((Object)((AuditLog)auditLogsForAccount1ViaAccountRecordId2.getAuditLogsForAccount().get(0)).getChangeType(), (Object)ChangeType.INSERT);
        Assert.assertEquals((Object)((AuditLog)auditLogsForAccount1ViaAccountRecordId2.getAuditLogsForAccount().get(1)).getChangeType(), (Object)ChangeType.UPDATE);
    }

    @Test(groups={"slow"}, description="Test Account DAO: long numbers")
    public void testLongPhoneNumber() throws AccountApiException {
        AccountModelDao account = AccountTestUtils.createTestAccount("123456789012345678901234");
        this.accountDao.create((EntityModelDao)account, (InternalCallContext)this.internalCallContext);
        AccountModelDao retrievedAccount = this.accountDao.getAccountByKey(account.getExternalKey(), (InternalTenantContext)this.internalCallContext);
        AccountTestUtils.checkAccountsEqual(retrievedAccount, account);
    }

    @Test(groups={"slow"}, description="Test Account DAO: very long numbers", enabled=false)
    public void testOverlyLongPhoneNumber() throws AccountApiException {
        AccountModelDao account = AccountTestUtils.createTestAccount("12345678901234567890123456");
        try {
            this.accountDao.create((EntityModelDao)account, (InternalCallContext)this.internalCallContext);
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof SQLException));
        }
    }

    @Test(groups={"slow"}, description="Test Account DAO: custom fields")
    public void testCustomFields() throws CustomFieldApiException {
        UUID accountId = UUID.randomUUID();
        String fieldName = UUID.randomUUID().toString().substring(0, 4);
        String fieldValue = UUID.randomUUID().toString();
        this.customFieldDao.create((EntityModelDao)new CustomFieldModelDao(this.internalCallContext.getCreatedDate(), fieldName, fieldValue, accountId, ObjectType.ACCOUNT), (InternalCallContext)this.internalCallContext);
        List customFieldMap = this.customFieldDao.getCustomFieldsForObject(accountId, ObjectType.ACCOUNT, (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)customFieldMap.size(), (int)1);
        CustomFieldModelDao customField = (CustomFieldModelDao)customFieldMap.get(0);
        Assert.assertEquals((String)customField.getFieldName(), (String)fieldName);
        Assert.assertEquals((String)customField.getFieldValue(), (String)fieldValue);
    }

    @Test(groups={"slow"}, description="Test Account DAO: tags")
    public void testTags() throws TagApiException, TagDefinitionApiException {
        AccountModelDao account = AccountTestUtils.createTestAccount();
        TagDefinitionModelDao tagDefinition = this.tagDefinitionDao.create(UUID.randomUUID().toString().substring(0, 4), UUID.randomUUID().toString(), (InternalCallContext)this.internalCallContext);
        DescriptiveTag tag = new DescriptiveTag(tagDefinition.getId(), ObjectType.ACCOUNT, account.getId(), this.internalCallContext.getCreatedDate());
        this.tagDao.create((EntityModelDao)new TagModelDao((Tag)tag), (InternalCallContext)this.internalCallContext);
        List tags = this.tagDao.getTagsForObject(account.getId(), ObjectType.ACCOUNT, false, (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)tags.size(), (int)1);
        Assert.assertEquals((Object)((TagModelDao)tags.get(0)).getTagDefinitionId(), (Object)tagDefinition.getId());
        Assert.assertEquals((Object)((TagModelDao)tags.get(0)).getObjectId(), (Object)account.getId());
        Assert.assertEquals((Object)((TagModelDao)tags.get(0)).getObjectType(), (Object)ObjectType.ACCOUNT);
    }

    @Test(groups={"slow"}, description="Test Account DAO: retrieve by externalKey")
    public void testGetIdFromKey() throws AccountApiException {
        AccountModelDao account = AccountTestUtils.createTestAccount();
        this.accountDao.create((EntityModelDao)account, (InternalCallContext)this.internalCallContext);
        UUID accountId = this.accountDao.getIdFromKey(account.getExternalKey(), (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((Object)accountId, (Object)account.getId());
    }

    @Test(groups={"slow"}, expectedExceptions={AccountApiException.class}, description="Test Account DAO: retrieve by null externalKey throws an exception")
    public void testGetIdFromKeyForNullKey() throws AccountApiException {
        this.accountDao.getIdFromKey(null, (InternalTenantContext)this.internalCallContext);
    }

    @Test(groups={"slow"}, description="Test Account DAO: basic update (1)")
    public void testUpdate() throws Exception {
        AccountModelDao account = AccountTestUtils.createTestAccount();
        this.accountDao.create((EntityModelDao)account, (InternalCallContext)this.internalCallContext);
        AccountModelDao createdAccount = this.accountDao.getAccountByKey(account.getExternalKey(), (InternalTenantContext)this.internalCallContext);
        List<EntityHistoryModelDao<AccountModelDao, Account>> history1 = this.getAccountHistory(createdAccount.getRecordId());
        Assert.assertEquals((int)history1.size(), (int)1);
        Assert.assertEquals((Object)history1.get(0).getChangeType(), (Object)ChangeType.INSERT);
        Assert.assertEquals((Object)((AccountModelDao)history1.get(0).getEntity()).getAccountRecordId(), (Object)createdAccount.getRecordId());
        Assert.assertEquals((Object)((AccountModelDao)history1.get(0).getEntity()).getTenantRecordId(), (Object)createdAccount.getTenantRecordId());
        Assert.assertEquals((String)((AccountModelDao)history1.get(0).getEntity()).getExternalKey(), (String)createdAccount.getExternalKey());
        Assert.assertEquals((Object)((AccountModelDao)history1.get(0).getEntity()).getMigrated(), (Object)createdAccount.getMigrated());
        Assert.assertEquals((Object)((AccountModelDao)history1.get(0).getEntity()).getIsNotifiedForInvoices(), (Object)createdAccount.getIsNotifiedForInvoices());
        Assert.assertEquals((Object)((AccountModelDao)history1.get(0).getEntity()).getTimeZone(), (Object)createdAccount.getTimeZone());
        Assert.assertEquals((String)((AccountModelDao)history1.get(0).getEntity()).getLocale(), (String)createdAccount.getLocale());
        Account accountData = new MockAccountBuilder((AccountData)new DefaultAccount(account)).migrated(false).isNotifiedForInvoices(false).timeZone(DateTimeZone.forID((String)"Australia/Darwin")).locale("FR-CA").build();
        AccountModelDao updatedAccount = new AccountModelDao(account.getId(), (AccountData)accountData);
        this.accountDao.update(updatedAccount, (InternalCallContext)this.internalCallContext);
        AccountModelDao retrievedAccount = this.accountDao.getAccountByKey(account.getExternalKey(), (InternalTenantContext)this.internalCallContext);
        AccountTestUtils.checkAccountsEqual(retrievedAccount, updatedAccount);
        List<EntityHistoryModelDao<AccountModelDao, Account>> history2 = this.getAccountHistory(createdAccount.getRecordId());
        Assert.assertEquals((int)history2.size(), (int)2);
        Assert.assertEquals((Object)history2.get(0).getChangeType(), (Object)ChangeType.INSERT);
        Assert.assertEquals((Object)history2.get(1).getChangeType(), (Object)ChangeType.UPDATE);
        Assert.assertEquals((Object)((AccountModelDao)history2.get(1).getEntity()).getAccountRecordId(), (Object)retrievedAccount.getRecordId());
        Assert.assertEquals((Object)((AccountModelDao)history2.get(1).getEntity()).getTenantRecordId(), (Object)retrievedAccount.getTenantRecordId());
        Assert.assertEquals((String)((AccountModelDao)history2.get(1).getEntity()).getExternalKey(), (String)retrievedAccount.getExternalKey());
        Assert.assertEquals((Object)((AccountModelDao)history2.get(1).getEntity()).getMigrated(), (Object)retrievedAccount.getMigrated());
        Assert.assertEquals((Object)((AccountModelDao)history2.get(1).getEntity()).getIsNotifiedForInvoices(), (Object)retrievedAccount.getIsNotifiedForInvoices());
        Assert.assertEquals((Object)((AccountModelDao)history2.get(1).getEntity()).getTimeZone(), (Object)retrievedAccount.getTimeZone());
        Assert.assertEquals((String)((AccountModelDao)history2.get(1).getEntity()).getLocale(), (String)retrievedAccount.getLocale());
        Account accountData2 = new MockAccountBuilder((AccountData)new DefaultAccount(updatedAccount)).isNotifiedForInvoices(true).locale("en_US").build();
        AccountModelDao updatedAccount2 = new AccountModelDao(account.getId(), (AccountData)accountData2);
        this.accountDao.update(updatedAccount2, (InternalCallContext)this.internalCallContext);
        AccountModelDao retrievedAccount2 = this.accountDao.getAccountByKey(account.getExternalKey(), (InternalTenantContext)this.internalCallContext);
        AccountTestUtils.checkAccountsEqual(retrievedAccount2, updatedAccount2);
        List<EntityHistoryModelDao<AccountModelDao, Account>> history3 = this.getAccountHistory(createdAccount.getRecordId());
        Assert.assertEquals((int)history3.size(), (int)3);
        Assert.assertEquals((Object)history3.get(0).getChangeType(), (Object)ChangeType.INSERT);
        Assert.assertEquals((Object)history3.get(1).getChangeType(), (Object)ChangeType.UPDATE);
        Assert.assertEquals((Object)history3.get(2).getChangeType(), (Object)ChangeType.UPDATE);
        Assert.assertEquals((Object)((AccountModelDao)history3.get(2).getEntity()).getAccountRecordId(), (Object)retrievedAccount2.getRecordId());
        Assert.assertEquals((Object)((AccountModelDao)history3.get(2).getEntity()).getTenantRecordId(), (Object)retrievedAccount2.getTenantRecordId());
        Assert.assertEquals((String)((AccountModelDao)history3.get(2).getEntity()).getExternalKey(), (String)retrievedAccount2.getExternalKey());
        Assert.assertEquals((Object)((AccountModelDao)history3.get(2).getEntity()).getMigrated(), (Object)retrievedAccount2.getMigrated());
        Assert.assertEquals((Object)((AccountModelDao)history3.get(2).getEntity()).getIsNotifiedForInvoices(), (Object)retrievedAccount2.getIsNotifiedForInvoices());
        Assert.assertEquals((Object)((AccountModelDao)history3.get(2).getEntity()).getTimeZone(), (Object)retrievedAccount2.getTimeZone());
        Assert.assertEquals((String)((AccountModelDao)history3.get(2).getEntity()).getLocale(), (String)retrievedAccount2.getLocale());
    }

    @Test(groups={"slow"}, description="Test Account DAO: payment method update")
    public void testUpdatePaymentMethod() throws Exception {
        AccountModelDao account = AccountTestUtils.createTestAccount();
        this.accountDao.create((EntityModelDao)account, (InternalCallContext)this.internalCallContext);
        UUID newPaymentMethodId = UUID.randomUUID();
        this.accountDao.updatePaymentMethod(account.getId(), newPaymentMethodId, (InternalCallContext)this.internalCallContext);
        AccountModelDao newAccount = (AccountModelDao)this.accountDao.getById(account.getId(), (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((Object)newAccount.getPaymentMethodId(), (Object)newPaymentMethodId);
        this.accountDao.updatePaymentMethod(account.getId(), null, (InternalCallContext)this.internalCallContext);
        AccountModelDao newAccountWithPMNull = (AccountModelDao)this.accountDao.getById(account.getId(), (InternalTenantContext)this.internalCallContext);
        Assert.assertNull((Object)newAccountWithPMNull.getPaymentMethodId());
    }

    @Test(groups={"slow"}, description="Test Account DAO: basic update (2)")
    public void testShouldBeAbleToUpdateSomeFields() throws Exception {
        AccountModelDao account = AccountTestUtils.createTestAccount();
        this.accountDao.create((EntityModelDao)account, (InternalCallContext)this.internalCallContext);
        MutableAccountData otherAccount = new DefaultAccount(account).toMutableAccountData();
        otherAccount.setAddress1(UUID.randomUUID().toString());
        otherAccount.setEmail(UUID.randomUUID().toString());
        AccountModelDao newAccount = new AccountModelDao(account.getId(), (AccountData)otherAccount);
        this.accountDao.update(newAccount, (InternalCallContext)this.internalCallContext);
        AccountModelDao retrievedAccount = (AccountModelDao)this.accountDao.getById(account.getId(), (InternalTenantContext)this.internalCallContext);
        AccountTestUtils.checkAccountsEqual(retrievedAccount, newAccount);
    }

    @Test(groups={"slow"}, description="Test Account DAO: BCD of 0")
    public void testShouldBeAbleToHandleBCDOfZero() throws Exception {
        AccountModelDao account = AccountTestUtils.createTestAccount(0);
        this.accountDao.create((EntityModelDao)account, (InternalCallContext)this.internalCallContext);
        AccountModelDao retrievedAccount = (AccountModelDao)this.accountDao.getById(account.getId(), (InternalTenantContext)this.internalCallContext);
        AccountTestUtils.checkAccountsEqual(retrievedAccount, account);
    }

    @Test(groups={"slow"}, description="Test Account DAO: duplicate emails throws an exception")
    public void testHandleDuplicateEmails() throws AccountApiException {
        UUID accountId = UUID.randomUUID();
        DefaultAccountEmail email = new DefaultAccountEmail(accountId, "test@gmail.com");
        Assert.assertEquals((int)this.accountDao.getEmailsByAccountId(accountId, (InternalTenantContext)this.internalCallContext).size(), (int)0);
        AccountEmailModelDao accountEmailModelDao = new AccountEmailModelDao((AccountEmail)email);
        this.accountDao.addEmail(accountEmailModelDao, (InternalCallContext)this.internalCallContext);
        Assert.assertEquals((int)this.accountDao.getEmailsByAccountId(accountId, (InternalTenantContext)this.internalCallContext).size(), (int)1);
        try {
            this.accountDao.addEmail(accountEmailModelDao, (InternalCallContext)this.internalCallContext);
            Assert.fail();
        }
        catch (AccountApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.ACCOUNT_EMAIL_ALREADY_EXISTS.getCode());
        }
    }

    @Test(groups={"slow"}, description="Test Account DAO: add and remove email")
    public void testAddRemoveAccountEmail() throws AccountApiException {
        UUID accountId = UUID.randomUUID();
        DefaultAccountEmail email = new DefaultAccountEmail(accountId, "test@gmail.com");
        this.accountDao.addEmail(new AccountEmailModelDao((AccountEmail)email), (InternalCallContext)this.internalCallContext);
        List accountEmails = this.accountDao.getEmailsByAccountId(accountId, (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)accountEmails.size(), (int)1);
        Assert.assertEquals((Object)((AccountEmailModelDao)accountEmails.get(0)).getAccountId(), (Object)accountId);
        Assert.assertEquals((String)((AccountEmailModelDao)accountEmails.get(0)).getEmail(), (String)email.getEmail());
        List auditLogsForAccountEmail = this.auditDao.getAuditLogsForId(TableName.ACCOUNT_EMAIL, email.getId(), AuditLevel.FULL, (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)auditLogsForAccountEmail.size(), (int)1);
        Assert.assertEquals((Object)((AuditLog)auditLogsForAccountEmail.get(0)).getChangeType(), (Object)ChangeType.INSERT);
        this.accountDao.removeEmail(new AccountEmailModelDao((AccountEmail)email), (InternalCallContext)this.internalCallContext);
        Assert.assertEquals((int)this.accountDao.getEmailsByAccountId(accountId, (InternalTenantContext)this.internalCallContext).size(), (int)0);
    }

    @Test(groups={"slow"}, description="Test Account DAO: add and remove multiple emails")
    public void testAddAndRemoveMultipleAccountEmails() throws AccountApiException {
        UUID accountId = UUID.randomUUID();
        String email1 = UUID.randomUUID().toString();
        String email2 = UUID.randomUUID().toString();
        Assert.assertEquals((int)this.accountDao.getEmailsByAccountId(accountId, (InternalTenantContext)this.internalCallContext).size(), (int)0);
        DefaultAccountEmail accountEmail1 = new DefaultAccountEmail(accountId, email1);
        this.accountDao.addEmail(new AccountEmailModelDao((AccountEmail)accountEmail1), (InternalCallContext)this.internalCallContext);
        List firstEmails = this.accountDao.getEmailsByAccountId(accountId, (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)firstEmails.size(), (int)1);
        Assert.assertEquals((Object)((AccountEmailModelDao)firstEmails.get(0)).getAccountId(), (Object)accountId);
        Assert.assertEquals((String)((AccountEmailModelDao)firstEmails.get(0)).getEmail(), (String)email1);
        DefaultAccountEmail accountEmail2 = new DefaultAccountEmail(accountId, email2);
        this.accountDao.addEmail(new AccountEmailModelDao((AccountEmail)accountEmail2), (InternalCallContext)this.internalCallContext);
        List secondEmails = this.accountDao.getEmailsByAccountId(accountId, (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)secondEmails.size(), (int)2);
        Assert.assertTrue((boolean)((AccountEmailModelDao)secondEmails.get(0)).getAccountId().equals(accountId));
        Assert.assertTrue((boolean)((AccountEmailModelDao)secondEmails.get(1)).getAccountId().equals(accountId));
        Assert.assertTrue((((AccountEmailModelDao)secondEmails.get(0)).getEmail().equals(email1) || ((AccountEmailModelDao)secondEmails.get(0)).getEmail().equals(email2) ? 1 : 0) != 0);
        Assert.assertTrue((((AccountEmailModelDao)secondEmails.get(1)).getEmail().equals(email1) || ((AccountEmailModelDao)secondEmails.get(1)).getEmail().equals(email2) ? 1 : 0) != 0);
        this.accountDao.removeEmail(new AccountEmailModelDao((AccountEmail)accountEmail1), (InternalCallContext)this.internalCallContext);
        List thirdEmails = this.accountDao.getEmailsByAccountId(accountId, (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)thirdEmails.size(), (int)1);
        Assert.assertEquals((Object)((AccountEmailModelDao)thirdEmails.get(0)).getAccountId(), (Object)accountId);
        Assert.assertEquals((String)((AccountEmailModelDao)thirdEmails.get(0)).getEmail(), (String)email2);
        List auditLogsForAccountEmail1 = this.auditDao.getAuditLogsForId(TableName.ACCOUNT_EMAIL, accountEmail1.getId(), AuditLevel.FULL, (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)auditLogsForAccountEmail1.size(), (int)2);
        Assert.assertEquals((Object)((AuditLog)auditLogsForAccountEmail1.get(0)).getChangeType(), (Object)ChangeType.INSERT);
        Assert.assertEquals((Object)((AuditLog)auditLogsForAccountEmail1.get(1)).getChangeType(), (Object)ChangeType.DELETE);
        List auditLogsForAccountEmail2 = this.auditDao.getAuditLogsForId(TableName.ACCOUNT_EMAIL, accountEmail2.getId(), AuditLevel.FULL, (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)auditLogsForAccountEmail2.size(), (int)1);
        Assert.assertEquals((Object)((AuditLog)auditLogsForAccountEmail2.get(0)).getChangeType(), (Object)ChangeType.INSERT);
    }

    private List<EntityHistoryModelDao<AccountModelDao, Account>> getAccountHistory(Long accountRecordId) {
        AccountSqlDao accountSqlDao = (AccountSqlDao)this.dbi.onDemand(AccountSqlDao.class);
        return accountSqlDao.getHistoryForTargetRecordId(accountRecordId.longValue(), (InternalCallContext)this.internalCallContext);
    }
}

