/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.account.api;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.ImmutableAccountData;
import org.killbill.billing.account.dao.AccountModelDao;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.util.account.AccountDateTimeUtils;
import org.killbill.billing.util.cache.ExternalizableInput;
import org.killbill.billing.util.cache.ExternalizableOutput;
import org.killbill.billing.util.cache.MapperHolder;
import org.killbill.billing.util.entity.Entity;
import org.killbill.billing.util.entity.dao.TimeZoneAwareEntity;

public class DefaultImmutableAccountData
implements ImmutableAccountData,
Externalizable {
    private static final long serialVersionUID = 8117686452347277415L;
    private UUID id;
    private String externalKey;
    private Currency currency;
    private DateTimeZone timeZone;
    private DateTimeZone fixedOffsetTimeZone;
    private DateTime referenceTime;

    public DefaultImmutableAccountData() {
    }

    public DefaultImmutableAccountData(UUID id, String externalKey, Currency currency, DateTimeZone timeZone, DateTimeZone fixedOffsetTimeZone, DateTime referenceTime) {
        this.id = id;
        this.externalKey = externalKey;
        this.currency = currency;
        this.timeZone = timeZone;
        this.fixedOffsetTimeZone = fixedOffsetTimeZone;
        this.referenceTime = referenceTime;
    }

    public DefaultImmutableAccountData(Account account) {
        this(account.getId(), account.getExternalKey(), account.getCurrency(), account.getTimeZone(), AccountDateTimeUtils.getFixedOffsetTimeZone((Account)account), AccountDateTimeUtils.getReferenceDateTime((Entity)account));
    }

    public DefaultImmutableAccountData(AccountModelDao account) {
        this(account.getId(), account.getExternalKey(), account.getCurrency(), account.getTimeZone(), AccountDateTimeUtils.getFixedOffsetTimeZone((TimeZoneAwareEntity)account), AccountDateTimeUtils.getReferenceDateTime((Entity)account));
    }

    public UUID getId() {
        return this.id;
    }

    public String getExternalKey() {
        return this.externalKey;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public DateTimeZone getTimeZone() {
        return this.timeZone;
    }

    @Deprecated
    public UUID getParentAccountId() {
        throw new UnsupportedOperationException("WILL BE REMOVED IN 0.20.0");
    }

    @Deprecated
    public Boolean isPaymentDelegatedToParent() {
        throw new UnsupportedOperationException("WILL BE REMOVED IN 0.20.0");
    }

    public DateTimeZone getFixedOffsetTimeZone() {
        return this.fixedOffsetTimeZone;
    }

    public DateTime getReferenceTime() {
        return this.referenceTime;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultImmutableAccountData{");
        sb.append("id=").append(this.id);
        sb.append(", externalKey='").append(this.externalKey).append('\'');
        sb.append(", currency=").append(this.currency);
        sb.append(", timeZone=").append(this.timeZone);
        sb.append(", fixedOffsetTimeZone=").append(this.fixedOffsetTimeZone);
        sb.append(", referenceTime=").append(this.referenceTime);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultImmutableAccountData that = (DefaultImmutableAccountData)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.externalKey != null ? !this.externalKey.equals(that.externalKey) : that.externalKey != null) {
            return false;
        }
        if (this.currency != that.currency) {
            return false;
        }
        if (this.timeZone != null ? !this.timeZone.equals((Object)that.timeZone) : that.timeZone != null) {
            return false;
        }
        if (this.fixedOffsetTimeZone != null ? !this.fixedOffsetTimeZone.equals((Object)that.fixedOffsetTimeZone) : that.fixedOffsetTimeZone != null) {
            return false;
        }
        return this.referenceTime != null ? this.referenceTime.compareTo((ReadableInstant)that.referenceTime) == 0 : that.referenceTime == null;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.externalKey != null ? this.externalKey.hashCode() : 0);
        result = 31 * result + (this.currency != null ? this.currency.hashCode() : 0);
        result = 31 * result + (this.timeZone != null ? this.timeZone.hashCode() : 0);
        result = 31 * result + (this.fixedOffsetTimeZone != null ? this.fixedOffsetTimeZone.hashCode() : 0);
        result = 31 * result + (this.referenceTime != null ? this.referenceTime.hashCode() : 0);
        return result;
    }

    public void readExternal(ObjectInput in) throws IOException {
        MapperHolder.mapper().readerForUpdating((Object)this).readValue((InputStream)new ExternalizableInput(in));
    }

    public void writeExternal(ObjectOutput oo) throws IOException {
        MapperHolder.mapper().writeValue((OutputStream)new ExternalizableOutput(oo), (Object)this);
    }
}

