/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.account.api.svcs;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountData;
import org.killbill.billing.account.api.AccountEmail;
import org.killbill.billing.account.api.AccountInternalApi;
import org.killbill.billing.account.api.DefaultAccount;
import org.killbill.billing.account.api.DefaultAccountEmail;
import org.killbill.billing.account.api.ImmutableAccountData;
import org.killbill.billing.account.api.ImmutableAccountInternalApi;
import org.killbill.billing.account.api.MutableAccountData;
import org.killbill.billing.account.api.user.DefaultAccountApiBase;
import org.killbill.billing.account.dao.AccountDao;
import org.killbill.billing.account.dao.AccountEmailModelDao;
import org.killbill.billing.account.dao.AccountModelDao;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.util.cache.AccountBCDCacheLoader;
import org.killbill.billing.util.cache.Cachable;
import org.killbill.billing.util.cache.CacheController;
import org.killbill.billing.util.cache.CacheControllerDispatcher;
import org.killbill.billing.util.cache.CacheLoaderArgument;
import org.killbill.billing.util.dao.NonEntityDao;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAccountInternalApi
extends DefaultAccountApiBase
implements AccountInternalApi {
    private final ImmutableAccountInternalApi immutableAccountInternalApi;
    private final AccountDao accountDao;
    private final CacheController<UUID, Integer> bcdCacheController;

    @Inject
    public DefaultAccountInternalApi(ImmutableAccountInternalApi immutableAccountInternalApi, AccountDao accountDao, NonEntityDao nonEntityDao, CacheControllerDispatcher cacheControllerDispatcher) {
        super(accountDao, nonEntityDao, cacheControllerDispatcher);
        this.immutableAccountInternalApi = immutableAccountInternalApi;
        this.accountDao = accountDao;
        this.bcdCacheController = cacheControllerDispatcher.getCacheController(Cachable.CacheType.ACCOUNT_BCD);
    }

    @Override
    public Account getAccountById(UUID accountId, InternalTenantContext context) throws AccountApiException {
        return super.getAccountById(accountId, context);
    }

    @Override
    public Account getAccountByKey(String key, InternalTenantContext context) throws AccountApiException {
        return super.getAccountByKey(key, context);
    }

    @Override
    public Account getAccountByRecordId(Long recordId, InternalTenantContext context) throws AccountApiException {
        return super.getAccountByRecordId(recordId, context);
    }

    public void updateBCD(String externalKey, int bcd, InternalCallContext context) throws AccountApiException {
        Account currentAccount = this.getAccountByKey(externalKey, (InternalTenantContext)context);
        if (currentAccount == null) {
            throw new AccountApiException(ErrorCode.ACCOUNT_DOES_NOT_EXIST_FOR_KEY, new Object[]{externalKey});
        }
        if (currentAccount.getBillCycleDayLocal() != 0) {
            throw new AccountApiException(ErrorCode.ACCOUNT_UPDATE_FAILED, new Object[0]);
        }
        MutableAccountData mutableAccountData = currentAccount.toMutableAccountData();
        mutableAccountData.setBillCycleDayLocal(bcd);
        AccountModelDao accountToUpdate = new AccountModelDao(currentAccount.getId(), (AccountData)mutableAccountData);
        this.bcdCacheController.remove((Object)currentAccount.getId());
        this.bcdCacheController.putIfAbsent((Object)currentAccount.getId(), (Object)new Integer(bcd));
        this.accountDao.update(accountToUpdate, context);
    }

    public int getBCD(UUID accountId, InternalTenantContext context) throws AccountApiException {
        CacheLoaderArgument arg = this.createBCDCacheLoaderArgument(context);
        Integer result = (Integer)this.bcdCacheController.get((Object)accountId, arg);
        return result != null ? result : 0;
    }

    public List<AccountEmail> getEmails(UUID accountId, InternalTenantContext context) {
        return ImmutableList.copyOf((Collection)Collections2.transform(this.accountDao.getEmailsByAccountId(accountId, context), (Function)new Function<AccountEmailModelDao, AccountEmail>(){

            public AccountEmail apply(AccountEmailModelDao input) {
                return new DefaultAccountEmail(input);
            }
        }));
    }

    public void removePaymentMethod(UUID accountId, InternalCallContext context) throws AccountApiException {
        this.updatePaymentMethod(accountId, null, context);
    }

    public void updatePaymentMethod(UUID accountId, UUID paymentMethodId, InternalCallContext context) throws AccountApiException {
        this.accountDao.updatePaymentMethod(accountId, paymentMethodId, context);
    }

    public UUID getByRecordId(Long recordId, InternalTenantContext context) throws AccountApiException {
        AccountModelDao accountModelDao = this.getAccountModelDaoByRecordId(recordId, context);
        return accountModelDao.getId();
    }

    public ImmutableAccountData getImmutableAccountDataById(UUID accountId, InternalTenantContext context) throws AccountApiException {
        return this.immutableAccountInternalApi.getImmutableAccountDataById(accountId, context);
    }

    public ImmutableAccountData getImmutableAccountDataByRecordId(Long recordId, InternalTenantContext context) throws AccountApiException {
        return this.immutableAccountInternalApi.getImmutableAccountDataByRecordId(recordId, context);
    }

    private AccountModelDao getAccountModelDaoByRecordId(Long recordId, InternalTenantContext context) throws AccountApiException {
        AccountModelDao accountModelDao = (AccountModelDao)this.accountDao.getByRecordId(recordId, context);
        if (accountModelDao == null) {
            throw new AccountApiException(ErrorCode.ACCOUNT_DOES_NOT_EXIST_FOR_RECORD_ID, new Object[]{recordId});
        }
        return accountModelDao;
    }

    private CacheLoaderArgument createBCDCacheLoaderArgument(InternalTenantContext context) {
        AccountBCDCacheLoader.LoaderCallback loaderCallback = new AccountBCDCacheLoader.LoaderCallback(){

            public Integer loadAccountBCD(UUID accountId, InternalTenantContext context) {
                Integer result = DefaultAccountInternalApi.this.accountDao.getAccountBCD(accountId, context);
                if (result != null) {
                    result = result.equals(0) ? null : result;
                }
                return result;
            }
        };
        Object[] args = new Object[]{loaderCallback};
        ObjectType irrelevant = null;
        return new CacheLoaderArgument(irrelevant, args, context);
    }

    public List<Account> getChildrenAccounts(UUID parentAccountId, InternalCallContext context) throws AccountApiException {
        return ImmutableList.copyOf((Collection)Collections2.transform(this.accountDao.getAccountsByParentId(parentAccountId, (InternalTenantContext)context), (Function)new Function<AccountModelDao, Account>(){

            public Account apply(AccountModelDao input) {
                return new DefaultAccount(input);
            }
        }));
    }
}

