/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.account.api.user;

import java.util.UUID;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.ObjectType;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.DefaultAccount;
import org.killbill.billing.account.api.DefaultImmutableAccountData;
import org.killbill.billing.account.api.ImmutableAccountData;
import org.killbill.billing.account.dao.AccountDao;
import org.killbill.billing.account.dao.AccountModelDao;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.util.cache.Cachable;
import org.killbill.billing.util.cache.CacheController;
import org.killbill.billing.util.cache.CacheControllerDispatcher;
import org.killbill.billing.util.dao.NonEntityDao;

public class DefaultAccountApiBase {
    private final AccountDao accountDao;
    private final CacheController<Long, ImmutableAccountData> accountCacheController;
    private final CacheController<String, Long> recordIdCacheController;
    private final NonEntityDao nonEntityDao;

    public DefaultAccountApiBase(AccountDao accountDao, NonEntityDao nonEntityDao, CacheControllerDispatcher cacheControllerDispatcher) {
        this.accountDao = accountDao;
        this.nonEntityDao = nonEntityDao;
        this.accountCacheController = cacheControllerDispatcher.getCacheController(Cachable.CacheType.ACCOUNT_IMMUTABLE);
        this.recordIdCacheController = cacheControllerDispatcher.getCacheController(Cachable.CacheType.RECORD_ID);
    }

    protected Account getAccountById(UUID accountId, InternalTenantContext context) throws AccountApiException {
        Long recordId = this.nonEntityDao.retrieveRecordIdFromObject(accountId, ObjectType.ACCOUNT, this.recordIdCacheController);
        Account account = this.getAccountByRecordIdInternal(recordId, context);
        if (account == null) {
            throw new AccountApiException(ErrorCode.ACCOUNT_DOES_NOT_EXIST_FOR_ID, new Object[]{accountId});
        }
        this.accountCacheController.putIfAbsent((Object)recordId, (Object)new DefaultImmutableAccountData(account));
        return account;
    }

    protected Account getAccountByKey(String key, InternalTenantContext context) throws AccountApiException {
        AccountModelDao accountModelDao = this.accountDao.getAccountByKey(key, context);
        if (accountModelDao == null) {
            throw new AccountApiException(ErrorCode.ACCOUNT_DOES_NOT_EXIST_FOR_KEY, new Object[]{key});
        }
        DefaultAccount account = new DefaultAccount(accountModelDao);
        Long recordId = this.nonEntityDao.retrieveRecordIdFromObject(account.getId(), ObjectType.ACCOUNT, this.recordIdCacheController);
        this.accountCacheController.putIfAbsent((Object)recordId, (Object)new DefaultImmutableAccountData(account));
        return account;
    }

    protected Account getAccountByRecordId(Long recordId, InternalTenantContext context) throws AccountApiException {
        Account account = this.getAccountByRecordIdInternal(recordId, context);
        if (account == null) {
            throw new AccountApiException(ErrorCode.ACCOUNT_DOES_NOT_EXIST_FOR_RECORD_ID, new Object[]{recordId});
        }
        return account;
    }

    protected Account getAccountByRecordIdInternal(Long recordId, InternalTenantContext context) {
        AccountModelDao accountModelDao = (AccountModelDao)this.accountDao.getByRecordId(recordId, context);
        return accountModelDao != null ? new DefaultAccount(accountModelDao) : null;
    }
}

