/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.account.api.user;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountData;
import org.killbill.billing.account.api.AccountEmail;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.account.api.DefaultAccount;
import org.killbill.billing.account.api.DefaultAccountEmail;
import org.killbill.billing.account.api.ImmutableAccountData;
import org.killbill.billing.account.api.ImmutableAccountInternalApi;
import org.killbill.billing.account.api.user.DefaultAccountApiBase;
import org.killbill.billing.account.dao.AccountDao;
import org.killbill.billing.account.dao.AccountEmailModelDao;
import org.killbill.billing.account.dao.AccountModelDao;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.util.cache.CacheControllerDispatcher;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.dao.NonEntityDao;
import org.killbill.billing.util.entity.Pagination;
import org.killbill.billing.util.entity.dao.DefaultPaginationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAccountUserApi
extends DefaultAccountApiBase
implements AccountUserApi {
    private final ImmutableAccountInternalApi immutableAccountInternalApi;
    private final InternalCallContextFactory internalCallContextFactory;
    private final AccountDao accountDao;

    @Inject
    public DefaultAccountUserApi(ImmutableAccountInternalApi immutableAccountInternalApi, AccountDao accountDao, NonEntityDao nonEntityDao, CacheControllerDispatcher cacheControllerDispatcher, InternalCallContextFactory internalCallContextFactory) {
        super(accountDao, nonEntityDao, cacheControllerDispatcher);
        this.immutableAccountInternalApi = immutableAccountInternalApi;
        this.internalCallContextFactory = internalCallContextFactory;
        this.accountDao = accountDao;
    }

    public Account getAccountByKey(String key, TenantContext context) throws AccountApiException {
        InternalTenantContext internalTenantContext = this.internalCallContextFactory.createInternalTenantContextWithoutAccountRecordId(context);
        return this.getAccountByKey(key, internalTenantContext);
    }

    public Account getAccountById(UUID id, TenantContext context) throws AccountApiException {
        InternalTenantContext internalTenantContext = this.internalCallContextFactory.createInternalTenantContext(id, context);
        return this.getAccountById(id, internalTenantContext);
    }

    public Account createAccount(AccountData data, CallContext context) throws AccountApiException {
        ImmutableAccountData immutableAccountData;
        if (data.getExternalKey() != null && this.getIdFromKey(data.getExternalKey(), (TenantContext)context) != null) {
            throw new AccountApiException(ErrorCode.ACCOUNT_ALREADY_EXISTS, new Object[]{data.getExternalKey()});
        }
        InternalCallContext internalContext = this.internalCallContextFactory.createInternalCallContextWithoutAccountRecordId(context);
        if (data.getParentAccountId() != null && (immutableAccountData = this.immutableAccountInternalApi.getImmutableAccountDataById(data.getParentAccountId(), (InternalTenantContext)internalContext)) == null) {
            throw new AccountApiException(ErrorCode.ACCOUNT_DOES_NOT_EXIST_FOR_ID, new Object[]{data.getParentAccountId()});
        }
        AccountModelDao account = new AccountModelDao(data);
        if (null != account.getExternalKey() && account.getExternalKey().length() > 255) {
            throw new AccountApiException(ErrorCode.EXTERNAL_KEY_LIMIT_EXCEEDED, new Object[0]);
        }
        this.accountDao.create(account, this.internalCallContextFactory.createInternalCallContextWithoutAccountRecordId(context));
        return new DefaultAccount(account);
    }

    public Pagination<Account> searchAccounts(final String searchKey, final Long offset, final Long limit, final TenantContext context) {
        return DefaultPaginationHelper.getEntityPaginationNoException((Long)limit, (DefaultPaginationHelper.SourcePaginationBuilder)new DefaultPaginationHelper.SourcePaginationBuilder<AccountModelDao, AccountApiException>(){

            public Pagination<AccountModelDao> build() {
                return DefaultAccountUserApi.this.accountDao.searchAccounts(searchKey, offset, limit, DefaultAccountUserApi.this.internalCallContextFactory.createInternalTenantContextWithoutAccountRecordId(context));
            }
        }, (Function)new Function<AccountModelDao, Account>(){

            public Account apply(AccountModelDao accountModelDao) {
                return new DefaultAccount(accountModelDao);
            }
        });
    }

    public Pagination<Account> getAccounts(final Long offset, final Long limit, final TenantContext context) {
        return DefaultPaginationHelper.getEntityPaginationNoException((Long)limit, (DefaultPaginationHelper.SourcePaginationBuilder)new DefaultPaginationHelper.SourcePaginationBuilder<AccountModelDao, AccountApiException>(){

            public Pagination<AccountModelDao> build() {
                return DefaultAccountUserApi.this.accountDao.get(offset, limit, DefaultAccountUserApi.this.internalCallContextFactory.createInternalTenantContextWithoutAccountRecordId(context));
            }
        }, (Function)new Function<AccountModelDao, Account>(){

            public Account apply(AccountModelDao accountModelDao) {
                return new DefaultAccount(accountModelDao);
            }
        });
    }

    public UUID getIdFromKey(String externalKey, TenantContext context) throws AccountApiException {
        return this.accountDao.getIdFromKey(externalKey, this.internalCallContextFactory.createInternalTenantContextWithoutAccountRecordId(context));
    }

    public void updateAccount(Account account, CallContext context) throws AccountApiException {
        DefaultAccount input = new DefaultAccount(account.getId(), (AccountData)account);
        Account currentAccount = this.getAccountById(input.getId(), (TenantContext)context);
        if (currentAccount == null) {
            throw new AccountApiException(ErrorCode.ACCOUNT_DOES_NOT_EXIST_FOR_ID, new Object[]{input.getId()});
        }
        input.validateAccountUpdateInput(currentAccount, true);
        AccountModelDao updatedAccountModelDao = new AccountModelDao(currentAccount.getId(), (AccountData)input);
        this.accountDao.update(updatedAccountModelDao, this.internalCallContextFactory.createInternalCallContext(updatedAccountModelDao.getId(), context));
    }

    public void updateAccount(UUID accountId, AccountData accountData, CallContext context) throws AccountApiException {
        Account currentAccount = this.getAccountById(accountId, (TenantContext)context);
        if (currentAccount == null) {
            throw new AccountApiException(ErrorCode.ACCOUNT_DOES_NOT_EXIST_FOR_ID, new Object[]{accountId});
        }
        this.updateAccount(currentAccount, accountData, context);
    }

    public void updateAccount(String externalKey, AccountData accountData, CallContext context) throws AccountApiException {
        Account currentAccount = this.getAccountByKey(externalKey, (TenantContext)context);
        if (currentAccount == null) {
            throw new AccountApiException(ErrorCode.ACCOUNT_DOES_NOT_EXIST_FOR_KEY, new Object[]{externalKey});
        }
        this.updateAccount(currentAccount, accountData, context);
    }

    private void updateAccount(Account currentAccount, AccountData accountData, CallContext context) throws AccountApiException {
        DefaultAccount updatedAccount = new DefaultAccount(currentAccount.getId(), accountData);
        Account mergedAccount = updatedAccount.mergeWithDelegate(currentAccount);
        AccountModelDao updatedAccountModelDao = new AccountModelDao(currentAccount.getId(), (AccountData)mergedAccount);
        this.accountDao.update(updatedAccountModelDao, this.internalCallContextFactory.createInternalCallContext(updatedAccountModelDao.getId(), context));
    }

    public List<AccountEmail> getEmails(UUID accountId, TenantContext context) {
        return ImmutableList.copyOf((Collection)Collections2.transform(this.accountDao.getEmailsByAccountId(accountId, this.internalCallContextFactory.createInternalTenantContextWithoutAccountRecordId(context)), (Function)new Function<AccountEmailModelDao, AccountEmail>(){

            public AccountEmail apply(AccountEmailModelDao input) {
                return new DefaultAccountEmail(input);
            }
        }));
    }

    public void addEmail(UUID accountId, AccountEmail email, CallContext context) throws AccountApiException {
        this.accountDao.addEmail(new AccountEmailModelDao(email), this.internalCallContextFactory.createInternalCallContext(accountId, context));
    }

    public void removeEmail(UUID accountId, AccountEmail email, CallContext context) {
        this.accountDao.removeEmail(new AccountEmailModelDao(email, false), this.internalCallContextFactory.createInternalCallContext(accountId, context));
    }

    public List<Account> getChildrenAccounts(UUID parentAccountId, TenantContext context) throws AccountApiException {
        return ImmutableList.copyOf((Collection)Collections2.transform(this.accountDao.getAccountsByParentId(parentAccountId, this.internalCallContextFactory.createInternalTenantContextWithoutAccountRecordId(context)), (Function)new Function<AccountModelDao, Account>(){

            public Account apply(AccountModelDao input) {
                return new DefaultAccount(input);
            }
        }));
    }
}

