/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.account.dao;

import com.google.common.base.MoreObjects;
import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountData;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.util.UUIDs;
import org.killbill.billing.util.dao.TableName;
import org.killbill.billing.util.entity.dao.EntityModelDao;
import org.killbill.billing.util.entity.dao.EntityModelDaoBase;
import org.killbill.billing.util.entity.dao.TimeZoneAwareEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccountModelDao
extends EntityModelDaoBase
implements TimeZoneAwareEntity,
EntityModelDao<Account> {
    private String externalKey;
    private String email;
    private String name;
    private Integer firstNameLength;
    private Currency currency;
    private UUID parentAccountId;
    private Boolean isPaymentDelegatedToParent;
    private int billingCycleDayLocal;
    private UUID paymentMethodId;
    private DateTimeZone timeZone;
    private String locale;
    private String address1;
    private String address2;
    private String companyName;
    private String city;
    private String stateOrProvince;
    private String country;
    private String postalCode;
    private String phone;
    private String notes;
    private Boolean migrated;
    private Boolean isNotifiedForInvoices;

    public AccountModelDao() {
    }

    public AccountModelDao(UUID id, DateTime createdDate, DateTime updatedDate, String externalKey, String email, String name, Integer firstNameLength, Currency currency, UUID parentAccountId, Boolean isPaymentDelegatedToParent, int billingCycleDayLocal, UUID paymentMethodId, DateTimeZone timeZone, String locale, String address1, String address2, String companyName, String city, String stateOrProvince, String country, String postalCode, String phone, String notes, Boolean migrated, Boolean notifiedForInvoices) {
        super(id, createdDate, updatedDate);
        this.externalKey = (String)MoreObjects.firstNonNull((Object)externalKey, (Object)id.toString());
        this.email = email;
        this.name = name;
        this.firstNameLength = firstNameLength;
        this.currency = currency;
        this.parentAccountId = parentAccountId;
        this.isPaymentDelegatedToParent = isPaymentDelegatedToParent;
        this.billingCycleDayLocal = billingCycleDayLocal;
        this.paymentMethodId = paymentMethodId;
        this.timeZone = (DateTimeZone)MoreObjects.firstNonNull((Object)timeZone, (Object)DateTimeZone.UTC);
        this.locale = locale;
        this.address1 = address1;
        this.address2 = address2;
        this.companyName = companyName;
        this.city = city;
        this.stateOrProvince = stateOrProvince;
        this.country = country;
        this.postalCode = postalCode;
        this.phone = phone;
        this.notes = notes;
        this.migrated = migrated;
        this.isNotifiedForInvoices = notifiedForInvoices;
    }

    public AccountModelDao(UUID id, @Nullable DateTime createdDate, DateTime updatedDate, AccountData account) {
        this(id, createdDate, updatedDate, account.getExternalKey(), account.getEmail(), account.getName(), account.getFirstNameLength(), account.getCurrency(), account.getParentAccountId(), account.isPaymentDelegatedToParent(), (Integer)MoreObjects.firstNonNull((Object)account.getBillCycleDayLocal(), (Object)0), account.getPaymentMethodId(), account.getTimeZone(), account.getLocale(), account.getAddress1(), account.getAddress2(), account.getCompanyName(), account.getCity(), account.getStateOrProvince(), account.getCountry(), account.getPostalCode(), account.getPhone(), account.getNotes(), account.isMigrated(), (Boolean)MoreObjects.firstNonNull((Object)account.isNotifiedForInvoices(), (Object)false));
    }

    public AccountModelDao(UUID id, AccountData account) {
        this(id, null, null, account);
    }

    public AccountModelDao(AccountData account) {
        this(UUIDs.randomUUID(), account);
    }

    public void setRecordId(Long recordId) {
        super.setRecordId(recordId);
        this.setAccountRecordId(recordId);
    }

    public String getExternalKey() {
        return this.externalKey;
    }

    public void setExternalKey(String externalKey) {
        this.externalKey = externalKey;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getFirstNameLength() {
        return this.firstNameLength;
    }

    public void setFirstNameLength(Integer firstNameLength) {
        this.firstNameLength = firstNameLength;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public UUID getParentAccountId() {
        return this.parentAccountId;
    }

    public void setParentAccountId(UUID parentAccountId) {
        this.parentAccountId = parentAccountId;
    }

    public Boolean getIsPaymentDelegatedToParent() {
        return this.isPaymentDelegatedToParent;
    }

    public void setIsPaymentDelegatedToParent(Boolean paymentDelegatedToParent) {
        this.isPaymentDelegatedToParent = paymentDelegatedToParent;
    }

    public Integer getBillingCycleDayLocal() {
        return this.billingCycleDayLocal;
    }

    public void setBillingCycleDayLocal(Integer billingCycleDayLocal) {
        this.billingCycleDayLocal = (Integer)MoreObjects.firstNonNull((Object)billingCycleDayLocal, (Object)0);
    }

    public UUID getPaymentMethodId() {
        return this.paymentMethodId;
    }

    public void setPaymentMethodId(UUID paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
    }

    public DateTimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(DateTimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getAddress1() {
        return this.address1;
    }

    public void setAddress1(String address1) {
        this.address1 = address1;
    }

    public String getAddress2() {
        return this.address2;
    }

    public void setAddress2(String address2) {
        this.address2 = address2;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getStateOrProvince() {
        return this.stateOrProvince;
    }

    public void setStateOrProvince(String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public Boolean getMigrated() {
        return this.migrated;
    }

    public void setMigrated(Boolean migrated) {
        this.migrated = migrated;
    }

    public Boolean getIsNotifiedForInvoices() {
        return this.isNotifiedForInvoices;
    }

    public void setIsNotifiedForInvoices(Boolean isNotifiedForInvoices) {
        this.isNotifiedForInvoices = isNotifiedForInvoices;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AccountModelDao");
        sb.append("{externalKey='").append(this.externalKey).append('\'');
        sb.append(", email='").append(this.email).append('\'');
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", firstNameLength=").append(this.firstNameLength);
        sb.append(", currency=").append(this.currency);
        sb.append(", parentAccountId=").append(this.parentAccountId);
        sb.append(", isPaymentDelegatedToParent=").append(this.isPaymentDelegatedToParent);
        sb.append(", billingCycleDayLocal=").append(this.billingCycleDayLocal);
        sb.append(", paymentMethodId=").append(this.paymentMethodId);
        sb.append(", timeZone=").append(this.timeZone);
        sb.append(", locale='").append(this.locale).append('\'');
        sb.append(", address1='").append(this.address1).append('\'');
        sb.append(", address2='").append(this.address2).append('\'');
        sb.append(", companyName='").append(this.companyName).append('\'');
        sb.append(", city='").append(this.city).append('\'');
        sb.append(", stateOrProvince='").append(this.stateOrProvince).append('\'');
        sb.append(", country='").append(this.country).append('\'');
        sb.append(", postalCode='").append(this.postalCode).append('\'');
        sb.append(", phone='").append(this.phone).append('\'');
        sb.append(", notes='").append(this.notes).append('\'');
        sb.append(", migrated=").append(this.migrated);
        sb.append(", isNotifiedForInvoices=").append(this.isNotifiedForInvoices);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AccountModelDao that = (AccountModelDao)((Object)o);
        if (this.billingCycleDayLocal != that.billingCycleDayLocal) {
            return false;
        }
        if (this.address1 != null ? !this.address1.equals(that.address1) : that.address1 != null) {
            return false;
        }
        if (this.address2 != null ? !this.address2.equals(that.address2) : that.address2 != null) {
            return false;
        }
        if (this.city != null ? !this.city.equals(that.city) : that.city != null) {
            return false;
        }
        if (this.companyName != null ? !this.companyName.equals(that.companyName) : that.companyName != null) {
            return false;
        }
        if (this.country != null ? !this.country.equals(that.country) : that.country != null) {
            return false;
        }
        if (this.currency != that.currency) {
            return false;
        }
        if (this.parentAccountId != null ? !this.parentAccountId.equals(that.parentAccountId) : that.parentAccountId != null) {
            return false;
        }
        if (this.isPaymentDelegatedToParent != null ? !this.isPaymentDelegatedToParent.equals(that.isPaymentDelegatedToParent) : that.isPaymentDelegatedToParent != null) {
            return false;
        }
        if (this.email != null ? !this.email.equals(that.email) : that.email != null) {
            return false;
        }
        if (this.externalKey != null ? !this.externalKey.equals(that.externalKey) : that.externalKey != null) {
            return false;
        }
        if (this.firstNameLength != null ? !this.firstNameLength.equals(that.firstNameLength) : that.firstNameLength != null) {
            return false;
        }
        if (this.migrated != null ? !this.migrated.equals(that.migrated) : that.migrated != null) {
            return false;
        }
        if (this.isNotifiedForInvoices != null ? !this.isNotifiedForInvoices.equals(that.isNotifiedForInvoices) : that.isNotifiedForInvoices != null) {
            return false;
        }
        if (this.locale != null ? !this.locale.equals(that.locale) : that.locale != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.paymentMethodId != null ? !this.paymentMethodId.equals(that.paymentMethodId) : that.paymentMethodId != null) {
            return false;
        }
        if (this.phone != null ? !this.phone.equals(that.phone) : that.phone != null) {
            return false;
        }
        if (this.notes != null ? !this.notes.equals(that.notes) : that.notes != null) {
            return false;
        }
        if (this.postalCode != null ? !this.postalCode.equals(that.postalCode) : that.postalCode != null) {
            return false;
        }
        if (this.stateOrProvince != null ? !this.stateOrProvince.equals(that.stateOrProvince) : that.stateOrProvince != null) {
            return false;
        }
        return !(this.timeZone != null ? !this.timeZone.equals((Object)that.timeZone) : that.timeZone != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.externalKey != null ? this.externalKey.hashCode() : 0);
        result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.firstNameLength != null ? this.firstNameLength.hashCode() : 0);
        result = 31 * result + (this.currency != null ? this.currency.hashCode() : 0);
        result = 31 * result + (this.parentAccountId != null ? this.parentAccountId.hashCode() : 0);
        result = 31 * result + (this.isPaymentDelegatedToParent != null ? this.isPaymentDelegatedToParent.hashCode() : 0);
        result = 31 * result + this.billingCycleDayLocal;
        result = 31 * result + (this.paymentMethodId != null ? this.paymentMethodId.hashCode() : 0);
        result = 31 * result + (this.timeZone != null ? this.timeZone.hashCode() : 0);
        result = 31 * result + (this.locale != null ? this.locale.hashCode() : 0);
        result = 31 * result + (this.address1 != null ? this.address1.hashCode() : 0);
        result = 31 * result + (this.address2 != null ? this.address2.hashCode() : 0);
        result = 31 * result + (this.companyName != null ? this.companyName.hashCode() : 0);
        result = 31 * result + (this.city != null ? this.city.hashCode() : 0);
        result = 31 * result + (this.stateOrProvince != null ? this.stateOrProvince.hashCode() : 0);
        result = 31 * result + (this.country != null ? this.country.hashCode() : 0);
        result = 31 * result + (this.postalCode != null ? this.postalCode.hashCode() : 0);
        result = 31 * result + (this.phone != null ? this.phone.hashCode() : 0);
        result = 31 * result + (this.notes != null ? this.notes.hashCode() : 0);
        result = 31 * result + (this.migrated != null ? this.migrated.hashCode() : 0);
        result = 31 * result + (this.isNotifiedForInvoices != null ? this.isNotifiedForInvoices.hashCode() : 0);
        return result;
    }

    public TableName getTableName() {
        return TableName.ACCOUNT;
    }

    public TableName getHistoryTableName() {
        return TableName.ACCOUNT_HISTORY;
    }
}

