/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing;

import org.killbill.billing.ErrorCode;

public class BillingExceptionBase
extends Exception {
    private static final long serialVersionUID = 165720101383L;
    private final Throwable cause;
    private final int code;
    private final String formattedMsg;

    public BillingExceptionBase(Throwable cause, int code, String msg) {
        this.formattedMsg = msg;
        this.code = code;
        this.cause = cause;
    }

    public BillingExceptionBase(BillingExceptionBase cause) {
        this.formattedMsg = cause.getMessage();
        this.code = cause.getCode();
        this.cause = cause;
    }

    public BillingExceptionBase(Throwable cause, ErrorCode code, Object ... args) {
        String tmp;
        this.formattedMsg = tmp = String.format(code.getFormat(), args);
        this.code = code.getCode();
        this.cause = cause;
    }

    public BillingExceptionBase(ErrorCode code, Object ... args) {
        this(null, code, args);
    }

    @Override
    public String getMessage() {
        return this.formattedMsg;
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    public int getCode() {
        return this.code;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{cause=").append(this.cause);
        sb.append(", code=").append(this.code);
        sb.append(", formattedMsg='").append(this.formattedMsg).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

