/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.api;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.joda.time.LocalDate;
import org.killbill.billing.KillbillApi;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.invoice.api.DryRunArguments;
import org.killbill.billing.invoice.api.Invoice;
import org.killbill.billing.invoice.api.InvoiceApiException;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.security.Permission;
import org.killbill.billing.security.RequiresPermissions;
import org.killbill.billing.util.api.AuditLevel;
import org.killbill.billing.util.api.TagApiException;
import org.killbill.billing.util.audit.AuditLogWithHistory;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.entity.Pagination;

public interface InvoiceUserApi
extends KillbillApi {
    public List<Invoice> getInvoicesByAccount(UUID var1, boolean var2, boolean var3, TenantContext var4);

    public List<Invoice> getInvoicesByAccount(UUID var1, LocalDate var2, LocalDate var3, boolean var4, TenantContext var5);

    public Pagination<Invoice> getInvoices(Long var1, Long var2, TenantContext var3);

    public Pagination<Invoice> searchInvoices(String var1, Long var2, Long var3, TenantContext var4);

    public BigDecimal getAccountBalance(UUID var1, TenantContext var2);

    public BigDecimal getAccountCBA(UUID var1, TenantContext var2);

    public Invoice getInvoice(UUID var1, TenantContext var2) throws InvoiceApiException;

    public Invoice getInvoiceByPayment(UUID var1, TenantContext var2) throws InvoiceApiException;

    public Invoice getInvoiceByNumber(Integer var1, TenantContext var2) throws InvoiceApiException;

    public Invoice getInvoiceByInvoiceItem(UUID var1, TenantContext var2) throws InvoiceApiException;

    public Collection<Invoice> getUnpaidInvoicesByAccountId(UUID var1, LocalDate var2, LocalDate var3, TenantContext var4);

    @RequiresPermissions(value={Permission.INVOICE_CAN_TRIGGER_INVOICE})
    public Invoice triggerInvoiceGeneration(UUID var1, LocalDate var2, CallContext var3) throws InvoiceApiException;

    @RequiresPermissions(value={Permission.INVOICE_CAN_DRY_RUN_INVOICE})
    public Invoice triggerDryRunInvoiceGeneration(UUID var1, LocalDate var2, DryRunArguments var3, CallContext var4) throws InvoiceApiException;

    @RequiresPermissions(value={Permission.INVOICE_CAN_WRITE_OFF})
    public void tagInvoiceAsWrittenOff(UUID var1, CallContext var2) throws TagApiException, InvoiceApiException;

    @RequiresPermissions(value={Permission.INVOICE_CAN_WRITE_OFF})
    public void tagInvoiceAsNotWrittenOff(UUID var1, CallContext var2) throws TagApiException, InvoiceApiException;

    public InvoiceItem getExternalChargeById(UUID var1, TenantContext var2) throws InvoiceApiException;

    @RequiresPermissions(value={Permission.ACCOUNT_CAN_CHARGE})
    public List<InvoiceItem> insertExternalCharges(UUID var1, LocalDate var2, Iterable<InvoiceItem> var3, boolean var4, Iterable<PluginProperty> var5, CallContext var6) throws InvoiceApiException;

    @RequiresPermissions(value={Permission.ACCOUNT_CAN_CHARGE})
    public List<InvoiceItem> insertTaxItems(UUID var1, LocalDate var2, Iterable<InvoiceItem> var3, boolean var4, Iterable<PluginProperty> var5, CallContext var6) throws InvoiceApiException;

    public InvoiceItem getCreditById(UUID var1, TenantContext var2) throws InvoiceApiException;

    @RequiresPermissions(value={Permission.ACCOUNT_CAN_CREDIT})
    public List<InvoiceItem> insertCredits(UUID var1, LocalDate var2, Iterable<InvoiceItem> var3, boolean var4, Iterable<PluginProperty> var5, CallContext var6) throws InvoiceApiException;

    @RequiresPermissions(value={Permission.INVOICE_CAN_ITEM_ADJUST})
    public InvoiceItem insertInvoiceItemAdjustment(UUID var1, UUID var2, UUID var3, LocalDate var4, String var5, String var6, Iterable<PluginProperty> var7, CallContext var8) throws InvoiceApiException;

    @RequiresPermissions(value={Permission.INVOICE_CAN_ITEM_ADJUST})
    public InvoiceItem insertInvoiceItemAdjustment(UUID var1, UUID var2, UUID var3, LocalDate var4, BigDecimal var5, Currency var6, String var7, String var8, Iterable<PluginProperty> var9, CallContext var10) throws InvoiceApiException;

    @RequiresPermissions(value={Permission.INVOICE_CAN_DELETE_CBA})
    public void deleteCBA(UUID var1, UUID var2, UUID var3, CallContext var4) throws InvoiceApiException;

    public String getInvoiceAsHTML(UUID var1, TenantContext var2) throws AccountApiException, IOException, InvoiceApiException;

    @RequiresPermissions(value={Permission.INVOICE_CAN_DELETE_CBA})
    public void consumeExistingCBAOnAccountWithUnpaidInvoices(UUID var1, CallContext var2);

    @RequiresPermissions(value={Permission.INVOICE_CAN_COMMIT})
    public void commitInvoice(UUID var1, CallContext var2) throws InvoiceApiException;

    @RequiresPermissions(value={Permission.INVOICE_CAN_TRIGGER_INVOICE})
    public UUID createMigrationInvoice(UUID var1, LocalDate var2, Iterable<InvoiceItem> var3, CallContext var4);

    @RequiresPermissions(value={Permission.INVOICE_CAN_DELETE_CBA})
    public void transferChildCreditToParent(UUID var1, CallContext var2) throws InvoiceApiException;

    public List<InvoiceItem> getInvoiceItemsByParentInvoice(UUID var1, TenantContext var2) throws InvoiceApiException;

    @RequiresPermissions(value={Permission.INVOICE_CAN_VOID})
    public void voidInvoice(UUID var1, CallContext var2) throws InvoiceApiException;

    public List<AuditLogWithHistory> getInvoiceAuditLogsWithHistoryForId(UUID var1, AuditLevel var2, TenantContext var3);

    public List<AuditLogWithHistory> getInvoiceItemAuditLogsWithHistoryForId(UUID var1, AuditLevel var2, TenantContext var3);

    public List<AuditLogWithHistory> getInvoicePaymentAuditLogsWithHistoryForId(UUID var1, AuditLevel var2, TenantContext var3);
}

