/*
 * Copyright 2010-2013 Ning, Inc.
 *
 * Ning licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package org.killbill.billing.util.api;

import java.io.OutputStream;
import java.util.UUID;

import org.killbill.billing.KillbillApi;
import org.killbill.billing.security.RequiresPermissions;
import org.killbill.billing.util.callcontext.CallContext;

import static org.killbill.billing.security.Permission.ADMIN_CAN_EXPORT;

// Although it's a read-only call, we want to know who triggered the export - hence the call context here
public interface ExportUserApi extends KillbillApi {

    @RequiresPermissions(ADMIN_CAN_EXPORT)
    public void exportDataForAccount(UUID accountId, DatabaseExportOutputStream out, CallContext context);

    @RequiresPermissions(ADMIN_CAN_EXPORT)
    public void exportDataAsCSVForAccount(UUID accountId, OutputStream out, CallContext context);
}
