/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing;

import org.killbill.billing.ErrorCode;

public class BillingExceptionBase
extends Exception {
    private static final long serialVersionUID = 165720101383L;
    private final Throwable cause;
    private final int code;
    private final String formattedMsg;

    public BillingExceptionBase(Throwable cause, int code, String msg) {
        this.cause = cause;
        this.code = code;
        this.formattedMsg = msg;
    }

    public BillingExceptionBase(BillingExceptionBase cause) {
        this((Throwable)cause, cause.getCode(), cause.getMessage());
    }

    public BillingExceptionBase(Throwable cause, ErrorCode code, Object ... args) {
        this(cause, code.getCode(), String.format(code.getFormat(), args));
    }

    public BillingExceptionBase(ErrorCode code, Object ... args) {
        this(null, code, args);
    }

    @Override
    public String getMessage() {
        return this.formattedMsg;
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    public int getCode() {
        return this.code;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{cause=").append(this.cause);
        sb.append(", code=").append(this.code);
        sb.append(", formattedMsg='").append(this.formattedMsg).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

