/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.api;

import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.PlanPhaseSpecifier;

public class PlanSpecifier {
    private final String planName;
    private final String productName;
    private final BillingPeriod billingPeriod;
    private final String priceListName;

    public PlanSpecifier(String productName, BillingPeriod billingPeriod, String priceListName) {
        this.planName = null;
        this.productName = productName;
        this.billingPeriod = billingPeriod;
        this.priceListName = priceListName;
    }

    public PlanSpecifier(String planName) {
        this.planName = planName;
        this.productName = null;
        this.billingPeriod = null;
        this.priceListName = null;
    }

    public PlanSpecifier(PlanPhaseSpecifier planPhase) {
        this.planName = planPhase.getPlanName();
        this.productName = planPhase.getProductName();
        this.billingPeriod = planPhase.getBillingPeriod();
        this.priceListName = planPhase.getPriceListName();
    }

    public String getPlanName() {
        return this.planName;
    }

    public String getProductName() {
        return this.productName;
    }

    public BillingPeriod getBillingPeriod() {
        return this.billingPeriod;
    }

    public String getPriceListName() {
        return this.priceListName;
    }
}

