/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.entitlement.api;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.joda.time.LocalDate;
import org.killbill.billing.KillbillApi;
import org.killbill.billing.catalog.api.BillingActionPolicy;
import org.killbill.billing.entitlement.api.BaseEntitlementWithAddOnsSpecifier;
import org.killbill.billing.entitlement.api.BcdTransfer;
import org.killbill.billing.entitlement.api.Entitlement;
import org.killbill.billing.entitlement.api.EntitlementAOStatusDryRun;
import org.killbill.billing.entitlement.api.EntitlementApiException;
import org.killbill.billing.entitlement.api.EntitlementSpecifier;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.security.Permission;
import org.killbill.billing.security.RequiresPermissions;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;

public interface EntitlementApi
extends KillbillApi {
    @RequiresPermissions(value={Permission.ENTITLEMENT_CAN_CREATE})
    public UUID createBaseEntitlement(UUID var1, EntitlementSpecifier var2, String var3, LocalDate var4, LocalDate var5, boolean var6, boolean var7, Iterable<PluginProperty> var8, CallContext var9) throws EntitlementApiException;

    @RequiresPermissions(value={Permission.ENTITLEMENT_CAN_CREATE})
    public List<UUID> createBaseEntitlementsWithAddOns(UUID var1, Iterable<BaseEntitlementWithAddOnsSpecifier> var2, boolean var3, Iterable<PluginProperty> var4, CallContext var5) throws EntitlementApiException;

    @RequiresPermissions(value={Permission.ENTITLEMENT_CAN_CREATE})
    public UUID addEntitlement(UUID var1, EntitlementSpecifier var2, LocalDate var3, LocalDate var4, boolean var5, Iterable<PluginProperty> var6, CallContext var7) throws EntitlementApiException;

    public List<EntitlementAOStatusDryRun> getDryRunStatusForChange(UUID var1, String var2, LocalDate var3, TenantContext var4) throws EntitlementApiException;

    @RequiresPermissions(value={Permission.ENTITLEMENT_CAN_PAUSE_RESUME})
    public void pause(UUID var1, LocalDate var2, Iterable<PluginProperty> var3, CallContext var4) throws EntitlementApiException;

    @RequiresPermissions(value={Permission.ENTITLEMENT_CAN_PAUSE_RESUME})
    public void resume(UUID var1, LocalDate var2, Iterable<PluginProperty> var3, CallContext var4) throws EntitlementApiException;

    public Entitlement getEntitlementForId(UUID var1, boolean var2, TenantContext var3) throws EntitlementApiException;

    public List<Entitlement> getAllEntitlementsForBundle(UUID var1, TenantContext var2) throws EntitlementApiException;

    public List<Entitlement> getAllEntitlementsForAccountIdAndBundleExternalKey(UUID var1, String var2, TenantContext var3) throws EntitlementApiException;

    public List<Entitlement> getAllEntitlementsForAccountId(UUID var1, TenantContext var2) throws EntitlementApiException;

    @RequiresPermissions(value={Permission.ENTITLEMENT_CAN_TRANSFER})
    public UUID transferEntitlements(UUID var1, UUID var2, String var3, LocalDate var4, Map<UUID, String> var5, BcdTransfer var6, Iterable<PluginProperty> var7, CallContext var8) throws EntitlementApiException;

    @RequiresPermissions(value={Permission.ENTITLEMENT_CAN_TRANSFER})
    public UUID transferEntitlementsOverrideBillingPolicy(UUID var1, UUID var2, String var3, LocalDate var4, Map<UUID, String> var5, BillingActionPolicy var6, BcdTransfer var7, Iterable<PluginProperty> var8, CallContext var9) throws EntitlementApiException;
}

