/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.osgi.api;

import java.util.Collections;
import java.util.Map;
import org.killbill.billing.tenant.api.Tenant;

public interface Healthcheck {
    public HealthStatus getHealthStatus(Tenant var1, Map var2);

    public static class HealthStatus {
        private final boolean healthy;
        private final Map details;

        public HealthStatus(boolean healthy, Map details) {
            this.details = Map.copyOf(details);
            this.healthy = healthy;
        }

        public static HealthStatus healthy() {
            return new HealthStatus(true, Collections.EMPTY_MAP);
        }

        public static HealthStatus healthy(String message) {
            return new HealthStatus(true, Collections.singletonMap("message", message));
        }

        public static HealthStatus unHealthy(String message) {
            return new HealthStatus(false, Collections.singletonMap("message", message));
        }

        public boolean isHealthy() {
            return this.healthy;
        }

        public Map getDetails() {
            return Map.copyOf(this.details);
        }
    }
}

