/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util.tag;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.killbill.billing.ObjectType;

public enum ControlTagType {
    AUTO_PAY_OFF(new UUID(0L, 1L), "Suspends payments until removed.", true, false, Collections.singletonList(ObjectType.ACCOUNT)),
    AUTO_INVOICING_OFF(new UUID(0L, 2L), "Suspends invoicing until removed.", false, true, Collections.singletonList(ObjectType.ACCOUNT)),
    OVERDUE_ENFORCEMENT_OFF(new UUID(0L, 3L), "Suspends overdue enforcement behaviour until removed.", false, false, Collections.singletonList(ObjectType.ACCOUNT)),
    WRITTEN_OFF(new UUID(0L, 4L), "Indicates that an invoice is written off. No billing or payment effect.", false, false, Collections.singletonList(ObjectType.INVOICE)),
    MANUAL_PAY(new UUID(0L, 5L), "Indicates that Killbill doesn't process payments for that account (external payments only)", true, false, Collections.singletonList(ObjectType.ACCOUNT)),
    TEST(new UUID(0L, 6L), "Indicates that this is a test account", false, false, Collections.singletonList(ObjectType.ACCOUNT)),
    PARTNER(new UUID(0L, 7L), "Indicates that this is a partner account", false, false, Collections.singletonList(ObjectType.ACCOUNT)),
    AUTO_INVOICING_DRAFT(new UUID(0L, 8L), "Generate account invoices in DRAFT mode.", false, false, Collections.singletonList(ObjectType.ACCOUNT)),
    AUTO_INVOICING_REUSE_DRAFT(new UUID(0L, 9L), "Use existing draft invoice if exists.", false, false, Collections.singletonList(ObjectType.ACCOUNT));

    private final UUID id;
    private final String description;
    private final boolean autoPaymentOff;
    private final boolean autoInvoicingOff;
    private final List<ObjectType> applicableObjectTypes;

    private ControlTagType(UUID id, String description, boolean autoPaymentOff, boolean autoInvoicingOff, List<ObjectType> applicableObjectTypes) {
        this.id = id;
        this.description = description;
        this.autoPaymentOff = autoPaymentOff;
        this.autoInvoicingOff = autoInvoicingOff;
        this.applicableObjectTypes = applicableObjectTypes;
    }

    public UUID getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getAutoPaymentOff() {
        return this.autoPaymentOff;
    }

    public boolean getAutoInvoicingOff() {
        return this.autoInvoicingOff;
    }

    public List<ObjectType> getApplicableObjectTypes() {
        return List.copyOf(this.applicableObjectTypes);
    }

    public static ControlTagType getTypeFromId(UUID targetId) {
        for (ControlTagType cur : ControlTagType.values()) {
            if (!cur.getId().equals(targetId)) continue;
            return cur;
        }
        return null;
    }

    public static boolean isAutoPayOff(Collection<UUID> input) {
        for (UUID cur : input) {
            for (ControlTagType controlTag : ControlTagType.values()) {
                if (!controlTag.getId().equals(cur) || !controlTag.getAutoPaymentOff()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAutoInvoicingOff(Collection<UUID> input) {
        for (UUID cur : input) {
            for (ControlTagType controlTag : ControlTagType.values()) {
                if (!controlTag.getId().equals(cur) || !controlTag.getAutoInvoicingOff()) continue;
                return true;
            }
        }
        return false;
    }
}

