/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.client;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import com.ning.http.client.Response;
import com.ning.http.util.UTF8UrlEncoder;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.killbill.billing.catalog.api.BillingActionPolicy;
import org.killbill.billing.catalog.api.ProductCategory;
import org.killbill.billing.client.KillBillClientException;
import org.killbill.billing.client.KillBillHttpClient;
import org.killbill.billing.client.model.Account;
import org.killbill.billing.client.model.AccountEmail;
import org.killbill.billing.client.model.AccountEmails;
import org.killbill.billing.client.model.AccountTimeline;
import org.killbill.billing.client.model.Accounts;
import org.killbill.billing.client.model.Bundle;
import org.killbill.billing.client.model.Bundles;
import org.killbill.billing.client.model.Catalog;
import org.killbill.billing.client.model.ComboHostedPaymentPage;
import org.killbill.billing.client.model.ComboPaymentTransaction;
import org.killbill.billing.client.model.Credit;
import org.killbill.billing.client.model.CustomField;
import org.killbill.billing.client.model.CustomFields;
import org.killbill.billing.client.model.HostedPaymentPageFields;
import org.killbill.billing.client.model.HostedPaymentPageFormDescriptor;
import org.killbill.billing.client.model.Invoice;
import org.killbill.billing.client.model.InvoiceDryRun;
import org.killbill.billing.client.model.InvoiceEmail;
import org.killbill.billing.client.model.InvoiceItem;
import org.killbill.billing.client.model.InvoiceItems;
import org.killbill.billing.client.model.InvoicePayment;
import org.killbill.billing.client.model.InvoicePaymentTransaction;
import org.killbill.billing.client.model.InvoicePayments;
import org.killbill.billing.client.model.Invoices;
import org.killbill.billing.client.model.OverdueState;
import org.killbill.billing.client.model.Payment;
import org.killbill.billing.client.model.PaymentMethod;
import org.killbill.billing.client.model.PaymentMethods;
import org.killbill.billing.client.model.PaymentTransaction;
import org.killbill.billing.client.model.Payments;
import org.killbill.billing.client.model.Permissions;
import org.killbill.billing.client.model.PlanDetail;
import org.killbill.billing.client.model.PlanDetails;
import org.killbill.billing.client.model.RoleDefinition;
import org.killbill.billing.client.model.Subscription;
import org.killbill.billing.client.model.TagDefinition;
import org.killbill.billing.client.model.TagDefinitions;
import org.killbill.billing.client.model.Tags;
import org.killbill.billing.client.model.Tenant;
import org.killbill.billing.client.model.TenantKey;
import org.killbill.billing.client.model.UserRoles;
import org.killbill.billing.entitlement.api.Entitlement;
import org.killbill.billing.util.api.AuditLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KillBillClient {
    private final KillBillHttpClient httpClient;

    public KillBillClient() {
        this(new KillBillHttpClient());
    }

    public KillBillClient(KillBillHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void close() {
        this.httpClient.close();
    }

    public Accounts getAccounts() throws KillBillClientException {
        return this.getAccounts(0L, 100L);
    }

    public Accounts getAccounts(Long offset, Long limit) throws KillBillClientException {
        return this.getAccounts(offset, limit, AuditLevel.NONE);
    }

    public Accounts getAccounts(Long offset, Long limit, AuditLevel auditLevel) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/pagination";
        ImmutableMultimap queryParams = ImmutableMultimap.of((Object)"offset", (Object)String.valueOf(offset), (Object)"limit", (Object)String.valueOf(limit), (Object)"audit", (Object)auditLevel.toString());
        return this.httpClient.doGet("/1.0/kb/accounts/pagination", (Multimap<String, String>)queryParams, Accounts.class);
    }

    public Account getAccount(UUID accountId) throws KillBillClientException {
        return this.getAccount(accountId, false, false);
    }

    public Account getAccount(UUID accountId, boolean withBalance, boolean withCBA) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/" + accountId;
        ImmutableMultimap queryParams = ImmutableMultimap.of((Object)"accountWithBalance", (Object)(withBalance ? "true" : "false"), (Object)"accountWithBalanceAndCBA", (Object)(withCBA ? "true" : "false"));
        return this.httpClient.doGet(uri, (Multimap<String, String>)queryParams, Account.class);
    }

    public Account getAccount(String externalKey) throws KillBillClientException {
        return this.getAccount(externalKey, false, false);
    }

    public Account getAccount(String externalKey, boolean withBalance, boolean withCBA) throws KillBillClientException {
        ImmutableMultimap queryParams = ImmutableMultimap.of((Object)"externalKey", (Object)externalKey, (Object)"accountWithBalance", (Object)(withBalance ? "true" : "false"), (Object)"accountWithBalanceAndCBA", (Object)(withCBA ? "true" : "false"));
        return this.httpClient.doGet("/1.0/kb/accounts", (Multimap<String, String>)queryParams, Account.class);
    }

    public Accounts searchAccounts(String key) throws KillBillClientException {
        return this.searchAccounts(key, 0L, 100L);
    }

    public Accounts searchAccounts(String key, Long offset, Long limit) throws KillBillClientException {
        return this.searchAccounts(key, offset, limit, AuditLevel.NONE);
    }

    public Accounts searchAccounts(String key, Long offset, Long limit, AuditLevel auditLevel) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/search/" + UTF8UrlEncoder.encode((String)key);
        ImmutableMultimap queryParams = ImmutableMultimap.of((Object)"offset", (Object)String.valueOf(offset), (Object)"limit", (Object)String.valueOf(limit), (Object)"audit", (Object)auditLevel.toString());
        return this.httpClient.doGet(uri, KillBillHttpClient.DEFAULT_EMPTY_QUERY, Accounts.class);
    }

    public AccountTimeline getAccountTimeline(UUID accountId) throws KillBillClientException {
        return this.getAccountTimeline(accountId, AuditLevel.NONE);
    }

    public AccountTimeline getAccountTimeline(UUID accountId, AuditLevel auditLevel) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/" + accountId + "/" + "timeline";
        ImmutableMultimap queryParams = ImmutableMultimap.of((Object)"audit", (Object)auditLevel.toString());
        return this.httpClient.doGet(uri, (Multimap<String, String>)queryParams, AccountTimeline.class);
    }

    public Account createAccount(Account account, String createdBy, String reason, String comment) throws KillBillClientException {
        Multimap<String, String> queryParams = this.paramsWithAudit(createdBy, reason, comment);
        return this.httpClient.doPostAndFollowLocation("/1.0/kb/accounts", account, queryParams, Account.class);
    }

    public Account updateAccount(Account account, String createdBy, String reason, String comment) throws KillBillClientException {
        Preconditions.checkNotNull((Object)account.getAccountId(), (Object)"Account#accountId cannot be null");
        String uri = "/1.0/kb/accounts/" + account.getAccountId();
        Multimap<String, String> queryParams = this.paramsWithAudit(createdBy, reason, comment);
        return this.httpClient.doPut(uri, account, queryParams, Account.class);
    }

    public AccountEmails getEmailsForAccount(UUID accountId) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/" + accountId + "/" + "emails";
        return this.httpClient.doGet(uri, KillBillHttpClient.DEFAULT_EMPTY_QUERY, AccountEmails.class);
    }

    public void addEmailToAccount(AccountEmail email, String createdBy, String reason, String comment) throws KillBillClientException {
        Preconditions.checkNotNull((Object)email.getAccountId(), (Object)"AccountEmail#accountId cannot be null");
        String uri = "/1.0/kb/accounts/" + email.getAccountId() + "/" + "emails";
        Multimap<String, String> queryParams = this.paramsWithAudit(createdBy, reason, comment);
        this.httpClient.doPost(uri, email, queryParams);
    }

    public void removeEmailFromAccount(AccountEmail email, String createdBy, String reason, String comment) throws KillBillClientException {
        Preconditions.checkNotNull((Object)email.getAccountId(), (Object)"AccountEmail#accountId cannot be null");
        Preconditions.checkNotNull((Object)email.getEmail(), (Object)"AccountEmail#email cannot be null");
        String uri = "/1.0/kb/accounts/" + email.getAccountId() + "/" + "emails" + "/" + UTF8UrlEncoder.encode((String)email.getEmail());
        Multimap<String, String> queryParams = this.paramsWithAudit(createdBy, reason, comment);
        this.httpClient.doDelete(uri, queryParams);
    }

    public InvoiceEmail getEmailNotificationsForAccount(UUID accountId) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/" + accountId + "/" + "emailNotifications";
        return this.httpClient.doGet(uri, KillBillHttpClient.DEFAULT_EMPTY_QUERY, InvoiceEmail.class);
    }

    public void updateEmailNotificationsForAccount(InvoiceEmail invoiceEmail, String createdBy, String reason, String comment) throws KillBillClientException {
        Preconditions.checkNotNull((Object)invoiceEmail.getAccountId(), (Object)"InvoiceEmail#accountId cannot be null");
        String uri = "/1.0/kb/accounts/" + invoiceEmail.getAccountId() + "/" + "emailNotifications";
        Multimap<String, String> queryParams = this.paramsWithAudit(createdBy, reason, comment);
        this.httpClient.doPut(uri, invoiceEmail, queryParams);
    }

    public Bundle getBundle(UUID bundleId) throws KillBillClientException {
        String uri = "/1.0/kb/bundles/" + bundleId;
        return this.httpClient.doGet(uri, KillBillHttpClient.DEFAULT_EMPTY_QUERY, Bundle.class);
    }

    public Bundle getBundle(String externalKey) throws KillBillClientException {
        String uri = "/1.0/kb/bundles";
        ImmutableMultimap queryParams = ImmutableMultimap.of((Object)"externalKey", (Object)externalKey);
        return this.httpClient.doGet("/1.0/kb/bundles", (Multimap<String, String>)queryParams, Bundle.class);
    }

    public Bundles getAccountBundles(UUID accountId) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/" + accountId + "/" + "bundles";
        return this.httpClient.doGet(uri, KillBillHttpClient.DEFAULT_EMPTY_QUERY, Bundles.class);
    }

    public Bundles getAccountBundles(UUID accountId, String externalKey) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/" + accountId + "/" + "bundles";
        ImmutableMultimap queryParams = ImmutableMultimap.of((Object)"externalKey", (Object)externalKey);
        return this.httpClient.doGet(uri, (Multimap<String, String>)queryParams, Bundles.class);
    }

    public Bundles getBundles() throws KillBillClientException {
        return this.getBundles(0L, 100L);
    }

    public Bundles getBundles(Long offset, Long limit) throws KillBillClientException {
        return this.getBundles(offset, limit, AuditLevel.NONE);
    }

    public Bundles getBundles(Long offset, Long limit, AuditLevel auditLevel) throws KillBillClientException {
        String uri = "/1.0/kb/bundles/pagination";
        ImmutableMultimap queryParams = ImmutableMultimap.of((Object)"offset", (Object)String.valueOf(offset), (Object)"limit", (Object)String.valueOf(limit), (Object)"audit", (Object)auditLevel.toString());
        return this.httpClient.doGet("/1.0/kb/bundles/pagination", (Multimap<String, String>)queryParams, Bundles.class);
    }

    public Bundles searchBundles(String key) throws KillBillClientException {
        return this.searchBundles(key, 0L, 100L);
    }

    public Bundles searchBundles(String key, Long offset, Long limit) throws KillBillClientException {
        return this.searchBundles(key, offset, limit, AuditLevel.NONE);
    }

    public Bundles searchBundles(String key, Long offset, Long limit, AuditLevel auditLevel) throws KillBillClientException {
        String uri = "/1.0/kb/bundles/search/" + UTF8UrlEncoder.encode((String)key);
        ImmutableMultimap queryParams = ImmutableMultimap.of((Object)"offset", (Object)String.valueOf(offset), (Object)"limit", (Object)String.valueOf(limit), (Object)"audit", (Object)auditLevel.toString());
        return this.httpClient.doGet(uri, KillBillHttpClient.DEFAULT_EMPTY_QUERY, Bundles.class);
    }

    public Bundle transferBundle(Bundle bundle, String createdBy, String reason, String comment) throws KillBillClientException {
        Preconditions.checkNotNull((Object)bundle.getBundleId(), (Object)"Bundle#bundleId cannot be null");
        Preconditions.checkNotNull((Object)bundle.getAccountId(), (Object)"Bundle#accountId cannot be null");
        String uri = "/1.0/kb/bundles/" + bundle.getBundleId();
        Multimap<String, String> queryParams = this.paramsWithAudit(createdBy, reason, comment);
        return this.httpClient.doPutAndFollowLocation(uri, bundle, queryParams, Bundle.class);
    }

    public Subscription getSubscription(UUID subscriptionId) throws KillBillClientException {
        String uri = "/1.0/kb/subscriptions/" + subscriptionId;
        return this.httpClient.doGet(uri, KillBillHttpClient.DEFAULT_EMPTY_QUERY, Subscription.class);
    }

    public Subscription createSubscription(Subscription subscription, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createSubscription(subscription, -1, createdBy, reason, comment);
    }

    public Subscription createSubscription(Subscription subscription, int timeoutSec, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createSubscription(subscription, null, timeoutSec, createdBy, reason, comment);
    }

    public Subscription createSubscription(Subscription subscription, DateTime requestedDate, int timeoutSec, String createdBy, String reason, String comment) throws KillBillClientException {
        Preconditions.checkNotNull((Object)subscription.getAccountId(), (Object)"Subscription#accountId cannot be null");
        Preconditions.checkNotNull((Object)subscription.getProductName(), (Object)"Subscription#productName cannot be null");
        Preconditions.checkNotNull((Object)subscription.getProductCategory(), (Object)"Subscription#productCategory cannot be null");
        Preconditions.checkNotNull((Object)subscription.getBillingPeriod(), (Object)"Subscription#billingPeriod cannot be null");
        Preconditions.checkNotNull((Object)subscription.getPriceList(), (Object)"Subscription#priceList cannot be null");
        if (subscription.getProductCategory() == ProductCategory.BASE) {
            Preconditions.checkNotNull((Object)subscription.getAccountId(), (Object)"Account#accountId cannot be null");
        }
        HashMultimap params = HashMultimap.create();
        params.put((Object)"callCompletion", (Object)(timeoutSec > 0 ? "true" : "false"));
        params.put((Object)"callTimeoutSec", (Object)String.valueOf(timeoutSec));
        if (requestedDate != null) {
            params.put((Object)"requestedDate", (Object)requestedDate.toDateTimeISO().toString());
        }
        Multimap<String, String> queryParams = this.paramsWithAudit((Multimap<String, String>)params, createdBy, reason, comment);
        int httpTimeout = Math.max(10, timeoutSec);
        return this.httpClient.doPostAndFollowLocation("/1.0/kb/subscriptions", (Object)subscription, queryParams, httpTimeout, Subscription.class);
    }

    public Subscription updateSubscription(Subscription subscription, int timeoutSec, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.updateSubscription(subscription, null, timeoutSec, createdBy, reason, comment);
    }

    public Subscription updateSubscription(Subscription subscription, @Nullable BillingActionPolicy billingPolicy, int timeoutSec, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.updateSubscription(subscription, null, billingPolicy, timeoutSec, createdBy, reason, comment);
    }

    public Subscription updateSubscription(Subscription subscription, @Nullable DateTime requestedDate, @Nullable BillingActionPolicy billingPolicy, int timeoutSec, String createdBy, String reason, String comment) throws KillBillClientException {
        Preconditions.checkNotNull((Object)subscription.getSubscriptionId(), (Object)"Subscription#subscriptionId cannot be null");
        Preconditions.checkNotNull((Object)subscription.getProductName(), (Object)"Subscription#productName cannot be null");
        Preconditions.checkNotNull((Object)subscription.getBillingPeriod(), (Object)"Subscription#billingPeriod cannot be null");
        Preconditions.checkNotNull((Object)subscription.getPriceList(), (Object)"Subscription#priceList cannot be null");
        String uri = "/1.0/kb/subscriptions/" + subscription.getSubscriptionId();
        HashMultimap params = HashMultimap.create();
        params.put((Object)"callCompletion", (Object)(timeoutSec > 0 ? "true" : "false"));
        params.put((Object)"callTimeoutSec", (Object)String.valueOf(timeoutSec));
        if (requestedDate != null) {
            params.put((Object)"requestedDate", (Object)requestedDate.toDateTimeISO().toString());
        }
        if (billingPolicy != null) {
            params.put((Object)"billingPolicy", (Object)billingPolicy.toString());
        }
        Multimap<String, String> queryParams = this.paramsWithAudit((Multimap<String, String>)params, createdBy, reason, comment);
        return this.httpClient.doPut(uri, subscription, queryParams, Subscription.class);
    }

    public void cancelSubscription(UUID subscriptionId, String createdBy, String reason, String comment) throws KillBillClientException {
        this.cancelSubscription(subscriptionId, -1, createdBy, reason, comment);
    }

    public void cancelSubscription(UUID subscriptionId, int timeoutSec, String createdBy, String reason, String comment) throws KillBillClientException {
        this.cancelSubscription(subscriptionId, null, null, timeoutSec, createdBy, reason, comment);
    }

    public void cancelSubscription(UUID subscriptionId, @Nullable Entitlement.EntitlementActionPolicy entitlementPolicy, @Nullable BillingActionPolicy billingPolicy, int timeoutSec, String createdBy, String reason, String comment) throws KillBillClientException {
        this.cancelSubscription(subscriptionId, null, entitlementPolicy, billingPolicy, timeoutSec, createdBy, reason, comment);
    }

    public void cancelSubscription(UUID subscriptionId, @Nullable DateTime requestedDate, @Nullable Entitlement.EntitlementActionPolicy entitlementPolicy, @Nullable BillingActionPolicy billingPolicy, int timeoutSec, String createdBy, String reason, String comment) throws KillBillClientException {
        String uri = "/1.0/kb/subscriptions/" + subscriptionId;
        HashMultimap params = HashMultimap.create();
        params.put((Object)"callCompletion", (Object)(timeoutSec > 0 ? "true" : "false"));
        params.put((Object)"callTimeoutSec", (Object)String.valueOf(timeoutSec));
        if (requestedDate != null) {
            params.put((Object)"requestedDate", (Object)requestedDate.toDateTimeISO().toString());
        }
        if (entitlementPolicy != null) {
            params.put((Object)"entitlementPolicy", (Object)entitlementPolicy.toString());
        }
        if (billingPolicy != null) {
            params.put((Object)"billingPolicy", (Object)billingPolicy.toString());
        }
        Multimap<String, String> queryParams = this.paramsWithAudit((Multimap<String, String>)params, createdBy, reason, comment);
        this.httpClient.doDelete(uri, queryParams);
    }

    public void uncancelSubscription(UUID subscriptionId, String createdBy, String reason, String comment) throws KillBillClientException {
        String uri = "/1.0/kb/subscriptions/" + subscriptionId + "/uncancel";
        Multimap<String, String> queryParams = this.paramsWithAudit(createdBy, reason, comment);
        this.httpClient.doPut(uri, null, queryParams);
    }

    public Invoices getInvoices() throws KillBillClientException {
        return this.getInvoices(0L, 100L);
    }

    public Invoices getInvoices(Long offset, Long limit) throws KillBillClientException {
        return this.getInvoices(true, offset, limit, AuditLevel.NONE);
    }

    public Invoices getInvoices(Long offset, Long limit, AuditLevel auditLevel) throws KillBillClientException {
        return this.getInvoices(true, offset, limit, auditLevel);
    }

    public Invoices getInvoices(boolean withItems, Long offset, Long limit, AuditLevel auditLevel) throws KillBillClientException {
        String uri = "/1.0/kb/invoices/pagination";
        ImmutableMultimap queryParams = ImmutableMultimap.of((Object)"offset", (Object)String.valueOf(offset), (Object)"limit", (Object)String.valueOf(limit), (Object)"withItems", (Object)String.valueOf(withItems), (Object)"audit", (Object)auditLevel.toString());
        return this.httpClient.doGet("/1.0/kb/invoices/pagination", (Multimap<String, String>)queryParams, Invoices.class);
    }

    public Invoice getInvoice(UUID invoiceId) throws KillBillClientException {
        return this.getInvoice(invoiceId, true);
    }

    public Invoice getInvoice(UUID invoiceId, boolean withItems) throws KillBillClientException {
        return this.getInvoice(invoiceId, withItems, AuditLevel.NONE);
    }

    public Invoice getInvoice(UUID invoiceId, boolean withItems, AuditLevel auditLevel) throws KillBillClientException {
        return this.getInvoiceByIdOrNumber(invoiceId.toString(), withItems, auditLevel);
    }

    public Invoice getInvoice(Integer invoiceNumber) throws KillBillClientException {
        return this.getInvoice(invoiceNumber, true);
    }

    public Invoice getInvoice(Integer invoiceNumber, boolean withItems) throws KillBillClientException {
        return this.getInvoice(invoiceNumber, withItems, AuditLevel.NONE);
    }

    public Invoice getInvoice(Integer invoiceNumber, boolean withItems, AuditLevel auditLevel) throws KillBillClientException {
        return this.getInvoiceByIdOrNumber(invoiceNumber.toString(), withItems, auditLevel);
    }

    public Invoice getInvoiceByIdOrNumber(String invoiceIdOrNumber, boolean withItems, AuditLevel auditLevel) throws KillBillClientException {
        String uri = "/1.0/kb/invoices/" + invoiceIdOrNumber;
        ImmutableMultimap queryParams = ImmutableMultimap.of((Object)"withItems", (Object)String.valueOf(withItems), (Object)"audit", (Object)auditLevel.toString());
        return this.httpClient.doGet(uri, (Multimap<String, String>)queryParams, Invoice.class);
    }

    public Invoices getInvoicesForAccount(UUID accountId) throws KillBillClientException {
        return this.getInvoicesForAccount(accountId, true);
    }

    public Invoices getInvoicesForAccount(UUID accountId, boolean withItems) throws KillBillClientException {
        return this.getInvoicesForAccount(accountId, withItems, false, AuditLevel.NONE);
    }

    public Invoices getInvoicesForAccount(UUID accountId, boolean withItems, boolean unpaidOnly) throws KillBillClientException {
        return this.getInvoicesForAccount(accountId, withItems, unpaidOnly, AuditLevel.NONE);
    }

    public Invoices getInvoicesForAccount(UUID accountId, boolean withItems, boolean unpaidOnly, AuditLevel auditLevel) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/" + accountId + "/" + "invoices";
        ImmutableMultimap queryParams = ImmutableMultimap.of((Object)"withItems", (Object)String.valueOf(withItems), (Object)"unpaidInvoicesOnly", (Object)String.valueOf(unpaidOnly), (Object)"audit", (Object)auditLevel.toString());
        return this.httpClient.doGet(uri, (Multimap<String, String>)queryParams, Invoices.class);
    }

    public Invoices searchInvoices(String key) throws KillBillClientException {
        return this.searchInvoices(key, 0L, 100L);
    }

    public Invoices searchInvoices(String key, Long offset, Long limit) throws KillBillClientException {
        return this.searchInvoices(key, offset, limit, AuditLevel.NONE);
    }

    public Invoices searchInvoices(String key, Long offset, Long limit, AuditLevel auditLevel) throws KillBillClientException {
        String uri = "/1.0/kb/invoices/search/" + UTF8UrlEncoder.encode((String)key);
        ImmutableMultimap queryParams = ImmutableMultimap.of((Object)"offset", (Object)String.valueOf(offset), (Object)"limit", (Object)String.valueOf(limit), (Object)"audit", (Object)auditLevel.toString());
        return this.httpClient.doGet(uri, (Multimap<String, String>)queryParams, Invoices.class);
    }

    public Invoice createDryRunInvoice(UUID accountId, @Nullable LocalDate futureDate, InvoiceDryRun dryRunInfo, String createdBy, String reason, String comment) throws KillBillClientException {
        String uri = "/1.0/kb/invoices/dryRun";
        String futureDateOrUpcomingNextInvoice = futureDate != null ? futureDate.toString() : null;
        ImmutableMultimap rawQueryParams = futureDateOrUpcomingNextInvoice != null ? ImmutableMultimap.of((Object)"accountId", (Object)accountId.toString(), (Object)"targetDate", (Object)futureDateOrUpcomingNextInvoice, (Object)"dryRun", (Object)"true") : ImmutableMultimap.of((Object)"accountId", (Object)accountId.toString(), (Object)"dryRun", (Object)"true");
        Multimap<String, String> queryParams = this.paramsWithAudit((Multimap<String, String>)rawQueryParams, createdBy, reason, comment);
        return this.httpClient.doPost("/1.0/kb/invoices/dryRun", dryRunInfo, queryParams, Invoice.class);
    }

    public Invoice createInvoice(UUID accountId, LocalDate futureDate, String createdBy, String reason, String comment) throws KillBillClientException {
        String uri = "/1.0/kb/invoices";
        Multimap<String, String> queryParams = this.paramsWithAudit((Multimap<String, String>)ImmutableMultimap.of((Object)"accountId", (Object)accountId.toString(), (Object)"targetDate", (Object)futureDate.toString()), createdBy, reason, comment);
        return this.httpClient.doPostAndFollowLocation("/1.0/kb/invoices", null, queryParams, Invoice.class);
    }

    public Invoice adjustInvoiceItem(InvoiceItem invoiceItem, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.adjustInvoiceItem(invoiceItem, new DateTime(DateTimeZone.UTC), createdBy, reason, comment);
    }

    public Invoice adjustInvoiceItem(InvoiceItem invoiceItem, DateTime requestedDate, String createdBy, String reason, String comment) throws KillBillClientException {
        Preconditions.checkNotNull((Object)invoiceItem.getAccountId(), (Object)"InvoiceItem#accountId cannot be null");
        Preconditions.checkNotNull((Object)invoiceItem.getInvoiceId(), (Object)"InvoiceItem#invoiceId cannot be null");
        Preconditions.checkNotNull((Object)invoiceItem.getInvoiceItemId(), (Object)"InvoiceItem#invoiceItemId cannot be null");
        String uri = "/1.0/kb/invoices/" + invoiceItem.getInvoiceId();
        Multimap<String, String> queryParams = this.paramsWithAudit((Multimap<String, String>)ImmutableMultimap.of((Object)"requestedDate", (Object)requestedDate.toDateTimeISO().toString()), createdBy, reason, comment);
        return this.httpClient.doPostAndFollowLocation(uri, invoiceItem, queryParams, Invoice.class);
    }

    public InvoiceItem createExternalCharge(InvoiceItem externalCharge, DateTime requestedDate, Boolean autoPay, String createdBy, String reason, String comment) throws KillBillClientException {
        List<InvoiceItem> externalCharges = this.createExternalCharges((Iterable<InvoiceItem>)ImmutableList.of((Object)externalCharge), requestedDate, autoPay, createdBy, reason, comment);
        return externalCharges.isEmpty() ? null : externalCharges.get(0);
    }

    public List<InvoiceItem> createExternalCharges(Iterable<InvoiceItem> externalCharges, DateTime requestedDate, Boolean autoPay, String createdBy, String reason, String comment) throws KillBillClientException {
        HashMap externalChargesPerAccount = new HashMap();
        for (InvoiceItem externalCharge : externalCharges) {
            Preconditions.checkNotNull((Object)externalCharge.getAccountId(), (Object)"InvoiceItem#accountId cannot be null");
            Preconditions.checkNotNull((Object)externalCharge.getAmount(), (Object)"InvoiceItem#amount cannot be null");
            if (externalChargesPerAccount.get(externalCharge.getAccountId()) == null) {
                externalChargesPerAccount.put(externalCharge.getAccountId(), new LinkedList());
            }
            ((Collection)externalChargesPerAccount.get(externalCharge.getAccountId())).add(externalCharge);
        }
        LinkedList<InvoiceItem> createdExternalCharges = new LinkedList<InvoiceItem>();
        for (UUID accountId : externalChargesPerAccount.keySet()) {
            List<InvoiceItem> invoiceItems = this.createExternalCharges(accountId, (Iterable)externalChargesPerAccount.get(accountId), requestedDate, autoPay, createdBy, reason, comment);
            createdExternalCharges.addAll(invoiceItems);
        }
        return createdExternalCharges;
    }

    private List<InvoiceItem> createExternalCharges(UUID accountId, Iterable<InvoiceItem> externalCharges, DateTime requestedDate, Boolean autoPay, String createdBy, String reason, String comment) throws KillBillClientException {
        String uri = "/1.0/kb/invoices/charges/" + accountId;
        Multimap<String, String> queryParams = this.paramsWithAudit((Multimap<String, String>)ImmutableMultimap.of((Object)"requestedDate", (Object)requestedDate.toDateTimeISO().toString(), (Object)"payInvoice", (Object)autoPay.toString()), createdBy, reason, comment);
        return this.httpClient.doPost(uri, externalCharges, queryParams, InvoiceItems.class);
    }

    public void triggerInvoiceNotification(UUID invoiceId, String createdBy, String reason, String comment) throws KillBillClientException {
        String uri = "/1.0/kb/invoices/" + invoiceId.toString() + "/" + "emailNotifications";
        Multimap<String, String> queryParams = this.paramsWithAudit(createdBy, reason, comment);
        this.httpClient.doPost(uri, null, queryParams);
    }

    public void uploadInvoiceTemplate(String invoiceTemplate, boolean manualPay, String createdBy, String reason, String comment) throws KillBillClientException {
        String uri = "invoices" + (manualPay ? "/manualPayTemplate" : "/template");
        this.uploadFile(invoiceTemplate, uri, "text/html", createdBy, reason, comment, null);
    }

    public String getInvoiceTemplate(boolean manualPay) throws KillBillClientException {
        String uri = "invoices" + (manualPay ? "/manualPayTemplate" : "/template");
        return this.getResourceFile(uri, "text/html");
    }

    public void uploadInvoiceTranslation(String invoiceTemplate, String locale, String createdBy, String reason, String comment) throws KillBillClientException {
        String uri = "invoices/translation/" + locale;
        this.uploadFile(invoiceTemplate, uri, "text/plain", createdBy, reason, comment, null);
    }

    public String getInvoiceTranslation(String locale) throws KillBillClientException {
        String uri = "invoices/translation/" + locale;
        return this.getResourceFile(uri, "text/plain");
    }

    public void uploadCatalogTranslation(String invoiceTemplate, String locale, String createdBy, String reason, String comment) throws KillBillClientException {
        String uri = "invoices/catalogTranslation/" + locale;
        this.uploadFile(invoiceTemplate, uri, "text/plain", createdBy, reason, comment, null);
    }

    public String getCatalogTranslation(String locale) throws KillBillClientException {
        String uri = "invoices/catalogTranslation/" + locale;
        return this.getResourceFile(uri, "text/plain");
    }

    public Credit getCredit(UUID creditId) throws KillBillClientException {
        return this.getCredit(creditId, AuditLevel.NONE);
    }

    public Credit getCredit(UUID creditId, AuditLevel auditLevel) throws KillBillClientException {
        String uri = "/1.0/kb/credits/" + creditId;
        ImmutableMultimap queryParams = ImmutableMultimap.of((Object)"audit", (Object)auditLevel.toString());
        return this.httpClient.doGet(uri, (Multimap<String, String>)queryParams, Credit.class);
    }

    public Credit createCredit(Credit credit, String createdBy, String reason, String comment) throws KillBillClientException {
        Preconditions.checkNotNull((Object)credit.getAccountId(), (Object)"Credt#accountId cannot be null");
        Preconditions.checkNotNull((Object)credit.getCreditAmount(), (Object)"Credt#creditAmount cannot be null");
        Multimap<String, String> queryParams = this.paramsWithAudit(createdBy, reason, comment);
        return this.httpClient.doPostAndFollowLocation("/1.0/kb/credits", credit, queryParams, Credit.class);
    }

    public Payments searchPayments(String key) throws KillBillClientException {
        return this.searchPayments(key, 0L, 100L);
    }

    public Payments searchPayments(String key, Long offset, Long limit) throws KillBillClientException {
        return this.searchPayments(key, offset, limit, AuditLevel.NONE);
    }

    public Payments searchPayments(String key, Long offset, Long limit, AuditLevel auditLevel) throws KillBillClientException {
        String uri = "/1.0/kb/payments/search/" + UTF8UrlEncoder.encode((String)key);
        ImmutableMultimap queryParams = ImmutableMultimap.of((Object)"offset", (Object)String.valueOf(offset), (Object)"limit", (Object)String.valueOf(limit), (Object)"audit", (Object)auditLevel.toString());
        return this.httpClient.doGet(uri, (Multimap<String, String>)queryParams, Payments.class);
    }

    public InvoicePayments getInvoicePaymentsForAccount(UUID accountId) throws KillBillClientException {
        return this.getInvoicePaymentsForAccount(accountId, AuditLevel.NONE);
    }

    public InvoicePayments getInvoicePaymentsForAccount(UUID accountId, AuditLevel auditLevel) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/" + accountId + "/" + "invoicePayments";
        ImmutableMultimap queryParams = ImmutableMultimap.of((Object)"audit", (Object)auditLevel.toString());
        return this.httpClient.doGet(uri, (Multimap<String, String>)queryParams, InvoicePayments.class);
    }

    public InvoicePayments getInvoicePayment(UUID invoiceId) throws KillBillClientException {
        String uri = "/1.0/kb/invoices/" + invoiceId + "/" + "payments";
        return this.httpClient.doGet(uri, KillBillHttpClient.DEFAULT_EMPTY_QUERY, InvoicePayments.class);
    }

    public void payAllInvoices(UUID accountId, boolean externalPayment, BigDecimal paymentAmount, String createdBy, String reason, String comment) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/" + accountId + "/" + "invoicePayments";
        HashMultimap params = HashMultimap.create();
        params.put((Object)"externalPayment", (Object)String.valueOf(externalPayment));
        if (paymentAmount != null) {
            params.put((Object)"paymentAmount", (Object)String.valueOf(paymentAmount));
        }
        Multimap<String, String> queryParams = this.paramsWithAudit((Multimap<String, String>)params, createdBy, reason, comment);
        this.httpClient.doPost(uri, null, queryParams);
    }

    public InvoicePayment createInvoicePayment(InvoicePayment payment, boolean isExternal, String createdBy, String reason, String comment) throws KillBillClientException {
        Preconditions.checkNotNull((Object)payment.getAccountId(), (Object)"InvoiceItem#accountId cannot be null");
        Preconditions.checkNotNull((Object)payment.getTargetInvoiceId(), (Object)"InvoiceItem#invoiceId cannot be null");
        Preconditions.checkNotNull((Object)payment.getPurchasedAmount(), (Object)"InvoiceItem#amount cannot be null");
        String uri = "/1.0/kb/invoices/" + payment.getTargetInvoiceId() + "/" + "payments";
        Multimap<String, String> queryParams = this.paramsWithAudit((Multimap<String, String>)ImmutableMultimap.of((Object)"externalPayment", (Object)String.valueOf(isExternal)), createdBy, reason, comment);
        return this.httpClient.doPostAndFollowLocation(uri, payment, queryParams, InvoicePayment.class);
    }

    public Payments getPayments() throws KillBillClientException {
        return this.getPayments(0L, 100L);
    }

    public Payments getPayments(Long offset, Long limit) throws KillBillClientException {
        return this.getPayments(offset, limit, AuditLevel.NONE);
    }

    public Payments getPayments(Long offset, Long limit, AuditLevel auditLevel) throws KillBillClientException {
        return this.getPayments(offset, limit, null, (Map<String, String>)ImmutableMap.of(), auditLevel);
    }

    public Payments getPayments(Long offset, Long limit, @Nullable String pluginName, Map<String, String> pluginProperties, AuditLevel auditLevel) throws KillBillClientException {
        String uri = "/1.0/kb/payments/pagination";
        HashMultimap queryParams = HashMultimap.create();
        if (pluginName != null) {
            queryParams.put((Object)"pluginName", (Object)pluginName);
        }
        queryParams.put((Object)"offset", (Object)String.valueOf(offset));
        queryParams.put((Object)"limit", (Object)String.valueOf(limit));
        queryParams.put((Object)"audit", (Object)auditLevel.toString());
        this.storePluginPropertiesAsParams(pluginProperties, (Multimap<String, String>)queryParams);
        return this.httpClient.doGet("/1.0/kb/payments/pagination", (Multimap<String, String>)queryParams, Payments.class);
    }

    public Payment getPayment(UUID paymentId) throws KillBillClientException {
        return this.getPayment(paymentId, true);
    }

    public Payment getPayment(UUID paymentId, boolean withPluginInfo) throws KillBillClientException {
        return this.getPayment(paymentId, withPluginInfo, AuditLevel.NONE);
    }

    public Payment getPayment(UUID paymentId, boolean withPluginInfo, AuditLevel auditLevel) throws KillBillClientException {
        return this.getPayment(paymentId, withPluginInfo, (Map<String, String>)ImmutableMap.of(), auditLevel);
    }

    public Payment getPayment(UUID paymentId, boolean withPluginInfo, Map<String, String> pluginProperties, AuditLevel auditLevel) throws KillBillClientException {
        String uri = "/1.0/kb/payments/" + paymentId;
        HashMultimap queryParams = HashMultimap.create();
        queryParams.put((Object)"withPluginInfo", (Object)String.valueOf(withPluginInfo));
        queryParams.put((Object)"audit", (Object)auditLevel.toString());
        this.storePluginPropertiesAsParams(pluginProperties, (Multimap<String, String>)queryParams);
        return this.httpClient.doGet(uri, (Multimap<String, String>)queryParams, Payment.class);
    }

    public Payments getPaymentsForAccount(UUID accountId) throws KillBillClientException {
        return this.getPaymentsForAccount(accountId, AuditLevel.NONE);
    }

    public Payments getPaymentsForAccount(UUID accountId, AuditLevel auditLevel) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/" + accountId + "/" + "payments";
        ImmutableMultimap queryParams = ImmutableMultimap.of((Object)"audit", (Object)auditLevel.toString());
        return this.httpClient.doGet(uri, (Multimap<String, String>)queryParams, Payments.class);
    }

    public Payment createPayment(ComboPaymentTransaction comboPaymentTransaction, @Nullable List<String> controlPluginNames, Map<String, String> pluginProperties, String createdBy, String reason, String comment) throws KillBillClientException {
        String uri = "/1.0/kb/payments/combo";
        HashMultimap queryParams = HashMultimap.create();
        if (controlPluginNames != null) {
            queryParams.putAll((Object)"controlPluginName", controlPluginNames);
        }
        Multimap<String, String> queryParamsWithAudit = this.paramsWithAudit((Multimap<String, String>)queryParams, createdBy, reason, comment);
        this.storePluginPropertiesAsParams(pluginProperties, (Multimap<String, String>)queryParams);
        return this.httpClient.doPostAndFollowLocation("/1.0/kb/payments/combo", comboPaymentTransaction, queryParamsWithAudit, Payment.class);
    }

    public Payment createPayment(ComboPaymentTransaction comboPaymentTransaction, Map<String, String> pluginProperties, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createPayment(comboPaymentTransaction, null, pluginProperties, createdBy, reason, comment);
    }

    public Payment createPayment(UUID accountId, PaymentTransaction paymentTransaction, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createPayment(accountId, paymentTransaction, (Map<String, String>)ImmutableMap.of(), createdBy, reason, comment);
    }

    public Payment createPayment(UUID accountId, PaymentTransaction paymentTransaction, Map<String, String> pluginProperties, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createPayment(accountId, null, paymentTransaction, pluginProperties, createdBy, reason, comment);
    }

    public Payment createPayment(UUID accountId, @Nullable UUID paymentMethodId, PaymentTransaction paymentTransaction, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createPayment(accountId, paymentMethodId, paymentTransaction, (Map<String, String>)ImmutableMap.of(), createdBy, reason, comment);
    }

    public Payment createPayment(UUID accountId, @Nullable UUID paymentMethodId, PaymentTransaction paymentTransaction, Map<String, String> pluginProperties, String createdBy, String reason, String comment) throws KillBillClientException {
        Preconditions.checkNotNull((Object)accountId, (Object)"accountId cannot be null");
        Preconditions.checkNotNull((Object)paymentTransaction.getTransactionType(), (Object)"PaymentTransaction#transactionType cannot be null");
        Preconditions.checkArgument(("AUTHORIZE".equals(paymentTransaction.getTransactionType()) || "CREDIT".equals(paymentTransaction.getTransactionType()) || "PURCHASE".equals(paymentTransaction.getTransactionType()) ? 1 : 0) != 0, (Object)("Invalid paymentTransaction type " + paymentTransaction.getTransactionType()));
        Preconditions.checkNotNull((Object)paymentTransaction.getAmount(), (Object)"PaymentTransaction#amount cannot be null");
        Preconditions.checkNotNull((Object)paymentTransaction.getCurrency(), (Object)"PaymentTransaction#currency cannot be null");
        String uri = "/1.0/kb/accounts/" + accountId + "/" + "payments";
        HashMultimap params = HashMultimap.create();
        if (paymentMethodId != null) {
            params.put((Object)"paymentMethodId", (Object)paymentMethodId.toString());
        }
        this.storePluginPropertiesAsParams(pluginProperties, (Multimap<String, String>)params);
        Multimap<String, String> queryParams = this.paramsWithAudit((Multimap<String, String>)params, createdBy, reason, comment);
        return this.httpClient.doPostAndFollowLocation(uri, paymentTransaction, queryParams, Payment.class);
    }

    public Payment completePayment(PaymentTransaction paymentTransaction, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.completePayment(paymentTransaction, (Map<String, String>)ImmutableMap.of(), createdBy, reason, comment);
    }

    public Payment completePayment(PaymentTransaction paymentTransaction, Map<String, String> pluginProperties, String createdBy, String reason, String comment) throws KillBillClientException {
        Preconditions.checkState((paymentTransaction.getPaymentId() != null || paymentTransaction.getPaymentExternalKey() != null ? 1 : 0) != 0, (Object)"PaymentTransaction#paymentId or PaymentTransaction#paymentExternalKey cannot be null");
        String uri = paymentTransaction.getPaymentId() != null ? "/1.0/kb/payments/" + paymentTransaction.getPaymentId() : "/1.0/kb/payments";
        HashMultimap params = HashMultimap.create();
        this.storePluginPropertiesAsParams(pluginProperties, (Multimap<String, String>)params);
        Multimap<String, String> queryParams = this.paramsWithAudit((Multimap<String, String>)params, createdBy, reason, comment);
        return this.httpClient.doPutAndFollowLocation(uri, paymentTransaction, queryParams, Payment.class);
    }

    public Payment captureAuthorization(PaymentTransaction paymentTransaction, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.captureAuthorization(paymentTransaction, (Map<String, String>)ImmutableMap.of(), createdBy, reason, comment);
    }

    public Payment captureAuthorization(PaymentTransaction paymentTransaction, Map<String, String> pluginProperties, String createdBy, String reason, String comment) throws KillBillClientException {
        Preconditions.checkState((paymentTransaction.getPaymentId() != null || paymentTransaction.getPaymentExternalKey() != null ? 1 : 0) != 0, (Object)"PaymentTransaction#paymentId or PaymentTransaction#paymentExternalKey cannot be null");
        Preconditions.checkNotNull((Object)paymentTransaction.getAmount(), (Object)"PaymentTransaction#amount cannot be null");
        String uri = paymentTransaction.getPaymentId() != null ? "/1.0/kb/payments/" + paymentTransaction.getPaymentId() : "/1.0/kb/payments";
        HashMultimap params = HashMultimap.create();
        this.storePluginPropertiesAsParams(pluginProperties, (Multimap<String, String>)params);
        Multimap<String, String> queryParams = this.paramsWithAudit((Multimap<String, String>)params, createdBy, reason, comment);
        return this.httpClient.doPostAndFollowLocation(uri, paymentTransaction, queryParams, Payment.class);
    }

    public Payment refundPayment(PaymentTransaction paymentTransaction, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.refundPayment(paymentTransaction, (Map<String, String>)ImmutableMap.of(), createdBy, reason, comment);
    }

    public Payment refundPayment(PaymentTransaction paymentTransaction, Map<String, String> pluginProperties, String createdBy, String reason, String comment) throws KillBillClientException {
        Preconditions.checkState((paymentTransaction.getPaymentId() != null || paymentTransaction.getPaymentExternalKey() != null ? 1 : 0) != 0, (Object)"PaymentTransaction#paymentId or PaymentTransaction#paymentExternalKey cannot be null");
        Preconditions.checkNotNull((Object)paymentTransaction.getAmount(), (Object)"PaymentTransaction#amount cannot be null");
        String uri = paymentTransaction.getPaymentId() != null ? "/1.0/kb/payments/" + paymentTransaction.getPaymentId() + "/" + "refunds" : "/1.0/kb/payments/refunds";
        HashMultimap params = HashMultimap.create();
        this.storePluginPropertiesAsParams(pluginProperties, (Multimap<String, String>)params);
        Multimap<String, String> queryParams = this.paramsWithAudit((Multimap<String, String>)params, createdBy, reason, comment);
        return this.httpClient.doPostAndFollowLocation(uri, paymentTransaction, queryParams, Payment.class);
    }

    public Payment chargebackPayment(PaymentTransaction paymentTransaction, String createdBy, String reason, String comment) throws KillBillClientException {
        Preconditions.checkState((paymentTransaction.getPaymentId() != null || paymentTransaction.getPaymentExternalKey() != null ? 1 : 0) != 0, (Object)"PaymentTransaction#paymentId or PaymentTransaction#paymentExternalKey cannot be null");
        Preconditions.checkNotNull((Object)paymentTransaction.getAmount(), (Object)"PaymentTransaction#amount cannot be null");
        String uri = paymentTransaction.getPaymentId() != null ? "/1.0/kb/payments/" + paymentTransaction.getPaymentId() + "/" + "chargebacks" : "/1.0/kb/payments/chargebacks";
        HashMultimap params = HashMultimap.create();
        Multimap<String, String> queryParams = this.paramsWithAudit((Multimap<String, String>)params, createdBy, reason, comment);
        return this.httpClient.doPostAndFollowLocation(uri, paymentTransaction, queryParams, Payment.class);
    }

    public Payment voidPayment(UUID paymentId, String transactionExternalKey, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.voidPayment(paymentId, null, transactionExternalKey, (Map<String, String>)ImmutableMap.of(), createdBy, reason, comment);
    }

    public Payment voidPayment(UUID paymentId, String paymentExternalKey, String transactionExternalKey, Map<String, String> pluginProperties, String createdBy, String reason, String comment) throws KillBillClientException {
        Preconditions.checkState((paymentId != null || paymentExternalKey != null ? 1 : 0) != 0, (Object)"PaymentTransaction#paymentId or PaymentTransaction#paymentExternalKey cannot be null");
        String uri = paymentId != null ? "/1.0/kb/payments/" + paymentId : "/1.0/kb/payments";
        PaymentTransaction paymentTransaction = new PaymentTransaction();
        if (paymentExternalKey != null) {
            paymentTransaction.setPaymentExternalKey(paymentExternalKey);
        }
        paymentTransaction.setTransactionExternalKey(transactionExternalKey);
        HashMultimap params = HashMultimap.create();
        this.storePluginPropertiesAsParams(pluginProperties, (Multimap<String, String>)params);
        Multimap<String, String> queryParams = this.paramsWithAudit((Multimap<String, String>)params, createdBy, reason, comment);
        return this.httpClient.doDeleteAndFollowLocation(uri, paymentTransaction, queryParams, Payment.class);
    }

    public HostedPaymentPageFormDescriptor buildFormDescriptor(HostedPaymentPageFields fields, UUID kbAccountId, @Nullable UUID kbPaymentMethodId, Map<String, String> pluginProperties, String createdBy, String reason, String comment) throws KillBillClientException {
        String uri = "/1.0/kb/paymentGateways/hosted/form/" + kbAccountId;
        HashMultimap params = HashMultimap.create();
        this.storePluginPropertiesAsParams(pluginProperties, (Multimap<String, String>)params);
        if (kbPaymentMethodId != null) {
            params.put((Object)"paymentMethodId", (Object)kbPaymentMethodId.toString());
        }
        Multimap<String, String> queryParams = this.paramsWithAudit((Multimap<String, String>)params, createdBy, reason, comment);
        return this.httpClient.doPost(uri, fields, queryParams, HostedPaymentPageFormDescriptor.class);
    }

    public HostedPaymentPageFormDescriptor buildFormDescriptor(ComboHostedPaymentPage comboHostedPaymentPage, Map<String, String> pluginProperties, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.buildFormDescriptor(comboHostedPaymentPage, null, pluginProperties, createdBy, reason, comment);
    }

    public HostedPaymentPageFormDescriptor buildFormDescriptor(ComboHostedPaymentPage comboHostedPaymentPage, @Nullable List<String> controlPluginNames, Map<String, String> pluginProperties, String createdBy, String reason, String comment) throws KillBillClientException {
        String uri = "/1.0/kb/paymentGateways/hosted/form";
        HashMultimap params = HashMultimap.create();
        if (controlPluginNames != null) {
            params.putAll((Object)"controlPluginName", controlPluginNames);
        }
        this.storePluginPropertiesAsParams(pluginProperties, (Multimap<String, String>)params);
        Multimap<String, String> queryParams = this.paramsWithAudit((Multimap<String, String>)params, createdBy, reason, comment);
        return this.httpClient.doPost("/1.0/kb/paymentGateways/hosted/form", comboHostedPaymentPage, queryParams, HostedPaymentPageFormDescriptor.class);
    }

    public Response processNotification(String notification, String pluginName, Map<String, String> pluginProperties, String createdBy, String reason, String comment) throws KillBillClientException {
        String uri = "/1.0/kb/paymentGateways/notification/" + pluginName;
        HashMultimap params = HashMultimap.create();
        this.storePluginPropertiesAsParams(pluginProperties, (Multimap<String, String>)params);
        Multimap<String, String> queryParams = this.paramsWithAudit((Multimap<String, String>)params, createdBy, reason, comment);
        return this.httpClient.doPost(uri, notification, queryParams);
    }

    public InvoicePayment createInvoicePaymentRefund(InvoicePaymentTransaction refundTransaction, String createdBy, String reason, String comment) throws KillBillClientException {
        Preconditions.checkNotNull((Object)refundTransaction.getPaymentId(), (Object)"InvoicePaymentTransaction#paymentId cannot be null");
        if (refundTransaction.getAdjustments() != null) {
            for (InvoiceItem invoiceItem : refundTransaction.getAdjustments()) {
                Preconditions.checkNotNull((Object)invoiceItem.getInvoiceItemId(), (Object)"InvoiceItem#invoiceItemId cannot be null");
            }
        }
        String uri = "/1.0/kb/invoicePayments/" + refundTransaction.getPaymentId() + "/" + "refunds";
        Multimap<String, String> queryParams = this.paramsWithAudit(createdBy, reason, comment);
        return this.httpClient.doPostAndFollowLocation(uri, refundTransaction, queryParams, InvoicePayment.class);
    }

    public InvoicePayment createInvoicePaymentChargeback(InvoicePaymentTransaction chargebackTransaction, String createdBy, String reason, String comment) throws KillBillClientException {
        Preconditions.checkNotNull((Object)chargebackTransaction.getPaymentId(), (Object)"InvoicePaymentTransaction#paymentId cannot be null");
        String uri = "/1.0/kb/invoicePayments/" + chargebackTransaction.getPaymentId() + "/" + "chargebacks";
        Multimap<String, String> queryParams = this.paramsWithAudit(createdBy, reason, comment);
        return this.httpClient.doPostAndFollowLocation(uri, chargebackTransaction, queryParams, InvoicePayment.class);
    }

    public PaymentMethods getPaymentMethods() throws KillBillClientException {
        return this.getPaymentMethods(0L, 100L);
    }

    public PaymentMethods getPaymentMethods(Long offset, Long limit) throws KillBillClientException {
        return this.getPaymentMethods(offset, limit, AuditLevel.NONE);
    }

    public PaymentMethods getPaymentMethods(Long offset, Long limit, AuditLevel auditLevel) throws KillBillClientException {
        String uri = "/1.0/kb/paymentMethods/pagination";
        ImmutableMultimap queryParams = ImmutableMultimap.of((Object)"offset", (Object)String.valueOf(offset), (Object)"limit", (Object)String.valueOf(limit), (Object)"audit", (Object)auditLevel.toString());
        return this.httpClient.doGet("/1.0/kb/paymentMethods/pagination", (Multimap<String, String>)queryParams, PaymentMethods.class);
    }

    public PaymentMethods searchPaymentMethods(String key) throws KillBillClientException {
        return this.searchPaymentMethods(key, 0L, 100L);
    }

    public PaymentMethods searchPaymentMethods(String key, Long offset, Long limit) throws KillBillClientException {
        return this.searchPaymentMethods(key, offset, limit, AuditLevel.NONE);
    }

    public PaymentMethods searchPaymentMethods(String key, Long offset, Long limit, AuditLevel auditLevel) throws KillBillClientException {
        String uri = "/1.0/kb/paymentMethods/search/" + UTF8UrlEncoder.encode((String)key);
        ImmutableMultimap queryParams = ImmutableMultimap.of((Object)"offset", (Object)String.valueOf(offset), (Object)"limit", (Object)String.valueOf(limit), (Object)"audit", (Object)auditLevel.toString());
        return this.httpClient.doGet(uri, KillBillHttpClient.DEFAULT_EMPTY_QUERY, PaymentMethods.class);
    }

    public PaymentMethod getPaymentMethod(UUID paymentMethodId) throws KillBillClientException {
        return this.getPaymentMethod(paymentMethodId, false);
    }

    public PaymentMethod getPaymentMethod(UUID paymentMethodId, boolean withPluginInfo) throws KillBillClientException {
        return this.getPaymentMethod(paymentMethodId, withPluginInfo, AuditLevel.NONE);
    }

    public PaymentMethod getPaymentMethod(UUID paymentMethodId, boolean withPluginInfo, AuditLevel auditLevel) throws KillBillClientException {
        String uri = "/1.0/kb/paymentMethods/" + paymentMethodId;
        ImmutableMultimap queryParams = ImmutableMultimap.of((Object)"withPluginInfo", (Object)String.valueOf(withPluginInfo), (Object)"audit", (Object)auditLevel.toString());
        return this.httpClient.doGet(uri, (Multimap<String, String>)queryParams, PaymentMethod.class);
    }

    public PaymentMethod getPaymentMethodByKey(String externalKey) throws KillBillClientException {
        return this.getPaymentMethodByKey(externalKey, false);
    }

    public PaymentMethod getPaymentMethodByKey(String externalKey, boolean withPluginInfo) throws KillBillClientException {
        return this.getPaymentMethodByKey(externalKey, withPluginInfo, AuditLevel.NONE);
    }

    public PaymentMethod getPaymentMethodByKey(String externalKey, boolean withPluginInfo, AuditLevel auditLevel) throws KillBillClientException {
        String uri = "/1.0/kb/paymentMethods";
        ImmutableMultimap queryParams = ImmutableMultimap.of((Object)"externalKey", (Object)externalKey, (Object)"withPluginInfo", (Object)String.valueOf(withPluginInfo), (Object)"audit", (Object)auditLevel.toString());
        return this.httpClient.doGet("/1.0/kb/paymentMethods", (Multimap<String, String>)queryParams, PaymentMethod.class);
    }

    public PaymentMethods getPaymentMethodsForAccount(UUID accountId) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/" + accountId + "/" + "paymentMethods";
        return this.httpClient.doGet(uri, KillBillHttpClient.DEFAULT_EMPTY_QUERY, PaymentMethods.class);
    }

    public PaymentMethods searchPaymentMethodsByKey(String key) throws KillBillClientException {
        return this.searchPaymentMethodsByKeyAndPlugin(key, null);
    }

    public PaymentMethods searchPaymentMethodsByKey(String key, boolean withPluginInfo) throws KillBillClientException {
        return this.searchPaymentMethodsByKeyAndPlugin(key, withPluginInfo, null, AuditLevel.NONE);
    }

    public PaymentMethods searchPaymentMethodsByKeyAndPlugin(String key, @Nullable String pluginName) throws KillBillClientException {
        return this.searchPaymentMethodsByKeyAndPlugin(key, pluginName, AuditLevel.NONE);
    }

    public PaymentMethods searchPaymentMethodsByKeyAndPlugin(String key, @Nullable String pluginName, AuditLevel auditLevel) throws KillBillClientException {
        return this.searchPaymentMethodsByKeyAndPlugin(key, pluginName != null, pluginName, auditLevel);
    }

    public PaymentMethods searchPaymentMethodsByKeyAndPlugin(String key, boolean withPluginInfo, @Nullable String pluginName, AuditLevel auditLevel) throws KillBillClientException {
        String uri = "/1.0/kb/paymentMethods/search/" + UTF8UrlEncoder.encode((String)key);
        ImmutableMultimap queryParams = ImmutableMultimap.of((Object)"pluginName", (Object)Strings.nullToEmpty((String)pluginName), (Object)"withPluginInfo", (Object)String.valueOf(withPluginInfo), (Object)"audit", (Object)auditLevel.toString());
        return this.httpClient.doGet(uri, (Multimap<String, String>)queryParams, PaymentMethods.class);
    }

    public PaymentMethod createPaymentMethod(PaymentMethod paymentMethod, String createdBy, String reason, String comment) throws KillBillClientException {
        Preconditions.checkNotNull((Object)paymentMethod.getAccountId(), (Object)"PaymentMethod#accountId cannot be null");
        Preconditions.checkNotNull((Object)paymentMethod.getPluginName(), (Object)"PaymentMethod#pluginName cannot be null");
        String uri = "/1.0/kb/accounts/" + paymentMethod.getAccountId() + "/" + "paymentMethods";
        Multimap<String, String> queryParams = this.paramsWithAudit((Multimap<String, String>)ImmutableMultimap.of((Object)"isDefault", (Object)(paymentMethod.getIsDefault() != false ? "true" : "false")), createdBy, reason, comment);
        return this.httpClient.doPostAndFollowLocation(uri, paymentMethod, queryParams, PaymentMethod.class);
    }

    public void updateDefaultPaymentMethod(UUID accountId, UUID paymentMethodId, String createdBy, String reason, String comment) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/" + accountId + "/" + "paymentMethods" + "/" + paymentMethodId + "/" + "setDefault";
        Multimap<String, String> queryParams = this.paramsWithAudit(createdBy, reason, comment);
        this.httpClient.doPut(uri, null, queryParams);
    }

    public void deletePaymentMethod(UUID paymentMethodId, Boolean deleteDefault, String createdBy, String reason, String comment) throws KillBillClientException {
        String uri = "/1.0/kb/paymentMethods/" + paymentMethodId;
        Multimap<String, String> queryParams = this.paramsWithAudit((Multimap<String, String>)ImmutableMultimap.of((Object)"deleteDefaultPmWithAutoPayOff", (Object)deleteDefault.toString()), createdBy, reason, comment);
        this.httpClient.doDelete(uri, queryParams);
    }

    public void uploadXMLOverdueConfig(String overdueConfigPath, String createdBy, String reason, String comment) throws KillBillClientException {
        String uri = "/1.0/kb/overdue";
        this.uploadFile(overdueConfigPath, "/1.0/kb/overdue", "application/xml", createdBy, reason, comment, null);
    }

    public String getXMLOverdueConfig() throws KillBillClientException {
        String uri = "/1.0/kb/overdue";
        return this.getResourceFile("/1.0/kb/overdue", "application/xml");
    }

    public OverdueState getOverdueStateForAccount(UUID accountId) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/" + accountId + "/" + "overdue";
        return this.httpClient.doGet(uri, KillBillHttpClient.DEFAULT_EMPTY_QUERY, OverdueState.class);
    }

    public TagDefinitions getTagDefinitions() throws KillBillClientException {
        return this.httpClient.doGet("/1.0/kb/tagDefinitions", KillBillHttpClient.DEFAULT_EMPTY_QUERY, TagDefinitions.class);
    }

    public TagDefinition getTagDefinition(UUID tagDefinitionId) throws KillBillClientException {
        String uri = "/1.0/kb/tagDefinitions/" + tagDefinitionId;
        return this.httpClient.doGet(uri, KillBillHttpClient.DEFAULT_EMPTY_QUERY, TagDefinition.class);
    }

    public TagDefinition createTagDefinition(TagDefinition tagDefinition, String createdBy, String reason, String comment) throws KillBillClientException {
        Multimap<String, String> queryParams = this.paramsWithAudit(createdBy, reason, comment);
        return this.httpClient.doPostAndFollowLocation("/1.0/kb/tagDefinitions", tagDefinition, queryParams, TagDefinition.class);
    }

    public void deleteTagDefinition(UUID tagDefinitionId, String createdBy, String reason, String comment) throws KillBillClientException {
        String uri = "/1.0/kb/tagDefinitions/" + tagDefinitionId;
        Multimap<String, String> queryParams = this.paramsWithAudit(createdBy, reason, comment);
        this.httpClient.doDelete(uri, queryParams);
    }

    public Tags getTags() throws KillBillClientException {
        return this.getTags(0L, 100L);
    }

    public Tags getTags(Long offset, Long limit) throws KillBillClientException {
        return this.getTags(offset, limit, AuditLevel.NONE);
    }

    public Tags getTags(Long offset, Long limit, AuditLevel auditLevel) throws KillBillClientException {
        String uri = "/1.0/kb/tags/pagination";
        ImmutableMultimap queryParams = ImmutableMultimap.of((Object)"offset", (Object)String.valueOf(offset), (Object)"limit", (Object)String.valueOf(limit), (Object)"audit", (Object)auditLevel.toString());
        return this.httpClient.doGet("/1.0/kb/tags/pagination", (Multimap<String, String>)queryParams, Tags.class);
    }

    public Tags searchTags(String key) throws KillBillClientException {
        return this.searchTags(key, 0L, 100L);
    }

    public Tags searchTags(String key, Long offset, Long limit) throws KillBillClientException {
        return this.searchTags(key, offset, limit, AuditLevel.NONE);
    }

    public Tags searchTags(String key, Long offset, Long limit, AuditLevel auditLevel) throws KillBillClientException {
        String uri = "/1.0/kb/tags/search/" + UTF8UrlEncoder.encode((String)key);
        ImmutableMultimap queryParams = ImmutableMultimap.of((Object)"offset", (Object)String.valueOf(offset), (Object)"limit", (Object)String.valueOf(limit), (Object)"audit", (Object)auditLevel.toString());
        return this.httpClient.doGet(uri, KillBillHttpClient.DEFAULT_EMPTY_QUERY, Tags.class);
    }

    public Tags getAllAccountTags(UUID accountId, String objectType) throws KillBillClientException {
        return this.getAllAccountTags(accountId, objectType);
    }

    public Tags getAllAccountTags(UUID accountId, @Nullable String objectType, AuditLevel auditLevel) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/" + accountId + "/" + "allTags";
        ImmutableMultimap.Builder mapBuilder = ImmutableMultimap.builder().put((Object)"audit", (Object)auditLevel.toString());
        if (objectType != null) {
            mapBuilder.put((Object)"objectType", (Object)objectType);
        }
        return this.httpClient.doGet(uri, (Multimap<String, String>)mapBuilder.build(), Tags.class);
    }

    public Tags getAccountTags(UUID accountId) throws KillBillClientException {
        return this.getAccountTags(accountId, AuditLevel.NONE);
    }

    public Tags getAccountTags(UUID accountId, AuditLevel auditLevel) throws KillBillClientException {
        return this.getObjectTags(accountId, "/1.0/kb/accounts", auditLevel);
    }

    public Tags createAccountTag(UUID accountId, UUID tagDefinitionId, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createObjectTag(accountId, "/1.0/kb/accounts", tagDefinitionId, createdBy, reason, comment);
    }

    public void deleteAccountTag(UUID accountId, UUID tagDefinitionId, String createdBy, String reason, String comment) throws KillBillClientException {
        this.deleteObjectTag(accountId, "/1.0/kb/accounts", tagDefinitionId, createdBy, reason, comment);
    }

    public Tags getBundleTags(UUID bundleId) throws KillBillClientException {
        return this.getBundleTags(bundleId, AuditLevel.NONE);
    }

    public Tags getBundleTags(UUID bundleId, AuditLevel auditLevel) throws KillBillClientException {
        return this.getObjectTags(bundleId, "/1.0/kb/bundles", auditLevel);
    }

    public Tags createBundleTag(UUID bundleId, UUID tagDefinitionId, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createObjectTag(bundleId, "/1.0/kb/bundles", tagDefinitionId, createdBy, reason, comment);
    }

    public void deleteBundleTag(UUID bundleId, UUID tagDefinitionId, String createdBy, String reason, String comment) throws KillBillClientException {
        this.deleteObjectTag(bundleId, "/1.0/kb/bundles", tagDefinitionId, createdBy, reason, comment);
    }

    public Tags getSubscriptionTags(UUID subscriptionId) throws KillBillClientException {
        return this.getBundleTags(subscriptionId, AuditLevel.NONE);
    }

    public Tags getSubscriptionTags(UUID subscriptionId, AuditLevel auditLevel) throws KillBillClientException {
        return this.getObjectTags(subscriptionId, "/1.0/kb/subscriptions", auditLevel);
    }

    public Tags createSubscriptionTag(UUID subscriptionId, UUID tagDefinitionId, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createObjectTag(subscriptionId, "/1.0/kb/subscriptions", tagDefinitionId, createdBy, reason, comment);
    }

    public void deleteSubscriptionTag(UUID subscriptionId, UUID tagDefinitionId, String createdBy, String reason, String comment) throws KillBillClientException {
        this.deleteObjectTag(subscriptionId, "/1.0/kb/subscriptions", tagDefinitionId, createdBy, reason, comment);
    }

    public Tags getInvoiceTags(UUID invoiceId) throws KillBillClientException {
        return this.getBundleTags(invoiceId, AuditLevel.NONE);
    }

    public Tags getInvoiceTags(UUID invoiceId, AuditLevel auditLevel) throws KillBillClientException {
        return this.getObjectTags(invoiceId, "/1.0/kb/invoices", auditLevel);
    }

    public Tags createInvoiceTag(UUID invoiceId, UUID tagDefinitionId, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createObjectTag(invoiceId, "/1.0/kb/invoices", tagDefinitionId, createdBy, reason, comment);
    }

    public void deleteInvoiceTag(UUID invoiceId, UUID tagDefinitionId, String createdBy, String reason, String comment) throws KillBillClientException {
        this.deleteObjectTag(invoiceId, "/1.0/kb/invoices", tagDefinitionId, createdBy, reason, comment);
    }

    public Tags getPaymentTags(UUID paymentId) throws KillBillClientException {
        return this.getBundleTags(paymentId, AuditLevel.NONE);
    }

    public Tags getPaymentTags(UUID paymentId, AuditLevel auditLevel) throws KillBillClientException {
        return this.getObjectTags(paymentId, "/1.0/kb/payments", auditLevel);
    }

    public Tags createPaymentTag(UUID paymentId, UUID tagDefinitionId, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createObjectTag(paymentId, "/1.0/kb/payments", tagDefinitionId, createdBy, reason, comment);
    }

    public void deletePaymentTag(UUID paymentId, UUID tagDefinitionId, String createdBy, String reason, String comment) throws KillBillClientException {
        this.deleteObjectTag(paymentId, "/1.0/kb/payments", tagDefinitionId, createdBy, reason, comment);
    }

    private Tags getObjectTags(UUID objectId, String resourcePathPrefix, AuditLevel auditLevel) throws KillBillClientException {
        String uri = resourcePathPrefix + "/" + objectId + "/" + "tags";
        ImmutableMultimap queryParams = ImmutableMultimap.of((Object)"audit", (Object)auditLevel.toString());
        return this.httpClient.doGet(uri, (Multimap<String, String>)queryParams, Tags.class);
    }

    private Tags createObjectTag(UUID objectId, String resourcePathPrefix, UUID tagDefinitionId, String createdBy, String reason, String comment) throws KillBillClientException {
        String uri = resourcePathPrefix + "/" + objectId + "/" + "tags";
        Multimap<String, String> queryParams = this.paramsWithAudit((Multimap<String, String>)ImmutableMultimap.of((Object)"tagList", (Object)tagDefinitionId.toString()), createdBy, reason, comment);
        return this.httpClient.doPostAndFollowLocation(uri, null, queryParams, Tags.class);
    }

    private void deleteObjectTag(UUID objectId, String resourcePathPrefix, UUID tagDefinitionId, String createdBy, String reason, String comment) throws KillBillClientException {
        String uri = resourcePathPrefix + "/" + objectId + "/" + "tags";
        Multimap<String, String> queryParams = this.paramsWithAudit((Multimap<String, String>)ImmutableMultimap.of((Object)"tagList", (Object)tagDefinitionId.toString()), createdBy, reason, comment);
        this.httpClient.doDelete(uri, queryParams);
    }

    public CustomFields getCustomFields() throws KillBillClientException {
        return this.getCustomFields(0L, 100L);
    }

    public CustomFields getCustomFields(Long offset, Long limit) throws KillBillClientException {
        return this.getCustomFields(offset, limit, AuditLevel.NONE);
    }

    public CustomFields getCustomFields(Long offset, Long limit, AuditLevel auditLevel) throws KillBillClientException {
        String uri = "/1.0/kb/customFields/pagination";
        ImmutableMultimap queryParams = ImmutableMultimap.of((Object)"offset", (Object)String.valueOf(offset), (Object)"limit", (Object)String.valueOf(limit), (Object)"audit", (Object)auditLevel.toString());
        return this.httpClient.doGet("/1.0/kb/customFields/pagination", (Multimap<String, String>)queryParams, CustomFields.class);
    }

    public CustomFields searchCustomFields(String key) throws KillBillClientException {
        return this.searchCustomFields(key, 0L, 100L);
    }

    public CustomFields searchCustomFields(String key, Long offset, Long limit) throws KillBillClientException {
        return this.searchCustomFields(key, offset, limit, AuditLevel.NONE);
    }

    public CustomFields searchCustomFields(String key, Long offset, Long limit, AuditLevel auditLevel) throws KillBillClientException {
        String uri = "/1.0/kb/customFields/search/" + UTF8UrlEncoder.encode((String)key);
        ImmutableMultimap queryParams = ImmutableMultimap.of((Object)"offset", (Object)String.valueOf(offset), (Object)"limit", (Object)String.valueOf(limit), (Object)"audit", (Object)auditLevel.toString());
        return this.httpClient.doGet(uri, KillBillHttpClient.DEFAULT_EMPTY_QUERY, CustomFields.class);
    }

    public CustomFields getAccountCustomFields(UUID accountId) throws KillBillClientException {
        return this.getAccountCustomFields(accountId, AuditLevel.NONE);
    }

    public CustomFields getAccountCustomFields(UUID accountId, AuditLevel auditLevel) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/" + accountId + "/" + "customFields";
        ImmutableMultimap queryParams = ImmutableMultimap.of((Object)"audit", (Object)auditLevel.toString());
        return this.httpClient.doGet(uri, (Multimap<String, String>)queryParams, CustomFields.class);
    }

    public CustomFields createAccountCustomField(UUID accountId, CustomField customField, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createAccountCustomFields(accountId, (Iterable<CustomField>)ImmutableList.of((Object)customField), createdBy, reason, comment);
    }

    public CustomFields createAccountCustomFields(UUID accountId, Iterable<CustomField> customFields, String createdBy, String reason, String comment) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/" + accountId + "/" + "customFields";
        Multimap<String, String> queryParams = this.paramsWithAudit(createdBy, reason, comment);
        return this.httpClient.doPostAndFollowLocation(uri, customFields, queryParams, CustomFields.class);
    }

    public void deleteAccountCustomField(UUID accountId, UUID customFieldId, String createdBy, String reason, String comment) throws KillBillClientException {
        this.deleteAccountCustomFields(accountId, (Iterable<UUID>)ImmutableList.of((Object)customFieldId), createdBy, reason, comment);
    }

    public void deleteAccountCustomFields(UUID accountId, String createdBy, String reason, String comment) throws KillBillClientException {
        this.deleteAccountCustomFields(accountId, null, createdBy, reason, comment);
    }

    public void deleteAccountCustomFields(UUID accountId, @Nullable Iterable<UUID> customFieldIds, String createdBy, String reason, String comment) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/" + accountId + "/" + "customFields";
        ImmutableMultimap paramCustomFields = customFieldIds == null ? ImmutableMultimap.of() : ImmutableMultimap.of((Object)"customFieldList", (Object)Joiner.on((String)",").join(customFieldIds));
        Multimap<String, String> queryParams = this.paramsWithAudit((Multimap<String, String>)paramCustomFields, createdBy, reason, comment);
        this.httpClient.doDelete(uri, queryParams);
    }

    public Catalog getSimpleCatalog() throws KillBillClientException {
        String uri = "/1.0/kb/catalog/simpleCatalog";
        return this.httpClient.doGet("/1.0/kb/catalog/simpleCatalog", KillBillHttpClient.DEFAULT_EMPTY_QUERY, Catalog.class);
    }

    public List<PlanDetail> getAvailableAddons(String baseProductName) throws KillBillClientException {
        String uri = "/1.0/kb/catalog/availableAddons";
        ImmutableMultimap queryParams = ImmutableMultimap.of((Object)"baseProductName", (Object)baseProductName);
        return this.httpClient.doGet("/1.0/kb/catalog/availableAddons", (Multimap<String, String>)queryParams, PlanDetails.class);
    }

    public List<PlanDetail> getBasePlans() throws KillBillClientException {
        String uri = "/1.0/kb/catalog/availableBasePlans";
        return this.httpClient.doGet("/1.0/kb/catalog/availableBasePlans", KillBillHttpClient.DEFAULT_EMPTY_QUERY, PlanDetails.class);
    }

    public void uploadXMLCatalog(String catalogPath, String createdBy, String reason, String comment) throws KillBillClientException {
        String uri = "/1.0/kb/catalog";
        this.uploadFile(catalogPath, "/1.0/kb/catalog", "application/xml; charset=utf-8", createdBy, reason, comment, null);
    }

    public String getJSONCatalog() throws KillBillClientException {
        String uri = "/1.0/kb/catalog";
        return this.getResourceFile("/1.0/kb/catalog", "application/json");
    }

    public String getXMLCatalog() throws KillBillClientException {
        String uri = "/1.0/kb/catalog";
        return this.getResourceFile("/1.0/kb/catalog", "application/xml");
    }

    public Tenant createTenant(Tenant tenant, String createdBy, String reason, String comment) throws KillBillClientException {
        Preconditions.checkNotNull((Object)tenant.getApiKey(), (Object)"Tenant#apiKey cannot be null");
        Preconditions.checkNotNull((Object)tenant.getApiSecret(), (Object)"Tenant#apiSecret cannot be null");
        Multimap<String, String> queryParams = this.paramsWithAudit(createdBy, reason, comment);
        return this.httpClient.doPostAndFollowLocation("/1.0/kb/tenants", tenant, queryParams, Tenant.class);
    }

    public TenantKey registerCallbackNotificationForTenant(String callback, String createdBy, String reason, String comment) throws KillBillClientException {
        String uri = "/1.0/kb/tenants/registerNotificationCallback";
        Multimap<String, String> queryParams = this.paramsWithAudit((Multimap<String, String>)ImmutableMultimap.of((Object)"cb", (Object)callback), createdBy, reason, comment);
        return this.httpClient.doPostAndFollowLocation("/1.0/kb/tenants/registerNotificationCallback", null, queryParams, TenantKey.class);
    }

    public TenantKey getCallbackNotificationForTenant() throws KillBillClientException {
        String uri = "/1.0/kb/tenants/registerNotificationCallback";
        return this.httpClient.doGet("/1.0/kb/tenants/registerNotificationCallback", KillBillHttpClient.DEFAULT_EMPTY_QUERY, TenantKey.class);
    }

    public void unregisterCallbackNotificationForTenant(String createdBy, String reason, String comment) throws KillBillClientException {
        String uri = "/1.0/kb/tenants/registerNotificationCallback";
        Multimap<String, String> queryParams = this.paramsWithAudit(createdBy, reason, comment);
        this.httpClient.doDelete("/1.0/kb/tenants/registerNotificationCallback", queryParams);
    }

    public TenantKey registerPluginConfigurationForTenant(String pluginName, String pluginConfig, String createdBy, String reason, String comment) throws KillBillClientException {
        String uri = "/1.0/kb/tenants/uploadPluginConfig/" + pluginName;
        return this.uploadFile(pluginConfig, uri, "text/plain", createdBy, reason, comment, TenantKey.class);
    }

    public TenantKey getPluginConfigurationForTenant(String pluginName) throws KillBillClientException {
        String uri = "/1.0/kb/tenants/uploadPluginConfig/" + pluginName;
        return this.httpClient.doGet(uri, KillBillHttpClient.DEFAULT_EMPTY_QUERY, TenantKey.class);
    }

    public void unregisterPluginConfigurationForTenant(String pluginName, String createdBy, String reason, String comment) throws KillBillClientException {
        String uri = "/1.0/kb/tenants/uploadPluginConfig/" + pluginName;
        Multimap<String, String> queryParams = this.paramsWithAudit(createdBy, reason, comment);
        this.httpClient.doDelete(uri, queryParams);
    }

    public Permissions getPermissions() throws KillBillClientException {
        return this.httpClient.doGet("/1.0/kb/security/permissions", KillBillHttpClient.DEFAULT_EMPTY_QUERY, Permissions.class);
    }

    public Response addUserRoles(UserRoles userRoles, String createdBy, String reason, String comment) throws KillBillClientException {
        Multimap<String, String> queryParams = this.paramsWithAudit(createdBy, reason, comment);
        return this.httpClient.doPost("/1.0/kb/security/users", userRoles, queryParams);
    }

    public Response updateUserPassword(String username, String newPassword, String createdBy, String reason, String comment) throws KillBillClientException {
        String uri = "/1.0/kb/security/users/" + username + "/password";
        Multimap<String, String> queryParams = this.paramsWithAudit(createdBy, reason, comment);
        UserRoles userRoles = new UserRoles(username, newPassword, (List<String>)ImmutableList.of());
        return this.httpClient.doPut(uri, userRoles, queryParams);
    }

    public Response updateUserRoles(String username, List<String> newRoles, String createdBy, String reason, String comment) throws KillBillClientException {
        String uri = "/1.0/kb/security/users/" + username + "/roles";
        Multimap<String, String> queryParams = this.paramsWithAudit(createdBy, reason, comment);
        UserRoles userRoles = new UserRoles(username, null, newRoles);
        return this.httpClient.doPut(uri, userRoles, queryParams);
    }

    public Response invalidateUser(String username, String createdBy, String reason, String comment) throws KillBillClientException {
        String uri = "/1.0/kb/security/users/" + username;
        Multimap<String, String> queryParams = this.paramsWithAudit(createdBy, reason, comment);
        return this.httpClient.doDelete(uri, queryParams);
    }

    public Response addRoleDefinition(RoleDefinition roleDefinition, String createdBy, String reason, String comment) throws KillBillClientException {
        Multimap<String, String> queryParams = this.paramsWithAudit(createdBy, reason, comment);
        return this.httpClient.doPost("/1.0/kb/security/roles", roleDefinition, queryParams);
    }

    public Response pluginGET(String uri) throws Exception {
        return this.pluginGET(uri, KillBillHttpClient.DEFAULT_EMPTY_QUERY);
    }

    public Response pluginGET(String uri, Multimap<String, String> queryParams) throws Exception {
        return this.httpClient.doGet("/plugins/" + uri, queryParams);
    }

    public Response pluginHEAD(String uri) throws Exception {
        return this.pluginHEAD(uri, KillBillHttpClient.DEFAULT_EMPTY_QUERY);
    }

    public Response pluginHEAD(String uri, Multimap<String, String> queryParams) throws Exception {
        return this.httpClient.doHead("/plugins/" + uri, queryParams);
    }

    public Response pluginPOST(String uri, @Nullable String body) throws Exception {
        return this.pluginPOST(uri, body, KillBillHttpClient.DEFAULT_EMPTY_QUERY);
    }

    public Response pluginPOST(String uri, @Nullable String body, Multimap<String, String> queryParams) throws Exception {
        return this.httpClient.doPost("/plugins/" + uri, body, queryParams);
    }

    public Response pluginPUT(String uri, @Nullable String body) throws Exception {
        return this.pluginPUT(uri, body, KillBillHttpClient.DEFAULT_EMPTY_QUERY);
    }

    public Response pluginPUT(String uri, @Nullable String body, Multimap<String, String> queryParams) throws Exception {
        return this.httpClient.doPut("/plugins/" + uri, body, queryParams);
    }

    public Response pluginDELETE(String uri) throws Exception {
        return this.pluginDELETE(uri, KillBillHttpClient.DEFAULT_EMPTY_QUERY);
    }

    public Response pluginDELETE(String uri, Multimap<String, String> queryParams) throws Exception {
        return this.httpClient.doDelete("/plugins/" + uri, queryParams);
    }

    public Response pluginOPTIONS(String uri) throws Exception {
        return this.pluginOPTIONS(uri, KillBillHttpClient.DEFAULT_EMPTY_QUERY);
    }

    public Response pluginOPTIONS(String uri, Multimap<String, String> queryParams) throws Exception {
        return this.httpClient.doOptions("/plugins/" + uri, queryParams);
    }

    private String getResourceFile(String uri, String contentType) throws KillBillClientException {
        HashMultimap queryParams = HashMultimap.create();
        queryParams.put((Object)"Accept", (Object)contentType);
        Response response = this.httpClient.doGet(uri, (Multimap<String, String>)queryParams);
        try {
            return response.getResponseBody("UTF-8");
        }
        catch (IOException e) {
            throw new KillBillClientException(e);
        }
    }

    private <ReturnType> ReturnType uploadFile(String fileToUpload, String uri, String contentType, String createdBy, String reason, String comment, Class<ReturnType> followUpClass) throws KillBillClientException {
        Preconditions.checkNotNull((Object)fileToUpload, (Object)"fileToUpload cannot be null");
        Multimap<String, String> queryParams = this.paramsWithAudit(createdBy, reason, comment);
        queryParams.put((Object)"Content-Type", (Object)contentType);
        File catalogFile = new File(fileToUpload);
        Preconditions.checkArgument((catalogFile.exists() && catalogFile.isFile() && catalogFile.canRead() ? 1 : 0) != 0, (Object)"file to upload needs to be a valid file");
        try {
            String body = Files.toString((File)catalogFile, (Charset)Charset.forName("UTF-8"));
            if (followUpClass != null) {
                return this.httpClient.doPostAndFollowLocation(uri, body, queryParams, followUpClass);
            }
            this.httpClient.doPost(uri, body, queryParams);
            return null;
        }
        catch (IOException e) {
            throw new KillBillClientException(e);
        }
    }

    private Multimap<String, String> paramsWithAudit(Multimap<String, String> queryParams, String createdBy, String reason, String comment) {
        HashMultimap queryParamsWithAudit = HashMultimap.create();
        queryParamsWithAudit.putAll(queryParams);
        queryParamsWithAudit.putAll(this.paramsWithAudit(createdBy, reason, comment));
        return queryParamsWithAudit;
    }

    private Multimap<String, String> paramsWithAudit(String createdBy, String reason, String comment) {
        HashMultimap result = HashMultimap.create();
        result.put((Object)"__AUDIT_OPTION_CREATED_BY", (Object)createdBy);
        result.put((Object)"__AUDIT_OPTION_REASON", (Object)reason);
        result.put((Object)"__AUDIT_OPTION_COMMENT", (Object)comment);
        return result;
    }

    private void storePluginPropertiesAsParams(Map<String, String> pluginProperties, Multimap<String, String> params) {
        for (String key : pluginProperties.keySet()) {
            params.put((Object)"pluginProperty", (Object)String.format("%s=%s", UTF8UrlEncoder.encode((String)key), UTF8UrlEncoder.encode((String)pluginProperties.get(key))));
        }
    }
}

