/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.Response;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.killbill.billing.client.KillBillClientException;
import org.killbill.billing.client.model.BillingException;
import org.killbill.billing.client.model.KillBillObjects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KillBillHttpClient {
    public static final int DEFAULT_HTTP_TIMEOUT_SEC = 10;
    public static final Multimap<String, String> DEFAULT_EMPTY_QUERY = ImmutableMultimap.of();
    public static final String AUDIT_OPTION_CREATED_BY = "__AUDIT_OPTION_CREATED_BY";
    public static final String AUDIT_OPTION_REASON = "__AUDIT_OPTION_REASON";
    public static final String AUDIT_OPTION_COMMENT = "__AUDIT_OPTION_COMMENT";
    public static final String TENANT_OPTION_API_KEY = "__TENANT_OPTION_API_KEY";
    public static final String TENANT_OPTION_API_SECRET = "__TENANT_OPTION_API_SECRET";
    public static final String RBAC_OPTION_USERNAME = "__RBAC_OPTION_USERNAME";
    public static final String RBAC_OPTION_PASSWORD = "__RBAC_OPTION_PASSWORD";
    public static final String CONTROL_PLUGIN_NAME = "controlPluginName";
    public static final String HTTP_HEADER_ACCEPT = "Accept";
    public static final String HTTP_HEADER_CONTENT_TYPE = "Content-Type";
    public static final String ACCEPT_JSON = "application/json";
    public static final String ACCEPT_XML = "application/xml";
    public static final String CONTENT_TYPE_JSON = "application/json; charset=utf-8";
    public static final String CONTENT_TYPE_XML = "application/xml; charset=utf-8";
    private static final Logger log = LoggerFactory.getLogger(KillBillHttpClient.class);
    private static final String USER_AGENT = "KillBill-JavaClient/1.0";
    private static final Joiner CSV_JOINER = Joiner.on((String)",");
    private final boolean DEBUG = Boolean.parseBoolean(System.getProperty("org.killbill.client.debug", "false"));
    private final String kbServerUrl;
    private final String username;
    private final String password;
    private final String apiKey;
    private final String apiSecret;
    private final AsyncHttpClient httpClient;
    private final ObjectMapper mapper;

    public KillBillHttpClient(String kbServerUrl, String username, String password, String apiKey, String apiSecret, String proxyHost, Integer proxyPort) {
        this.kbServerUrl = kbServerUrl;
        this.username = username;
        this.password = password;
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
        AsyncHttpClientConfig.Builder cfg = new AsyncHttpClientConfig.Builder();
        cfg.setConnectTimeout(10000);
        cfg.setRequestTimeout(10000);
        cfg.setReadTimeout(10000);
        cfg.setUserAgent(USER_AGENT);
        if (proxyHost != null && proxyPort != null) {
            ProxyServer proxyServer = new ProxyServer(proxyHost, proxyPort.intValue());
            cfg.setProxyServer(proxyServer);
        }
        this.httpClient = new AsyncHttpClient(cfg.build());
        this.mapper = new ObjectMapper();
        this.mapper.registerModule((Module)new JodaModule());
    }

    public KillBillHttpClient(String kbServerUrl, String username, String password, String apiKey, String apiSecret) {
        this(kbServerUrl, username, password, apiKey, apiSecret, null, null);
    }

    public KillBillHttpClient() {
        this(System.getProperty("killbill.url", "http://127.0.0.1:8080/"), System.getProperty("killbill.username", "admin"), System.getProperty("killbill.password", "password"), System.getProperty("killbill.apiKey", "bob"), System.getProperty("killbill.apiSecret", "lazar"));
    }

    public void close() {
        this.httpClient.close();
    }

    public Response doPost(String uri, Object body, Multimap<String, String> options) throws KillBillClientException {
        return this.doPost(uri, body, options, Response.class);
    }

    public <T> T doPost(String uri, Object body, Multimap<String, String> options, Class<T> clazz) throws KillBillClientException {
        return this.doPost(uri, body, options, 10, clazz);
    }

    public <T> T doPost(String uri, Object body, Multimap<String, String> options, int timeoutSec, Class<T> clazz) throws KillBillClientException {
        return this.doPostAndMaybeFollowLocation(uri, body, options, DEFAULT_EMPTY_QUERY, timeoutSec, clazz, false);
    }

    public <T> T doPostAndFollowLocation(String uri, Object body, Multimap<String, String> options, Class<T> clazz) throws KillBillClientException {
        return this.doPostAndFollowLocation(uri, body, options, DEFAULT_EMPTY_QUERY, clazz);
    }

    public <T> T doPostAndFollowLocation(String uri, Object body, Multimap<String, String> options, Multimap<String, String> optionsForFollow, Class<T> clazz) throws KillBillClientException {
        return this.doPostAndFollowLocation(uri, body, options, optionsForFollow, 10, clazz);
    }

    public <T> T doPostAndFollowLocation(String uri, Object body, Multimap<String, String> options, int timeoutSec, Class<T> clazz) throws KillBillClientException {
        return this.doPostAndFollowLocation(uri, body, options, DEFAULT_EMPTY_QUERY, timeoutSec, clazz);
    }

    public <T> T doPostAndFollowLocation(String uri, Object body, Multimap<String, String> options, Multimap<String, String> optionsForFollow, int timeoutSec, Class<T> clazz) throws KillBillClientException {
        return this.doPostAndMaybeFollowLocation(uri, body, options, optionsForFollow, timeoutSec, clazz, true);
    }

    public <T> T doPostAndMaybeFollowLocation(String uri, Object body, Multimap<String, String> options, Multimap<String, String> optionsForFollow, int timeoutSec, Class<T> clazz, boolean followLocation) throws KillBillClientException {
        String verb = "POST";
        return this.doPrepareRequestAndMaybeFollowLocation("POST", uri, body, options, optionsForFollow, timeoutSec, clazz, followLocation);
    }

    public Response doPut(String uri, Object body, Multimap<String, String> options) throws KillBillClientException {
        return this.doPut(uri, body, options, Response.class);
    }

    public <T> T doPut(String uri, Object body, Multimap<String, String> options, Class<T> clazz) throws KillBillClientException {
        return this.doPut(uri, body, options, 10, clazz);
    }

    public <T> T doPut(String uri, Object body, Multimap<String, String> options, int timeoutSec, Class<T> clazz) throws KillBillClientException {
        return this.doPutAndMaybeFollowLocation(uri, body, options, timeoutSec, clazz, false);
    }

    public <T> T doPutAndFollowLocation(String uri, Object body, Multimap<String, String> options, Class<T> clazz) throws KillBillClientException {
        return this.doPutAndFollowLocation(uri, body, options, 10, clazz);
    }

    public <T> T doPutAndFollowLocation(String uri, Object body, Multimap<String, String> options, int timeoutSec, Class<T> clazz) throws KillBillClientException {
        return this.doPutAndMaybeFollowLocation(uri, body, options, timeoutSec, clazz, true);
    }

    public <T> T doPutAndMaybeFollowLocation(String uri, Object body, Multimap<String, String> options, int timeoutSec, Class<T> clazz, boolean followLocation) throws KillBillClientException {
        String verb = "PUT";
        return this.doPrepareRequestAndMaybeFollowLocation("PUT", uri, body, options, DEFAULT_EMPTY_QUERY, timeoutSec, clazz, followLocation);
    }

    public Response doDelete(String uri, Multimap<String, String> options) throws KillBillClientException {
        return this.doDelete(uri, options, Response.class);
    }

    public <T> T doDelete(String uri, Multimap<String, String> options, Class<T> clazz) throws KillBillClientException {
        return this.doDeleteAndMaybeFollowLocation(uri, options, 10, clazz, false);
    }

    public <T> T doDeleteAndFollowLocation(String uri, Object body, Multimap<String, String> options, Class<T> clazz) throws KillBillClientException {
        return this.doDeleteAndFollowLocation(uri, body, options, 10, clazz);
    }

    public <T> T doDeleteAndFollowLocation(String uri, Object body, Multimap<String, String> options, int timeoutSec, Class<T> clazz) throws KillBillClientException {
        return this.doDeleteAndMaybeFollowLocation(uri, body, options, timeoutSec, clazz, true);
    }

    public <T> T doDeleteAndMaybeFollowLocation(String uri, Multimap<String, String> options, int timeoutSec, Class<T> clazz, boolean followLocation) throws KillBillClientException {
        String verb = "DELETE";
        return this.doPrepareRequestAndMaybeFollowLocation("DELETE", uri, options, DEFAULT_EMPTY_QUERY, timeoutSec, clazz, followLocation);
    }

    public <T> T doDeleteAndMaybeFollowLocation(String uri, Object body, Multimap<String, String> options, int timeoutSec, Class<T> clazz, boolean followLocation) throws KillBillClientException {
        String verb = "DELETE";
        return this.doPrepareRequestAndMaybeFollowLocation("DELETE", uri, body, options, DEFAULT_EMPTY_QUERY, timeoutSec, clazz, followLocation);
    }

    public Response doGet(String uri, Multimap<String, String> options) throws KillBillClientException {
        return this.doGet(uri, options, Response.class);
    }

    public <T> T doGet(String uri, Multimap<String, String> options, Class<T> clazz) throws KillBillClientException {
        return this.doGetWithUrl(uri, options, 10, clazz);
    }

    public <T> T doGet(String uri, Multimap<String, String> options, int timeoutSec, Class<T> clazz) throws KillBillClientException {
        return this.doGetWithUrl(uri, options, timeoutSec, clazz);
    }

    public <T> T doGetWithUrl(String url, Multimap<String, String> options, int timeoutSec, Class<T> clazz) throws KillBillClientException {
        String verb = "GET";
        return this.doPrepareRequestAndMaybeFollowLocation("GET", url, options, DEFAULT_EMPTY_QUERY, timeoutSec, clazz);
    }

    public Response doHead(String uri, Multimap<String, String> options) throws KillBillClientException {
        return this.doHead(uri, options, Response.class);
    }

    public <T> T doHead(String uri, Multimap<String, String> options, Class<T> clazz) throws KillBillClientException {
        return this.doHeadWithUrl(uri, options, 10, clazz);
    }

    public <T> T doHead(String uri, Multimap<String, String> options, int timeoutSec, Class<T> clazz) throws KillBillClientException {
        return this.doHeadWithUrl(uri, options, timeoutSec, clazz);
    }

    public <T> T doHeadWithUrl(String url, Multimap<String, String> options, int timeoutSec, Class<T> clazz) throws KillBillClientException {
        String verb = "HEAD";
        return this.doPrepareRequestAndMaybeFollowLocation("HEAD", url, options, DEFAULT_EMPTY_QUERY, timeoutSec, clazz);
    }

    public Response doOptions(String uri, Multimap<String, String> options) throws KillBillClientException {
        return this.doOptions(uri, options, Response.class);
    }

    public <T> T doOptions(String uri, Multimap<String, String> options, Class<T> clazz) throws KillBillClientException {
        return this.doOptionsWithUrl(uri, options, 10, clazz);
    }

    public <T> T doOptions(String uri, Multimap<String, String> options, int timeoutSec, Class<T> clazz) throws KillBillClientException {
        return this.doOptionsWithUrl(uri, options, timeoutSec, clazz);
    }

    public <T> T doOptionsWithUrl(String url, Multimap<String, String> options, int timeoutSec, Class<T> clazz) throws KillBillClientException {
        String verb = "OPTIONS";
        return this.doPrepareRequestAndMaybeFollowLocation("OPTIONS", url, options, DEFAULT_EMPTY_QUERY, timeoutSec, clazz);
    }

    private <T> T doPrepareRequestAndMaybeFollowLocation(String verb, String uri, Multimap<String, String> options, Multimap<String, String> optionsForFollow, int timeoutSec, Class<T> clazz) throws KillBillClientException {
        return this.doPrepareRequestAndMaybeFollowLocation(verb, uri, null, options, optionsForFollow, timeoutSec, clazz, false);
    }

    private <T> T doPrepareRequestAndMaybeFollowLocation(String verb, String uri, Multimap<String, String> options, Multimap<String, String> optionsForFollow, int timeoutSec, Class<T> clazz, boolean followLocation) throws KillBillClientException {
        return this.doPrepareRequestAndMaybeFollowLocation(verb, uri, null, options, optionsForFollow, timeoutSec, clazz, followLocation);
    }

    private <T> T doPrepareRequestAndMaybeFollowLocation(String verb, String uri, Object body, Multimap<String, String> optionsRo, Multimap<String, String> optionsForFollow, int timeoutSec, Class<T> clazz, boolean followLocation) throws KillBillClientException {
        String password;
        String username;
        String apiSecret;
        HashMultimap options = HashMultimap.create(optionsRo);
        String createdBy = this.getUniqueValue((Multimap<String, String>)options, AUDIT_OPTION_CREATED_BY);
        String reason = this.getUniqueValue((Multimap<String, String>)options, AUDIT_OPTION_REASON);
        String comment = this.getUniqueValue((Multimap<String, String>)options, AUDIT_OPTION_COMMENT);
        String apiKey = this.getUniqueValue((Multimap<String, String>)options, TENANT_OPTION_API_KEY);
        if (apiKey == null) {
            apiKey = this.apiKey;
        }
        if ((apiSecret = this.getUniqueValue((Multimap<String, String>)options, TENANT_OPTION_API_SECRET)) == null) {
            apiSecret = this.apiSecret;
        }
        if ((username = this.getUniqueValue((Multimap<String, String>)options, RBAC_OPTION_USERNAME)) == null) {
            username = this.username;
        }
        if ((password = this.getUniqueValue((Multimap<String, String>)options, RBAC_OPTION_PASSWORD)) == null) {
            password = this.password;
        }
        options.removeAll((Object)AUDIT_OPTION_CREATED_BY);
        options.removeAll((Object)AUDIT_OPTION_REASON);
        options.removeAll((Object)AUDIT_OPTION_COMMENT);
        options.removeAll((Object)TENANT_OPTION_API_KEY);
        options.removeAll((Object)TENANT_OPTION_API_SECRET);
        options.removeAll((Object)RBAC_OPTION_USERNAME);
        options.removeAll((Object)RBAC_OPTION_PASSWORD);
        AsyncHttpClient.BoundRequestBuilder builder = this.getBuilderWithHeaderAndQuery(verb, this.getKBServerUrl(uri), username, password, (Multimap<String, String>)options);
        if (apiKey != null) {
            builder.addHeader("X-Killbill-ApiKey", apiKey);
        }
        if (apiSecret != null) {
            builder.addHeader("X-Killbill-ApiSecret", apiSecret);
        }
        if (createdBy != null) {
            builder.addHeader("X-Killbill-CreatedBy", createdBy);
        }
        if (reason != null) {
            builder.addHeader("X-Killbill-Reason", reason);
        }
        if (comment != null) {
            builder.addHeader("X-Killbill-Comment", comment);
        }
        if (!"GET".equals(verb) && !"HEAD".equals(verb)) {
            if (body != null) {
                if (body instanceof String) {
                    builder.setBody((String)body);
                } else {
                    try {
                        builder.setBody(this.mapper.writeValueAsString(body));
                    }
                    catch (JsonProcessingException e) {
                        throw new KillBillClientException((Exception)((Object)e));
                    }
                }
            } else {
                builder.setBody("{}");
            }
        }
        if (followLocation) {
            Response response = this.executeAndWait(builder, timeoutSec, Response.class);
            if (response == null || response.getHeader("Location") == null) {
                return (T)(Response.class.isAssignableFrom(clazz) ? response : null);
            }
            String location = response.getHeader("Location");
            return this.doGetWithUrl(location, optionsForFollow, timeoutSec, clazz);
        }
        return this.executeAndWait(builder, timeoutSec, clazz);
    }

    private String getUniqueValue(Multimap<String, String> options, String key) {
        Collection values = options.get((Object)key);
        if (values == null || values.size() == 0) {
            return null;
        }
        Preconditions.checkState((values.size() == 1 ? 1 : 0) != 0, (Object)("You can only specify a unique value for " + key));
        return (String)values.iterator().next();
    }

    private <T> T executeAndWait(AsyncHttpClient.BoundRequestBuilder builder, int timeoutSec, Class<T> clazz) throws KillBillClientException {
        Response response;
        try {
            ListenableFuture futureStatus = builder.execute((AsyncHandler)new AsyncCompletionHandler<Response>(){

                public Response onCompleted(Response response) throws Exception {
                    return response;
                }
            });
            response = (Response)futureStatus.get((long)timeoutSec, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new KillBillClientException(e);
        }
        catch (ExecutionException e) {
            throw new KillBillClientException(e);
        }
        catch (TimeoutException e) {
            throw new KillBillClientException(e);
        }
        if (response != null && response.getStatusCode() == 401) {
            throw new KillBillClientException(new IllegalArgumentException("Unauthorized - did you configure your RBAC and/or tenant credentials?"), response);
        }
        if (response != null && (response.getStatusCode() == 404 || response.getStatusCode() == 204)) {
            if (Iterable.class.isAssignableFrom(clazz)) {
                for (Constructor<?> constructor : clazz.getConstructors()) {
                    if (constructor.getParameterTypes().length != 0) continue;
                    try {
                        return (T)constructor.newInstance(new Object[0]);
                    }
                    catch (InstantiationException e) {
                        return null;
                    }
                    catch (IllegalAccessException e) {
                        return null;
                    }
                    catch (InvocationTargetException e) {
                        return null;
                    }
                }
                return null;
            }
            return null;
        }
        if (response != null && response.getStatusCode() >= 400) {
            BillingException exception = this.deserializeResponse(response, BillingException.class);
            log.warn("Error " + response.getStatusCode() + " from Kill Bill: " + exception.getMessage());
            throw new KillBillClientException(exception, response);
        }
        if (Response.class.isAssignableFrom(clazz)) {
            return (T)response;
        }
        return this.deserializeResponse(response, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T deserializeResponse(Response response, Class<T> clazz) throws KillBillClientException {
        Object result;
        block16: {
            try {
                if (this.DEBUG) {
                    String content = response.getResponseBody();
                    log.debug("Received: " + content);
                    result = this.mapper.readValue(content, clazz);
                    break block16;
                }
                InputStream in = null;
                try {
                    in = response.getResponseBodyAsStream();
                    result = this.mapper.readValue(in, clazz);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            log.warn("Failed to close http-client - provided InputStream: {}", (Object)e.getLocalizedMessage());
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new KillBillClientException(e, response);
            }
        }
        if (KillBillObjects.class.isAssignableFrom(clazz)) {
            String paginationMaxNbRecords;
            String paginationTotalNbRecords;
            String paginationNextOffset;
            KillBillObjects objects = (KillBillObjects)result;
            String paginationCurrentOffset = response.getHeader("X-Killbill-Pagination-CurrentOffset");
            if (paginationCurrentOffset != null) {
                objects.setPaginationCurrentOffset(Integer.parseInt(paginationCurrentOffset));
            }
            if ((paginationNextOffset = response.getHeader("X-Killbill-Pagination-NextOffset")) != null) {
                objects.setPaginationNextOffset(Integer.parseInt(paginationNextOffset));
            }
            if ((paginationTotalNbRecords = response.getHeader("X-Killbill-Pagination-TotalNbRecords")) != null) {
                objects.setPaginationTotalNbRecords(Integer.parseInt(paginationTotalNbRecords));
            }
            if ((paginationMaxNbRecords = response.getHeader("X-Killbill-Pagination-MaxNbRecords")) != null) {
                objects.setPaginationMaxNbRecords(Integer.parseInt(paginationMaxNbRecords));
            }
            objects.setPaginationNextPageUri(response.getHeader("X-Killbill-Pagination-NextPageUri"));
            objects.setKillBillHttpClient(this);
        }
        return (T)result;
    }

    private AsyncHttpClient.BoundRequestBuilder getBuilderWithHeaderAndQuery(String verb, String url, @Nullable String username, @Nullable String password, Multimap<String, String> options) {
        Collection acceptHeaders;
        AsyncHttpClient.BoundRequestBuilder builder;
        if (verb.equals("GET")) {
            builder = this.httpClient.prepareGet(url);
        } else if (verb.equals("POST")) {
            builder = this.httpClient.preparePost(url);
        } else if (verb.equals("PUT")) {
            builder = this.httpClient.preparePut(url);
        } else if (verb.equals("DELETE")) {
            builder = this.httpClient.prepareDelete(url);
        } else if (verb.equals("HEAD")) {
            builder = this.httpClient.prepareHead(url);
        } else if (verb.equals("OPTIONS")) {
            builder = this.httpClient.prepareOptions(url);
        } else {
            throw new IllegalArgumentException("Unrecognized verb: " + verb);
        }
        if (username != null && password != null) {
            Realm realm = new Realm.RealmBuilder().setPrincipal(username).setPassword(password).build();
            builder.setRealm(realm);
        }
        String acceptHeader = !(acceptHeaders = options.removeAll((Object)HTTP_HEADER_ACCEPT)).isEmpty() ? CSV_JOINER.join((Iterable)acceptHeaders) : ACCEPT_JSON;
        builder.addHeader(HTTP_HEADER_ACCEPT, acceptHeader);
        String contentTypeHeader = this.getUniqueValue(options, HTTP_HEADER_CONTENT_TYPE);
        if (contentTypeHeader == null) {
            contentTypeHeader = CONTENT_TYPE_JSON;
        } else {
            options.removeAll((Object)HTTP_HEADER_CONTENT_TYPE);
        }
        builder.addHeader(HTTP_HEADER_CONTENT_TYPE, contentTypeHeader);
        builder.setBodyEncoding("UTF-8");
        for (String key : options.keySet()) {
            if (options.get((Object)key) == null) continue;
            for (String value : options.get((Object)key)) {
                builder.addQueryParam(key, value);
            }
        }
        return builder;
    }

    private String getKBServerUrl(String uri) throws KillBillClientException {
        try {
            URI u = new URI(uri);
            if (u.isAbsolute()) {
                return uri;
            }
            return String.format("%s%s", this.kbServerUrl, uri);
        }
        catch (URISyntaxException e) {
            throw new KillBillClientException(e);
        }
    }
}

