/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.client.model.AuditLog;
import org.killbill.billing.client.model.KillBillObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvoiceItem
extends KillBillObject {
    private UUID invoiceItemId;
    private UUID invoiceId;
    private UUID linkedInvoiceItemId;
    private UUID accountId;
    private UUID bundleId;
    private UUID subscriptionId;
    private String planName;
    private String phaseName;
    private String usageName;
    private String itemType;
    private String description;
    private LocalDate startDate;
    private LocalDate endDate;
    private BigDecimal amount;
    private Currency currency;

    public InvoiceItem() {
    }

    @JsonCreator
    public InvoiceItem(@JsonProperty(value="invoiceItemId") UUID invoiceItemId, @JsonProperty(value="invoiceId") UUID invoiceId, @JsonProperty(value="linkedInvoiceItemId") UUID linkedInvoiceItemId, @JsonProperty(value="accountId") UUID accountId, @JsonProperty(value="bundleId") UUID bundleId, @JsonProperty(value="subscriptionId") UUID subscriptionId, @JsonProperty(value="planName") String planName, @JsonProperty(value="phaseName") String phaseName, @JsonProperty(value="usageName") String usageName, @JsonProperty(value="itemType") String itemType, @JsonProperty(value="description") String description, @JsonProperty(value="startDate") LocalDate startDate, @JsonProperty(value="endDate") LocalDate endDate, @JsonProperty(value="amount") BigDecimal amount, @JsonProperty(value="currency") Currency currency, @JsonProperty(value="auditLogs") @Nullable List<AuditLog> auditLogs) {
        super(auditLogs);
        this.invoiceItemId = invoiceItemId;
        this.invoiceId = invoiceId;
        this.linkedInvoiceItemId = linkedInvoiceItemId;
        this.accountId = accountId;
        this.bundleId = bundleId;
        this.subscriptionId = subscriptionId;
        this.planName = planName;
        this.phaseName = phaseName;
        this.itemType = itemType;
        this.description = description;
        this.startDate = startDate;
        this.endDate = endDate;
        this.amount = amount;
        this.currency = currency;
    }

    public UUID getInvoiceItemId() {
        return this.invoiceItemId;
    }

    public void setInvoiceItemId(UUID invoiceItemId) {
        this.invoiceItemId = invoiceItemId;
    }

    public UUID getInvoiceId() {
        return this.invoiceId;
    }

    public void setInvoiceId(UUID invoiceId) {
        this.invoiceId = invoiceId;
    }

    public UUID getLinkedInvoiceItemId() {
        return this.linkedInvoiceItemId;
    }

    public void setLinkedInvoiceItemId(UUID linkedInvoiceItemId) {
        this.linkedInvoiceItemId = linkedInvoiceItemId;
    }

    public UUID getAccountId() {
        return this.accountId;
    }

    public void setAccountId(UUID accountId) {
        this.accountId = accountId;
    }

    public UUID getBundleId() {
        return this.bundleId;
    }

    public void setBundleId(UUID bundleId) {
        this.bundleId = bundleId;
    }

    public UUID getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setSubscriptionId(UUID subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public String getPlanName() {
        return this.planName;
    }

    public String getUsageName() {
        return this.usageName;
    }

    public void setPlanName(String planName) {
        this.planName = planName;
    }

    public String getPhaseName() {
        return this.phaseName;
    }

    public void setPhaseName(String phaseName) {
        this.phaseName = phaseName;
    }

    public void setUsageName(String usageName) {
        this.usageName = usageName;
    }

    public String getItemType() {
        return this.itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvoiceItem that = (InvoiceItem)o;
        if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) {
            return false;
        }
        if (this.amount != null ? this.amount.compareTo(that.amount) != 0 : that.amount != null) {
            return false;
        }
        if (this.bundleId != null ? !this.bundleId.equals(that.bundleId) : that.bundleId != null) {
            return false;
        }
        if (this.currency != that.currency) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.endDate != null ? this.endDate.compareTo((ReadablePartial)that.endDate) != 0 : that.endDate != null) {
            return false;
        }
        if (this.invoiceId != null ? !this.invoiceId.equals(that.invoiceId) : that.invoiceId != null) {
            return false;
        }
        if (this.invoiceItemId != null ? !this.invoiceItemId.equals(that.invoiceItemId) : that.invoiceItemId != null) {
            return false;
        }
        if (this.itemType != null ? !this.itemType.equals(that.itemType) : that.itemType != null) {
            return false;
        }
        if (this.linkedInvoiceItemId != null ? !this.linkedInvoiceItemId.equals(that.linkedInvoiceItemId) : that.linkedInvoiceItemId != null) {
            return false;
        }
        if (this.phaseName != null ? !this.phaseName.equals(that.phaseName) : that.phaseName != null) {
            return false;
        }
        if (this.planName != null ? !this.planName.equals(that.planName) : that.planName != null) {
            return false;
        }
        if (this.usageName != null ? !this.usageName.equals(that.usageName) : that.usageName != null) {
            return false;
        }
        if (this.startDate != null ? this.startDate.compareTo((ReadablePartial)that.startDate) != 0 : that.startDate != null) {
            return false;
        }
        return !(this.subscriptionId != null ? !this.subscriptionId.equals(that.subscriptionId) : that.subscriptionId != null);
    }

    public int hashCode() {
        int result = this.invoiceItemId != null ? this.invoiceItemId.hashCode() : 0;
        result = 31 * result + (this.invoiceId != null ? this.invoiceId.hashCode() : 0);
        result = 31 * result + (this.linkedInvoiceItemId != null ? this.linkedInvoiceItemId.hashCode() : 0);
        result = 31 * result + (this.accountId != null ? this.accountId.hashCode() : 0);
        result = 31 * result + (this.bundleId != null ? this.bundleId.hashCode() : 0);
        result = 31 * result + (this.subscriptionId != null ? this.subscriptionId.hashCode() : 0);
        result = 31 * result + (this.planName != null ? this.planName.hashCode() : 0);
        result = 31 * result + (this.phaseName != null ? this.phaseName.hashCode() : 0);
        result = 31 * result + (this.usageName != null ? this.usageName.hashCode() : 0);
        result = 31 * result + (this.itemType != null ? this.itemType.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.startDate != null ? this.startDate.hashCode() : 0);
        result = 31 * result + (this.endDate != null ? this.endDate.hashCode() : 0);
        result = 31 * result + (this.amount != null ? this.amount.hashCode() : 0);
        result = 31 * result + (this.currency != null ? this.currency.hashCode() : 0);
        return result;
    }
}

