/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.killbill.billing.client.model.AuditLog;
import org.killbill.billing.client.model.KillBillObject;
import org.killbill.billing.client.model.PaymentTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Payment
extends KillBillObject {
    private UUID accountId;
    private UUID paymentId;
    private Integer paymentNumber;
    private String paymentExternalKey;
    private BigDecimal authAmount;
    private BigDecimal capturedAmount;
    private BigDecimal purchasedAmount;
    private BigDecimal refundedAmount;
    private BigDecimal creditedAmount;
    private String currency;
    private UUID paymentMethodId;
    private List<PaymentTransaction> transactions;

    public Payment() {
    }

    @JsonCreator
    public Payment(@JsonProperty(value="accountId") UUID accountId, @JsonProperty(value="paymentId") UUID paymentId, @JsonProperty(value="paymentNumber") Integer paymentNumber, @JsonProperty(value="paymentExternalKey") String paymentExternalKey, @JsonProperty(value="authAmount") BigDecimal authAmount, @JsonProperty(value="capturedAmount") BigDecimal capturedAmount, @JsonProperty(value="purchasedAmount") BigDecimal purchasedAmount, @JsonProperty(value="refundedAmount") BigDecimal refundedAmount, @JsonProperty(value="creditedAmount") BigDecimal creditedAmount, @JsonProperty(value="currency") String currency, @JsonProperty(value="paymentMethodId") UUID paymentMethodId, @JsonProperty(value="transactions") List<PaymentTransaction> transactions, @JsonProperty(value="auditLogs") @Nullable List<AuditLog> auditLogs) {
        super(auditLogs);
        this.accountId = accountId;
        this.paymentId = paymentId;
        this.paymentNumber = paymentNumber;
        this.paymentExternalKey = paymentExternalKey;
        this.authAmount = authAmount;
        this.capturedAmount = capturedAmount;
        this.purchasedAmount = purchasedAmount;
        this.refundedAmount = refundedAmount;
        this.creditedAmount = creditedAmount;
        this.currency = currency;
        this.paymentMethodId = paymentMethodId;
        this.transactions = transactions;
    }

    public UUID getAccountId() {
        return this.accountId;
    }

    public void setAccountId(UUID accountId) {
        this.accountId = accountId;
    }

    public UUID getPaymentId() {
        return this.paymentId;
    }

    public void setPaymentId(UUID paymentId) {
        this.paymentId = paymentId;
    }

    public Integer getPaymentNumber() {
        return this.paymentNumber;
    }

    public void setPaymentNumber(Integer paymentNumber) {
        this.paymentNumber = paymentNumber;
    }

    public String getPaymentExternalKey() {
        return this.paymentExternalKey;
    }

    public void setPaymentExternalKey(String paymentExternalKey) {
        this.paymentExternalKey = paymentExternalKey;
    }

    public BigDecimal getAuthAmount() {
        return this.authAmount;
    }

    public void setAuthAmount(BigDecimal authAmount) {
        this.authAmount = authAmount;
    }

    public BigDecimal getCapturedAmount() {
        return this.capturedAmount;
    }

    public void setCapturedAmount(BigDecimal capturedAmount) {
        this.capturedAmount = capturedAmount;
    }

    public BigDecimal getPurchasedAmount() {
        return this.purchasedAmount;
    }

    public void setPurchasedAmount(BigDecimal purchasedAmount) {
        this.purchasedAmount = purchasedAmount;
    }

    public BigDecimal getRefundedAmount() {
        return this.refundedAmount;
    }

    public void setRefundedAmount(BigDecimal refundedAmount) {
        this.refundedAmount = refundedAmount;
    }

    public BigDecimal getCreditedAmount() {
        return this.creditedAmount;
    }

    public void setCreditedAmount(BigDecimal creditedAmount) {
        this.creditedAmount = creditedAmount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public UUID getPaymentMethodId() {
        return this.paymentMethodId;
    }

    public void setPaymentMethodId(UUID paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
    }

    public List<PaymentTransaction> getTransactions() {
        return this.transactions;
    }

    public void setTransactions(List<PaymentTransaction> transactions) {
        this.transactions = transactions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Payment)) {
            return false;
        }
        Payment payment = (Payment)o;
        if (this.accountId != null ? !this.accountId.equals(payment.accountId) : payment.accountId != null) {
            return false;
        }
        if (this.authAmount != null ? this.authAmount.compareTo(payment.authAmount) != 0 : payment.authAmount != null) {
            return false;
        }
        if (this.capturedAmount != null ? this.capturedAmount.compareTo(payment.capturedAmount) != 0 : payment.capturedAmount != null) {
            return false;
        }
        if (this.creditedAmount != null ? this.creditedAmount.compareTo(payment.creditedAmount) != 0 : payment.creditedAmount != null) {
            return false;
        }
        if (this.currency != null ? !this.currency.equals(payment.currency) : payment.currency != null) {
            return false;
        }
        if (this.paymentExternalKey != null ? !this.paymentExternalKey.equals(payment.paymentExternalKey) : payment.paymentExternalKey != null) {
            return false;
        }
        if (this.paymentId != null ? !this.paymentId.equals(payment.paymentId) : payment.paymentId != null) {
            return false;
        }
        if (this.paymentMethodId != null ? !this.paymentMethodId.equals(payment.paymentMethodId) : payment.paymentMethodId != null) {
            return false;
        }
        if (this.paymentNumber != null ? !this.paymentNumber.equals(payment.paymentNumber) : payment.paymentNumber != null) {
            return false;
        }
        if (this.purchasedAmount != null ? this.purchasedAmount.compareTo(payment.purchasedAmount) != 0 : payment.purchasedAmount != null) {
            return false;
        }
        if (this.refundedAmount != null ? this.refundedAmount.compareTo(payment.refundedAmount) != 0 : payment.refundedAmount != null) {
            return false;
        }
        return !(this.transactions != null ? !this.transactions.equals(payment.transactions) : payment.transactions != null);
    }

    public int hashCode() {
        int result = this.accountId != null ? this.accountId.hashCode() : 0;
        result = 31 * result + (this.paymentId != null ? this.paymentId.hashCode() : 0);
        result = 31 * result + (this.paymentNumber != null ? this.paymentNumber.hashCode() : 0);
        result = 31 * result + (this.paymentExternalKey != null ? this.paymentExternalKey.hashCode() : 0);
        result = 31 * result + (this.authAmount != null ? this.authAmount.hashCode() : 0);
        result = 31 * result + (this.capturedAmount != null ? this.capturedAmount.hashCode() : 0);
        result = 31 * result + (this.purchasedAmount != null ? this.purchasedAmount.hashCode() : 0);
        result = 31 * result + (this.refundedAmount != null ? this.refundedAmount.hashCode() : 0);
        result = 31 * result + (this.creditedAmount != null ? this.creditedAmount.hashCode() : 0);
        result = 31 * result + (this.currency != null ? this.currency.hashCode() : 0);
        result = 31 * result + (this.paymentMethodId != null ? this.paymentMethodId.hashCode() : 0);
        result = 31 * result + (this.transactions != null ? this.transactions.hashCode() : 0);
        return result;
    }
}

