/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.killbill.billing.client.model.AuditLog;
import org.killbill.billing.client.model.KillBillObject;
import org.killbill.billing.client.model.PluginProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaymentTransaction
extends KillBillObject {
    private UUID transactionId;
    private String transactionExternalKey;
    private UUID paymentId;
    private String paymentExternalKey;
    private String transactionType;
    private DateTime effectiveDate;
    private String status;
    private BigDecimal amount;
    private String currency;
    private String gatewayErrorCode;
    private String gatewayErrorMsg;
    private String firstPaymentReferenceId;
    private String secondPaymentReferenceId;
    private List<PluginProperty> properties = ImmutableList.of();

    public PaymentTransaction() {
    }

    @JsonCreator
    public PaymentTransaction(@JsonProperty(value="transactionId") UUID transactionId, @JsonProperty(value="transactionExternalKey") String transactionExternalKey, @JsonProperty(value="paymentId") UUID paymentId, @JsonProperty(value="paymentExternalKey") String paymentExternalKey, @JsonProperty(value="transactionType") String transactionType, @JsonProperty(value="amount") BigDecimal amount, @JsonProperty(value="currency") String currency, @JsonProperty(value="effectiveDate") DateTime effectiveDate, @JsonProperty(value="status") String status, @JsonProperty(value="gatewayErrorCode") String gatewayErrorCode, @JsonProperty(value="gatewayErrorMsg") String gatewayErrorMsg, @JsonProperty(value="firstPaymentReferenceId") String firstPaymentReferenceId, @JsonProperty(value="secondPaymentReferenceId") String secondPaymentReferenceId, @JsonProperty(value="properties") @Nullable List<PluginProperty> properties, @JsonProperty(value="auditLogs") @Nullable List<AuditLog> auditLogs) {
        super(auditLogs);
        this.transactionId = transactionId;
        this.transactionExternalKey = transactionExternalKey;
        this.paymentId = paymentId;
        this.paymentExternalKey = paymentExternalKey;
        this.transactionType = transactionType;
        this.effectiveDate = effectiveDate;
        this.status = status;
        this.amount = amount;
        this.currency = currency;
        this.gatewayErrorCode = gatewayErrorCode;
        this.gatewayErrorMsg = gatewayErrorMsg;
        this.firstPaymentReferenceId = firstPaymentReferenceId;
        this.secondPaymentReferenceId = secondPaymentReferenceId;
        this.setProperties(properties);
    }

    public UUID getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(UUID transactionId) {
        this.transactionId = transactionId;
    }

    public String getTransactionExternalKey() {
        return this.transactionExternalKey;
    }

    public void setTransactionExternalKey(String transactionExternalKey) {
        this.transactionExternalKey = transactionExternalKey;
    }

    public UUID getPaymentId() {
        return this.paymentId;
    }

    public void setPaymentId(UUID paymentId) {
        this.paymentId = paymentId;
    }

    public String getPaymentExternalKey() {
        return this.paymentExternalKey;
    }

    public void setPaymentExternalKey(String paymentExternalKey) {
        this.paymentExternalKey = paymentExternalKey;
    }

    public String getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType;
    }

    public DateTime getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(DateTime effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getGatewayErrorCode() {
        return this.gatewayErrorCode;
    }

    public void setGatewayErrorCode(String gatewayErrorCode) {
        this.gatewayErrorCode = gatewayErrorCode;
    }

    public String getGatewayErrorMsg() {
        return this.gatewayErrorMsg;
    }

    public void setGatewayErrorMsg(String gatewayErrorMsg) {
        this.gatewayErrorMsg = gatewayErrorMsg;
    }

    public String getFirstPaymentReferenceId() {
        return this.firstPaymentReferenceId;
    }

    public void setFirstPaymentReferenceId(String firstPaymentReferenceId) {
        this.firstPaymentReferenceId = firstPaymentReferenceId;
    }

    public String getSecondPaymentReferenceId() {
        return this.secondPaymentReferenceId;
    }

    public void setSecondPaymentReferenceId(String secondPaymentReferenceId) {
        this.secondPaymentReferenceId = secondPaymentReferenceId;
    }

    public List<PluginProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(List<PluginProperty> properties) {
        if (properties != null) {
            this.properties = properties;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PaymentTransaction{");
        sb.append("transactionId=").append(this.transactionId);
        sb.append(", transactionExternalKey='").append(this.transactionExternalKey).append('\'');
        sb.append(", paymentId=").append(this.paymentId);
        sb.append(", paymentExternalKey='").append(this.paymentExternalKey).append('\'');
        sb.append(", transactionType='").append(this.transactionType).append('\'');
        sb.append(", effectiveDate=").append(this.effectiveDate);
        sb.append(", status='").append(this.status).append('\'');
        sb.append(", amount=").append(this.amount);
        sb.append(", currency='").append(this.currency).append('\'');
        sb.append(", gatewayErrorCode='").append(this.gatewayErrorCode).append('\'');
        sb.append(", gatewayErrorMsg='").append(this.gatewayErrorMsg).append('\'');
        sb.append(", firstPaymentReferenceId='").append(this.firstPaymentReferenceId).append('\'');
        sb.append(", secondPaymentReferenceId='").append(this.secondPaymentReferenceId).append('\'');
        sb.append(", properties=").append(this.properties);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentTransaction that = (PaymentTransaction)o;
        if (this.amount != null ? this.amount.compareTo(that.amount) != 0 : that.amount != null) {
            return false;
        }
        if (this.currency != null ? !this.currency.equals(that.currency) : that.currency != null) {
            return false;
        }
        if (this.paymentExternalKey != null ? !this.paymentExternalKey.equals(that.paymentExternalKey) : that.paymentExternalKey != null) {
            return false;
        }
        if (this.paymentId != null ? !this.paymentId.equals(that.paymentId) : that.paymentId != null) {
            return false;
        }
        if (this.transactionExternalKey != null ? !this.transactionExternalKey.equals(that.transactionExternalKey) : that.transactionExternalKey != null) {
            return false;
        }
        if (this.transactionId != null ? !this.transactionId.equals(that.transactionId) : that.transactionId != null) {
            return false;
        }
        if (this.effectiveDate != null ? this.effectiveDate.compareTo((ReadableInstant)that.effectiveDate) != 0 : that.effectiveDate != null) {
            return false;
        }
        if (this.firstPaymentReferenceId != null ? !this.firstPaymentReferenceId.equals(that.firstPaymentReferenceId) : that.firstPaymentReferenceId != null) {
            return false;
        }
        if (this.gatewayErrorCode != null ? !this.gatewayErrorCode.equals(that.gatewayErrorCode) : that.gatewayErrorCode != null) {
            return false;
        }
        if (this.gatewayErrorMsg != null ? !this.gatewayErrorMsg.equals(that.gatewayErrorMsg) : that.gatewayErrorMsg != null) {
            return false;
        }
        if (this.properties != null ? !this.properties.equals(that.properties) : that.properties != null) {
            return false;
        }
        if (this.secondPaymentReferenceId != null ? !this.secondPaymentReferenceId.equals(that.secondPaymentReferenceId) : that.secondPaymentReferenceId != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(that.status) : that.status != null) {
            return false;
        }
        return !(this.transactionType != null ? !this.transactionType.equals(that.transactionType) : that.transactionType != null);
    }

    public int hashCode() {
        int result = this.transactionId != null ? this.transactionId.hashCode() : 0;
        result = 31 * result + (this.transactionExternalKey != null ? this.transactionExternalKey.hashCode() : 0);
        result = 31 * result + (this.paymentId != null ? this.paymentId.hashCode() : 0);
        result = 31 * result + (this.paymentExternalKey != null ? this.paymentExternalKey.hashCode() : 0);
        result = 31 * result + (this.transactionType != null ? this.transactionType.hashCode() : 0);
        result = 31 * result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.amount != null ? this.amount.hashCode() : 0);
        result = 31 * result + (this.currency != null ? this.currency.hashCode() : 0);
        result = 31 * result + (this.gatewayErrorCode != null ? this.gatewayErrorCode.hashCode() : 0);
        result = 31 * result + (this.gatewayErrorMsg != null ? this.gatewayErrorMsg.hashCode() : 0);
        result = 31 * result + (this.firstPaymentReferenceId != null ? this.firstPaymentReferenceId.hashCode() : 0);
        result = 31 * result + (this.secondPaymentReferenceId != null ? this.secondPaymentReferenceId.hashCode() : 0);
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        return result;
    }
}

