/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import com.ning.http.client.Response;
import com.ning.http.util.UTF8UrlEncoder;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.killbill.billing.catalog.api.BillingActionPolicy;
import org.killbill.billing.catalog.api.ProductCategory;
import org.killbill.billing.client.KillBillClientException;
import org.killbill.billing.client.KillBillHttpClient;
import org.killbill.billing.client.RequestOptions;
import org.killbill.billing.client.model.Account;
import org.killbill.billing.client.model.AccountEmail;
import org.killbill.billing.client.model.AccountEmails;
import org.killbill.billing.client.model.AccountTimeline;
import org.killbill.billing.client.model.Accounts;
import org.killbill.billing.client.model.BlockingState;
import org.killbill.billing.client.model.BlockingStates;
import org.killbill.billing.client.model.BulkBaseSubscriptionAndAddOns;
import org.killbill.billing.client.model.Bundle;
import org.killbill.billing.client.model.Bundles;
import org.killbill.billing.client.model.Catalog;
import org.killbill.billing.client.model.Catalogs;
import org.killbill.billing.client.model.ComboHostedPaymentPage;
import org.killbill.billing.client.model.ComboPaymentTransaction;
import org.killbill.billing.client.model.Credit;
import org.killbill.billing.client.model.CustomField;
import org.killbill.billing.client.model.CustomFields;
import org.killbill.billing.client.model.HostedPaymentPageFields;
import org.killbill.billing.client.model.HostedPaymentPageFormDescriptor;
import org.killbill.billing.client.model.Invoice;
import org.killbill.billing.client.model.InvoiceDryRun;
import org.killbill.billing.client.model.InvoiceEmail;
import org.killbill.billing.client.model.InvoiceItem;
import org.killbill.billing.client.model.InvoiceItems;
import org.killbill.billing.client.model.InvoicePayment;
import org.killbill.billing.client.model.InvoicePaymentTransaction;
import org.killbill.billing.client.model.InvoicePayments;
import org.killbill.billing.client.model.Invoices;
import org.killbill.billing.client.model.OverdueState;
import org.killbill.billing.client.model.Payment;
import org.killbill.billing.client.model.PaymentMethod;
import org.killbill.billing.client.model.PaymentMethods;
import org.killbill.billing.client.model.PaymentTransaction;
import org.killbill.billing.client.model.Payments;
import org.killbill.billing.client.model.Permissions;
import org.killbill.billing.client.model.PlanDetail;
import org.killbill.billing.client.model.PlanDetails;
import org.killbill.billing.client.model.RoleDefinition;
import org.killbill.billing.client.model.RolledUpUsage;
import org.killbill.billing.client.model.SimplePlan;
import org.killbill.billing.client.model.Subscription;
import org.killbill.billing.client.model.SubscriptionUsageRecord;
import org.killbill.billing.client.model.TagDefinition;
import org.killbill.billing.client.model.TagDefinitions;
import org.killbill.billing.client.model.Tags;
import org.killbill.billing.client.model.Tenant;
import org.killbill.billing.client.model.TenantKey;
import org.killbill.billing.client.model.UserRoles;
import org.killbill.billing.entitlement.api.BlockingStateType;
import org.killbill.billing.entitlement.api.Entitlement;
import org.killbill.billing.util.api.AuditLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KillBillClient
implements Closeable {
    private static final Joiner JOINER = Joiner.on((String)",");
    private final KillBillHttpClient httpClient;

    public KillBillClient() {
        this(new KillBillHttpClient());
    }

    public KillBillClient(KillBillHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public void close() {
        this.httpClient.close();
    }

    @Deprecated
    public Accounts getAccounts() throws KillBillClientException {
        return this.getAccounts(RequestOptions.empty());
    }

    public Accounts getAccounts(RequestOptions inputOptions) throws KillBillClientException {
        return this.getAccounts((Long)0L, (Long)100L, inputOptions);
    }

    @Deprecated
    public Accounts getAccounts(Long offset, Long limit) throws KillBillClientException {
        return this.getAccounts(offset, limit, RequestOptions.empty());
    }

    public Accounts getAccounts(Long offset, Long limit, RequestOptions inputOptions) throws KillBillClientException {
        return this.getAccounts(offset, limit, AuditLevel.NONE, inputOptions);
    }

    @Deprecated
    public Accounts getAccounts(Long offset, Long limit, AuditLevel auditLevel) throws KillBillClientException {
        return this.getAccounts(offset, limit, auditLevel, RequestOptions.empty());
    }

    public Accounts getAccounts(Long offset, Long limit, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/pagination";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"offset", (Object)String.valueOf(offset));
        queryParams.put((Object)"limit", (Object)String.valueOf(limit));
        queryParams.put((Object)"audit", (Object)auditLevel.toString());
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet("/1.0/kb/accounts/pagination", Accounts.class, requestOptions);
    }

    @Deprecated
    public Account getAccount(UUID accountId) throws KillBillClientException {
        return this.getAccount(accountId, RequestOptions.empty());
    }

    public Account getAccount(UUID accountId, RequestOptions inputOptions) throws KillBillClientException {
        return this.getAccount(accountId, false, false, inputOptions);
    }

    @Deprecated
    public Account getAccount(UUID accountId, boolean withBalance, boolean withCBA) throws KillBillClientException {
        return this.getAccount(accountId, withBalance, withCBA, RequestOptions.empty());
    }

    public Account getAccount(UUID accountId, boolean withBalance, boolean withCBA, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/" + accountId;
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"accountWithBalance", (Object)(withBalance ? "true" : "false"));
        queryParams.put((Object)"accountWithBalanceAndCBA", (Object)(withCBA ? "true" : "false"));
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet(uri, Account.class, requestOptions);
    }

    @Deprecated
    public Account getAccount(String externalKey) throws KillBillClientException {
        return this.getAccount(externalKey, RequestOptions.empty());
    }

    public Account getAccount(String externalKey, RequestOptions inputOptions) throws KillBillClientException {
        return this.getAccount(externalKey, false, false, inputOptions);
    }

    @Deprecated
    public Account getAccount(String externalKey, boolean withBalance, boolean withCBA) throws KillBillClientException {
        return this.getAccount(externalKey, withBalance, withCBA, RequestOptions.empty());
    }

    public Account getAccount(String externalKey, boolean withBalance, boolean withCBA, RequestOptions inputOptions) throws KillBillClientException {
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"externalKey", (Object)externalKey);
        queryParams.put((Object)"accountWithBalance", (Object)(withBalance ? "true" : "false"));
        queryParams.put((Object)"accountWithBalanceAndCBA", (Object)(withCBA ? "true" : "false"));
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet("/1.0/kb/accounts", Account.class, requestOptions);
    }

    @Deprecated
    public Accounts searchAccounts(String key) throws KillBillClientException {
        return this.searchAccounts(key, RequestOptions.empty());
    }

    public Accounts searchAccounts(String key, RequestOptions inputOptions) throws KillBillClientException {
        return this.searchAccounts(key, (Long)0L, (Long)100L, inputOptions);
    }

    @Deprecated
    public Accounts searchAccounts(String key, Long offset, Long limit) throws KillBillClientException {
        return this.searchAccounts(key, offset, limit, RequestOptions.empty());
    }

    public Accounts searchAccounts(String key, Long offset, Long limit, RequestOptions inputOptions) throws KillBillClientException {
        return this.searchAccounts(key, offset, limit, AuditLevel.NONE, RequestOptions.empty());
    }

    @Deprecated
    public Accounts searchAccounts(String key, Long offset, Long limit, AuditLevel auditLevel) throws KillBillClientException {
        return this.searchAccounts(key, offset, limit, auditLevel, RequestOptions.empty());
    }

    public Accounts searchAccounts(String key, Long offset, Long limit, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/search/" + UTF8UrlEncoder.encodePath((String)key);
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"offset", (Object)String.valueOf(offset));
        queryParams.put((Object)"limit", (Object)String.valueOf(limit));
        queryParams.put((Object)"audit", (Object)auditLevel.toString());
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet(uri, Accounts.class, requestOptions);
    }

    @Deprecated
    public AccountTimeline getAccountTimeline(UUID accountId) throws KillBillClientException {
        return this.getAccountTimeline(accountId, RequestOptions.empty());
    }

    public AccountTimeline getAccountTimeline(UUID accountId, RequestOptions inputOptions) throws KillBillClientException {
        return this.getAccountTimeline(accountId, AuditLevel.NONE, inputOptions);
    }

    @Deprecated
    public AccountTimeline getAccountTimeline(UUID accountId, AuditLevel auditLevel) throws KillBillClientException {
        return this.getAccountTimeline(accountId, auditLevel, RequestOptions.empty());
    }

    public AccountTimeline getAccountTimeline(UUID accountId, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/" + accountId + "/" + "timeline";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"audit", (Object)auditLevel.toString());
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet(uri, AccountTimeline.class, requestOptions);
    }

    @Deprecated
    public Account createAccount(Account account, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createAccount(account, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Account createAccount(Account account, RequestOptions inputOptions) throws KillBillClientException {
        Boolean followLocation = (Boolean)MoreObjects.firstNonNull((Object)inputOptions.getFollowLocation(), (Object)Boolean.TRUE);
        RequestOptions requestOptions = inputOptions.extend().withFollowLocation(followLocation).build();
        return this.httpClient.doPost("/1.0/kb/accounts", (Object)account, Account.class, requestOptions);
    }

    @Deprecated
    public Account updateAccount(Account account, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.updateAccount(account, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Account updateAccount(Account account, RequestOptions inputOptions) throws KillBillClientException {
        return this.updateAccount(account, false, inputOptions);
    }

    public Account updateAccount(Account account, boolean treatNullAsReset, RequestOptions inputOptions) throws KillBillClientException {
        Preconditions.checkNotNull((Object)account.getAccountId(), (Object)"Account#accountId cannot be null");
        String uri = "/1.0/kb/accounts/" + account.getAccountId();
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"treatNullAsReset", (Object)(treatNullAsReset ? "true" : "false"));
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doPut(uri, (Object)account, Account.class, requestOptions);
    }

    public void closeAccount(UUID accountId, boolean cancelAllSubscriptions, boolean writeOffUnpaidInvoices, boolean itemAdjustUnpaidInvoices, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/" + accountId;
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"cancelAllSubscriptions", (Object)(cancelAllSubscriptions ? "true" : "false"));
        queryParams.put((Object)"writeOffUnpaidInvoices", (Object)(writeOffUnpaidInvoices ? "true" : "false"));
        queryParams.put((Object)"itemAdjustUnpaidInvoices", (Object)(itemAdjustUnpaidInvoices ? "true" : "false"));
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        this.httpClient.doDelete(uri, requestOptions);
    }

    @Deprecated
    public AccountEmails getEmailsForAccount(UUID accountId) throws KillBillClientException {
        return this.getEmailsForAccount(accountId, RequestOptions.empty());
    }

    public AccountEmails getEmailsForAccount(UUID accountId, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/" + accountId + "/" + "emails";
        return this.httpClient.doGet(uri, AccountEmails.class, inputOptions);
    }

    @Deprecated
    public void addEmailToAccount(AccountEmail email, String createdBy, String reason, String comment) throws KillBillClientException {
        this.addEmailToAccount(email, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void addEmailToAccount(AccountEmail email, RequestOptions inputOptions) throws KillBillClientException {
        Preconditions.checkNotNull((Object)email.getAccountId(), (Object)"AccountEmail#accountId cannot be null");
        String uri = "/1.0/kb/accounts/" + email.getAccountId() + "/" + "emails";
        this.httpClient.doPost(uri, (Object)email, inputOptions);
    }

    @Deprecated
    public void removeEmailFromAccount(AccountEmail email, String createdBy, String reason, String comment) throws KillBillClientException {
        this.removeEmailFromAccount(email, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void removeEmailFromAccount(AccountEmail email, RequestOptions inputOptions) throws KillBillClientException {
        Preconditions.checkNotNull((Object)email.getAccountId(), (Object)"AccountEmail#accountId cannot be null");
        Preconditions.checkNotNull((Object)email.getEmail(), (Object)"AccountEmail#email cannot be null");
        String uri = "/1.0/kb/accounts/" + email.getAccountId() + "/" + "emails" + "/" + UTF8UrlEncoder.encodePath((String)email.getEmail());
        this.httpClient.doDelete(uri, inputOptions);
    }

    @Deprecated
    public InvoiceEmail getEmailNotificationsForAccount(UUID accountId) throws KillBillClientException {
        return this.getEmailNotificationsForAccount(accountId, RequestOptions.empty());
    }

    public InvoiceEmail getEmailNotificationsForAccount(UUID accountId, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/" + accountId + "/" + "emailNotifications";
        return this.httpClient.doGet(uri, InvoiceEmail.class, inputOptions);
    }

    @Deprecated
    public void updateEmailNotificationsForAccount(InvoiceEmail invoiceEmail, String createdBy, String reason, String comment) throws KillBillClientException {
        this.updateEmailNotificationsForAccount(invoiceEmail, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void updateEmailNotificationsForAccount(InvoiceEmail invoiceEmail, RequestOptions inputOptions) throws KillBillClientException {
        Preconditions.checkNotNull((Object)invoiceEmail.getAccountId(), (Object)"InvoiceEmail#accountId cannot be null");
        String uri = "/1.0/kb/accounts/" + invoiceEmail.getAccountId() + "/" + "emailNotifications";
        this.httpClient.doPut(uri, (Object)invoiceEmail, inputOptions);
    }

    public Accounts getChildrenAccounts(UUID parentAccountId, boolean withBalance, boolean withCBA, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/" + parentAccountId + "/" + "children";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"accountWithBalance", (Object)(withBalance ? "true" : "false"));
        queryParams.put((Object)"accountWithBalanceAndCBA", (Object)(withCBA ? "true" : "false"));
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet(uri, Accounts.class, requestOptions);
    }

    public void transferChildCreditToParent(UUID childAccountId, RequestOptions inputOptions) throws KillBillClientException {
        Preconditions.checkNotNull((Object)childAccountId, (Object)"Account#childAccountId cannot be null");
        String uri = "/1.0/kb/accounts/" + childAccountId + "/" + "transferCredit";
        this.httpClient.doPost(uri, null, inputOptions);
    }

    @Deprecated
    public Bundle getBundle(UUID bundleId) throws KillBillClientException {
        return this.getBundle(bundleId, RequestOptions.empty());
    }

    public Bundle getBundle(UUID bundleId, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/bundles/" + bundleId;
        return this.httpClient.doGet(uri, Bundle.class, inputOptions);
    }

    @Deprecated
    public Bundle getBundle(String externalKey) throws KillBillClientException {
        return this.getBundle(externalKey, RequestOptions.empty());
    }

    public Bundle getBundle(String externalKey, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/bundles";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"externalKey", (Object)externalKey);
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        Bundles bundles = this.httpClient.doGet("/1.0/kb/bundles", Bundles.class, requestOptions);
        return bundles.isEmpty() ? null : (Bundle)bundles.get(0);
    }

    public Bundles getAllBundlesForExternalKey(String externalKey, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/bundles";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"externalKey", (Object)externalKey);
        queryParams.put((Object)"includedDeleted", (Object)"true");
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet("/1.0/kb/bundles", Bundles.class, requestOptions);
    }

    @Deprecated
    public Bundles getAccountBundles(UUID accountId) throws KillBillClientException {
        return this.getAccountBundles(accountId, RequestOptions.empty());
    }

    public Bundles getAccountBundles(UUID accountId, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/" + accountId + "/" + "bundles";
        return this.httpClient.doGet(uri, Bundles.class, inputOptions);
    }

    @Deprecated
    public Bundles getAccountBundles(UUID accountId, String externalKey) throws KillBillClientException {
        return this.getAccountBundles(accountId, externalKey, RequestOptions.empty());
    }

    public Bundles getAccountBundles(UUID accountId, String externalKey, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/" + accountId + "/" + "bundles";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"externalKey", (Object)externalKey);
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet(uri, Bundles.class, requestOptions);
    }

    @Deprecated
    public Bundles getBundles() throws KillBillClientException {
        return this.getBundles(RequestOptions.empty());
    }

    public Bundles getBundles(RequestOptions inputOptions) throws KillBillClientException {
        return this.getBundles((Long)0L, (Long)100L, inputOptions);
    }

    @Deprecated
    public Bundles getBundles(Long offset, Long limit) throws KillBillClientException {
        return this.getBundles(offset, limit, RequestOptions.empty());
    }

    public Bundles getBundles(Long offset, Long limit, RequestOptions inputOptions) throws KillBillClientException {
        return this.getBundles(offset, limit, AuditLevel.NONE, inputOptions);
    }

    @Deprecated
    public Bundles getBundles(Long offset, Long limit, AuditLevel auditLevel) throws KillBillClientException {
        return this.getBundles(offset, limit, auditLevel, RequestOptions.empty());
    }

    public Bundles getBundles(Long offset, Long limit, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/bundles/pagination";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"offset", (Object)String.valueOf(offset));
        queryParams.put((Object)"limit", (Object)String.valueOf(limit));
        queryParams.put((Object)"audit", (Object)auditLevel.toString());
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet("/1.0/kb/bundles/pagination", Bundles.class, requestOptions);
    }

    @Deprecated
    public Bundles searchBundles(String key) throws KillBillClientException {
        return this.searchBundles(key, RequestOptions.empty());
    }

    public Bundles searchBundles(String key, RequestOptions inputOptions) throws KillBillClientException {
        return this.searchBundles(key, (Long)0L, (Long)100L, inputOptions);
    }

    @Deprecated
    public Bundles searchBundles(String key, Long offset, Long limit) throws KillBillClientException {
        return this.searchBundles(key, offset, limit, RequestOptions.empty());
    }

    public Bundles searchBundles(String key, Long offset, Long limit, RequestOptions inputOptions) throws KillBillClientException {
        return this.searchBundles(key, offset, limit, AuditLevel.NONE, inputOptions);
    }

    @Deprecated
    public Bundles searchBundles(String key, Long offset, Long limit, AuditLevel auditLevel) throws KillBillClientException {
        return this.searchBundles(key, offset, limit, auditLevel, RequestOptions.empty());
    }

    public Bundles searchBundles(String key, Long offset, Long limit, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/bundles/search/" + UTF8UrlEncoder.encodePath((String)key);
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"offset", (Object)String.valueOf(offset));
        queryParams.put((Object)"limit", (Object)String.valueOf(limit));
        queryParams.put((Object)"audit", (Object)auditLevel.toString());
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet(uri, Bundles.class, requestOptions);
    }

    @Deprecated
    public Bundle transferBundle(Bundle bundle, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.transferBundle(bundle, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Bundle transferBundle(Bundle bundle, RequestOptions inputOptions) throws KillBillClientException {
        Preconditions.checkNotNull((Object)bundle.getBundleId(), (Object)"Bundle#bundleId cannot be null");
        Preconditions.checkNotNull((Object)bundle.getAccountId(), (Object)"Bundle#accountId cannot be null");
        String uri = "/1.0/kb/bundles/" + bundle.getBundleId();
        Boolean followLocation = (Boolean)MoreObjects.firstNonNull((Object)inputOptions.getFollowLocation(), (Object)Boolean.TRUE);
        RequestOptions requestOptions = inputOptions.extend().withFollowLocation(followLocation).build();
        return this.httpClient.doPut(uri, (Object)bundle, Bundle.class, requestOptions);
    }

    @Deprecated
    public void setBlockingState(UUID blockableId, BlockingState blockingState, @Nullable LocalDate requestedDate, Map<String, String> pluginProperties, String createdBy, String reason, String comment) throws KillBillClientException {
        this.setBlockingState(blockableId, blockingState, requestedDate, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void setBlockingState(UUID blockableId, BlockingState blockingState, @Nullable LocalDate requestedDate, RequestOptions inputOptions) throws KillBillClientException {
        String resourcePath;
        Preconditions.checkNotNull((Object)blockableId, (Object)"blockableId cannot be null");
        Preconditions.checkNotNull((Object)blockingState.getService(), (Object)"Bundle#service cannot be null");
        Preconditions.checkNotNull((Object)blockingState.getStateName(), (Object)"Bundle#stateName cannot be null");
        Preconditions.checkNotNull((Object)blockingState.getType(), (Object)"Bundle#type cannot be null");
        if (blockingState.getType() == BlockingStateType.ACCOUNT) {
            resourcePath = "/1.0/kb/accounts";
        } else if (blockingState.getType() == BlockingStateType.SUBSCRIPTION_BUNDLE) {
            resourcePath = "/1.0/kb/bundles";
        } else if (blockingState.getType() == BlockingStateType.SUBSCRIPTION) {
            resourcePath = "/1.0/kb/subscriptions";
        } else {
            throw new IllegalArgumentException("Unexpected blockingState:type " + blockingState.getType());
        }
        String uri = resourcePath + "/" + blockableId + "/" + "block";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        if (requestedDate != null) {
            queryParams.put((Object)"requestedDate", (Object)requestedDate.toString());
        }
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        this.httpClient.doPut(uri, (Object)blockingState, requestOptions);
    }

    public BlockingStates getBlockingStates(UUID accountId, @Nullable List<BlockingStateType> typeFilter, @Nullable List<String> svcsFilter, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/" + accountId.toString() + "/" + "block";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        if (typeFilter != null) {
            queryParams.put((Object)"blockingStateTypes", (Object)JOINER.join(typeFilter));
        }
        if (svcsFilter != null) {
            queryParams.put((Object)"blockingStateSvcs", (Object)JOINER.join(svcsFilter));
        }
        queryParams.put((Object)"audit", (Object)auditLevel.toString());
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet(uri, BlockingStates.class, requestOptions);
    }

    @Deprecated
    public Subscription getSubscription(UUID subscriptionId) throws KillBillClientException {
        return this.getSubscription(subscriptionId, RequestOptions.empty());
    }

    public Subscription getSubscription(UUID subscriptionId, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/subscriptions/" + subscriptionId;
        return this.httpClient.doGet(uri, Subscription.class, inputOptions);
    }

    @Deprecated
    public Subscription createSubscription(Subscription subscription, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createSubscription(subscription, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Subscription createSubscription(Subscription subscription, RequestOptions inputOptions) throws KillBillClientException {
        return this.createSubscription(subscription, null, -1, null, inputOptions);
    }

    @Deprecated
    public Subscription createSubscription(Subscription subscription, LocalDate requestedDate, int timeoutSec, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createSubscription(subscription, requestedDate, timeoutSec, null, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Subscription createSubscription(Subscription subscription, LocalDate requestedDate, int timeoutSec, RequestOptions inputOptions) throws KillBillClientException {
        return this.createSubscription(subscription, requestedDate, timeoutSec, null, inputOptions);
    }

    public Subscription createSubscription(Subscription subscription, LocalDate requestedDate, int timeoutSec, Boolean isMigrated, RequestOptions inputOptions) throws KillBillClientException {
        if (subscription.getPlanName() == null) {
            Preconditions.checkNotNull((Object)subscription.getAccountId(), (Object)"Subscription#accountId cannot be null");
            Preconditions.checkNotNull((Object)subscription.getProductName(), (Object)"Subscription#productName cannot be null");
            Preconditions.checkNotNull((Object)subscription.getProductCategory(), (Object)"Subscription#productCategory cannot be null");
            Preconditions.checkNotNull((Object)subscription.getBillingPeriod(), (Object)"Subscription#billingPeriod cannot be null");
            Preconditions.checkNotNull((Object)subscription.getPriceList(), (Object)"Subscription#priceList cannot be null");
        }
        if (subscription.getProductCategory() == ProductCategory.BASE) {
            Preconditions.checkNotNull((Object)subscription.getAccountId(), (Object)"Account#accountId cannot be null");
        }
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"callCompletion", (Object)(timeoutSec > 0 ? "true" : "false"));
        queryParams.put((Object)"callTimeoutSec", (Object)String.valueOf(timeoutSec));
        if (requestedDate != null) {
            queryParams.put((Object)"requestedDate", (Object)requestedDate.toString());
        }
        if (isMigrated != null) {
            queryParams.put((Object)"migrated", (Object)isMigrated.toString());
        }
        int httpTimeout = Math.max(10, timeoutSec);
        Boolean followLocation = (Boolean)MoreObjects.firstNonNull((Object)inputOptions.getFollowLocation(), (Object)Boolean.TRUE);
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).withFollowLocation(followLocation).build();
        return this.httpClient.doPost("/1.0/kb/subscriptions", (Object)subscription, Subscription.class, requestOptions, httpTimeout);
    }

    @Deprecated
    public Bundle createSubscriptionWithAddOns(List<Subscription> subscriptions, LocalDate requestedDate, int timeoutSec, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createSubscriptionWithAddOns(subscriptions, requestedDate, timeoutSec, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Bundle createSubscriptionWithAddOns(List<Subscription> subscriptions, LocalDate requestedDate, int timeoutSec, RequestOptions inputOptions) throws KillBillClientException {
        Bundles bundles = this.createSubscriptionsWithAddOns((Iterable<BulkBaseSubscriptionAndAddOns>)ImmutableList.of((Object)new BulkBaseSubscriptionAndAddOns(subscriptions)), requestedDate, timeoutSec, inputOptions);
        return bundles != null && !bundles.isEmpty() ? (Bundle)bundles.get(0) : null;
    }

    public Bundles createSubscriptionsWithAddOns(Iterable<BulkBaseSubscriptionAndAddOns> subscriptionsBulk, LocalDate requestedDate, int timeoutSec, RequestOptions inputOptions) throws KillBillClientException {
        for (BulkBaseSubscriptionAndAddOns bulk : subscriptionsBulk) {
            boolean first = true;
            for (Subscription subscription : bulk.getBaseEntitlementAndAddOns()) {
                if (first) {
                    Preconditions.checkState((subscription.getProductCategory() == ProductCategory.BASE ? 1 : 0) != 0, (Object)"First subscription must be a reference to the Base");
                    Preconditions.checkNotNull((Object)subscription.getAccountId(), (Object)"Account#accountId cannot be null for base subscription");
                    first = false;
                    continue;
                }
                Preconditions.checkState((subscription.getPlanName() != null || subscription.getProductName() != null && subscription.getProductCategory() != null && subscription.getBillingPeriod() != null && subscription.getPriceList() != null ? 1 : 0) != 0, (Object)"A valid subscription descriptor must be provided (planName or {productName, productCategory, billingPeriod, priceList}");
            }
        }
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"callCompletion", (Object)(timeoutSec > 0 ? "true" : "false"));
        queryParams.put((Object)"callTimeoutSec", (Object)String.valueOf(timeoutSec));
        if (requestedDate != null) {
            queryParams.put((Object)"requestedDate", (Object)requestedDate.toString());
        }
        int httpTimeout = Math.max(10, timeoutSec);
        String uri = "/1.0/kb/subscriptions/createEntitlementsWithAddOns";
        Boolean followLocation = (Boolean)MoreObjects.firstNonNull((Object)inputOptions.getFollowLocation(), (Object)Boolean.TRUE);
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).withFollowLocation(followLocation).build();
        return this.httpClient.doPost("/1.0/kb/subscriptions/createEntitlementsWithAddOns", subscriptionsBulk, Bundles.class, requestOptions, httpTimeout);
    }

    @Deprecated
    public Subscription updateSubscription(Subscription subscription, int timeoutSec, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.updateSubscription(subscription, timeoutSec, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Subscription updateSubscription(Subscription subscription, int timeoutSec, RequestOptions inputOptions) throws KillBillClientException {
        return this.updateSubscription(subscription, null, timeoutSec, inputOptions);
    }

    @Deprecated
    public Subscription updateSubscription(Subscription subscription, @Nullable BillingActionPolicy billingPolicy, int timeoutSec, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.updateSubscription(subscription, billingPolicy, timeoutSec, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Subscription updateSubscription(Subscription subscription, @Nullable BillingActionPolicy billingPolicy, int timeoutSec, RequestOptions inputOptions) throws KillBillClientException {
        return this.updateSubscription(subscription, null, billingPolicy, timeoutSec, inputOptions);
    }

    @Deprecated
    public Subscription updateSubscription(Subscription subscription, @Nullable LocalDate requestedDate, @Nullable BillingActionPolicy billingPolicy, int timeoutSec, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.updateSubscription(subscription, requestedDate, billingPolicy, timeoutSec, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Subscription updateSubscription(Subscription subscription, @Nullable LocalDate requestedDate, @Nullable BillingActionPolicy billingPolicy, int timeoutSec, RequestOptions inputOptions) throws KillBillClientException {
        Preconditions.checkNotNull((Object)subscription.getSubscriptionId(), (Object)"Subscription#subscriptionId cannot be null");
        if (subscription.getPlanName() == null) {
            Preconditions.checkNotNull((Object)subscription.getProductName(), (Object)"Subscription#productName cannot be null");
            Preconditions.checkNotNull((Object)subscription.getBillingPeriod(), (Object)"Subscription#billingPeriod cannot be null");
            Preconditions.checkNotNull((Object)subscription.getPriceList(), (Object)"Subscription#priceList cannot be null");
        }
        String uri = "/1.0/kb/subscriptions/" + subscription.getSubscriptionId();
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"callCompletion", (Object)(timeoutSec > 0 ? "true" : "false"));
        queryParams.put((Object)"callTimeoutSec", (Object)String.valueOf(timeoutSec));
        if (requestedDate != null) {
            queryParams.put((Object)"requestedDate", (Object)requestedDate.toString());
        }
        if (billingPolicy != null) {
            queryParams.put((Object)"billingPolicy", (Object)billingPolicy.toString());
        }
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doPut(uri, (Object)subscription, Subscription.class, requestOptions);
    }

    public void updateSubscriptionBCD(Subscription subscription, @Nullable LocalDate effectiveDateFrom, int timeoutSec, RequestOptions inputOptions) throws KillBillClientException {
        Preconditions.checkNotNull((Object)subscription.getBillCycleDayLocal(), (Object)"Subscription#billCycleDayLocal cannot be null");
        String uri = "/1.0/kb/subscriptions/" + subscription.getSubscriptionId() + "/" + "bcd";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"callTimeoutSec", (Object)String.valueOf(timeoutSec));
        if (effectiveDateFrom != null) {
            queryParams.put((Object)"effectiveFromDate", (Object)effectiveDateFrom.toString());
        }
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        this.httpClient.doPut(uri, (Object)subscription, requestOptions);
    }

    @Deprecated
    public void cancelSubscription(UUID subscriptionId, String createdBy, String reason, String comment) throws KillBillClientException {
        this.cancelSubscription(subscriptionId, -1, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void cancelSubscription(UUID subscriptionId, RequestOptions inputOptions) throws KillBillClientException {
        this.cancelSubscription(subscriptionId, -1, inputOptions);
    }

    @Deprecated
    public void cancelSubscription(UUID subscriptionId, int timeoutSec, String createdBy, String reason, String comment) throws KillBillClientException {
        this.cancelSubscription(subscriptionId, timeoutSec, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void cancelSubscription(UUID subscriptionId, int timeoutSec, RequestOptions inputOptions) throws KillBillClientException {
        this.cancelSubscription(subscriptionId, null, null, timeoutSec, inputOptions);
    }

    @Deprecated
    public void cancelSubscription(UUID subscriptionId, @Nullable Entitlement.EntitlementActionPolicy entitlementPolicy, @Nullable BillingActionPolicy billingPolicy, int timeoutSec, String createdBy, String reason, String comment) throws KillBillClientException {
        this.cancelSubscription(subscriptionId, entitlementPolicy, billingPolicy, timeoutSec, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void cancelSubscription(UUID subscriptionId, @Nullable Entitlement.EntitlementActionPolicy entitlementPolicy, @Nullable BillingActionPolicy billingPolicy, int timeoutSec, RequestOptions inputOptions) throws KillBillClientException {
        this.cancelSubscription(subscriptionId, null, entitlementPolicy, billingPolicy, timeoutSec, inputOptions);
    }

    @Deprecated
    public void cancelSubscription(UUID subscriptionId, @Nullable LocalDate requestedDate, @Nullable Entitlement.EntitlementActionPolicy entitlementPolicy, @Nullable BillingActionPolicy billingPolicy, int timeoutSec, String createdBy, String reason, String comment) throws KillBillClientException {
        this.cancelSubscription(subscriptionId, requestedDate, entitlementPolicy, billingPolicy, timeoutSec, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void cancelSubscription(UUID subscriptionId, @Nullable LocalDate requestedDate, @Nullable Entitlement.EntitlementActionPolicy entitlementPolicy, @Nullable BillingActionPolicy billingPolicy, int timeoutSec, RequestOptions inputOptions) throws KillBillClientException {
        this.cancelSubscription(subscriptionId, requestedDate, null, entitlementPolicy, billingPolicy, timeoutSec, inputOptions);
    }

    @Deprecated
    public void cancelSubscription(UUID subscriptionId, @Nullable LocalDate requestedDate, @Nullable Boolean useRequestedDateForBilling, @Nullable Entitlement.EntitlementActionPolicy entitlementPolicy, @Nullable BillingActionPolicy billingPolicy, int timeoutSec, String createdBy, String reason, String comment) throws KillBillClientException {
        this.cancelSubscription(subscriptionId, requestedDate, useRequestedDateForBilling, entitlementPolicy, billingPolicy, timeoutSec, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void cancelSubscription(UUID subscriptionId, @Nullable LocalDate requestedDate, @Nullable Boolean useRequestedDateForBilling, @Nullable Entitlement.EntitlementActionPolicy entitlementPolicy, @Nullable BillingActionPolicy billingPolicy, int timeoutSec, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/subscriptions/" + subscriptionId;
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"callCompletion", (Object)(timeoutSec > 0 ? "true" : "false"));
        queryParams.put((Object)"callTimeoutSec", (Object)String.valueOf(timeoutSec));
        if (requestedDate != null) {
            queryParams.put((Object)"requestedDate", (Object)requestedDate.toString());
        }
        if (entitlementPolicy != null) {
            queryParams.put((Object)"entitlementPolicy", (Object)entitlementPolicy.toString());
        }
        if (billingPolicy != null) {
            queryParams.put((Object)"billingPolicy", (Object)billingPolicy.toString());
        }
        if (useRequestedDateForBilling != null) {
            queryParams.put((Object)"useRequestedDateForBilling", (Object)useRequestedDateForBilling.toString());
        }
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        this.httpClient.doDelete(uri, requestOptions);
    }

    @Deprecated
    public void uncancelSubscription(UUID subscriptionId, String createdBy, String reason, String comment) throws KillBillClientException {
        this.uncancelSubscription(subscriptionId, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void uncancelSubscription(UUID subscriptionId, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/subscriptions/" + subscriptionId + "/uncancel";
        this.httpClient.doPut(uri, null, inputOptions);
    }

    public CustomFields getSubscriptionCustomFields(UUID subscriptionId, RequestOptions inputOptions) throws KillBillClientException {
        return this.getSubscriptionCustomFields(subscriptionId, AuditLevel.NONE, inputOptions);
    }

    public CustomFields getSubscriptionCustomFields(UUID subscriptionId, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/subscriptions/" + subscriptionId + "/" + "customFields";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"audit", (Object)auditLevel.toString());
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet(uri, CustomFields.class, requestOptions);
    }

    public CustomFields createSubscriptionCustomField(UUID subscriptionId, CustomField customField, RequestOptions inputOptions) throws KillBillClientException {
        return this.createSubscriptionCustomFields(subscriptionId, (Iterable<CustomField>)ImmutableList.of((Object)customField), inputOptions);
    }

    public CustomFields createSubscriptionCustomFields(UUID subscriptionId, Iterable<CustomField> customFields, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/subscriptions/" + subscriptionId + "/" + "customFields";
        Boolean followLocation = (Boolean)MoreObjects.firstNonNull((Object)inputOptions.getFollowLocation(), (Object)Boolean.TRUE);
        RequestOptions requestOptions = inputOptions.extend().withFollowLocation(followLocation).build();
        return this.httpClient.doPost(uri, customFields, CustomFields.class, requestOptions);
    }

    public void deleteSubscriptionCustomFields(UUID subscriptionId, RequestOptions inputOptions) throws KillBillClientException {
        this.deleteSubscriptionCustomFields(subscriptionId, null, inputOptions);
    }

    public void deleteSubscriptionCustomFields(UUID subscriptionId, @Nullable Iterable<UUID> customFieldIds, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/subscriptions/" + subscriptionId + "/" + "customFields";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        if (customFieldIds != null) {
            queryParams.put((Object)"customFieldList", (Object)Joiner.on((String)",").join(customFieldIds));
        }
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        this.httpClient.doDelete(uri, requestOptions);
    }

    public CustomFields getBundleCustomFields(UUID bundleId, RequestOptions inputOptions) throws KillBillClientException {
        return this.getBundleCustomFields(bundleId, AuditLevel.NONE, inputOptions);
    }

    public CustomFields getBundleCustomFields(UUID bundleId, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/bundles/" + bundleId + "/" + "customFields";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"audit", (Object)auditLevel.toString());
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet(uri, CustomFields.class, requestOptions);
    }

    public CustomFields createBundleCustomField(UUID bundleId, CustomField customField, RequestOptions inputOptions) throws KillBillClientException {
        return this.createBundleCustomFields(bundleId, (Iterable<CustomField>)ImmutableList.of((Object)customField), inputOptions);
    }

    public CustomFields createBundleCustomFields(UUID bundleId, Iterable<CustomField> customFields, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/bundles/" + bundleId + "/" + "customFields";
        Boolean followLocation = (Boolean)MoreObjects.firstNonNull((Object)inputOptions.getFollowLocation(), (Object)Boolean.TRUE);
        RequestOptions requestOptions = inputOptions.extend().withFollowLocation(followLocation).build();
        return this.httpClient.doPost(uri, customFields, CustomFields.class, requestOptions);
    }

    public void deleteBundleCustomFields(UUID bundleId, RequestOptions inputOptions) throws KillBillClientException {
        this.deleteBundleCustomFields(bundleId, null, inputOptions);
    }

    public void deleteBundleCustomFields(UUID bundleId, @Nullable Iterable<UUID> customFieldIds, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/bundles/" + bundleId + "/" + "customFields";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        if (customFieldIds != null) {
            queryParams.put((Object)"customFieldList", (Object)Joiner.on((String)",").join(customFieldIds));
        }
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        this.httpClient.doDelete(uri, requestOptions);
    }

    @Deprecated
    public void createSubscriptionUsageRecord(SubscriptionUsageRecord subscriptionUsageRecord, String createdBy, String reason, String comment) throws KillBillClientException {
        this.createSubscriptionUsageRecord(subscriptionUsageRecord, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void createSubscriptionUsageRecord(SubscriptionUsageRecord subscriptionUsageRecord, RequestOptions inputOptions) throws KillBillClientException {
        Preconditions.checkNotNull((Object)subscriptionUsageRecord.getSubscriptionId(), (Object)"SubscriptionUsageRecord#subscriptionId cannot be null");
        Preconditions.checkNotNull(subscriptionUsageRecord.getUnitUsageRecords(), (Object)"SubscriptionUsageRecord#unitUsageRecords cannot be null");
        Preconditions.checkArgument((!subscriptionUsageRecord.getUnitUsageRecords().isEmpty() ? 1 : 0) != 0, (Object)"SubscriptionUsageRecord#unitUsageRecords cannot be empty");
        String uri = "/1.0/kb/usages";
        this.httpClient.doPost("/1.0/kb/usages", (Object)subscriptionUsageRecord, inputOptions);
    }

    @Deprecated
    public RolledUpUsage getRolledUpUsage(UUID subscriptionId, @Nullable String unitType, LocalDate startDate, LocalDate endDate) throws KillBillClientException {
        return this.getRolledUpUsage(subscriptionId, unitType, startDate, endDate, RequestOptions.empty());
    }

    public RolledUpUsage getRolledUpUsage(UUID subscriptionId, @Nullable String unitType, LocalDate startDate, LocalDate endDate, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/usages/" + subscriptionId;
        if (unitType != null && !unitType.trim().isEmpty()) {
            uri = uri.concat("/").concat(unitType);
        }
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"startDate", (Object)startDate.toString());
        queryParams.put((Object)"endDate", (Object)endDate.toString());
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet(uri, RolledUpUsage.class, requestOptions);
    }

    @Deprecated
    public Invoices getInvoices() throws KillBillClientException {
        return this.getInvoices(RequestOptions.empty());
    }

    public Invoices getInvoices(RequestOptions inputOptions) throws KillBillClientException {
        return this.getInvoices((Long)0L, (Long)100L, inputOptions);
    }

    @Deprecated
    public Invoices getInvoices(Long offset, Long limit) throws KillBillClientException {
        return this.getInvoices(offset, limit, RequestOptions.empty());
    }

    public Invoices getInvoices(Long offset, Long limit, RequestOptions inputOptions) throws KillBillClientException {
        return this.getInvoices(true, offset, limit, AuditLevel.NONE, inputOptions);
    }

    @Deprecated
    public Invoices getInvoices(Long offset, Long limit, AuditLevel auditLevel) throws KillBillClientException {
        return this.getInvoices(true, offset, limit, auditLevel, RequestOptions.empty());
    }

    public Invoices getInvoices(Long offset, Long limit, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        return this.getInvoices(true, offset, limit, auditLevel, inputOptions);
    }

    @Deprecated
    public Invoices getInvoices(boolean withItems, Long offset, Long limit, AuditLevel auditLevel) throws KillBillClientException {
        return this.getInvoices(withItems, offset, limit, auditLevel, RequestOptions.empty());
    }

    public Invoices getInvoices(boolean withItems, Long offset, Long limit, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/invoices/pagination";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"offset", (Object)String.valueOf(offset));
        queryParams.put((Object)"limit", (Object)String.valueOf(limit));
        queryParams.put((Object)"withItems", (Object)String.valueOf(withItems));
        queryParams.put((Object)"audit", (Object)auditLevel.toString());
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet("/1.0/kb/invoices/pagination", Invoices.class, requestOptions);
    }

    @Deprecated
    public Invoice getInvoice(UUID invoiceId) throws KillBillClientException {
        return this.getInvoice(invoiceId, RequestOptions.empty());
    }

    public Invoice getInvoice(UUID invoiceId, RequestOptions inputOptions) throws KillBillClientException {
        return this.getInvoice(invoiceId, true, false, inputOptions);
    }

    @Deprecated
    public Invoice getInvoice(UUID invoiceId, boolean withItems) throws KillBillClientException {
        return this.getInvoice(invoiceId, withItems, false, RequestOptions.empty());
    }

    public Invoice getInvoice(UUID invoiceId, boolean withItems, boolean withChildrenItems, RequestOptions inputOptions) throws KillBillClientException {
        return this.getInvoice(invoiceId, withItems, withChildrenItems, AuditLevel.NONE, inputOptions);
    }

    @Deprecated
    public Invoice getInvoice(UUID invoiceId, boolean withItems, AuditLevel auditLevel) throws KillBillClientException {
        return this.getInvoice(invoiceId, withItems, false, auditLevel, RequestOptions.empty());
    }

    public Invoice getInvoice(UUID invoiceId, boolean withItems, boolean withChildrenItems, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        return this.getInvoiceByIdOrNumber(invoiceId.toString(), withItems, withChildrenItems, auditLevel, inputOptions);
    }

    @Deprecated
    public Invoice getInvoice(Integer invoiceNumber) throws KillBillClientException {
        return this.getInvoice(invoiceNumber, RequestOptions.empty());
    }

    public Invoice getInvoice(Integer invoiceNumber, RequestOptions inputOptions) throws KillBillClientException {
        return this.getInvoice(invoiceNumber, true, false, inputOptions);
    }

    @Deprecated
    public Invoice getInvoice(Integer invoiceNumber, boolean withItems) throws KillBillClientException {
        return this.getInvoice(invoiceNumber, withItems, false, RequestOptions.empty());
    }

    public Invoice getInvoice(Integer invoiceNumber, boolean withItems, boolean withChildrenItems, RequestOptions inputOptions) throws KillBillClientException {
        return this.getInvoice(invoiceNumber, withItems, withChildrenItems, AuditLevel.NONE, inputOptions);
    }

    @Deprecated
    public Invoice getInvoice(Integer invoiceNumber, boolean withItems, AuditLevel auditLevel) throws KillBillClientException {
        return this.getInvoice(invoiceNumber, withItems, false, auditLevel, RequestOptions.empty());
    }

    public Invoice getInvoice(Integer invoiceNumber, boolean withItems, boolean withChildrenItems, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        return this.getInvoiceByIdOrNumber(invoiceNumber.toString(), withItems, withChildrenItems, auditLevel, inputOptions);
    }

    @Deprecated
    public Invoice getInvoiceByIdOrNumber(String invoiceIdOrNumber, boolean withItems, AuditLevel auditLevel) throws KillBillClientException {
        return this.getInvoiceByIdOrNumber(invoiceIdOrNumber, withItems, false, auditLevel, RequestOptions.empty());
    }

    public Invoice getInvoiceByIdOrNumber(String invoiceIdOrNumber, boolean withItems, boolean withChildrenItems, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/invoices/" + invoiceIdOrNumber;
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"withItems", (Object)String.valueOf(withItems));
        queryParams.put((Object)"withChildrenItems", (Object)String.valueOf(withChildrenItems));
        queryParams.put((Object)"audit", (Object)auditLevel.toString());
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet(uri, Invoice.class, requestOptions);
    }

    @Deprecated
    public String getInvoiceAsHtml(UUID invoiceId) throws KillBillClientException {
        return this.getInvoiceAsHtml(invoiceId, RequestOptions.empty());
    }

    public String getInvoiceAsHtml(UUID invoiceId, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/invoices/" + invoiceId + "/" + "html";
        return this.getResourceFile(uri, "text/html", inputOptions);
    }

    @Deprecated
    public Invoices getInvoicesForAccount(UUID accountId) throws KillBillClientException {
        return this.getInvoicesForAccount(accountId, RequestOptions.empty());
    }

    public Invoices getInvoicesForAccount(UUID accountId, RequestOptions inputOptions) throws KillBillClientException {
        return this.getInvoicesForAccount(accountId, true, true, inputOptions);
    }

    @Deprecated
    public Invoices getInvoicesForAccount(UUID accountId, boolean withItems, boolean includeMigrationInvoices) throws KillBillClientException {
        return this.getInvoicesForAccount(accountId, withItems, includeMigrationInvoices, RequestOptions.empty());
    }

    public Invoices getInvoicesForAccount(UUID accountId, boolean withItems, boolean includeMigrationInvoices, RequestOptions inputOptions) throws KillBillClientException {
        return this.getInvoicesForAccount(accountId, withItems, false, includeMigrationInvoices, AuditLevel.NONE, inputOptions);
    }

    @Deprecated
    public Invoices getInvoicesForAccount(UUID accountId, boolean withItems, boolean unpaidOnly, boolean includeMigrationInvoices) throws KillBillClientException {
        return this.getInvoicesForAccount(accountId, withItems, unpaidOnly, RequestOptions.empty());
    }

    public Invoices getInvoicesForAccount(UUID accountId, boolean withItems, boolean unpaidOnly, boolean includeMigrationInvoices, RequestOptions inputOptions) throws KillBillClientException {
        return this.getInvoicesForAccount(accountId, withItems, unpaidOnly, includeMigrationInvoices, AuditLevel.NONE, inputOptions);
    }

    @Deprecated
    public Invoices getInvoicesForAccount(UUID accountId, boolean withItems, boolean unpaidOnly, boolean includeMigrationInvoices, AuditLevel auditLevel) throws KillBillClientException {
        return this.getInvoicesForAccount(accountId, withItems, unpaidOnly, includeMigrationInvoices, auditLevel, RequestOptions.empty());
    }

    public Invoices getInvoicesForAccount(UUID accountId, boolean withItems, boolean unpaidOnly, boolean includeMigrationInvoices, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/" + accountId + "/" + "invoices";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"withItems", (Object)String.valueOf(withItems));
        queryParams.put((Object)"unpaidInvoicesOnly", (Object)String.valueOf(unpaidOnly));
        queryParams.put((Object)"withMigrationInvoices", (Object)String.valueOf(includeMigrationInvoices));
        queryParams.put((Object)"audit", (Object)auditLevel.toString());
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet(uri, Invoices.class, requestOptions);
    }

    @Deprecated
    public Invoices searchInvoices(String key) throws KillBillClientException {
        return this.searchInvoices(key, RequestOptions.empty());
    }

    public Invoices searchInvoices(String key, RequestOptions inputOptions) throws KillBillClientException {
        return this.searchInvoices(key, (Long)0L, (Long)100L, inputOptions);
    }

    @Deprecated
    public Invoices searchInvoices(String key, Long offset, Long limit) throws KillBillClientException {
        return this.searchInvoices(key, offset, limit, RequestOptions.empty());
    }

    public Invoices searchInvoices(String key, Long offset, Long limit, RequestOptions inputOptions) throws KillBillClientException {
        return this.searchInvoices(key, offset, limit, AuditLevel.NONE, inputOptions);
    }

    @Deprecated
    public Invoices searchInvoices(String key, Long offset, Long limit, AuditLevel auditLevel) throws KillBillClientException {
        return this.searchInvoices(key, offset, limit, auditLevel, RequestOptions.empty());
    }

    public Invoices searchInvoices(String key, Long offset, Long limit, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/invoices/search/" + UTF8UrlEncoder.encodePath((String)key);
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"offset", (Object)String.valueOf(offset));
        queryParams.put((Object)"limit", (Object)String.valueOf(limit));
        queryParams.put((Object)"audit", (Object)auditLevel.toString());
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet(uri, Invoices.class, requestOptions);
    }

    @Deprecated
    public Invoice createDryRunInvoice(UUID accountId, @Nullable LocalDate futureDate, InvoiceDryRun dryRunInfo, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createDryRunInvoice(accountId, futureDate, dryRunInfo, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Invoice createDryRunInvoice(UUID accountId, @Nullable LocalDate futureDate, InvoiceDryRun dryRunInfo, RequestOptions inputOptions) throws KillBillClientException {
        String futureDateOrUpcomingNextInvoice;
        String uri = "/1.0/kb/invoices/dryRun";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        String string = futureDateOrUpcomingNextInvoice = futureDate != null ? futureDate.toString() : null;
        if (futureDateOrUpcomingNextInvoice != null) {
            queryParams.put((Object)"accountId", (Object)accountId.toString());
            queryParams.put((Object)"targetDate", (Object)futureDateOrUpcomingNextInvoice);
            queryParams.put((Object)"dryRun", (Object)"true");
        } else {
            queryParams.put((Object)"accountId", (Object)accountId.toString());
            queryParams.put((Object)"dryRun", (Object)"true");
        }
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doPost("/1.0/kb/invoices/dryRun", (Object)dryRunInfo, Invoice.class, requestOptions);
    }

    @Deprecated
    public Invoice createInvoice(UUID accountId, LocalDate futureDate, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createInvoice(accountId, futureDate, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Invoice createInvoice(UUID accountId, LocalDate futureDate, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/invoices";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"accountId", (Object)accountId.toString());
        queryParams.put((Object)"targetDate", (Object)futureDate.toString());
        Boolean followLocation = (Boolean)MoreObjects.firstNonNull((Object)inputOptions.getFollowLocation(), (Object)Boolean.TRUE);
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).withFollowLocation(followLocation).build();
        return this.httpClient.doPost("/1.0/kb/invoices", null, Invoice.class, requestOptions);
    }

    @Deprecated
    public Invoice adjustInvoiceItem(InvoiceItem invoiceItem, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.adjustInvoiceItem(invoiceItem, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Invoice adjustInvoiceItem(InvoiceItem invoiceItem, RequestOptions inputOptions) throws KillBillClientException {
        return this.adjustInvoiceItem(invoiceItem, null, inputOptions);
    }

    @Deprecated
    public Invoice adjustInvoiceItem(InvoiceItem invoiceItem, LocalDate requestedDate, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.adjustInvoiceItem(invoiceItem, requestedDate, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Invoice adjustInvoiceItem(InvoiceItem invoiceItem, LocalDate requestedDate, RequestOptions inputOptions) throws KillBillClientException {
        Preconditions.checkNotNull((Object)invoiceItem.getAccountId(), (Object)"InvoiceItem#accountId cannot be null");
        Preconditions.checkNotNull((Object)invoiceItem.getInvoiceId(), (Object)"InvoiceItem#invoiceId cannot be null");
        Preconditions.checkNotNull((Object)invoiceItem.getInvoiceItemId(), (Object)"InvoiceItem#invoiceItemId cannot be null");
        String uri = "/1.0/kb/invoices/" + invoiceItem.getInvoiceId();
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        if (requestedDate != null) {
            queryParams.put((Object)"requestedDate", (Object)requestedDate.toString());
        }
        Boolean followLocation = (Boolean)MoreObjects.firstNonNull((Object)inputOptions.getFollowLocation(), (Object)Boolean.TRUE);
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).withFollowLocation(followLocation).build();
        return this.httpClient.doPost(uri, (Object)invoiceItem, Invoice.class, requestOptions);
    }

    @Deprecated
    public InvoiceItem createExternalCharge(InvoiceItem externalCharge, @Nullable LocalDate requestedDate, Boolean autoPay, Boolean autoCommit, String createdBy, String reason, String comment) throws KillBillClientException {
        List<InvoiceItem> externalCharges = this.createExternalCharges((Iterable<InvoiceItem>)ImmutableList.of((Object)externalCharge), requestedDate, autoPay, autoCommit, createdBy, reason, comment);
        return externalCharges.isEmpty() ? null : externalCharges.get(0);
    }

    @Deprecated
    public List<InvoiceItem> createExternalCharges(Iterable<InvoiceItem> externalCharges, @Nullable LocalDate requestedDate, Boolean autoPay, Boolean autoCommit, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createExternalCharges(externalCharges, requestedDate, autoPay, autoCommit, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public List<InvoiceItem> createExternalCharges(Iterable<InvoiceItem> externalCharges, LocalDate requestedDate, Boolean autoPay, Boolean autoCommit, RequestOptions inputOptions) throws KillBillClientException {
        return this.createExternalCharges(externalCharges, requestedDate, autoPay, autoCommit, null, null, inputOptions);
    }

    public List<InvoiceItem> createExternalCharges(Iterable<InvoiceItem> externalCharges, LocalDate requestedDate, Boolean autoPay, Boolean autoCommit, String paymentExternalKey, String transactionExternalKey, RequestOptions inputOptions) throws KillBillClientException {
        HashMap externalChargesPerAccount = new HashMap();
        for (InvoiceItem externalCharge : externalCharges) {
            Preconditions.checkNotNull((Object)externalCharge.getAccountId(), (Object)"InvoiceItem#accountId cannot be null");
            Preconditions.checkNotNull((Object)externalCharge.getAmount(), (Object)"InvoiceItem#amount cannot be null");
            if (externalChargesPerAccount.get(externalCharge.getAccountId()) == null) {
                externalChargesPerAccount.put(externalCharge.getAccountId(), new LinkedList());
            }
            ((Collection)externalChargesPerAccount.get(externalCharge.getAccountId())).add(externalCharge);
        }
        LinkedList<InvoiceItem> createdExternalCharges = new LinkedList<InvoiceItem>();
        for (UUID accountId : externalChargesPerAccount.keySet()) {
            List<InvoiceItem> invoiceItems = this.createExternalCharges(accountId, (Iterable)externalChargesPerAccount.get(accountId), requestedDate, autoPay, autoCommit, paymentExternalKey, transactionExternalKey, inputOptions);
            createdExternalCharges.addAll(invoiceItems);
        }
        return createdExternalCharges;
    }

    private List<InvoiceItem> createExternalCharges(UUID accountId, Iterable<InvoiceItem> externalCharges, @Nullable LocalDate requestedDate, Boolean autoPay, Boolean autoCommit, String paymentExternalKey, String transactionExternalKey, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/invoices/charges/" + accountId;
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        if (requestedDate != null) {
            queryParams.put((Object)"requestedDate", (Object)requestedDate.toString());
        }
        queryParams.put((Object)"payInvoice", (Object)autoPay.toString());
        queryParams.put((Object)"autoCommit", (Object)autoCommit.toString());
        if (paymentExternalKey != null) {
            queryParams.put((Object)"paymentExternalKey", (Object)paymentExternalKey);
        }
        if (transactionExternalKey != null) {
            queryParams.put((Object)"transactionExternalKey", (Object)transactionExternalKey);
        }
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doPost(uri, externalCharges, InvoiceItems.class, requestOptions);
    }

    public Invoice createMigrationInvoice(UUID accountId, LocalDate targetDate, Iterable<InvoiceItem> items, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/invoices/migration/" + accountId;
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        if (targetDate != null) {
            queryParams.put((Object)"requestedDate", (Object)targetDate.toString());
        }
        HashMultimap queryFollowParams = HashMultimap.create(inputOptions.getQueryParamsForFollow());
        queryFollowParams.put((Object)"withItems", (Object)"true");
        Boolean followLocation = (Boolean)MoreObjects.firstNonNull((Object)inputOptions.getFollowLocation(), (Object)Boolean.TRUE);
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).withFollowLocation(followLocation).withQueryParamsForFollow((Multimap<String, String>)queryFollowParams).build();
        return this.httpClient.doPost(uri, items, Invoice.class, requestOptions);
    }

    @Deprecated
    public void triggerInvoiceNotification(UUID invoiceId, String createdBy, String reason, String comment) throws KillBillClientException {
        this.triggerInvoiceNotification(invoiceId, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void triggerInvoiceNotification(UUID invoiceId, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/invoices/" + invoiceId.toString() + "/" + "emailNotifications";
        this.httpClient.doPost(uri, null, inputOptions);
    }

    @Deprecated
    public void uploadInvoiceTemplate(String invoiceTemplateFilePath, boolean manualPay, String createdBy, String reason, String comment) throws KillBillClientException {
        this.uploadInvoiceTemplate(invoiceTemplateFilePath, manualPay, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void uploadInvoiceTemplate(String invoiceTemplateFilePath, boolean manualPay, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "invoices" + (manualPay ? "/manualPayTemplate" : "/template");
        this.uploadFile(invoiceTemplateFilePath, uri, "text/html", inputOptions, null);
    }

    @Deprecated
    public void uploadInvoiceTemplate(InputStream invoiceTemplateInputStream, boolean manualPay, String createdBy, String reason, String comment) throws KillBillClientException {
        this.uploadInvoiceTemplate(invoiceTemplateInputStream, manualPay, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void uploadInvoiceTemplate(InputStream invoiceTemplateInputStream, boolean manualPay, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "invoices" + (manualPay ? "/manualPayTemplate" : "/template");
        this.uploadFile(invoiceTemplateInputStream, uri, "text/html", inputOptions, null);
    }

    @Deprecated
    public String getInvoiceTemplate(boolean manualPay) throws KillBillClientException {
        return this.getInvoiceTemplate(manualPay, RequestOptions.empty());
    }

    public String getInvoiceTemplate(boolean manualPay, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "invoices" + (manualPay ? "/manualPayTemplate" : "/template");
        return this.getResourceFile(uri, "text/html", inputOptions);
    }

    @Deprecated
    public void uploadInvoiceTranslation(String invoiceTranslationFilePath, String locale, String createdBy, String reason, String comment) throws KillBillClientException {
        this.uploadInvoiceTranslation(invoiceTranslationFilePath, locale, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void uploadInvoiceTranslation(String invoiceTranslationFilePath, String locale, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "invoices/translation/" + locale;
        this.uploadFile(invoiceTranslationFilePath, uri, "text/plain", inputOptions, null);
    }

    @Deprecated
    public void uploadInvoiceTranslation(InputStream invoiceTranslationInputStream, String locale, String createdBy, String reason, String comment) throws KillBillClientException {
        this.uploadInvoiceTranslation(invoiceTranslationInputStream, locale, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void uploadInvoiceTranslation(InputStream invoiceTranslationInputStream, String locale, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "invoices/translation/" + locale;
        this.uploadFile(invoiceTranslationInputStream, uri, "text/plain", inputOptions, null);
    }

    @Deprecated
    public String getInvoiceTranslation(String locale) throws KillBillClientException {
        return this.getInvoiceTranslation(locale, RequestOptions.empty());
    }

    public String getInvoiceTranslation(String locale, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "invoices/translation/" + locale;
        return this.getResourceFile(uri, "text/plain", inputOptions);
    }

    @Deprecated
    public void uploadCatalogTranslation(String catalogTranslationFilePath, String locale, String createdBy, String reason, String comment) throws KillBillClientException {
        this.uploadCatalogTranslation(catalogTranslationFilePath, locale, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void uploadCatalogTranslation(String catalogTranslationFilePath, String locale, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "invoices/catalogTranslation/" + locale;
        this.uploadFile(catalogTranslationFilePath, uri, "text/plain", inputOptions, null);
    }

    @Deprecated
    public void uploadCatalogTranslation(InputStream catalogTranslationInputStream, String locale, String createdBy, String reason, String comment) throws KillBillClientException {
        this.uploadCatalogTranslation(catalogTranslationInputStream, locale, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void uploadCatalogTranslation(InputStream catalogTranslationInputStream, String locale, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "invoices/catalogTranslation/" + locale;
        this.uploadFile(catalogTranslationInputStream, uri, "text/plain", inputOptions, null);
    }

    @Deprecated
    public String getCatalogTranslation(String locale) throws KillBillClientException {
        return this.getCatalogTranslation(locale, RequestOptions.empty());
    }

    public String getCatalogTranslation(String locale, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "invoices/catalogTranslation/" + locale;
        return this.getResourceFile(uri, "text/plain", inputOptions);
    }

    @Deprecated
    public void commitInvoice(UUID invoiceId, String createdBy, String reason, String comment) throws KillBillClientException {
        this.commitInvoice(invoiceId, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void commitInvoice(UUID invoiceId, RequestOptions inputOptions) throws KillBillClientException {
        Preconditions.checkNotNull((Object)invoiceId, (Object)"invoiceId cannot be null");
        String uri = "/1.0/kb/invoices/" + invoiceId.toString() + "/commitInvoice";
        this.httpClient.doPut(uri, null, inputOptions);
    }

    @Deprecated
    public Credit getCredit(UUID creditId) throws KillBillClientException {
        return this.getCredit(creditId, RequestOptions.empty());
    }

    public Credit getCredit(UUID creditId, RequestOptions inputOptions) throws KillBillClientException {
        return this.getCredit(creditId, AuditLevel.NONE, inputOptions);
    }

    @Deprecated
    public Credit getCredit(UUID creditId, AuditLevel auditLevel) throws KillBillClientException {
        return this.getCredit(creditId, auditLevel, RequestOptions.empty());
    }

    public Credit getCredit(UUID creditId, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/credits/" + creditId;
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"audit", (Object)auditLevel.toString());
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet(uri, Credit.class, requestOptions);
    }

    @Deprecated
    public Credit createCredit(Credit credit, Boolean autoCommit, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createCredit(credit, autoCommit, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Credit createCredit(Credit credit, Boolean autoCommit, RequestOptions inputOptions) throws KillBillClientException {
        Preconditions.checkNotNull((Object)credit.getAccountId(), (Object)"Credt#accountId cannot be null");
        Preconditions.checkNotNull((Object)credit.getCreditAmount(), (Object)"Credt#creditAmount cannot be null");
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"autoCommit", (Object)autoCommit.toString());
        Boolean followLocation = (Boolean)MoreObjects.firstNonNull((Object)inputOptions.getFollowLocation(), (Object)Boolean.TRUE);
        RequestOptions requestOptions = inputOptions.extend().withFollowLocation(followLocation).withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doPost("/1.0/kb/credits", (Object)credit, Credit.class, requestOptions);
    }

    @Deprecated
    public Payments searchPayments(String key) throws KillBillClientException {
        return this.searchPayments(key, RequestOptions.empty());
    }

    public Payments searchPayments(String key, RequestOptions inputOptions) throws KillBillClientException {
        return this.searchPayments(key, (Long)0L, (Long)100L, inputOptions);
    }

    @Deprecated
    public Payments searchPayments(String key, Long offset, Long limit) throws KillBillClientException {
        return this.searchPayments(key, offset, limit, RequestOptions.empty());
    }

    public Payments searchPayments(String key, Long offset, Long limit, RequestOptions inputOptions) throws KillBillClientException {
        return this.searchPayments(key, offset, limit, AuditLevel.NONE, inputOptions);
    }

    @Deprecated
    public Payments searchPayments(String key, Long offset, Long limit, AuditLevel auditLevel) throws KillBillClientException {
        return this.searchPayments(key, offset, limit, auditLevel, RequestOptions.empty());
    }

    public Payments searchPayments(String key, Long offset, Long limit, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/payments/search/" + UTF8UrlEncoder.encodePath((String)key);
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"offset", (Object)String.valueOf(offset));
        queryParams.put((Object)"limit", (Object)String.valueOf(limit));
        queryParams.put((Object)"audit", (Object)auditLevel.toString());
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet(uri, Payments.class, requestOptions);
    }

    @Deprecated
    public InvoicePayments getInvoicePaymentsForAccount(UUID accountId) throws KillBillClientException {
        return this.getInvoicePaymentsForAccount(accountId, RequestOptions.empty());
    }

    public InvoicePayments getInvoicePaymentsForAccount(UUID accountId, RequestOptions inputOptions) throws KillBillClientException {
        return this.getInvoicePaymentsForAccount(accountId, AuditLevel.NONE, inputOptions);
    }

    @Deprecated
    public InvoicePayments getInvoicePaymentsForAccount(UUID accountId, AuditLevel auditLevel) throws KillBillClientException {
        return this.getInvoicePaymentsForAccount(accountId, auditLevel, RequestOptions.empty());
    }

    public InvoicePayments getInvoicePaymentsForAccount(UUID accountId, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/" + accountId + "/" + "invoicePayments";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"audit", (Object)auditLevel.toString());
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet(uri, InvoicePayments.class, requestOptions);
    }

    @Deprecated
    public InvoicePayments getInvoicePayment(UUID invoiceId) throws KillBillClientException {
        return this.getInvoicePayment(invoiceId, RequestOptions.empty());
    }

    public InvoicePayments getInvoicePayment(UUID invoiceId, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/invoices/" + invoiceId + "/" + "payments";
        return this.httpClient.doGet(uri, InvoicePayments.class, inputOptions);
    }

    @Deprecated
    public void payAllInvoices(UUID accountId, boolean externalPayment, BigDecimal paymentAmount, String createdBy, String reason, String comment) throws KillBillClientException {
        this.payAllInvoices(accountId, externalPayment, paymentAmount, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void payAllInvoices(UUID accountId, boolean externalPayment, BigDecimal paymentAmount, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/" + accountId + "/" + "invoicePayments";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"externalPayment", (Object)String.valueOf(externalPayment));
        if (paymentAmount != null) {
            queryParams.put((Object)"paymentAmount", (Object)String.valueOf(paymentAmount));
        }
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        this.httpClient.doPost(uri, null, requestOptions);
    }

    @Deprecated
    public InvoicePayment createInvoicePayment(InvoicePayment payment, boolean isExternal, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createInvoicePayment(payment, isExternal, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public InvoicePayment createInvoicePayment(InvoicePayment payment, boolean isExternal, RequestOptions inputOptions) throws KillBillClientException {
        Preconditions.checkNotNull((Object)payment.getAccountId(), (Object)"InvoiceItem#accountId cannot be null");
        Preconditions.checkNotNull((Object)payment.getTargetInvoiceId(), (Object)"InvoiceItem#invoiceId cannot be null");
        Preconditions.checkNotNull((Object)payment.getPurchasedAmount(), (Object)"InvoiceItem#amount cannot be null");
        String uri = "/1.0/kb/invoices/" + payment.getTargetInvoiceId() + "/" + "payments";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"externalPayment", (Object)String.valueOf(isExternal));
        Boolean followLocation = (Boolean)MoreObjects.firstNonNull((Object)inputOptions.getFollowLocation(), (Object)Boolean.TRUE);
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).withFollowLocation(followLocation).build();
        return this.httpClient.doPost(uri, (Object)payment, InvoicePayment.class, requestOptions);
    }

    @Deprecated
    public Payments getPayments() throws KillBillClientException {
        return this.getPayments(RequestOptions.empty());
    }

    public Payments getPayments(RequestOptions inputOptions) throws KillBillClientException {
        return this.getPayments((Long)0L, (Long)100L, inputOptions);
    }

    @Deprecated
    public Payments getPayments(Long offset, Long limit) throws KillBillClientException {
        return this.getPayments(offset, limit, RequestOptions.empty());
    }

    public Payments getPayments(Long offset, Long limit, RequestOptions inputOptions) throws KillBillClientException {
        return this.getPayments(offset, limit, AuditLevel.NONE, inputOptions);
    }

    @Deprecated
    public Payments getPayments(Long offset, Long limit, AuditLevel auditLevel) throws KillBillClientException {
        return this.getPayments(offset, limit, auditLevel, RequestOptions.empty());
    }

    public Payments getPayments(Long offset, Long limit, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        return this.getPayments(offset, limit, null, (Map<String, String>)ImmutableMap.of(), auditLevel, inputOptions);
    }

    @Deprecated
    public Payments getPayments(Long offset, Long limit, @Nullable String pluginName, Map<String, String> pluginProperties, AuditLevel auditLevel) throws KillBillClientException {
        return this.getPayments(offset, limit, pluginName, pluginProperties, auditLevel, RequestOptions.empty());
    }

    public Payments getPayments(Long offset, Long limit, @Nullable String pluginName, Map<String, String> pluginProperties, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/payments/pagination";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        if (pluginName != null) {
            queryParams.put((Object)"pluginName", (Object)pluginName);
        }
        queryParams.put((Object)"offset", (Object)String.valueOf(offset));
        queryParams.put((Object)"limit", (Object)String.valueOf(limit));
        queryParams.put((Object)"audit", (Object)auditLevel.toString());
        this.storePluginPropertiesAsParams(pluginProperties, (Multimap<String, String>)queryParams);
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet("/1.0/kb/payments/pagination", Payments.class, requestOptions);
    }

    @Deprecated
    public Payment getPayment(UUID paymentId) throws KillBillClientException {
        return this.getPayment(paymentId, RequestOptions.empty());
    }

    public Payment getPayment(UUID paymentId, RequestOptions inputOptions) throws KillBillClientException {
        return this.getPayment(paymentId, true, inputOptions);
    }

    @Deprecated
    public Payment getPayment(UUID paymentId, boolean withPluginInfo) throws KillBillClientException {
        return this.getPayment(paymentId, withPluginInfo, RequestOptions.empty());
    }

    public Payment getPayment(UUID paymentId, boolean withPluginInfo, RequestOptions inputOptions) throws KillBillClientException {
        return this.getPayment(paymentId, withPluginInfo, AuditLevel.NONE, inputOptions);
    }

    @Deprecated
    public Payment getPayment(UUID paymentId, boolean withPluginInfo, AuditLevel auditLevel) throws KillBillClientException {
        return this.getPayment(paymentId, withPluginInfo, auditLevel, RequestOptions.empty());
    }

    public Payment getPayment(UUID paymentId, boolean withPluginInfo, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        return this.getPayment(paymentId, withPluginInfo, (Map<String, String>)ImmutableMap.of(), auditLevel, inputOptions);
    }

    @Deprecated
    public Payment getPayment(UUID paymentId, boolean withPluginInfo, Map<String, String> pluginProperties, AuditLevel auditLevel) throws KillBillClientException {
        return this.getPayment(paymentId, withPluginInfo, pluginProperties, auditLevel, RequestOptions.empty());
    }

    public Payment getPayment(UUID paymentId, boolean withPluginInfo, Map<String, String> pluginProperties, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        return this.getPayment(paymentId, withPluginInfo, false, pluginProperties, auditLevel, inputOptions);
    }

    public Payment getPayment(UUID paymentId, boolean withPluginInfo, boolean withAttempts, Map<String, String> pluginProperties, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/payments/" + paymentId;
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"withPluginInfo", (Object)String.valueOf(withPluginInfo));
        queryParams.put((Object)"withAttempts", (Object)String.valueOf(withAttempts));
        queryParams.put((Object)"audit", (Object)auditLevel.toString());
        this.storePluginPropertiesAsParams(pluginProperties, (Multimap<String, String>)queryParams);
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet(uri, Payment.class, requestOptions);
    }

    @Deprecated
    public Payment getPaymentByExternalKey(String externalKey) throws KillBillClientException {
        return this.getPaymentByExternalKey(externalKey, RequestOptions.empty());
    }

    public Payment getPaymentByExternalKey(String externalKey, RequestOptions inputOptions) throws KillBillClientException {
        return this.getPaymentByExternalKey(externalKey, true, inputOptions);
    }

    @Deprecated
    public Payment getPaymentByExternalKey(String externalKey, boolean withPluginInfo) throws KillBillClientException {
        return this.getPaymentByExternalKey(externalKey, withPluginInfo, RequestOptions.empty());
    }

    public Payment getPaymentByExternalKey(String externalKey, boolean withPluginInfo, RequestOptions inputOptions) throws KillBillClientException {
        return this.getPaymentByExternalKey(externalKey, withPluginInfo, AuditLevel.NONE);
    }

    @Deprecated
    public Payment getPaymentByExternalKey(String externalKey, boolean withPluginInfo, AuditLevel auditLevel) throws KillBillClientException {
        return this.getPaymentByExternalKey(externalKey, withPluginInfo, auditLevel, RequestOptions.empty());
    }

    public Payment getPaymentByExternalKey(String externalKey, boolean withPluginInfo, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        return this.getPaymentByExternalKey(externalKey, withPluginInfo, (Map<String, String>)ImmutableMap.of(), auditLevel, inputOptions);
    }

    @Deprecated
    public Payment getPaymentByExternalKey(String externalKey, boolean withPluginInfo, Map<String, String> pluginProperties, AuditLevel auditLevel) throws KillBillClientException {
        return this.getPaymentByExternalKey(externalKey, withPluginInfo, pluginProperties, auditLevel, RequestOptions.empty());
    }

    public Payment getPaymentByExternalKey(String externalKey, boolean withPluginInfo, Map<String, String> pluginProperties, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/payments";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"externalKey", (Object)externalKey);
        queryParams.put((Object)"withPluginInfo", (Object)String.valueOf(withPluginInfo));
        queryParams.put((Object)"audit", (Object)auditLevel.toString());
        this.storePluginPropertiesAsParams(pluginProperties, (Multimap<String, String>)queryParams);
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet("/1.0/kb/payments", Payment.class, requestOptions);
    }

    @Deprecated
    public Payments getPaymentsForAccount(UUID accountId) throws KillBillClientException {
        return this.getPaymentsForAccount(accountId, RequestOptions.empty());
    }

    public Payments getPaymentsForAccount(UUID accountId, RequestOptions inputOptions) throws KillBillClientException {
        return this.getPaymentsForAccount(accountId, AuditLevel.NONE, inputOptions);
    }

    @Deprecated
    public Payments getPaymentsForAccount(UUID accountId, AuditLevel auditLevel) throws KillBillClientException {
        return this.getPaymentsForAccount(accountId, auditLevel, RequestOptions.empty());
    }

    public Payments getPaymentsForAccount(UUID accountId, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/" + accountId + "/" + "payments";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"audit", (Object)auditLevel.toString());
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet(uri, Payments.class, requestOptions);
    }

    @Deprecated
    public Payment createPayment(ComboPaymentTransaction comboPaymentTransaction, Map<String, String> pluginProperties, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createPayment(comboPaymentTransaction, pluginProperties, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Payment createPayment(ComboPaymentTransaction comboPaymentTransaction, Map<String, String> pluginProperties, RequestOptions inputOptions) throws KillBillClientException {
        return this.createPayment(comboPaymentTransaction, null, pluginProperties, inputOptions);
    }

    @Deprecated
    public Payment createPayment(ComboPaymentTransaction comboPaymentTransaction, @Nullable List<String> controlPluginNames, Map<String, String> pluginProperties, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createPayment(comboPaymentTransaction, controlPluginNames, pluginProperties, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Payment createPayment(ComboPaymentTransaction comboPaymentTransaction, @Nullable List<String> controlPluginNames, Map<String, String> pluginProperties, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/payments/combo";
        LinkedListMultimap queryParams = LinkedListMultimap.create(inputOptions.getQueryParams());
        if (controlPluginNames != null) {
            queryParams.putAll((Object)"controlPluginName", controlPluginNames);
        }
        this.storePluginPropertiesAsParams(pluginProperties, (Multimap<String, String>)queryParams);
        Boolean followLocation = (Boolean)MoreObjects.firstNonNull((Object)inputOptions.getFollowLocation(), (Object)Boolean.TRUE);
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).withFollowLocation(followLocation).build();
        return this.httpClient.doPost("/1.0/kb/payments/combo", (Object)comboPaymentTransaction, Payment.class, requestOptions);
    }

    @Deprecated
    public Payment createPayment(UUID accountId, PaymentTransaction paymentTransaction, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createPayment(accountId, paymentTransaction, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Payment createPayment(UUID accountId, PaymentTransaction paymentTransaction, RequestOptions inputOptions) throws KillBillClientException {
        return this.createPayment(accountId, null, paymentTransaction, null, (Map<String, String>)ImmutableMap.of(), inputOptions);
    }

    @Deprecated
    public Payment createPayment(UUID accountId, PaymentTransaction paymentTransaction, Map<String, String> pluginProperties, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createPayment(accountId, paymentTransaction, pluginProperties, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Payment createPayment(UUID accountId, PaymentTransaction paymentTransaction, Map<String, String> pluginProperties, RequestOptions inputOptions) throws KillBillClientException {
        return this.createPayment(accountId, null, paymentTransaction, null, pluginProperties, inputOptions);
    }

    @Deprecated
    public Payment createPayment(UUID accountId, @Nullable UUID paymentMethodId, PaymentTransaction paymentTransaction, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createPayment(accountId, paymentMethodId, paymentTransaction, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Payment createPayment(UUID accountId, @Nullable UUID paymentMethodId, PaymentTransaction paymentTransaction, RequestOptions inputOptions) throws KillBillClientException {
        return this.createPayment(accountId, paymentMethodId, paymentTransaction, null, (Map<String, String>)ImmutableMap.of(), inputOptions);
    }

    @Deprecated
    public Payment createPayment(UUID accountId, @Nullable UUID paymentMethodId, PaymentTransaction paymentTransaction, Map<String, String> pluginProperties, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createPayment(accountId, paymentMethodId, paymentTransaction, pluginProperties, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Payment createPayment(UUID accountId, @Nullable UUID paymentMethodId, PaymentTransaction paymentTransaction, Map<String, String> pluginProperties, RequestOptions inputOptions) throws KillBillClientException {
        return this.createPayment(accountId, paymentMethodId, paymentTransaction, null, pluginProperties, inputOptions);
    }

    public Payment createPayment(UUID accountId, @Nullable UUID paymentMethodId, PaymentTransaction paymentTransaction, @Nullable List<String> controlPluginNames, Map<String, String> pluginProperties, RequestOptions inputOptions) throws KillBillClientException {
        Preconditions.checkNotNull((Object)accountId, (Object)"accountId cannot be null");
        Preconditions.checkNotNull((Object)paymentTransaction.getTransactionType(), (Object)"PaymentTransaction#transactionType cannot be null");
        Preconditions.checkArgument(("AUTHORIZE".equals(paymentTransaction.getTransactionType()) || "CREDIT".equals(paymentTransaction.getTransactionType()) || "PURCHASE".equals(paymentTransaction.getTransactionType()) ? 1 : 0) != 0, (Object)("Invalid paymentTransaction type " + paymentTransaction.getTransactionType()));
        Preconditions.checkNotNull((Object)paymentTransaction.getAmount(), (Object)"PaymentTransaction#amount cannot be null");
        Preconditions.checkNotNull((Object)paymentTransaction.getCurrency(), (Object)"PaymentTransaction#currency cannot be null");
        String uri = "/1.0/kb/accounts/" + accountId + "/" + "payments";
        LinkedListMultimap params = LinkedListMultimap.create(inputOptions.getQueryParams());
        if (paymentMethodId != null) {
            params.put((Object)"paymentMethodId", (Object)paymentMethodId.toString());
        }
        if (controlPluginNames != null) {
            params.putAll((Object)"controlPluginName", controlPluginNames);
        }
        this.storePluginPropertiesAsParams(pluginProperties, (Multimap<String, String>)params);
        Boolean followLocation = (Boolean)MoreObjects.firstNonNull((Object)inputOptions.getFollowLocation(), (Object)Boolean.TRUE);
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)params).withFollowLocation(followLocation).build();
        return this.httpClient.doPost(uri, (Object)paymentTransaction, Payment.class, requestOptions);
    }

    @Deprecated
    public Payment completePayment(PaymentTransaction paymentTransaction, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.completePayment(paymentTransaction, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Payment completePayment(PaymentTransaction paymentTransaction, RequestOptions requestOptions) throws KillBillClientException {
        return this.completePayment(paymentTransaction, (Map<String, String>)ImmutableMap.of(), requestOptions);
    }

    @Deprecated
    public Payment completePayment(PaymentTransaction paymentTransaction, Map<String, String> pluginProperties, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.completePayment(paymentTransaction, pluginProperties, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Payment completePayment(PaymentTransaction paymentTransaction, Map<String, String> pluginProperties, RequestOptions inputOptions) throws KillBillClientException {
        return this.completePayment(paymentTransaction, null, pluginProperties, inputOptions);
    }

    public Payment completePayment(PaymentTransaction paymentTransaction, @Nullable List<String> controlPluginNames, Map<String, String> pluginProperties, RequestOptions inputOptions) throws KillBillClientException {
        Preconditions.checkState((paymentTransaction.getPaymentId() != null || paymentTransaction.getPaymentExternalKey() != null ? 1 : 0) != 0, (Object)"PaymentTransaction#paymentId or PaymentTransaction#paymentExternalKey cannot be null");
        String uri = paymentTransaction.getPaymentId() != null ? "/1.0/kb/payments/" + paymentTransaction.getPaymentId() : "/1.0/kb/payments";
        HashMultimap params = HashMultimap.create(inputOptions.getQueryParams());
        if (controlPluginNames != null) {
            params.putAll((Object)"controlPluginName", controlPluginNames);
        }
        this.storePluginPropertiesAsParams(pluginProperties, (Multimap<String, String>)params);
        Boolean followLocation = (Boolean)MoreObjects.firstNonNull((Object)inputOptions.getFollowLocation(), (Object)Boolean.TRUE);
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)params).withFollowLocation(followLocation).build();
        return this.httpClient.doPut(uri, (Object)paymentTransaction, Payment.class, requestOptions);
    }

    @Deprecated
    public Payment captureAuthorization(PaymentTransaction paymentTransaction, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.captureAuthorization(paymentTransaction, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Payment captureAuthorization(PaymentTransaction paymentTransaction, RequestOptions inputOptions) throws KillBillClientException {
        return this.captureAuthorization(paymentTransaction, null, (Map<String, String>)ImmutableMap.of(), inputOptions);
    }

    @Deprecated
    public Payment captureAuthorization(PaymentTransaction paymentTransaction, @Nullable List<String> controlPluginNames, Map<String, String> pluginProperties, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.captureAuthorization(paymentTransaction, controlPluginNames, pluginProperties, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Payment captureAuthorization(PaymentTransaction paymentTransaction, @Nullable List<String> controlPluginNames, Map<String, String> pluginProperties, RequestOptions inputOptions) throws KillBillClientException {
        Preconditions.checkState((paymentTransaction.getPaymentId() != null || paymentTransaction.getPaymentExternalKey() != null ? 1 : 0) != 0, (Object)"PaymentTransaction#paymentId or PaymentTransaction#paymentExternalKey cannot be null");
        Preconditions.checkNotNull((Object)paymentTransaction.getAmount(), (Object)"PaymentTransaction#amount cannot be null");
        String uri = paymentTransaction.getPaymentId() != null ? "/1.0/kb/payments/" + paymentTransaction.getPaymentId() : "/1.0/kb/payments";
        LinkedListMultimap params = LinkedListMultimap.create(inputOptions.getQueryParams());
        this.storePluginPropertiesAsParams(pluginProperties, (Multimap<String, String>)params);
        if (controlPluginNames != null) {
            params.putAll((Object)"controlPluginName", controlPluginNames);
        }
        Boolean followLocation = (Boolean)MoreObjects.firstNonNull((Object)inputOptions.getFollowLocation(), (Object)Boolean.TRUE);
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)params).withFollowLocation(followLocation).build();
        return this.httpClient.doPost(uri, (Object)paymentTransaction, Payment.class, requestOptions);
    }

    @Deprecated
    public Payment refundPayment(PaymentTransaction paymentTransaction, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.refundPayment(paymentTransaction, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Payment refundPayment(PaymentTransaction paymentTransaction, RequestOptions inputOptions) throws KillBillClientException {
        return this.refundPayment(paymentTransaction, null, (Map<String, String>)ImmutableMap.of(), inputOptions);
    }

    @Deprecated
    public Payment refundPayment(PaymentTransaction paymentTransaction, @Nullable List<String> controlPluginNames, Map<String, String> pluginProperties, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.refundPayment(paymentTransaction, controlPluginNames, pluginProperties, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Payment refundPayment(PaymentTransaction paymentTransaction, @Nullable List<String> controlPluginNames, Map<String, String> pluginProperties, RequestOptions inputOptions) throws KillBillClientException {
        Preconditions.checkState((paymentTransaction.getPaymentId() != null || paymentTransaction.getPaymentExternalKey() != null ? 1 : 0) != 0, (Object)"PaymentTransaction#paymentId or PaymentTransaction#paymentExternalKey cannot be null");
        Preconditions.checkNotNull((Object)paymentTransaction.getAmount(), (Object)"PaymentTransaction#amount cannot be null");
        String uri = paymentTransaction.getPaymentId() != null ? "/1.0/kb/payments/" + paymentTransaction.getPaymentId() + "/" + "refunds" : "/1.0/kb/payments/refunds";
        LinkedListMultimap params = LinkedListMultimap.create(inputOptions.getQueryParams());
        this.storePluginPropertiesAsParams(pluginProperties, (Multimap<String, String>)params);
        if (controlPluginNames != null) {
            params.putAll((Object)"controlPluginName", controlPluginNames);
        }
        Boolean followLocation = (Boolean)MoreObjects.firstNonNull((Object)inputOptions.getFollowLocation(), (Object)Boolean.TRUE);
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)params).withFollowLocation(followLocation).build();
        return this.httpClient.doPost(uri, (Object)paymentTransaction, Payment.class, requestOptions);
    }

    @Deprecated
    public Payment chargebackPayment(PaymentTransaction paymentTransaction, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.chargebackPayment(paymentTransaction, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Payment chargebackPayment(PaymentTransaction paymentTransaction, RequestOptions requestOptions) throws KillBillClientException {
        return this.chargebackPayment(paymentTransaction, null, (Map<String, String>)ImmutableMap.of(), requestOptions);
    }

    @Deprecated
    public Payment chargebackPayment(PaymentTransaction paymentTransaction, @Nullable List<String> controlPluginNames, Map<String, String> pluginProperties, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.chargebackPayment(paymentTransaction, controlPluginNames, pluginProperties, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Payment chargebackPayment(PaymentTransaction paymentTransaction, @Nullable List<String> controlPluginNames, Map<String, String> pluginProperties, RequestOptions inputOptions) throws KillBillClientException {
        Preconditions.checkState((paymentTransaction.getPaymentId() != null || paymentTransaction.getPaymentExternalKey() != null ? 1 : 0) != 0, (Object)"PaymentTransaction#paymentId or PaymentTransaction#paymentExternalKey cannot be null");
        Preconditions.checkNotNull((Object)paymentTransaction.getAmount(), (Object)"PaymentTransaction#amount cannot be null");
        String uri = paymentTransaction.getPaymentId() != null ? "/1.0/kb/payments/" + paymentTransaction.getPaymentId() + "/" + "chargebacks" : "/1.0/kb/payments/chargebacks";
        LinkedListMultimap params = LinkedListMultimap.create(inputOptions.getQueryParams());
        this.storePluginPropertiesAsParams(pluginProperties, (Multimap<String, String>)params);
        if (controlPluginNames != null) {
            params.putAll((Object)"controlPluginName", controlPluginNames);
        }
        Boolean followLocation = (Boolean)MoreObjects.firstNonNull((Object)inputOptions.getFollowLocation(), (Object)Boolean.TRUE);
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)params).withFollowLocation(followLocation).build();
        return this.httpClient.doPost(uri, (Object)paymentTransaction, Payment.class, requestOptions);
    }

    @Deprecated
    public Payment voidPayment(UUID paymentId, String transactionExternalKey, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.voidPayment(paymentId, transactionExternalKey, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Payment voidPayment(UUID paymentId, String transactionExternalKey, RequestOptions inputOptions) throws KillBillClientException {
        return this.voidPayment(paymentId, null, transactionExternalKey, null, (Map<String, String>)ImmutableMap.of(), inputOptions);
    }

    @Deprecated
    public Payment voidPayment(UUID paymentId, String paymentExternalKey, String transactionExternalKey, @Nullable List<String> controlPluginNames, Map<String, String> pluginProperties, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.voidPayment(paymentId, paymentExternalKey, transactionExternalKey, controlPluginNames, pluginProperties, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Payment voidPayment(UUID paymentId, String paymentExternalKey, String transactionExternalKey, @Nullable List<String> controlPluginNames, Map<String, String> pluginProperties, RequestOptions inputOptions) throws KillBillClientException {
        Preconditions.checkState((paymentId != null || paymentExternalKey != null ? 1 : 0) != 0, (Object)"PaymentTransaction#paymentId or PaymentTransaction#paymentExternalKey cannot be null");
        String uri = paymentId != null ? "/1.0/kb/payments/" + paymentId : "/1.0/kb/payments";
        PaymentTransaction paymentTransaction = new PaymentTransaction();
        if (paymentExternalKey != null) {
            paymentTransaction.setPaymentExternalKey(paymentExternalKey);
        }
        paymentTransaction.setTransactionExternalKey(transactionExternalKey);
        LinkedListMultimap params = LinkedListMultimap.create(inputOptions.getQueryParams());
        this.storePluginPropertiesAsParams(pluginProperties, (Multimap<String, String>)params);
        if (controlPluginNames != null) {
            params.putAll((Object)"controlPluginName", controlPluginNames);
        }
        Boolean followLocation = (Boolean)MoreObjects.firstNonNull((Object)inputOptions.getFollowLocation(), (Object)Boolean.TRUE);
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)params).withFollowLocation(followLocation).build();
        return this.httpClient.doDelete(uri, paymentTransaction, Payment.class, requestOptions);
    }

    public void cancelScheduledPaymentTransaction(UUID paymentTransactionId, String paymentTransactionExternalKey, RequestOptions inputOptions) throws KillBillClientException {
        Preconditions.checkState((paymentTransactionId != null || paymentTransactionExternalKey != null ? 1 : 0) != 0, (Object)"PaymentTransaction#paymentTransactionId or PaymentTransaction#paymentTransactionExternalKey cannot be null");
        String uri = paymentTransactionId != null ? "/1.0/kb/payments/" + paymentTransactionId + "/" + "cancelScheduledPaymentTransaction" : "/1.0/kb/payments/cancelScheduledPaymentTransaction";
        LinkedListMultimap params = LinkedListMultimap.create(inputOptions.getQueryParams());
        if (paymentTransactionExternalKey != null) {
            params.put((Object)"transactionExternalKey", (Object)paymentTransactionExternalKey);
        }
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)params).build();
        this.httpClient.doDelete(uri, requestOptions);
    }

    @Deprecated
    public HostedPaymentPageFormDescriptor buildFormDescriptor(HostedPaymentPageFields fields, UUID kbAccountId, @Nullable UUID kbPaymentMethodId, Map<String, String> pluginProperties, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.buildFormDescriptor(fields, kbAccountId, kbPaymentMethodId, pluginProperties, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public HostedPaymentPageFormDescriptor buildFormDescriptor(HostedPaymentPageFields fields, UUID kbAccountId, @Nullable UUID kbPaymentMethodId, Map<String, String> pluginProperties, RequestOptions inputOptions) throws KillBillClientException {
        return this.buildFormDescriptor(fields, kbAccountId, kbPaymentMethodId, null, pluginProperties, inputOptions);
    }

    public HostedPaymentPageFormDescriptor buildFormDescriptor(HostedPaymentPageFields fields, UUID kbAccountId, @Nullable UUID kbPaymentMethodId, @Nullable List<String> controlPluginNames, Map<String, String> pluginProperties, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/paymentGateways/hosted/form/" + kbAccountId;
        LinkedListMultimap params = LinkedListMultimap.create(inputOptions.getQueryParams());
        this.storePluginPropertiesAsParams(pluginProperties, (Multimap<String, String>)params);
        if (controlPluginNames != null) {
            params.putAll((Object)"controlPluginName", controlPluginNames);
        }
        if (kbPaymentMethodId != null) {
            params.put((Object)"paymentMethodId", (Object)kbPaymentMethodId.toString());
        }
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)params).withFollowLocation(false).build();
        return this.httpClient.doPost(uri, (Object)fields, HostedPaymentPageFormDescriptor.class, requestOptions);
    }

    @Deprecated
    public HostedPaymentPageFormDescriptor buildFormDescriptor(ComboHostedPaymentPage comboHostedPaymentPage, Map<String, String> pluginProperties, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.buildFormDescriptor(comboHostedPaymentPage, pluginProperties, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public HostedPaymentPageFormDescriptor buildFormDescriptor(ComboHostedPaymentPage comboHostedPaymentPage, Map<String, String> pluginProperties, RequestOptions inputOptions) throws KillBillClientException {
        return this.buildFormDescriptor(comboHostedPaymentPage, null, pluginProperties, inputOptions);
    }

    @Deprecated
    public HostedPaymentPageFormDescriptor buildFormDescriptor(ComboHostedPaymentPage comboHostedPaymentPage, @Nullable List<String> controlPluginNames, Map<String, String> pluginProperties, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.buildFormDescriptor(comboHostedPaymentPage, controlPluginNames, pluginProperties, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public HostedPaymentPageFormDescriptor buildFormDescriptor(ComboHostedPaymentPage comboHostedPaymentPage, @Nullable List<String> controlPluginNames, Map<String, String> pluginProperties, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/paymentGateways/hosted/form";
        LinkedListMultimap params = LinkedListMultimap.create(inputOptions.getQueryParams());
        if (controlPluginNames != null) {
            params.putAll((Object)"controlPluginName", controlPluginNames);
        }
        this.storePluginPropertiesAsParams(pluginProperties, (Multimap<String, String>)params);
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)params).withFollowLocation(false).build();
        return this.httpClient.doPost("/1.0/kb/paymentGateways/hosted/form", (Object)comboHostedPaymentPage, HostedPaymentPageFormDescriptor.class, requestOptions);
    }

    @Deprecated
    public Response processNotification(String notification, String pluginName, Map<String, String> pluginProperties, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.processNotification(notification, pluginName, pluginProperties, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Response processNotification(String notification, String pluginName, Map<String, String> pluginProperties, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/paymentGateways/notification/" + pluginName;
        HashMultimap params = HashMultimap.create(inputOptions.getQueryParams());
        this.storePluginPropertiesAsParams(pluginProperties, (Multimap<String, String>)params);
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)params).build();
        return this.httpClient.doPost(uri, (Object)notification, requestOptions);
    }

    @Deprecated
    public InvoicePayment createInvoicePaymentRefund(InvoicePaymentTransaction refundTransaction, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createInvoicePaymentRefund(refundTransaction, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public InvoicePayment createInvoicePaymentRefund(InvoicePaymentTransaction refundTransaction, RequestOptions inputOptions) throws KillBillClientException {
        return this.createInvoicePaymentRefund(refundTransaction, false, null, inputOptions);
    }

    public InvoicePayment createInvoicePaymentRefund(InvoicePaymentTransaction refundTransaction, boolean externalPayment, UUID paymentMethodId, RequestOptions inputOptions) throws KillBillClientException {
        Preconditions.checkNotNull((Object)refundTransaction.getPaymentId(), (Object)"InvoicePaymentTransaction#paymentId cannot be null");
        if (refundTransaction.getAdjustments() != null) {
            for (InvoiceItem invoiceItem : refundTransaction.getAdjustments()) {
                Preconditions.checkNotNull((Object)invoiceItem.getInvoiceItemId(), (Object)"InvoiceItem#invoiceItemId cannot be null");
            }
        }
        LinkedListMultimap params = LinkedListMultimap.create(inputOptions.getQueryParams());
        params.put((Object)"externalPayment", (Object)String.valueOf(externalPayment));
        if (paymentMethodId != null) {
            params.put((Object)"paymentMethodId", (Object)paymentMethodId.toString());
        }
        String uri = "/1.0/kb/invoicePayments/" + refundTransaction.getPaymentId() + "/" + "refunds";
        Boolean followLocation = (Boolean)MoreObjects.firstNonNull((Object)inputOptions.getFollowLocation(), (Object)Boolean.TRUE);
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)params).withFollowLocation(followLocation).build();
        return this.httpClient.doPost(uri, (Object)refundTransaction, InvoicePayment.class, requestOptions);
    }

    @Deprecated
    public InvoicePayment createInvoicePaymentChargeback(InvoicePaymentTransaction chargebackTransaction, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createInvoicePaymentChargeback(chargebackTransaction, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public InvoicePayment createInvoicePaymentChargeback(InvoicePaymentTransaction chargebackTransaction, RequestOptions inputOptions) throws KillBillClientException {
        Preconditions.checkNotNull((Object)chargebackTransaction.getPaymentId(), (Object)"InvoicePaymentTransaction#paymentId cannot be null");
        String uri = "/1.0/kb/invoicePayments/" + chargebackTransaction.getPaymentId() + "/" + "chargebacks";
        Boolean followLocation = (Boolean)MoreObjects.firstNonNull((Object)inputOptions.getFollowLocation(), (Object)Boolean.TRUE);
        RequestOptions requestOptions = inputOptions.extend().withFollowLocation(followLocation).build();
        return this.httpClient.doPost(uri, (Object)chargebackTransaction, InvoicePayment.class, requestOptions);
    }

    @Deprecated
    public PaymentMethods getPaymentMethods() throws KillBillClientException {
        return this.getPaymentMethods(RequestOptions.empty());
    }

    public PaymentMethods getPaymentMethods(RequestOptions inputOptions) throws KillBillClientException {
        return this.getPaymentMethods((Long)0L, (Long)100L, inputOptions);
    }

    @Deprecated
    public PaymentMethods getPaymentMethods(Long offset, Long limit) throws KillBillClientException {
        return this.getPaymentMethods(offset, limit, RequestOptions.empty());
    }

    public PaymentMethods getPaymentMethods(Long offset, Long limit, RequestOptions inputOptions) throws KillBillClientException {
        return this.getPaymentMethods(offset, limit, AuditLevel.NONE, inputOptions);
    }

    @Deprecated
    public PaymentMethods getPaymentMethods(Long offset, Long limit, AuditLevel auditLevel) throws KillBillClientException {
        return this.getPaymentMethods(offset, limit, auditLevel, RequestOptions.empty());
    }

    public PaymentMethods getPaymentMethods(Long offset, Long limit, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/paymentMethods/pagination";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"offset", (Object)String.valueOf(offset));
        queryParams.put((Object)"limit", (Object)String.valueOf(limit));
        queryParams.put((Object)"audit", (Object)auditLevel.toString());
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet("/1.0/kb/paymentMethods/pagination", PaymentMethods.class, requestOptions);
    }

    @Deprecated
    public PaymentMethods searchPaymentMethods(String key) throws KillBillClientException {
        return this.searchPaymentMethods(key, RequestOptions.empty());
    }

    public PaymentMethods searchPaymentMethods(String key, RequestOptions inputOptions) throws KillBillClientException {
        return this.searchPaymentMethods(key, (Long)0L, (Long)100L, inputOptions);
    }

    @Deprecated
    public PaymentMethods searchPaymentMethods(String key, Long offset, Long limit) throws KillBillClientException {
        return this.searchPaymentMethods(key, offset, limit, RequestOptions.empty());
    }

    public PaymentMethods searchPaymentMethods(String key, Long offset, Long limit, RequestOptions inputOptions) throws KillBillClientException {
        return this.searchPaymentMethods(key, offset, limit, AuditLevel.NONE, inputOptions);
    }

    @Deprecated
    public PaymentMethods searchPaymentMethods(String key, Long offset, Long limit, AuditLevel auditLevel) throws KillBillClientException {
        return this.searchPaymentMethods(key, offset, limit, auditLevel, RequestOptions.empty());
    }

    public PaymentMethods searchPaymentMethods(String key, Long offset, Long limit, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/paymentMethods/search/" + UTF8UrlEncoder.encodePath((String)key);
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"offset", (Object)String.valueOf(offset));
        queryParams.put((Object)"limit", (Object)String.valueOf(limit));
        queryParams.put((Object)"audit", (Object)auditLevel.toString());
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet(uri, PaymentMethods.class, requestOptions);
    }

    @Deprecated
    public PaymentMethod getPaymentMethod(UUID paymentMethodId) throws KillBillClientException {
        return this.getPaymentMethod(paymentMethodId, RequestOptions.empty());
    }

    public PaymentMethod getPaymentMethod(UUID paymentMethodId, RequestOptions inputOptions) throws KillBillClientException {
        return this.getPaymentMethod(paymentMethodId, false, inputOptions);
    }

    @Deprecated
    public PaymentMethod getPaymentMethod(UUID paymentMethodId, boolean withPluginInfo) throws KillBillClientException {
        return this.getPaymentMethod(paymentMethodId, withPluginInfo, RequestOptions.empty());
    }

    public PaymentMethod getPaymentMethod(UUID paymentMethodId, boolean withPluginInfo, RequestOptions inputOptions) throws KillBillClientException {
        return this.getPaymentMethod(paymentMethodId, withPluginInfo, AuditLevel.NONE, inputOptions);
    }

    @Deprecated
    public PaymentMethod getPaymentMethod(UUID paymentMethodId, boolean withPluginInfo, AuditLevel auditLevel) throws KillBillClientException {
        return this.getPaymentMethod(paymentMethodId, withPluginInfo, auditLevel, RequestOptions.empty());
    }

    public PaymentMethod getPaymentMethod(UUID paymentMethodId, boolean withPluginInfo, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/paymentMethods/" + paymentMethodId;
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"withPluginInfo", (Object)String.valueOf(withPluginInfo));
        queryParams.put((Object)"audit", (Object)auditLevel.toString());
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet(uri, PaymentMethod.class, requestOptions);
    }

    @Deprecated
    public PaymentMethod getPaymentMethodByKey(String externalKey) throws KillBillClientException {
        return this.getPaymentMethodByKey(externalKey, RequestOptions.empty());
    }

    public PaymentMethod getPaymentMethodByKey(String externalKey, RequestOptions inputOptions) throws KillBillClientException {
        return this.getPaymentMethodByKey(externalKey, false, inputOptions);
    }

    @Deprecated
    public PaymentMethod getPaymentMethodByKey(String externalKey, boolean withPluginInfo) throws KillBillClientException {
        return this.getPaymentMethodByKey(externalKey, withPluginInfo, RequestOptions.empty());
    }

    public PaymentMethod getPaymentMethodByKey(String externalKey, boolean withPluginInfo, RequestOptions inputOptions) throws KillBillClientException {
        return this.getPaymentMethodByKey(externalKey, withPluginInfo, AuditLevel.NONE, inputOptions);
    }

    @Deprecated
    public PaymentMethod getPaymentMethodByKey(String externalKey, boolean withPluginInfo, AuditLevel auditLevel) throws KillBillClientException {
        return this.getPaymentMethodByKey(externalKey, withPluginInfo, auditLevel, RequestOptions.empty());
    }

    public PaymentMethod getPaymentMethodByKey(String externalKey, boolean withPluginInfo, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/paymentMethods";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"externalKey", (Object)externalKey);
        queryParams.put((Object)"withPluginInfo", (Object)String.valueOf(withPluginInfo));
        queryParams.put((Object)"audit", (Object)auditLevel.toString());
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet("/1.0/kb/paymentMethods", PaymentMethod.class, requestOptions);
    }

    @Deprecated
    public PaymentMethods getPaymentMethodsForAccount(UUID accountId) throws KillBillClientException {
        return this.getPaymentMethodsForAccount(accountId, RequestOptions.empty());
    }

    public PaymentMethods getPaymentMethodsForAccount(UUID accountId, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/" + accountId + "/" + "paymentMethods";
        return this.httpClient.doGet(uri, PaymentMethods.class, inputOptions);
    }

    @Deprecated
    public PaymentMethods getPaymentMethodsForAccount(UUID accountId, Map<String, String> pluginProperties, boolean withPluginInfo, AuditLevel auditLevel) throws KillBillClientException {
        return this.getPaymentMethodsForAccount(accountId, pluginProperties, withPluginInfo, auditLevel, RequestOptions.empty());
    }

    public PaymentMethods getPaymentMethodsForAccount(UUID accountId, Map<String, String> pluginProperties, boolean withPluginInfo, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/" + accountId + "/" + "paymentMethods";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"withPluginInfo", (Object)String.valueOf(withPluginInfo));
        queryParams.put((Object)"audit", (Object)auditLevel.toString());
        this.storePluginPropertiesAsParams(pluginProperties, (Multimap<String, String>)queryParams);
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet(uri, PaymentMethods.class, requestOptions);
    }

    @Deprecated
    public PaymentMethods searchPaymentMethodsByKey(String key) throws KillBillClientException {
        return this.searchPaymentMethodsByKey(key, RequestOptions.empty());
    }

    public PaymentMethods searchPaymentMethodsByKey(String key, RequestOptions inputOptions) throws KillBillClientException {
        return this.searchPaymentMethodsByKeyAndPlugin(key, null, inputOptions);
    }

    @Deprecated
    public PaymentMethods searchPaymentMethodsByKey(String key, boolean withPluginInfo) throws KillBillClientException {
        return this.searchPaymentMethodsByKey(key, withPluginInfo, RequestOptions.empty());
    }

    public PaymentMethods searchPaymentMethodsByKey(String key, boolean withPluginInfo, RequestOptions inputOptions) throws KillBillClientException {
        return this.searchPaymentMethodsByKeyAndPlugin(key, withPluginInfo, null, AuditLevel.NONE, inputOptions);
    }

    @Deprecated
    public PaymentMethods searchPaymentMethodsByKeyAndPlugin(String key, @Nullable String pluginName) throws KillBillClientException {
        return this.searchPaymentMethodsByKeyAndPlugin(key, pluginName, AuditLevel.NONE, RequestOptions.empty());
    }

    public PaymentMethods searchPaymentMethodsByKeyAndPlugin(String key, @Nullable String pluginName, RequestOptions inputOptions) throws KillBillClientException {
        return this.searchPaymentMethodsByKeyAndPlugin(key, pluginName, AuditLevel.NONE, inputOptions);
    }

    @Deprecated
    public PaymentMethods searchPaymentMethodsByKeyAndPlugin(String key, @Nullable String pluginName, AuditLevel auditLevel) throws KillBillClientException {
        return this.searchPaymentMethodsByKeyAndPlugin(key, pluginName, auditLevel, RequestOptions.empty());
    }

    public PaymentMethods searchPaymentMethodsByKeyAndPlugin(String key, @Nullable String pluginName, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        return this.searchPaymentMethodsByKeyAndPlugin(key, pluginName != null, pluginName, auditLevel, inputOptions);
    }

    @Deprecated
    public PaymentMethods searchPaymentMethodsByKeyAndPlugin(String key, boolean withPluginInfo, @Nullable String pluginName, AuditLevel auditLevel) throws KillBillClientException {
        return this.searchPaymentMethodsByKeyAndPlugin(key, withPluginInfo, pluginName, auditLevel, RequestOptions.empty());
    }

    public PaymentMethods searchPaymentMethodsByKeyAndPlugin(String key, boolean withPluginInfo, @Nullable String pluginName, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/paymentMethods/search/" + UTF8UrlEncoder.encodePath((String)key);
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"pluginName", (Object)Strings.nullToEmpty((String)pluginName));
        queryParams.put((Object)"withPluginInfo", (Object)String.valueOf(withPluginInfo));
        queryParams.put((Object)"audit", (Object)auditLevel.toString());
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet(uri, PaymentMethods.class, requestOptions);
    }

    @Deprecated
    public PaymentMethod createPaymentMethod(PaymentMethod paymentMethod, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createPaymentMethod(paymentMethod, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public PaymentMethod createPaymentMethod(PaymentMethod paymentMethod, RequestOptions inputOptions) throws KillBillClientException {
        Preconditions.checkNotNull((Object)paymentMethod.getAccountId(), (Object)"PaymentMethod#accountId cannot be null");
        Preconditions.checkNotNull((Object)paymentMethod.getPluginName(), (Object)"PaymentMethod#pluginName cannot be null");
        String uri = "/1.0/kb/accounts/" + paymentMethod.getAccountId() + "/" + "paymentMethods";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"isDefault", (Object)(Boolean.TRUE.equals(paymentMethod.getIsDefault()) ? "true" : "false"));
        Boolean followLocation = (Boolean)MoreObjects.firstNonNull((Object)inputOptions.getFollowLocation(), (Object)Boolean.TRUE);
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).withFollowLocation(followLocation).build();
        return this.httpClient.doPost(uri, (Object)paymentMethod, PaymentMethod.class, requestOptions);
    }

    @Deprecated
    public void updateDefaultPaymentMethod(UUID accountId, UUID paymentMethodId, String createdBy, String reason, String comment) throws KillBillClientException {
        this.updateDefaultPaymentMethod(accountId, paymentMethodId, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void updateDefaultPaymentMethod(UUID accountId, UUID paymentMethodId, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/" + accountId + "/" + "paymentMethods" + "/" + paymentMethodId + "/" + "setDefault";
        this.httpClient.doPut(uri, null, inputOptions);
    }

    @Deprecated
    public void deletePaymentMethod(UUID paymentMethodId, Boolean deleteDefault, Boolean forceDeleteDefault, String createdBy, String reason, String comment) throws KillBillClientException {
        this.deletePaymentMethod(paymentMethodId, deleteDefault, forceDeleteDefault, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void deletePaymentMethod(UUID paymentMethodId, Boolean deleteDefault, Boolean forceDeleteDefault, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/paymentMethods/" + paymentMethodId;
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"deleteDefaultPmWithAutoPayOff", (Object)deleteDefault.toString());
        queryParams.put((Object)"forceDefaultPmDeletion", (Object)forceDeleteDefault.toString());
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        this.httpClient.doDelete(uri, requestOptions);
    }

    @Deprecated
    public void refreshPaymentMethods(UUID accountId, String pluginName, Map<String, String> pluginProperties, String createdBy, String reason, String comment) throws KillBillClientException {
        this.refreshPaymentMethods(accountId, pluginName, pluginProperties, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void refreshPaymentMethods(UUID accountId, String pluginName, Map<String, String> pluginProperties, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/" + accountId + "/" + "paymentMethods" + "/refresh";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        if (pluginName != null) {
            queryParams.put((Object)"pluginName", (Object)pluginName);
        }
        this.storePluginPropertiesAsParams(pluginProperties, (Multimap<String, String>)queryParams);
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        this.httpClient.doPost(uri, null, requestOptions);
    }

    @Deprecated
    public void refreshPaymentMethods(UUID accountId, Map<String, String> pluginProperties, String createdBy, String reason, String comment) throws KillBillClientException {
        this.refreshPaymentMethods(accountId, pluginProperties, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void refreshPaymentMethods(UUID accountId, Map<String, String> pluginProperties, RequestOptions inputOptions) throws KillBillClientException {
        this.refreshPaymentMethods(accountId, null, pluginProperties, inputOptions);
    }

    @Deprecated
    public void uploadXMLOverdueConfig(String overdueConfigFilePath, String createdBy, String reason, String comment) throws KillBillClientException {
        this.uploadXMLOverdueConfig(overdueConfigFilePath, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void uploadXMLOverdueConfig(String overdueConfigFilePath, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/overdue";
        this.uploadFile(overdueConfigFilePath, "/1.0/kb/overdue", "application/xml", inputOptions, null);
    }

    @Deprecated
    public void uploadXMLOverdueConfig(InputStream overdueConfigInputStream, String createdBy, String reason, String comment) throws KillBillClientException {
        this.uploadXMLOverdueConfig(overdueConfigInputStream, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void uploadXMLOverdueConfig(InputStream overdueConfigInputStream, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/overdue";
        this.uploadFile(overdueConfigInputStream, "/1.0/kb/overdue", "application/xml", inputOptions, null);
    }

    @Deprecated
    public String getXMLOverdueConfig() throws KillBillClientException {
        return this.getXMLOverdueConfig(RequestOptions.empty());
    }

    public String getXMLOverdueConfig(RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/overdue";
        return this.getResourceFile("/1.0/kb/overdue", "application/xml", inputOptions);
    }

    @Deprecated
    public OverdueState getOverdueStateForAccount(UUID accountId) throws KillBillClientException {
        return this.getOverdueStateForAccount(accountId, RequestOptions.empty());
    }

    public OverdueState getOverdueStateForAccount(UUID accountId, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/" + accountId + "/" + "overdue";
        return this.httpClient.doGet(uri, OverdueState.class, inputOptions);
    }

    @Deprecated
    public TagDefinitions getTagDefinitions() throws KillBillClientException {
        return this.getTagDefinitions(RequestOptions.empty());
    }

    public TagDefinitions getTagDefinitions(RequestOptions inputOptions) throws KillBillClientException {
        return this.httpClient.doGet("/1.0/kb/tagDefinitions", TagDefinitions.class, inputOptions);
    }

    @Deprecated
    public TagDefinition getTagDefinition(UUID tagDefinitionId) throws KillBillClientException {
        return this.getTagDefinition(tagDefinitionId, RequestOptions.empty());
    }

    public TagDefinition getTagDefinition(UUID tagDefinitionId, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/tagDefinitions/" + tagDefinitionId;
        return this.httpClient.doGet(uri, TagDefinition.class, inputOptions);
    }

    @Deprecated
    public TagDefinition createTagDefinition(TagDefinition tagDefinition, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createTagDefinition(tagDefinition, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public TagDefinition createTagDefinition(TagDefinition tagDefinition, RequestOptions inputOptions) throws KillBillClientException {
        Boolean followLocation = (Boolean)MoreObjects.firstNonNull((Object)inputOptions.getFollowLocation(), (Object)Boolean.TRUE);
        RequestOptions requestOptions = inputOptions.extend().withFollowLocation(followLocation).build();
        return this.httpClient.doPost("/1.0/kb/tagDefinitions", (Object)tagDefinition, TagDefinition.class, requestOptions);
    }

    @Deprecated
    public void deleteTagDefinition(UUID tagDefinitionId, String createdBy, String reason, String comment) throws KillBillClientException {
        this.deleteTagDefinition(tagDefinitionId, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void deleteTagDefinition(UUID tagDefinitionId, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/tagDefinitions/" + tagDefinitionId;
        this.httpClient.doDelete(uri, inputOptions);
    }

    @Deprecated
    public Tags getTags() throws KillBillClientException {
        return this.getTags(RequestOptions.empty());
    }

    public Tags getTags(RequestOptions inputOptions) throws KillBillClientException {
        return this.getTags((Long)0L, (Long)100L, inputOptions);
    }

    @Deprecated
    public Tags getTags(Long offset, Long limit) throws KillBillClientException {
        return this.getTags(offset, limit, RequestOptions.empty());
    }

    public Tags getTags(Long offset, Long limit, RequestOptions inputOptions) throws KillBillClientException {
        return this.getTags(offset, limit, AuditLevel.NONE, inputOptions);
    }

    @Deprecated
    public Tags getTags(Long offset, Long limit, AuditLevel auditLevel) throws KillBillClientException {
        return this.getTags(offset, limit, auditLevel, RequestOptions.empty());
    }

    public Tags getTags(Long offset, Long limit, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/tags/pagination";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"offset", (Object)String.valueOf(offset));
        queryParams.put((Object)"limit", (Object)String.valueOf(limit));
        queryParams.put((Object)"audit", (Object)auditLevel.toString());
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet("/1.0/kb/tags/pagination", Tags.class, requestOptions);
    }

    @Deprecated
    public Tags searchTags(String key) throws KillBillClientException {
        return this.searchTags(key, RequestOptions.empty());
    }

    public Tags searchTags(String key, RequestOptions inputOptions) throws KillBillClientException {
        return this.searchTags(key, (Long)0L, (Long)100L, inputOptions);
    }

    @Deprecated
    public Tags searchTags(String key, Long offset, Long limit) throws KillBillClientException {
        return this.searchTags(key, offset, limit, RequestOptions.empty());
    }

    public Tags searchTags(String key, Long offset, Long limit, RequestOptions inputOptions) throws KillBillClientException {
        return this.searchTags(key, offset, limit, AuditLevel.NONE, inputOptions);
    }

    @Deprecated
    public Tags searchTags(String key, Long offset, Long limit, AuditLevel auditLevel) throws KillBillClientException {
        return this.searchTags(key, offset, limit, auditLevel, RequestOptions.empty());
    }

    public Tags searchTags(String key, Long offset, Long limit, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/tags/search/" + UTF8UrlEncoder.encodePath((String)key);
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"offset", (Object)String.valueOf(offset));
        queryParams.put((Object)"limit", (Object)String.valueOf(limit));
        queryParams.put((Object)"audit", (Object)auditLevel.toString());
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet(uri, Tags.class, requestOptions);
    }

    @Deprecated
    public Tags getAllAccountTags(UUID accountId, String objectType) throws KillBillClientException {
        return this.getAllAccountTags(accountId, objectType, RequestOptions.empty());
    }

    public Tags getAllAccountTags(UUID accountId, String objectType, RequestOptions inputOptions) throws KillBillClientException {
        return this.getAllAccountTags(accountId, objectType, AuditLevel.NONE, inputOptions);
    }

    @Deprecated
    public Tags getAllAccountTags(UUID accountId, @Nullable String objectType, AuditLevel auditLevel) throws KillBillClientException {
        return this.getAllAccountTags(accountId, objectType, auditLevel, RequestOptions.empty());
    }

    public Tags getAllAccountTags(UUID accountId, @Nullable String objectType, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/" + accountId + "/" + "allTags";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"audit", (Object)auditLevel.toString());
        if (objectType != null) {
            queryParams.put((Object)"objectType", (Object)objectType);
        }
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet(uri, Tags.class, requestOptions);
    }

    @Deprecated
    public Tags getAccountTags(UUID accountId) throws KillBillClientException {
        return this.getAccountTags(accountId, RequestOptions.empty());
    }

    public Tags getAccountTags(UUID accountId, RequestOptions inputOptions) throws KillBillClientException {
        return this.getAccountTags(accountId, AuditLevel.NONE, inputOptions);
    }

    @Deprecated
    public Tags getAccountTags(UUID accountId, AuditLevel auditLevel) throws KillBillClientException {
        return this.getAccountTags(accountId, auditLevel, RequestOptions.empty());
    }

    public Tags getAccountTags(UUID accountId, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        return this.getObjectTags(accountId, "/1.0/kb/accounts", auditLevel, inputOptions);
    }

    @Deprecated
    public Tags createAccountTag(UUID accountId, UUID tagDefinitionId, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createAccountTag(accountId, tagDefinitionId, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Tags createAccountTag(UUID accountId, UUID tagDefinitionId, RequestOptions inputOptions) throws KillBillClientException {
        return this.createObjectTag(accountId, "/1.0/kb/accounts", tagDefinitionId, inputOptions);
    }

    @Deprecated
    public void deleteAccountTag(UUID accountId, UUID tagDefinitionId, String createdBy, String reason, String comment) throws KillBillClientException {
        this.deleteAccountTag(accountId, tagDefinitionId, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void deleteAccountTag(UUID accountId, UUID tagDefinitionId, RequestOptions inputOptions) throws KillBillClientException {
        this.deleteObjectTag(accountId, "/1.0/kb/accounts", tagDefinitionId, inputOptions);
    }

    @Deprecated
    public Tags getBundleTags(UUID bundleId) throws KillBillClientException {
        return this.getBundleTags(bundleId, RequestOptions.empty());
    }

    public Tags getBundleTags(UUID bundleId, RequestOptions inputOptions) throws KillBillClientException {
        return this.getBundleTags(bundleId, AuditLevel.NONE, inputOptions);
    }

    @Deprecated
    public Tags getBundleTags(UUID bundleId, AuditLevel auditLevel) throws KillBillClientException {
        return this.getBundleTags(bundleId, auditLevel, RequestOptions.empty());
    }

    public Tags getBundleTags(UUID bundleId, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        return this.getObjectTags(bundleId, "/1.0/kb/bundles", auditLevel, inputOptions);
    }

    @Deprecated
    public Tags createBundleTag(UUID bundleId, UUID tagDefinitionId, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createBundleTag(bundleId, tagDefinitionId, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Tags createBundleTag(UUID bundleId, UUID tagDefinitionId, RequestOptions inputOptions) throws KillBillClientException {
        return this.createObjectTag(bundleId, "/1.0/kb/bundles", tagDefinitionId, inputOptions);
    }

    @Deprecated
    public void deleteBundleTag(UUID bundleId, UUID tagDefinitionId, String createdBy, String reason, String comment) throws KillBillClientException {
        this.deleteBundleTag(bundleId, tagDefinitionId, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void deleteBundleTag(UUID bundleId, UUID tagDefinitionId, RequestOptions inputOptions) throws KillBillClientException {
        this.deleteObjectTag(bundleId, "/1.0/kb/bundles", tagDefinitionId, inputOptions);
    }

    @Deprecated
    public Tags getSubscriptionTags(UUID subscriptionId) throws KillBillClientException {
        return this.getSubscriptionTags(subscriptionId, RequestOptions.empty());
    }

    public Tags getSubscriptionTags(UUID subscriptionId, RequestOptions inputOptions) throws KillBillClientException {
        return this.getSubscriptionTags(subscriptionId, AuditLevel.NONE, inputOptions);
    }

    @Deprecated
    public Tags getSubscriptionTags(UUID subscriptionId, AuditLevel auditLevel) throws KillBillClientException {
        return this.getSubscriptionTags(subscriptionId, auditLevel, RequestOptions.empty());
    }

    public Tags getSubscriptionTags(UUID subscriptionId, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        return this.getObjectTags(subscriptionId, "/1.0/kb/subscriptions", auditLevel, inputOptions);
    }

    @Deprecated
    public Tags createSubscriptionTag(UUID subscriptionId, UUID tagDefinitionId, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createSubscriptionTag(subscriptionId, tagDefinitionId, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Tags createSubscriptionTag(UUID subscriptionId, UUID tagDefinitionId, RequestOptions inputOptions) throws KillBillClientException {
        return this.createObjectTag(subscriptionId, "/1.0/kb/subscriptions", tagDefinitionId, inputOptions);
    }

    @Deprecated
    public void deleteSubscriptionTag(UUID subscriptionId, UUID tagDefinitionId, String createdBy, String reason, String comment) throws KillBillClientException {
        this.deleteSubscriptionTag(subscriptionId, tagDefinitionId, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void deleteSubscriptionTag(UUID subscriptionId, UUID tagDefinitionId, RequestOptions inputOptions) throws KillBillClientException {
        this.deleteObjectTag(subscriptionId, "/1.0/kb/subscriptions", tagDefinitionId, inputOptions);
    }

    @Deprecated
    public Tags getInvoiceTags(UUID invoiceId) throws KillBillClientException {
        return this.getInvoiceTags(invoiceId, RequestOptions.empty());
    }

    public Tags getInvoiceTags(UUID invoiceId, RequestOptions inputOptions) throws KillBillClientException {
        return this.getInvoiceTags(invoiceId, AuditLevel.NONE, inputOptions);
    }

    @Deprecated
    public Tags getInvoiceTags(UUID invoiceId, AuditLevel auditLevel) throws KillBillClientException {
        return this.getInvoiceTags(invoiceId, auditLevel, RequestOptions.empty());
    }

    public Tags getInvoiceTags(UUID invoiceId, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        return this.getObjectTags(invoiceId, "/1.0/kb/invoices", auditLevel, inputOptions);
    }

    @Deprecated
    public Tags createInvoiceTag(UUID invoiceId, UUID tagDefinitionId, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createInvoiceTag(invoiceId, tagDefinitionId, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Tags createInvoiceTag(UUID invoiceId, UUID tagDefinitionId, RequestOptions inputOptions) throws KillBillClientException {
        return this.createObjectTag(invoiceId, "/1.0/kb/invoices", tagDefinitionId, inputOptions);
    }

    @Deprecated
    public void deleteInvoiceTag(UUID invoiceId, UUID tagDefinitionId, String createdBy, String reason, String comment) throws KillBillClientException {
        this.deleteInvoiceTag(invoiceId, tagDefinitionId, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void deleteInvoiceTag(UUID invoiceId, UUID tagDefinitionId, RequestOptions inputOptions) throws KillBillClientException {
        this.deleteObjectTag(invoiceId, "/1.0/kb/invoices", tagDefinitionId, inputOptions);
    }

    @Deprecated
    public Tags getPaymentTags(UUID paymentId) throws KillBillClientException {
        return this.getPaymentTags(paymentId, RequestOptions.empty());
    }

    public Tags getPaymentTags(UUID paymentId, RequestOptions inputOptions) throws KillBillClientException {
        return this.getPaymentTags(paymentId, AuditLevel.NONE, inputOptions);
    }

    @Deprecated
    public Tags getPaymentTags(UUID paymentId, AuditLevel auditLevel) throws KillBillClientException {
        return this.getPaymentTags(paymentId, auditLevel, RequestOptions.empty());
    }

    public Tags getPaymentTags(UUID paymentId, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        return this.getObjectTags(paymentId, "/1.0/kb/payments", auditLevel, inputOptions);
    }

    @Deprecated
    public Tags createPaymentTag(UUID paymentId, UUID tagDefinitionId, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createPaymentTag(paymentId, tagDefinitionId, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Tags createPaymentTag(UUID paymentId, UUID tagDefinitionId, RequestOptions inputOptions) throws KillBillClientException {
        return this.createObjectTag(paymentId, "/1.0/kb/payments", tagDefinitionId, inputOptions);
    }

    @Deprecated
    public void deletePaymentTag(UUID paymentId, UUID tagDefinitionId, String createdBy, String reason, String comment) throws KillBillClientException {
        this.deletePaymentTag(paymentId, tagDefinitionId, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void deletePaymentTag(UUID paymentId, UUID tagDefinitionId, RequestOptions inputOptions) throws KillBillClientException {
        this.deleteObjectTag(paymentId, "/1.0/kb/payments", tagDefinitionId, inputOptions);
    }

    private Tags getObjectTags(UUID objectId, String resourcePathPrefix, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        String uri = resourcePathPrefix + "/" + objectId + "/" + "tags";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"audit", (Object)auditLevel.toString());
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet(uri, Tags.class, requestOptions);
    }

    public Tags getPaymentTransactionTags(UUID paymentTransactionId, RequestOptions inputOptions) throws KillBillClientException {
        return this.getObjectTags(paymentTransactionId, "/1.0/kb/paymentTransactions", AuditLevel.NONE, inputOptions);
    }

    public Tags createPaymentTransactionTag(UUID paymentTransactionId, UUID tagDefinitionId, RequestOptions inputOptions) throws KillBillClientException {
        return this.createObjectTag(paymentTransactionId, "/1.0/kb/paymentTransactions", tagDefinitionId, inputOptions);
    }

    private Tags createObjectTag(UUID objectId, String resourcePathPrefix, UUID tagDefinitionId, RequestOptions inputOptions) throws KillBillClientException {
        String uri = resourcePathPrefix + "/" + objectId + "/" + "tags";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"tagList", (Object)tagDefinitionId.toString());
        Boolean followLocation = (Boolean)MoreObjects.firstNonNull((Object)inputOptions.getFollowLocation(), (Object)Boolean.TRUE);
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).withFollowLocation(followLocation).build();
        return this.httpClient.doPost(uri, null, Tags.class, requestOptions);
    }

    private void deleteObjectTag(UUID objectId, String resourcePathPrefix, UUID tagDefinitionId, RequestOptions inputOptions) throws KillBillClientException {
        String uri = resourcePathPrefix + "/" + objectId + "/" + "tags";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"tagList", (Object)tagDefinitionId.toString());
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        this.httpClient.doDelete(uri, requestOptions);
    }

    @Deprecated
    public CustomFields getCustomFields() throws KillBillClientException {
        return this.getCustomFields(RequestOptions.empty());
    }

    public CustomFields getCustomFields(RequestOptions inputOptions) throws KillBillClientException {
        return this.getCustomFields((Long)0L, (Long)100L, inputOptions);
    }

    @Deprecated
    public CustomFields getCustomFields(Long offset, Long limit) throws KillBillClientException {
        return this.getCustomFields(offset, limit, RequestOptions.empty());
    }

    public CustomFields getCustomFields(Long offset, Long limit, RequestOptions inputOptions) throws KillBillClientException {
        return this.getCustomFields(offset, limit, AuditLevel.NONE, inputOptions);
    }

    @Deprecated
    public CustomFields getCustomFields(Long offset, Long limit, AuditLevel auditLevel) throws KillBillClientException {
        return this.getCustomFields(offset, limit, auditLevel, RequestOptions.empty());
    }

    public CustomFields getCustomFields(Long offset, Long limit, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/customFields/pagination";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"offset", (Object)String.valueOf(offset));
        queryParams.put((Object)"limit", (Object)String.valueOf(limit));
        queryParams.put((Object)"audit", (Object)auditLevel.toString());
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet("/1.0/kb/customFields/pagination", CustomFields.class, requestOptions);
    }

    @Deprecated
    public CustomFields searchCustomFields(String key) throws KillBillClientException {
        return this.searchCustomFields(key, RequestOptions.empty());
    }

    public CustomFields searchCustomFields(String key, RequestOptions inputOptions) throws KillBillClientException {
        return this.searchCustomFields(key, (Long)0L, (Long)100L, inputOptions);
    }

    @Deprecated
    public CustomFields searchCustomFields(String key, Long offset, Long limit) throws KillBillClientException {
        return this.searchCustomFields(key, offset, limit, RequestOptions.empty());
    }

    public CustomFields searchCustomFields(String key, Long offset, Long limit, RequestOptions inputOptions) throws KillBillClientException {
        return this.searchCustomFields(key, offset, limit, AuditLevel.NONE, inputOptions);
    }

    @Deprecated
    public CustomFields searchCustomFields(String key, Long offset, Long limit, AuditLevel auditLevel) throws KillBillClientException {
        return this.searchCustomFields(key, offset, limit, auditLevel, RequestOptions.empty());
    }

    public CustomFields searchCustomFields(String key, Long offset, Long limit, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/customFields/search/" + UTF8UrlEncoder.encodePath((String)key);
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"offset", (Object)String.valueOf(offset));
        queryParams.put((Object)"limit", (Object)String.valueOf(limit));
        queryParams.put((Object)"audit", (Object)auditLevel.toString());
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet(uri, CustomFields.class, requestOptions);
    }

    @Deprecated
    public CustomFields getAccountCustomFields(UUID accountId) throws KillBillClientException {
        return this.getAccountCustomFields(accountId, RequestOptions.empty());
    }

    public CustomFields getAccountCustomFields(UUID accountId, RequestOptions inputOptions) throws KillBillClientException {
        return this.getAccountCustomFields(accountId, AuditLevel.NONE, inputOptions);
    }

    @Deprecated
    public CustomFields getAccountCustomFields(UUID accountId, AuditLevel auditLevel) throws KillBillClientException {
        return this.getAccountCustomFields(accountId, auditLevel, RequestOptions.empty());
    }

    public CustomFields getAccountCustomFields(UUID accountId, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/" + accountId + "/" + "customFields";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"audit", (Object)auditLevel.toString());
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet(uri, CustomFields.class, requestOptions);
    }

    @Deprecated
    public CustomFields createAccountCustomField(UUID accountId, CustomField customField, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createAccountCustomField(accountId, customField, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public CustomFields createAccountCustomField(UUID accountId, CustomField customField, RequestOptions inputOptions) throws KillBillClientException {
        return this.createAccountCustomFields(accountId, (Iterable<CustomField>)ImmutableList.of((Object)customField), inputOptions);
    }

    @Deprecated
    public CustomFields createAccountCustomFields(UUID accountId, Iterable<CustomField> customFields, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createAccountCustomFields(accountId, customFields, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public CustomFields createAccountCustomFields(UUID accountId, Iterable<CustomField> customFields, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/" + accountId + "/" + "customFields";
        Boolean followLocation = (Boolean)MoreObjects.firstNonNull((Object)inputOptions.getFollowLocation(), (Object)Boolean.TRUE);
        RequestOptions requestOptions = inputOptions.extend().withFollowLocation(followLocation).build();
        return this.httpClient.doPost(uri, customFields, CustomFields.class, requestOptions);
    }

    @Deprecated
    public void deleteAccountCustomField(UUID accountId, UUID customFieldId, String createdBy, String reason, String comment) throws KillBillClientException {
        this.deleteAccountCustomField(accountId, customFieldId, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void deleteAccountCustomField(UUID accountId, UUID customFieldId, RequestOptions inputOptions) throws KillBillClientException {
        this.deleteAccountCustomFields(accountId, (Iterable<UUID>)ImmutableList.of((Object)customFieldId), inputOptions);
    }

    @Deprecated
    public void deleteAccountCustomFields(UUID accountId, String createdBy, String reason, String comment) throws KillBillClientException {
        this.deleteAccountCustomFields(accountId, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void deleteAccountCustomFields(UUID accountId, RequestOptions inputOptions) throws KillBillClientException {
        this.deleteAccountCustomFields(accountId, null, inputOptions);
    }

    @Deprecated
    public void deleteAccountCustomFields(UUID accountId, @Nullable Iterable<UUID> customFieldIds, String createdBy, String reason, String comment) throws KillBillClientException {
        this.deleteAccountCustomFields(accountId, customFieldIds, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void deleteAccountCustomFields(UUID accountId, @Nullable Iterable<UUID> customFieldIds, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/accounts/" + accountId + "/" + "customFields";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        if (customFieldIds != null) {
            queryParams.put((Object)"customFieldList", (Object)Joiner.on((String)",").join(customFieldIds));
        }
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        this.httpClient.doDelete(uri, requestOptions);
    }

    @Deprecated
    public CustomFields getPaymentMethodCustomFields(UUID paymentMethodId) throws KillBillClientException {
        return this.getPaymentMethodCustomFields(paymentMethodId, RequestOptions.empty());
    }

    public CustomFields getPaymentMethodCustomFields(UUID paymentMethodId, RequestOptions inputOptions) throws KillBillClientException {
        return this.getPaymentMethodCustomFields(paymentMethodId, AuditLevel.NONE, inputOptions);
    }

    @Deprecated
    public CustomFields getPaymentMethodCustomFields(UUID paymentMethodId, AuditLevel auditLevel) throws KillBillClientException {
        return this.getPaymentMethodCustomFields(paymentMethodId, auditLevel, RequestOptions.empty());
    }

    public CustomFields getPaymentMethodCustomFields(UUID paymentMethodId, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/paymentMethods/" + paymentMethodId + "/" + "customFields";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"audit", (Object)auditLevel.toString());
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet(uri, CustomFields.class, requestOptions);
    }

    @Deprecated
    public CustomFields createPaymentMethodCustomField(UUID paymentMethodId, CustomField customField, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createPaymentMethodCustomField(paymentMethodId, customField, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public CustomFields createPaymentMethodCustomField(UUID paymentMethodId, CustomField customField, RequestOptions inputOptions) throws KillBillClientException {
        return this.createPaymentMethodCustomFields(paymentMethodId, (Iterable<CustomField>)ImmutableList.of((Object)customField), inputOptions);
    }

    @Deprecated
    public CustomFields createPaymentMethodCustomFields(UUID paymentMethodId, Iterable<CustomField> customFields, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createPaymentMethodCustomFields(paymentMethodId, customFields, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public CustomFields createPaymentMethodCustomFields(UUID paymentMethodId, Iterable<CustomField> customFields, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/paymentMethods/" + paymentMethodId + "/" + "customFields";
        Boolean followLocation = (Boolean)MoreObjects.firstNonNull((Object)inputOptions.getFollowLocation(), (Object)Boolean.TRUE);
        RequestOptions requestOptions = inputOptions.extend().withFollowLocation(followLocation).build();
        return this.httpClient.doPost(uri, customFields, CustomFields.class, requestOptions);
    }

    @Deprecated
    public void deletePaymentMethodCustomFields(UUID paymentMethodId, String createdBy, String reason, String comment) throws KillBillClientException {
        this.deletePaymentMethodCustomFields(paymentMethodId, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void deletePaymentMethodCustomFields(UUID paymentMethodId, RequestOptions inputOptions) throws KillBillClientException {
        this.deletePaymentMethodCustomFields(paymentMethodId, null, inputOptions);
    }

    @Deprecated
    public void deletePaymentMethodCustomFields(UUID paymentMethodId, @Nullable Iterable<UUID> customFieldIds, String createdBy, String reason, String comment) throws KillBillClientException {
        this.deletePaymentMethodCustomFields(paymentMethodId, customFieldIds, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void deletePaymentMethodCustomFields(UUID paymentMethodId, @Nullable Iterable<UUID> customFieldIds, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/paymentMethods/" + paymentMethodId + "/" + "customFields";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        if (customFieldIds != null) {
            queryParams.put((Object)"customFieldList", (Object)Joiner.on((String)",").join(customFieldIds));
        }
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        this.httpClient.doDelete(uri, requestOptions);
    }

    public CustomFields getPaymentCustomFields(UUID paymentId, RequestOptions inputOptions) throws KillBillClientException {
        return this.getPaymentCustomFields(paymentId, AuditLevel.NONE, inputOptions);
    }

    public CustomFields getPaymentCustomFields(UUID paymentId, AuditLevel auditLevel, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/payments/" + paymentId + "/" + "customFields";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"audit", (Object)auditLevel.toString());
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet(uri, CustomFields.class, requestOptions);
    }

    public CustomFields createPaymentCustomField(UUID paymentId, CustomField customField, RequestOptions inputOptions) throws KillBillClientException {
        return this.createPaymentCustomFields(paymentId, (Iterable<CustomField>)ImmutableList.of((Object)customField), inputOptions);
    }

    public CustomFields createPaymentCustomFields(UUID paymentId, Iterable<CustomField> customFields, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/payments/" + paymentId + "/" + "customFields";
        Boolean followLocation = (Boolean)MoreObjects.firstNonNull((Object)inputOptions.getFollowLocation(), (Object)Boolean.TRUE);
        RequestOptions requestOptions = inputOptions.extend().withFollowLocation(followLocation).build();
        return this.httpClient.doPost(uri, customFields, CustomFields.class, requestOptions);
    }

    public void deletePaymentCustomFields(UUID paymentId, RequestOptions inputOptions) throws KillBillClientException {
        this.deletePaymentCustomFields(paymentId, null, inputOptions);
    }

    public void deletePaymentCustomFields(UUID paymentId, @Nullable Iterable<UUID> customFieldIds, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/payments/" + paymentId + "/" + "customFields";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        if (customFieldIds != null) {
            queryParams.put((Object)"customFieldList", (Object)Joiner.on((String)",").join(customFieldIds));
        }
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        this.httpClient.doDelete(uri, requestOptions);
    }

    @Deprecated
    public List<PlanDetail> getAvailableAddons(String baseProductName) throws KillBillClientException {
        return this.getAvailableAddons(baseProductName, RequestOptions.empty());
    }

    public List<PlanDetail> getAvailableAddons(String baseProductName, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/catalog/availableAddons";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"baseProductName", (Object)baseProductName);
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doGet("/1.0/kb/catalog/availableAddons", PlanDetails.class, requestOptions);
    }

    @Deprecated
    public List<PlanDetail> getBasePlans() throws KillBillClientException {
        return this.getBasePlans(RequestOptions.empty());
    }

    public List<PlanDetail> getBasePlans(RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/catalog/availableBasePlans";
        return this.httpClient.doGet("/1.0/kb/catalog/availableBasePlans", PlanDetails.class, inputOptions);
    }

    @Deprecated
    public void uploadXMLCatalog(String catalogFilePath, String createdBy, String reason, String comment) throws KillBillClientException {
        this.uploadXMLCatalog(catalogFilePath, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void uploadXMLCatalog(String catalogFilePath, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/catalog";
        this.uploadFile(catalogFilePath, "/1.0/kb/catalog", "application/xml; charset=utf-8", inputOptions, null);
    }

    @Deprecated
    public void uploadXMLCatalog(InputStream catalogInputStream, String createdBy, String reason, String comment) throws KillBillClientException {
        this.uploadXMLCatalog(catalogInputStream, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void uploadXMLCatalog(InputStream catalogInputStream, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/catalog";
        this.uploadFile(catalogInputStream, "/1.0/kb/catalog", "application/xml; charset=utf-8", inputOptions, null);
    }

    @Deprecated
    public List<Catalog> getJSONCatalog() throws KillBillClientException {
        return this.getJSONCatalog(RequestOptions.empty());
    }

    public List<Catalog> getJSONCatalog(RequestOptions inputOptions) throws KillBillClientException {
        return this.getJSONCatalog(null, inputOptions);
    }

    @Deprecated
    public List<Catalog> getJSONCatalog(DateTime requestedDate) throws KillBillClientException {
        return this.getJSONCatalog(requestedDate, RequestOptions.empty());
    }

    public List<Catalog> getJSONCatalog(DateTime requestedDate, RequestOptions inputOptions) throws KillBillClientException {
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        if (requestedDate != null) {
            queryParams.put((Object)"requestedDate", (Object)requestedDate.toDateTimeISO().toString());
        }
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        String uri = "/1.0/kb/catalog";
        return this.httpClient.doGet("/1.0/kb/catalog", Catalogs.class, requestOptions);
    }

    @Deprecated
    public String getXMLCatalog() throws KillBillClientException {
        return this.getXMLCatalog(RequestOptions.empty());
    }

    public String getXMLCatalog(RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/catalog";
        return this.getResourceFile("/1.0/kb/catalog", "application/xml", inputOptions);
    }

    public void addSimplePan(SimplePlan simplePlan, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/catalog/simplePlan";
        RequestOptions requestOptions = inputOptions.extend().withFollowLocation(false).build();
        this.httpClient.doPost("/1.0/kb/catalog/simplePlan", (Object)simplePlan, requestOptions);
    }

    @Deprecated
    public Tenant createTenant(Tenant tenant, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.createTenant(tenant, true, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Tenant createTenant(Tenant tenant, boolean useGlobalDefault, RequestOptions inputOptions) throws KillBillClientException {
        Preconditions.checkNotNull((Object)tenant.getApiKey(), (Object)"Tenant#apiKey cannot be null");
        Preconditions.checkNotNull((Object)tenant.getApiSecret(), (Object)"Tenant#apiSecret cannot be null");
        Boolean followLocation = (Boolean)MoreObjects.firstNonNull((Object)inputOptions.getFollowLocation(), (Object)Boolean.TRUE);
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"useGlobalDefault", (Object)String.valueOf(useGlobalDefault));
        RequestOptions requestOptions = inputOptions.extend().withFollowLocation(followLocation).withQueryParams((Multimap<String, String>)queryParams).build();
        return this.httpClient.doPost("/1.0/kb/tenants", (Object)tenant, Tenant.class, requestOptions);
    }

    @Deprecated
    public TenantKey registerCallbackNotificationForTenant(String callback, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.registerCallbackNotificationForTenant(callback, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public TenantKey registerCallbackNotificationForTenant(String callback, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/tenants/registerNotificationCallback";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        queryParams.put((Object)"cb", (Object)callback);
        Boolean followLocation = (Boolean)MoreObjects.firstNonNull((Object)inputOptions.getFollowLocation(), (Object)Boolean.TRUE);
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).withFollowLocation(followLocation).build();
        return this.httpClient.doPost("/1.0/kb/tenants/registerNotificationCallback", null, TenantKey.class, requestOptions);
    }

    @Deprecated
    public TenantKey getCallbackNotificationForTenant() throws KillBillClientException {
        return this.getCallbackNotificationForTenant(RequestOptions.empty());
    }

    public TenantKey getCallbackNotificationForTenant(RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/tenants/registerNotificationCallback";
        return this.httpClient.doGet("/1.0/kb/tenants/registerNotificationCallback", TenantKey.class, inputOptions);
    }

    @Deprecated
    public void unregisterCallbackNotificationForTenant(String createdBy, String reason, String comment) throws KillBillClientException {
        this.unregisterCallbackNotificationForTenant(RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void unregisterCallbackNotificationForTenant(RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/tenants/registerNotificationCallback";
        this.httpClient.doDelete("/1.0/kb/tenants/registerNotificationCallback", inputOptions);
    }

    @Deprecated
    public TenantKey registerPluginConfigurationForTenant(String pluginName, String pluginConfigFilePath, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.registerPluginConfigurationForTenant(pluginName, pluginConfigFilePath, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public TenantKey registerPluginConfigurationForTenant(String pluginName, String pluginConfigFilePath, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/tenants/uploadPluginConfig/" + pluginName;
        return this.uploadFile(pluginConfigFilePath, uri, "text/plain", inputOptions, TenantKey.class);
    }

    @Deprecated
    public TenantKey registerPluginConfigurationForTenant(String pluginName, InputStream pluginConfigInputStream, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.registerPluginConfigurationForTenant(pluginName, pluginConfigInputStream, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public TenantKey registerPluginConfigurationForTenant(String pluginName, InputStream pluginConfigInputStream, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/tenants/uploadPluginConfig/" + pluginName;
        return this.uploadFile(pluginConfigInputStream, uri, "text/plain", inputOptions, TenantKey.class);
    }

    @Deprecated
    public TenantKey postPluginConfigurationPropertiesForTenant(String pluginName, String pluginConfigProperties, String createdBy, String reason, String comment) throws KillBillClientException {
        RequestOptions options = RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build();
        return this.postPluginConfigurationPropertiesForTenant(pluginName, pluginConfigProperties, options);
    }

    public TenantKey postPluginConfigurationPropertiesForTenant(String pluginName, String pluginConfigProperties, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/tenants/uploadPluginConfig/" + pluginName;
        RequestOptions options = inputOptions.extend().withFollowLocation(true).withHeader("Content-Type", "text/plain").build();
        return this.httpClient.doPost(uri, (Object)pluginConfigProperties, TenantKey.class, options);
    }

    @Deprecated
    public TenantKey getPluginConfigurationForTenant(String pluginName) throws KillBillClientException {
        return this.getPluginConfigurationForTenant(pluginName, RequestOptions.empty());
    }

    public TenantKey getPluginConfigurationForTenant(String pluginName, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/tenants/uploadPluginConfig/" + pluginName;
        return this.httpClient.doGet(uri, TenantKey.class, inputOptions);
    }

    public TenantKey postConfigurationPropertiesForTenant(String configProperties, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/tenants/uploadPerTenantConfig";
        Boolean followLocation = (Boolean)MoreObjects.firstNonNull((Object)inputOptions.getFollowLocation(), (Object)Boolean.TRUE);
        RequestOptions requestOptions = inputOptions.extend().withHeader("Content-Type", "text/plain").withFollowLocation(followLocation).build();
        return this.httpClient.doPost("/1.0/kb/tenants/uploadPerTenantConfig", (Object)configProperties, TenantKey.class, requestOptions);
    }

    public TenantKey getConfigurationForTenant() throws KillBillClientException {
        String uri = "/1.0/kb/tenants/uploadPerTenantConfig";
        return this.httpClient.doGet("/1.0/kb/tenants/uploadPerTenantConfig", TenantKey.class, RequestOptions.empty());
    }

    public void unregisterConfigurationForTenant(RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/tenants/uploadPerTenantConfig";
        this.httpClient.doDelete("/1.0/kb/tenants/uploadPerTenantConfig", inputOptions);
    }

    @Deprecated
    public void unregisterPluginConfigurationForTenant(String pluginName, String createdBy, String reason, String comment) throws KillBillClientException {
        this.unregisterPluginConfigurationForTenant(pluginName, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public void unregisterPluginConfigurationForTenant(String pluginName, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/tenants/uploadPluginConfig/" + pluginName;
        this.httpClient.doDelete(uri, inputOptions);
    }

    public TenantKey registerPluginPaymentStateMachineConfigurationForTenant(String pluginName, String pluginPaymentStateMachineConfigFilePath, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/tenants/uploadPluginPaymentStateMachineConfig/" + pluginName;
        return this.uploadFile(pluginPaymentStateMachineConfigFilePath, uri, "text/plain", inputOptions, TenantKey.class);
    }

    public TenantKey registerPluginPaymentStateMachineConfigurationForTenant(String pluginName, InputStream pluginPaymentStateMachineConfigInputStream, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/tenants/uploadPluginPaymentStateMachineConfig/" + pluginName;
        return this.uploadFile(pluginPaymentStateMachineConfigInputStream, uri, "text/plain", inputOptions, TenantKey.class);
    }

    public TenantKey postPluginPaymentStateMachineConfigurationXMLForTenant(String pluginName, String pluginPaymentStateMachineConfigXML, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/tenants/uploadPluginPaymentStateMachineConfig/" + pluginName;
        RequestOptions options = inputOptions.extend().withFollowLocation(true).withHeader("Content-Type", "text/plain").build();
        return this.httpClient.doPost(uri, (Object)pluginPaymentStateMachineConfigXML, TenantKey.class, options);
    }

    public TenantKey getPluginPaymentStateMachineConfigurationForTenant(String pluginName, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/tenants/uploadPluginPaymentStateMachineConfig/" + pluginName;
        return this.httpClient.doGet(uri, TenantKey.class, inputOptions);
    }

    public void unregisterPluginPaymentStateMachineConfigurationForTenant(String pluginName, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/tenants/uploadPluginPaymentStateMachineConfig/" + pluginName;
        this.httpClient.doDelete(uri, inputOptions);
    }

    public void invalidateAllCaches(RequestOptions inputOptions) throws KillBillClientException {
        this.invalidateCacheByName(null, inputOptions);
    }

    public void invalidateCacheByName(@Nullable String cacheName, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/admin/cache";
        HashMultimap queryParams = HashMultimap.create(inputOptions.getQueryParams());
        if (null != cacheName) {
            queryParams.put((Object)"cacheName", (Object)cacheName);
        }
        RequestOptions requestOptions = inputOptions.extend().withQueryParams((Multimap<String, String>)queryParams).build();
        this.httpClient.doDelete("/1.0/kb/admin/cache", requestOptions);
    }

    public void invalidateCacheByAccount(String accountId, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/admin/cache/accounts/" + accountId;
        this.httpClient.doDelete(uri, inputOptions);
    }

    public void invalidateCacheByTenant(RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/admin/cache/tenants";
        this.httpClient.doDelete("/1.0/kb/admin/cache/tenants", inputOptions);
    }

    @Deprecated
    public Permissions getPermissions() throws KillBillClientException {
        return this.getPermissions(RequestOptions.empty());
    }

    public Permissions getPermissions(RequestOptions inputOptions) throws KillBillClientException {
        return this.httpClient.doGet("/1.0/kb/security/permissions", Permissions.class, inputOptions);
    }

    @Deprecated
    public Response addUserRoles(UserRoles userRoles, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.addUserRoles(userRoles, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Response addUserRoles(UserRoles userRoles, RequestOptions inputOptions) throws KillBillClientException {
        return this.httpClient.doPost("/1.0/kb/security/users", (Object)userRoles, inputOptions);
    }

    @Deprecated
    public Response updateUserPassword(String username, String newPassword, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.updateUserPassword(username, newPassword, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Response updateUserPassword(String username, String newPassword, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/security/users/" + username + "/password";
        UserRoles userRoles = new UserRoles(username, newPassword, (List<String>)ImmutableList.of());
        return this.httpClient.doPut(uri, (Object)userRoles, inputOptions);
    }

    @Deprecated
    public Response updateUserRoles(String username, List<String> newRoles, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.updateUserRoles(username, newRoles, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Response updateUserRoles(String username, List<String> newRoles, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/security/users/" + username + "/roles";
        UserRoles userRoles = new UserRoles(username, null, newRoles);
        return this.httpClient.doPut(uri, (Object)userRoles, inputOptions);
    }

    @Deprecated
    public Response invalidateUser(String username, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.invalidateUser(username, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Response invalidateUser(String username, RequestOptions inputOptions) throws KillBillClientException {
        String uri = "/1.0/kb/security/users/" + username;
        return this.httpClient.doDelete(uri, inputOptions);
    }

    @Deprecated
    public Response addRoleDefinition(RoleDefinition roleDefinition, String createdBy, String reason, String comment) throws KillBillClientException {
        return this.addRoleDefinition(roleDefinition, RequestOptions.builder().withCreatedBy(createdBy).withReason(reason).withComment(comment).build());
    }

    public Response addRoleDefinition(RoleDefinition roleDefinition, RequestOptions inputOptions) throws KillBillClientException {
        return this.httpClient.doPost("/1.0/kb/security/roles", (Object)roleDefinition, inputOptions);
    }

    @Deprecated
    public Response pluginGET(String uri) throws Exception {
        return this.pluginGET(uri, RequestOptions.empty());
    }

    @Deprecated
    public Response pluginGET(String uri, Multimap<String, String> queryParams) throws Exception {
        return this.pluginGET(uri, RequestOptions.builder().withQueryParams(queryParams).build());
    }

    public Response pluginGET(String uri, RequestOptions inputOptions) throws Exception {
        return this.httpClient.doGet("/plugins/" + uri, inputOptions);
    }

    @Deprecated
    public Response pluginHEAD(String uri) throws Exception {
        return this.pluginHEAD(uri, RequestOptions.empty());
    }

    @Deprecated
    public Response pluginHEAD(String uri, Multimap<String, String> queryParams) throws Exception {
        return this.pluginHEAD(uri, RequestOptions.builder().withQueryParams(queryParams).build());
    }

    public Response pluginHEAD(String uri, RequestOptions inputOptions) throws Exception {
        return this.httpClient.doHead("/plugins/" + uri, inputOptions);
    }

    @Deprecated
    public Response pluginPOST(String uri, @Nullable String body) throws Exception {
        return this.pluginPOST(uri, body, RequestOptions.empty());
    }

    @Deprecated
    public Response pluginPOST(String uri, @Nullable String body, Multimap<String, String> queryParams) throws Exception {
        return this.pluginPOST(uri, body, RequestOptions.builder().withQueryParams(queryParams).build());
    }

    public Response pluginPOST(String uri, @Nullable String body, RequestOptions inputOptions) throws Exception {
        return this.httpClient.doPost("/plugins/" + uri, (Object)body, inputOptions);
    }

    @Deprecated
    public Response pluginPUT(String uri, @Nullable String body) throws Exception {
        return this.pluginPUT(uri, body, RequestOptions.empty());
    }

    @Deprecated
    public Response pluginPUT(String uri, @Nullable String body, Multimap<String, String> queryParams) throws Exception {
        return this.pluginPUT(uri, body, RequestOptions.builder().withQueryParams(queryParams).build());
    }

    public Response pluginPUT(String uri, @Nullable String body, RequestOptions inputOptions) throws Exception {
        return this.httpClient.doPut("/plugins/" + uri, (Object)body, inputOptions);
    }

    @Deprecated
    public Response pluginDELETE(String uri) throws Exception {
        return this.pluginDELETE(uri, RequestOptions.empty());
    }

    @Deprecated
    public Response pluginDELETE(String uri, Multimap<String, String> queryParams) throws Exception {
        return this.pluginDELETE(uri, RequestOptions.builder().withQueryParams(queryParams).build());
    }

    public Response pluginDELETE(String uri, RequestOptions inputOptions) throws Exception {
        return this.httpClient.doDelete("/plugins/" + uri, inputOptions);
    }

    @Deprecated
    public Response pluginOPTIONS(String uri) throws Exception {
        return this.pluginOPTIONS(uri, RequestOptions.empty());
    }

    @Deprecated
    public Response pluginOPTIONS(String uri, Multimap<String, String> queryParams) throws Exception {
        return this.pluginOPTIONS(uri, RequestOptions.builder().withQueryParams(queryParams).build());
    }

    public Response pluginOPTIONS(String uri, RequestOptions inputOptions) throws Exception {
        return this.httpClient.doOptions("/plugins/" + uri, inputOptions);
    }

    private String getResourceFile(String uri, String contentType, RequestOptions inputOptions) throws KillBillClientException {
        RequestOptions requestOptions = inputOptions.extend().withHeader("Accept", contentType).build();
        Response response = this.httpClient.doGet(uri, requestOptions);
        try {
            return response.getResponseBody("UTF-8");
        }
        catch (IOException e) {
            throw new KillBillClientException(e);
        }
    }

    private <ReturnType> ReturnType uploadFile(String fileToUpload, String uri, String contentType, RequestOptions inputOptions, Class<ReturnType> followUpClass) throws KillBillClientException {
        Preconditions.checkNotNull((Object)fileToUpload, (Object)"fileToUpload cannot be null");
        File catalogFile = new File(fileToUpload);
        Preconditions.checkArgument((catalogFile.exists() && catalogFile.isFile() && catalogFile.canRead() ? 1 : 0) != 0, (Object)"file to upload needs to be a valid file");
        try {
            String body = Files.toString((File)catalogFile, (Charset)Charset.forName("UTF-8"));
            return this.doUploadFile(body, uri, contentType, inputOptions, followUpClass);
        }
        catch (IOException e) {
            throw new KillBillClientException(e);
        }
    }

    private <ReturnType> ReturnType uploadFile(InputStream fileToUpload, String uri, String contentType, RequestOptions inputOptions, Class<ReturnType> followUpClass) throws KillBillClientException {
        Preconditions.checkNotNull((Object)fileToUpload, (Object)"fileToUpload cannot be null");
        try {
            InputStreamReader reader = new InputStreamReader(fileToUpload, Charset.forName("UTF-8"));
            String body = CharStreams.toString((Readable)reader);
            return this.doUploadFile(body, uri, contentType, inputOptions, followUpClass);
        }
        catch (IOException e) {
            throw new KillBillClientException(e);
        }
    }

    private <ReturnType> ReturnType doUploadFile(String body, String uri, String contentType, RequestOptions inputOptions, Class<ReturnType> followUpClass) throws KillBillClientException {
        RequestOptions.RequestOptionsBuilder requestOptionsBuilder = inputOptions.extend().withHeader("Content-Type", contentType);
        if (followUpClass != null) {
            Boolean followLocation = (Boolean)MoreObjects.firstNonNull((Object)inputOptions.getFollowLocation(), (Object)Boolean.TRUE);
            RequestOptions requestOptions = requestOptionsBuilder.withFollowLocation(followLocation).build();
            return this.httpClient.doPost(uri, (Object)body, followUpClass, requestOptions);
        }
        RequestOptions requestOptions = requestOptionsBuilder.build();
        this.httpClient.doPost(uri, (Object)body, requestOptions);
        return null;
    }

    @VisibleForTesting
    void storePluginPropertiesAsParams(Map<String, String> pluginProperties, Multimap<String, String> params) {
        for (String key : pluginProperties.keySet()) {
            params.put((Object)"pluginProperty", (Object)String.format("%s=%s", UTF8UrlEncoder.encodeQueryElement((String)key), UTF8UrlEncoder.encodeQueryElement((String)pluginProperties.get(key))));
        }
    }
}

