/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.Response;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.killbill.billing.client.KillBillClientException;
import org.killbill.billing.client.RequestOptions;
import org.killbill.billing.client.SslUtils;
import org.killbill.billing.client.model.BillingException;
import org.killbill.billing.client.model.KillBillObjects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KillBillHttpClient
implements Closeable {
    public static final int DEFAULT_HTTP_TIMEOUT_SEC = 10;
    public static final Multimap<String, String> DEFAULT_EMPTY_QUERY = ImmutableMultimap.of();
    public static final String AUDIT_OPTION_CREATED_BY = "__AUDIT_OPTION_CREATED_BY";
    public static final String AUDIT_OPTION_REASON = "__AUDIT_OPTION_REASON";
    public static final String AUDIT_OPTION_COMMENT = "__AUDIT_OPTION_COMMENT";
    public static final String TENANT_OPTION_API_KEY = "__TENANT_OPTION_API_KEY";
    public static final String TENANT_OPTION_API_SECRET = "__TENANT_OPTION_API_SECRET";
    public static final String RBAC_OPTION_USERNAME = "__RBAC_OPTION_USERNAME";
    public static final String RBAC_OPTION_PASSWORD = "__RBAC_OPTION_PASSWORD";
    public static final String CONTROL_PLUGIN_NAME = "controlPluginName";
    public static final String HTTP_HEADER_ACCEPT = "Accept";
    public static final String HTTP_HEADER_CONTENT_TYPE = "Content-Type";
    public static final String ACCEPT_HTML = "text/html";
    public static final String ACCEPT_JSON = "application/json";
    public static final String ACCEPT_XML = "application/xml";
    public static final String CONTENT_TYPE_JSON = "application/json; charset=utf-8";
    public static final String CONTENT_TYPE_XML = "application/xml; charset=utf-8";
    private static final Logger log = LoggerFactory.getLogger(KillBillHttpClient.class);
    private static final String USER_AGENT = "KillBill-JavaClient/1.0";
    private static final Joiner CSV_JOINER = Joiner.on((String)",");
    private final boolean DEBUG = Boolean.parseBoolean(System.getProperty("org.killbill.client.debug", "false"));
    private final String kbServerUrl;
    private final String username;
    private final String password;
    private final String apiKey;
    private final String apiSecret;
    private final AsyncHttpClient httpClient;
    private final ObjectMapper mapper;
    private final int requestTimeoutSec;

    public KillBillHttpClient(String kbServerUrl, String username, String password, String apiKey, String apiSecret, String proxyHost, Integer proxyPort, Integer connectTimeOut, Integer readTimeOut, Integer requestTimeout) {
        this(kbServerUrl, username, password, apiKey, apiSecret, proxyHost, proxyPort, connectTimeOut, readTimeOut, requestTimeout, null, null);
    }

    public KillBillHttpClient(String kbServerUrl, String username, String password, String apiKey, String apiSecret, String proxyHost, Integer proxyPort, Integer connectTimeOut, Integer readTimeOut, Integer requestTimeout, Boolean strictSSL, String SSLProtocol) {
        this.kbServerUrl = kbServerUrl;
        this.username = username;
        this.password = password;
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
        AsyncHttpClientConfig.Builder cfg = new AsyncHttpClientConfig.Builder();
        if (requestTimeout != null) {
            cfg.setRequestTimeout(requestTimeout.intValue());
            int timeoutSec = (int)TimeUnit.MILLISECONDS.toSeconds(requestTimeout.intValue());
            if (TimeUnit.SECONDS.toMillis(timeoutSec) != (long)requestTimeout.intValue()) {
                ++timeoutSec;
            }
            this.requestTimeoutSec = timeoutSec;
        } else {
            cfg.setRequestTimeout(10000);
            this.requestTimeoutSec = 10;
        }
        cfg.setConnectTimeout(((Integer)MoreObjects.firstNonNull((Object)connectTimeOut, (Object)10000)).intValue());
        cfg.setReadTimeout(((Integer)MoreObjects.firstNonNull((Object)readTimeOut, (Object)10000)).intValue());
        cfg.setUserAgent(USER_AGENT);
        if (proxyHost != null && proxyPort != null) {
            ProxyServer proxyServer = new ProxyServer(proxyHost, proxyPort.intValue());
            cfg.setProxyServer(proxyServer);
        }
        if (strictSSL != null) {
            try {
                cfg.setSSLContext(SslUtils.getInstance().getSSLContext(strictSSL, SSLProtocol));
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
        }
        this.httpClient = new AsyncHttpClient(cfg.build());
        this.mapper = new ObjectMapper();
        this.mapper.registerModule((Module)new JodaModule());
    }

    public KillBillHttpClient(String kbServerUrl, String username, String password, String apiKey, String apiSecret) {
        this(kbServerUrl, username, password, apiKey, apiSecret, null, null, null, null, null);
    }

    public KillBillHttpClient(String kbServerUrl, String username, String password, String apiKey, String apiSecret, String proxyHost, Integer proxyPort) {
        this(kbServerUrl, username, password, apiKey, apiSecret, proxyHost, proxyPort, null, null, null);
    }

    public KillBillHttpClient() {
        this(System.getProperty("killbill.url", "http://127.0.0.1:8080/"), System.getProperty("killbill.username", "admin"), System.getProperty("killbill.password", "password"), System.getProperty("killbill.apiKey", "bob"), System.getProperty("killbill.apiSecret", "lazar"));
    }

    @Override
    public void close() {
        this.httpClient.close();
    }

    @Deprecated
    public Response doPost(String uri, Object body, Multimap<String, String> options) throws KillBillClientException {
        return this.doPost(uri, body, options, Response.class);
    }

    @Deprecated
    public <T> T doPost(String uri, Object body, Multimap<String, String> options, Class<T> clazz) throws KillBillClientException {
        return this.doPost(uri, body, options, this.requestTimeoutSec, clazz);
    }

    @Deprecated
    public <T> T doPost(String uri, Object body, Multimap<String, String> options, int timeoutSec, Class<T> clazz) throws KillBillClientException {
        return this.doPostAndMaybeFollowLocation(uri, body, options, DEFAULT_EMPTY_QUERY, timeoutSec, clazz, false);
    }

    public Response doPost(String uri, Object body, RequestOptions requestOptions) throws KillBillClientException {
        return this.doPost(uri, body, Response.class, requestOptions);
    }

    public <T> T doPost(String uri, Object body, Class<T> returnClass, RequestOptions requestOptions) throws KillBillClientException {
        return this.doPost(uri, body, returnClass, requestOptions, this.requestTimeoutSec);
    }

    public <T> T doPost(String uri, Object body, Class<T> returnClass, RequestOptions requestOptions, int timeoutSec) throws KillBillClientException {
        String verb = "POST";
        return this.doPrepareRequest("POST", uri, body, returnClass, requestOptions, timeoutSec);
    }

    @Deprecated
    public <T> T doPostAndFollowLocation(String uri, Object body, Multimap<String, String> options, Class<T> clazz) throws KillBillClientException {
        return this.doPostAndFollowLocation(uri, body, options, DEFAULT_EMPTY_QUERY, clazz);
    }

    @Deprecated
    public <T> T doPostAndFollowLocation(String uri, Object body, Multimap<String, String> options, Multimap<String, String> optionsForFollow, Class<T> clazz) throws KillBillClientException {
        return this.doPostAndFollowLocation(uri, body, options, optionsForFollow, this.requestTimeoutSec, clazz);
    }

    @Deprecated
    public <T> T doPostAndFollowLocation(String uri, Object body, Multimap<String, String> options, int timeoutSec, Class<T> clazz) throws KillBillClientException {
        return this.doPostAndFollowLocation(uri, body, options, DEFAULT_EMPTY_QUERY, timeoutSec, clazz);
    }

    @Deprecated
    public <T> T doPostAndFollowLocation(String uri, Object body, Multimap<String, String> options, Multimap<String, String> optionsForFollow, int timeoutSec, Class<T> clazz) throws KillBillClientException {
        return this.doPostAndMaybeFollowLocation(uri, body, options, optionsForFollow, timeoutSec, clazz, true);
    }

    @Deprecated
    public <T> T doPostAndMaybeFollowLocation(String uri, Object body, Multimap<String, String> options, Multimap<String, String> optionsForFollow, int timeoutSec, Class<T> clazz, boolean followLocation) throws KillBillClientException {
        String verb = "POST";
        return this.doPrepareRequestAndMaybeFollowLocation("POST", uri, body, options, optionsForFollow, timeoutSec, clazz, followLocation);
    }

    @Deprecated
    public Response doPut(String uri, Object body, Multimap<String, String> options) throws KillBillClientException {
        return this.doPut(uri, body, options, Response.class);
    }

    @Deprecated
    public <T> T doPut(String uri, Object body, Multimap<String, String> options, Class<T> clazz) throws KillBillClientException {
        return this.doPut(uri, body, options, this.requestTimeoutSec, clazz);
    }

    @Deprecated
    public <T> T doPut(String uri, Object body, Multimap<String, String> options, int timeoutSec, Class<T> clazz) throws KillBillClientException {
        return this.doPutAndMaybeFollowLocation(uri, body, options, timeoutSec, clazz, false);
    }

    @Deprecated
    public <T> T doPutAndFollowLocation(String uri, Object body, Multimap<String, String> options, Class<T> clazz) throws KillBillClientException {
        return this.doPutAndFollowLocation(uri, body, options, this.requestTimeoutSec, clazz);
    }

    @Deprecated
    public <T> T doPutAndFollowLocation(String uri, Object body, Multimap<String, String> options, int timeoutSec, Class<T> clazz) throws KillBillClientException {
        return this.doPutAndMaybeFollowLocation(uri, body, options, timeoutSec, clazz, true);
    }

    @Deprecated
    public <T> T doPutAndMaybeFollowLocation(String uri, Object body, Multimap<String, String> options, int timeoutSec, Class<T> clazz, boolean followLocation) throws KillBillClientException {
        String verb = "PUT";
        return this.doPrepareRequestAndMaybeFollowLocation("PUT", uri, body, options, DEFAULT_EMPTY_QUERY, timeoutSec, clazz, followLocation);
    }

    public Response doPut(String uri, Object body, RequestOptions options) throws KillBillClientException {
        return this.doPut(uri, body, Response.class, options);
    }

    public <T> T doPut(String uri, Object body, Class<T> returnClass, RequestOptions options) throws KillBillClientException {
        return this.doPut(uri, body, returnClass, options, this.requestTimeoutSec);
    }

    public <T> T doPut(String uri, Object body, Class<T> returnClass, RequestOptions options, int timeoutSec) throws KillBillClientException {
        String verb = "PUT";
        return this.doPrepareRequest("PUT", uri, body, returnClass, options, timeoutSec);
    }

    @Deprecated
    public Response doDelete(String uri, Multimap<String, String> options) throws KillBillClientException {
        return this.doDelete(uri, options, Response.class);
    }

    @Deprecated
    public <T> T doDelete(String uri, Multimap<String, String> options, Class<T> clazz) throws KillBillClientException {
        return this.doDeleteAndMaybeFollowLocation(uri, options, this.requestTimeoutSec, clazz, false);
    }

    @Deprecated
    public <T> T doDeleteAndMaybeFollowLocation(String uri, Multimap<String, String> options, int timeoutSec, Class<T> clazz, boolean followLocation) throws KillBillClientException {
        String verb = "DELETE";
        return this.doPrepareRequestAndMaybeFollowLocation("DELETE", uri, options, DEFAULT_EMPTY_QUERY, timeoutSec, clazz, followLocation);
    }

    public Response doDelete(String uri, RequestOptions requestOptions) throws KillBillClientException {
        return this.doDelete(uri, null, Response.class, requestOptions);
    }

    public <T> T doDelete(String uri, Object body, Class<T> returnClass, RequestOptions requestOptions) throws KillBillClientException {
        return this.doDelete(uri, body, returnClass, requestOptions, this.requestTimeoutSec);
    }

    public <T> T doDelete(String uri, Object body, Class<T> returnClass, RequestOptions requestOptions, int timeoutSec) throws KillBillClientException {
        String verb = "DELETE";
        return this.doPrepareRequest("DELETE", uri, body, returnClass, requestOptions, timeoutSec);
    }

    @Deprecated
    public Response doGet(String uri, Multimap<String, String> options) throws KillBillClientException {
        return this.doGet(uri, options, Response.class);
    }

    @Deprecated
    public <T> T doGet(String uri, Multimap<String, String> options, Class<T> clazz) throws KillBillClientException {
        return this.doGetWithUrl(uri, options, this.requestTimeoutSec, clazz);
    }

    @Deprecated
    public <T> T doGetWithUrl(String url, Multimap<String, String> options, int timeoutSec, Class<T> clazz) throws KillBillClientException {
        String verb = "GET";
        return this.doPrepareRequestAndMaybeFollowLocation("GET", url, options, DEFAULT_EMPTY_QUERY, timeoutSec, clazz);
    }

    public Response doGet(String uri, RequestOptions requestOptions) throws KillBillClientException {
        return this.doGet(uri, Response.class, requestOptions);
    }

    public <T> T doGet(String uri, Class<T> returnClass, RequestOptions requestOptions) throws KillBillClientException {
        return this.doGet(uri, returnClass, requestOptions, this.requestTimeoutSec);
    }

    public <T> T doGet(String uri, Class<T> returnClass, RequestOptions requestOptions, int timeoutSec) throws KillBillClientException {
        String verb = "GET";
        return this.doPrepareRequest("GET", uri, null, returnClass, requestOptions, timeoutSec);
    }

    @Deprecated
    public Response doHead(String uri, Multimap<String, String> options) throws KillBillClientException {
        return this.doHead(uri, options, Response.class);
    }

    @Deprecated
    public <T> T doHead(String uri, Multimap<String, String> options, Class<T> clazz) throws KillBillClientException {
        return this.doHeadWithUrl(uri, options, this.requestTimeoutSec, clazz);
    }

    @Deprecated
    public <T> T doHeadWithUrl(String url, Multimap<String, String> options, int timeoutSec, Class<T> clazz) throws KillBillClientException {
        String verb = "HEAD";
        return this.doPrepareRequestAndMaybeFollowLocation("HEAD", url, options, DEFAULT_EMPTY_QUERY, timeoutSec, clazz);
    }

    public Response doHead(String uri, RequestOptions requestOptions) throws KillBillClientException {
        return this.doHead(uri, requestOptions, this.requestTimeoutSec);
    }

    public Response doHead(String uri, RequestOptions requestOptions, int timeoutSec) throws KillBillClientException {
        String verb = "HEAD";
        return this.doPrepareRequest("HEAD", uri, null, Response.class, requestOptions, timeoutSec);
    }

    @Deprecated
    public Response doOptions(String uri, Multimap<String, String> options) throws KillBillClientException {
        return this.doOptions(uri, options, Response.class);
    }

    @Deprecated
    public <T> T doOptions(String uri, Multimap<String, String> options, Class<T> clazz) throws KillBillClientException {
        return this.doOptionsWithUrl(uri, options, this.requestTimeoutSec, clazz);
    }

    @Deprecated
    public <T> T doOptionsWithUrl(String url, Multimap<String, String> options, int timeoutSec, Class<T> clazz) throws KillBillClientException {
        String verb = "OPTIONS";
        return this.doPrepareRequestAndMaybeFollowLocation("OPTIONS", url, options, DEFAULT_EMPTY_QUERY, timeoutSec, clazz);
    }

    public Response doOptions(String uri, RequestOptions requestOptions) throws KillBillClientException {
        return this.doOptions(uri, requestOptions, this.requestTimeoutSec);
    }

    public Response doOptions(String uri, RequestOptions requestOptions, int timeoutSec) throws KillBillClientException {
        String verb = "OPTIONS";
        return this.doPrepareRequest("OPTIONS", uri, null, Response.class, requestOptions, timeoutSec);
    }

    @Deprecated
    private <T> T doPrepareRequestAndMaybeFollowLocation(String verb, String uri, Multimap<String, String> options, Multimap<String, String> optionsForFollow, int timeoutSec, Class<T> clazz) throws KillBillClientException {
        return this.doPrepareRequestAndMaybeFollowLocation(verb, uri, null, options, optionsForFollow, timeoutSec, clazz, false);
    }

    @Deprecated
    private <T> T doPrepareRequestAndMaybeFollowLocation(String verb, String uri, Multimap<String, String> options, Multimap<String, String> optionsForFollow, int timeoutSec, Class<T> clazz, boolean followLocation) throws KillBillClientException {
        return this.doPrepareRequestAndMaybeFollowLocation(verb, uri, null, options, optionsForFollow, timeoutSec, clazz, followLocation);
    }

    private <T> T doPrepareRequest(String verb, String uri, Object body, Class<T> returnClass, RequestOptions requestOptions, int timeoutSec) throws KillBillClientException {
        Response response;
        AsyncHttpClient.BoundRequestBuilder builder = this.getBuilderWithHeaderAndQuery(verb, this.getKBServerUrl(uri), requestOptions);
        String apiKey = requestOptions.getTenantApiKey() != null ? requestOptions.getTenantApiKey() : this.apiKey;
        KillBillHttpClient.addHeader(builder, "X-Killbill-ApiKey", apiKey);
        String apiSecret = requestOptions.getTenantApiSecret() != null ? requestOptions.getTenantApiSecret() : this.apiSecret;
        KillBillHttpClient.addHeader(builder, "X-Killbill-ApiSecret", apiSecret);
        KillBillHttpClient.addHeader(builder, "X-Killbill-CreatedBy", requestOptions.getCreatedBy());
        KillBillHttpClient.addHeader(builder, "X-Killbill-Reason", requestOptions.getReason());
        KillBillHttpClient.addHeader(builder, "X-Killbill-Comment", requestOptions.getComment());
        KillBillHttpClient.addHeader(builder, "X-Request-Id", requestOptions.getRequestId());
        if (!"GET".equals(verb) && !"HEAD".equals(verb)) {
            if (body != null) {
                if (body instanceof String) {
                    builder.setBody((String)body);
                } else {
                    try {
                        builder.setBody(this.mapper.writeValueAsString(body));
                    }
                    catch (JsonProcessingException e) {
                        throw new KillBillClientException((Exception)((Object)e));
                    }
                }
            } else {
                builder.setBody("{}");
            }
        }
        if ((response = KillBillHttpClient.doRequest(builder, timeoutSec)).getStatusCode() == 404 || response.getStatusCode() == 204) {
            return KillBillHttpClient.createEmptyResult(returnClass);
        }
        if (requestOptions.shouldFollowLocation()) {
            if (response.getHeader("Location") != null) {
                String location = response.getHeader("Location");
                RequestOptions optionsForFollow = RequestOptions.builder().withUser(requestOptions.getUser()).withPassword(requestOptions.getPassword()).withTenantApiKey(requestOptions.getTenantApiKey()).withTenantApiSecret(requestOptions.getTenantApiSecret()).withRequestId(requestOptions.getRequestId()).withFollowLocation(false).withQueryParams(requestOptions.getQueryParamsForFollow()).build();
                return this.doGet(location, returnClass, optionsForFollow, timeoutSec);
            }
            this.throwExceptionOnResponseError(response);
            return Response.class.isAssignableFrom(returnClass) ? (T)returnClass.cast(response) : null;
        }
        this.throwExceptionOnResponseError(response);
        return this.deserializeResponse(response, returnClass);
    }

    private static void addHeader(AsyncHttpClient.BoundRequestBuilder builder, String headerName, String value) {
        if (value != null) {
            builder.addHeader(headerName, value);
        }
    }

    @Deprecated
    private <T> T doPrepareRequestAndMaybeFollowLocation(String verb, String uri, Object body, Multimap<String, String> optionsRo, Multimap<String, String> optionsForFollow, int timeoutSec, Class<T> clazz, boolean followLocation) throws KillBillClientException {
        Response response;
        String password;
        String username;
        String apiSecret;
        HashMultimap options = HashMultimap.create(optionsRo);
        String createdBy = this.getUniqueValue((Multimap<String, String>)options, AUDIT_OPTION_CREATED_BY);
        String reason = this.getUniqueValue((Multimap<String, String>)options, AUDIT_OPTION_REASON);
        String comment = this.getUniqueValue((Multimap<String, String>)options, AUDIT_OPTION_COMMENT);
        String apiKey = this.getUniqueValue((Multimap<String, String>)options, TENANT_OPTION_API_KEY);
        if (apiKey == null) {
            apiKey = this.apiKey;
        }
        if ((apiSecret = this.getUniqueValue((Multimap<String, String>)options, TENANT_OPTION_API_SECRET)) == null) {
            apiSecret = this.apiSecret;
        }
        if ((username = this.getUniqueValue((Multimap<String, String>)options, RBAC_OPTION_USERNAME)) == null) {
            username = this.username;
        }
        if ((password = this.getUniqueValue((Multimap<String, String>)options, RBAC_OPTION_PASSWORD)) == null) {
            password = this.password;
        }
        options.removeAll((Object)AUDIT_OPTION_CREATED_BY);
        options.removeAll((Object)AUDIT_OPTION_REASON);
        options.removeAll((Object)AUDIT_OPTION_COMMENT);
        options.removeAll((Object)TENANT_OPTION_API_KEY);
        options.removeAll((Object)TENANT_OPTION_API_SECRET);
        options.removeAll((Object)RBAC_OPTION_USERNAME);
        options.removeAll((Object)RBAC_OPTION_PASSWORD);
        AsyncHttpClient.BoundRequestBuilder builder = this.getBuilderWithHeaderAndQuery(verb, this.getKBServerUrl(uri), username, password, (Multimap<String, String>)options);
        if (apiKey != null) {
            builder.addHeader("X-Killbill-ApiKey", apiKey);
        }
        if (apiSecret != null) {
            builder.addHeader("X-Killbill-ApiSecret", apiSecret);
        }
        if (createdBy != null) {
            builder.addHeader("X-Killbill-CreatedBy", createdBy);
        }
        if (reason != null) {
            builder.addHeader("X-Killbill-Reason", reason);
        }
        if (comment != null) {
            builder.addHeader("X-Killbill-Comment", comment);
        }
        if (!"GET".equals(verb) && !"HEAD".equals(verb)) {
            if (body != null) {
                if (body instanceof String) {
                    builder.setBody((String)body);
                } else {
                    try {
                        builder.setBody(this.mapper.writeValueAsString(body));
                    }
                    catch (JsonProcessingException e) {
                        throw new KillBillClientException((Exception)((Object)e));
                    }
                }
            } else {
                builder.setBody("{}");
            }
        }
        if ((response = KillBillHttpClient.doRequest(builder, timeoutSec)).getStatusCode() == 404 || response.getStatusCode() == 204) {
            return KillBillHttpClient.createEmptyResult(clazz);
        }
        if (followLocation) {
            if (response.getHeader("Location") != null) {
                String location = response.getHeader("Location");
                return this.doGetWithUrl(location, optionsForFollow, timeoutSec, clazz);
            }
            this.throwExceptionOnResponseError(response);
            return Response.class.isAssignableFrom(clazz) ? (T)clazz.cast(response) : null;
        }
        this.throwExceptionOnResponseError(response);
        return this.deserializeResponse(response, clazz);
    }

    private String getUniqueValue(Multimap<String, String> options, String key) {
        Collection values = options.get((Object)key);
        if (values == null || values.isEmpty()) {
            return null;
        }
        Preconditions.checkState((values.size() == 1 ? 1 : 0) != 0, (Object)("You can only specify a unique value for " + key));
        return (String)values.iterator().next();
    }

    private static Response doRequest(AsyncHttpClient.BoundRequestBuilder builder, int timeoutSec) throws KillBillClientException {
        try {
            ListenableFuture futureStatus = builder.execute((AsyncHandler)new AsyncCompletionHandler<Response>(){

                public Response onCompleted(Response response) throws Exception {
                    return response;
                }
            });
            return (Response)futureStatus.get((long)timeoutSec, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new KillBillClientException(e);
        }
        catch (ExecutionException e) {
            throw new KillBillClientException(e);
        }
        catch (TimeoutException e) {
            throw new KillBillClientException(e);
        }
    }

    private void throwExceptionOnResponseError(Response response) throws KillBillClientException {
        if (response.getStatusCode() == 401) {
            throw new KillBillClientException(new IllegalArgumentException("Unauthorized - did you configure your RBAC and/or tenant credentials?"), response);
        }
        if (response.getStatusCode() >= 400) {
            BillingException exception = this.deserializeResponse(response, BillingException.class);
            if (exception != null) {
                log.warn("Error " + response.getStatusCode() + " from Kill Bill: " + exception.getMessage());
            } else {
                log.warn("Error " + response.getStatusCode() + " from Kill Bill");
            }
            throw new KillBillClientException(exception, response);
        }
    }

    private <T> T deserializeResponse(Response response, Class<T> clazz) throws KillBillClientException {
        if (Response.class.isAssignableFrom(clazz)) {
            return clazz.cast(response);
        }
        T result = this.unmarshalResponse(response, clazz);
        if (KillBillObjects.class.isAssignableFrom(clazz)) {
            String paginationMaxNbRecords;
            String paginationTotalNbRecords;
            String paginationNextOffset;
            KillBillObjects objects = (KillBillObjects)result;
            String paginationCurrentOffset = response.getHeader("X-Killbill-Pagination-CurrentOffset");
            if (paginationCurrentOffset != null) {
                objects.setPaginationCurrentOffset(Integer.parseInt(paginationCurrentOffset));
            }
            if ((paginationNextOffset = response.getHeader("X-Killbill-Pagination-NextOffset")) != null) {
                objects.setPaginationNextOffset(Integer.parseInt(paginationNextOffset));
            }
            if ((paginationTotalNbRecords = response.getHeader("X-Killbill-Pagination-TotalNbRecords")) != null) {
                objects.setPaginationTotalNbRecords(Integer.parseInt(paginationTotalNbRecords));
            }
            if ((paginationMaxNbRecords = response.getHeader("X-Killbill-Pagination-MaxNbRecords")) != null) {
                objects.setPaginationMaxNbRecords(Integer.parseInt(paginationMaxNbRecords));
            }
            objects.setPaginationNextPageUri(response.getHeader("X-Killbill-Pagination-NextPageUri"));
            objects.setKillBillHttpClient(this);
        }
        return result;
    }

    private static <T> T createEmptyResult(Class<T> clazz) {
        if (Iterable.class.isAssignableFrom(clazz)) {
            for (Constructor<?> constructor : clazz.getConstructors()) {
                if (constructor.getParameterTypes().length != 0) continue;
                try {
                    return clazz.cast(constructor.newInstance(new Object[0]));
                }
                catch (InstantiationException e) {
                    return null;
                }
                catch (IllegalAccessException e) {
                    return null;
                }
                catch (InvocationTargetException e) {
                    return null;
                }
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T unmarshalResponse(Response response, Class<T> clazz) throws KillBillClientException {
        Object result;
        block11: {
            try {
                if (this.DEBUG) {
                    String content = response.getResponseBody();
                    log.debug("Received: " + content);
                    result = this.mapper.readValue(content, clazz);
                    break block11;
                }
                InputStream in = null;
                try {
                    in = response.getResponseBodyAsStream();
                    result = this.mapper.readValue(in, clazz);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            log.warn("Failed to close http-client - provided InputStream: {}", (Object)e.getLocalizedMessage());
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new KillBillClientException(e, response);
            }
        }
        return (T)result;
    }

    @Deprecated
    private AsyncHttpClient.BoundRequestBuilder getBuilderWithHeaderAndQuery(String verb, String url, @Nullable String username, @Nullable String password, Multimap<String, String> options) {
        Collection acceptHeaders;
        AsyncHttpClient.BoundRequestBuilder builder;
        if ("GET".equals(verb)) {
            builder = this.httpClient.prepareGet(url);
        } else if ("POST".equals(verb)) {
            builder = this.httpClient.preparePost(url);
        } else if ("PUT".equals(verb)) {
            builder = this.httpClient.preparePut(url);
        } else if ("DELETE".equals(verb)) {
            builder = this.httpClient.prepareDelete(url);
        } else if ("HEAD".equals(verb)) {
            builder = this.httpClient.prepareHead(url);
        } else if ("OPTIONS".equals(verb)) {
            builder = this.httpClient.prepareOptions(url);
        } else {
            throw new IllegalArgumentException("Unrecognized verb: " + verb);
        }
        if (username != null && password != null) {
            Realm realm = new Realm.RealmBuilder().setPrincipal(username).setPassword(password).setScheme(Realm.AuthScheme.BASIC).setUsePreemptiveAuth(true).build();
            builder.setRealm(realm);
        }
        String acceptHeader = !(acceptHeaders = options.removeAll((Object)HTTP_HEADER_ACCEPT)).isEmpty() ? CSV_JOINER.join((Iterable)acceptHeaders) : ACCEPT_JSON;
        builder.addHeader(HTTP_HEADER_ACCEPT, acceptHeader);
        String contentTypeHeader = this.getUniqueValue(options, HTTP_HEADER_CONTENT_TYPE);
        if (contentTypeHeader == null) {
            contentTypeHeader = CONTENT_TYPE_JSON;
        } else {
            options.removeAll((Object)HTTP_HEADER_CONTENT_TYPE);
        }
        builder.addHeader(HTTP_HEADER_CONTENT_TYPE, contentTypeHeader);
        builder.setBodyEncoding("UTF-8");
        for (String key : options.keySet()) {
            if (options.get((Object)key) == null) continue;
            for (String value : options.get((Object)key)) {
                builder.addQueryParam(key, value);
            }
        }
        return builder;
    }

    private AsyncHttpClient.BoundRequestBuilder getBuilderWithHeaderAndQuery(String verb, String url, RequestOptions requestOptions) {
        String password;
        AsyncHttpClient.BoundRequestBuilder builder;
        if ("GET".equals(verb)) {
            builder = this.httpClient.prepareGet(url);
        } else if ("POST".equals(verb)) {
            builder = this.httpClient.preparePost(url);
        } else if ("PUT".equals(verb)) {
            builder = this.httpClient.preparePut(url);
        } else if ("DELETE".equals(verb)) {
            builder = this.httpClient.prepareDelete(url);
        } else if ("HEAD".equals(verb)) {
            builder = this.httpClient.prepareHead(url);
        } else if ("OPTIONS".equals(verb)) {
            builder = this.httpClient.prepareOptions(url);
        } else {
            throw new IllegalArgumentException("Unrecognized verb: " + verb);
        }
        String username = requestOptions.getUser() != null ? requestOptions.getUser() : this.username;
        String string = password = requestOptions.getPassword() != null ? requestOptions.getPassword() : this.password;
        if (username != null && password != null) {
            Realm realm = new Realm.RealmBuilder().setPrincipal(username).setPassword(password).setScheme(Realm.AuthScheme.BASIC).setUsePreemptiveAuth(true).build();
            builder.setRealm(realm);
        }
        if (requestOptions.getHeaders().get((Object)HTTP_HEADER_ACCEPT) == null) {
            builder.addHeader(HTTP_HEADER_ACCEPT, ACCEPT_JSON);
        }
        if (requestOptions.getHeaders().get((Object)HTTP_HEADER_CONTENT_TYPE) == null) {
            builder.addHeader(HTTP_HEADER_CONTENT_TYPE, CONTENT_TYPE_JSON);
        }
        for (Map.Entry header : requestOptions.getHeaders().entrySet()) {
            builder.addHeader((String)header.getKey(), (String)header.getValue());
        }
        builder.setBodyEncoding("UTF-8");
        ImmutableMultimap<String, String> queryParams = requestOptions.getQueryParams();
        for (String key : queryParams.keySet()) {
            if (queryParams.get((Object)key) == null) continue;
            for (String value : queryParams.get((Object)key)) {
                builder.addQueryParam(key, value);
            }
        }
        return builder;
    }

    private String getKBServerUrl(String uri) throws KillBillClientException {
        try {
            URI u = new URI(uri);
            if (u.isAbsolute()) {
                return uri;
            }
            return String.format("%s%s", this.kbServerUrl, uri);
        }
        catch (URISyntaxException e) {
            throw new KillBillClientException(e);
        }
    }
}

