/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.client;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestOptions {
    private final String requestId;
    private final String user;
    private final String password;
    private final String createdBy;
    private final String reason;
    private final String comment;
    private final String tenantApiKey;
    private final String tenantApiSecret;
    private final ImmutableMap<String, String> headers;
    private final ImmutableMultimap<String, String> queryParams;
    private final Boolean followLocation;
    private final Multimap<String, String> queryParamsForFollow;

    public RequestOptions(String requestId, String user, String password, String createdBy, String reason, String comment, String tenantApiKey, String tenantApiSecret, Map<String, String> headers, Multimap<String, String> queryParams, Boolean followLocation, Multimap<String, String> queryParamsForFollow) {
        this.requestId = requestId;
        this.user = user;
        this.password = password;
        this.createdBy = createdBy;
        this.reason = reason;
        this.comment = comment;
        this.tenantApiKey = tenantApiKey;
        this.tenantApiSecret = tenantApiSecret;
        this.headers = headers != null ? ImmutableMap.copyOf(headers) : ImmutableMap.of();
        this.queryParams = queryParams != null ? ImmutableMultimap.copyOf(queryParams) : ImmutableMultimap.of();
        this.followLocation = followLocation;
        this.queryParamsForFollow = ImmutableMultimap.copyOf(queryParamsForFollow);
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String getReason() {
        return this.reason;
    }

    public String getComment() {
        return this.comment;
    }

    public String getTenantApiKey() {
        return this.tenantApiKey;
    }

    public String getTenantApiSecret() {
        return this.tenantApiSecret;
    }

    public ImmutableMap<String, String> getHeaders() {
        return this.headers;
    }

    public ImmutableMultimap<String, String> getQueryParams() {
        return this.queryParams;
    }

    public Boolean getFollowLocation() {
        return this.followLocation;
    }

    public boolean shouldFollowLocation() {
        if (this.followLocation == null) {
            return false;
        }
        return this.followLocation;
    }

    public Multimap<String, String> getQueryParamsForFollow() {
        return this.queryParamsForFollow;
    }

    public RequestOptionsBuilder extend() {
        RequestOptionsBuilder builder = new RequestOptionsBuilder();
        builder.headers.putAll(this.headers);
        return builder.withRequestId(this.requestId).withUser(this.user).withPassword(this.password).withCreatedBy(this.createdBy).withReason(this.reason).withComment(this.comment).withTenantApiKey(this.tenantApiKey).withTenantApiSecret(this.tenantApiSecret).withQueryParams((Multimap<String, String>)this.queryParams).withFollowLocation(this.followLocation).withQueryParamsForFollow(this.queryParamsForFollow);
    }

    public static RequestOptionsBuilder builder() {
        return new RequestOptionsBuilder();
    }

    public static RequestOptions empty() {
        return new RequestOptionsBuilder().build();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RequestOptionsBuilder {
        private String requestId;
        private String user;
        private String password;
        private String createdBy;
        private String reason;
        private String comment;
        private String tenantApiKey;
        private String tenantApiSecret;
        private final Map<String, String> headers = new HashMap<String, String>();
        private Multimap<String, String> queryParams = HashMultimap.create();
        private Boolean followLocation;
        private Multimap<String, String> queryParamsForFollow = HashMultimap.create();

        public RequestOptionsBuilder withRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public RequestOptionsBuilder withUser(String user) {
            this.user = user;
            return this;
        }

        public RequestOptionsBuilder withPassword(String password) {
            this.password = password;
            return this;
        }

        public RequestOptionsBuilder withCreatedBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public RequestOptionsBuilder withReason(String reason) {
            this.reason = reason;
            return this;
        }

        public RequestOptionsBuilder withComment(String comment) {
            this.comment = comment;
            return this;
        }

        public RequestOptionsBuilder withTenantApiKey(String tenantApiKey) {
            this.tenantApiKey = tenantApiKey;
            return this;
        }

        public RequestOptionsBuilder withTenantApiSecret(String tenantApiSecret) {
            this.tenantApiSecret = tenantApiSecret;
            return this;
        }

        public RequestOptionsBuilder withHeader(String header, String value) {
            this.headers.put(header, value);
            return this;
        }

        public RequestOptionsBuilder withQueryParams(Multimap<String, String> queryParams) {
            this.queryParams = queryParams;
            return this;
        }

        public RequestOptionsBuilder withFollowLocation(Boolean followLocation) {
            this.followLocation = followLocation;
            return this;
        }

        public RequestOptionsBuilder withQueryParamsForFollow(Multimap<String, String> queryParamsForFollow) {
            this.queryParamsForFollow = queryParamsForFollow;
            return this;
        }

        public RequestOptions build() {
            return new RequestOptions(this.requestId, this.user, this.password, this.createdBy, this.reason, this.comment, this.tenantApiKey, this.tenantApiSecret, this.headers, this.queryParams, this.followLocation, this.queryParamsForFollow);
        }
    }
}

