/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.client;

import com.google.common.base.MoreObjects;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SslUtils {
    private static final String TLS_PROTOCOL_DEFAULT = "TLSv1.2";
    private final SSLContext looseTrustManagerSSLContext = this.looseTrustManagerSSLContext();
    private SSLContext context;

    public static SslUtils getInstance() {
        return SingletonHolder.instance;
    }

    private SSLContext looseTrustManagerSSLContext() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{new LooseTrustManager()}, new SecureRandom());
            return sslContext;
        }
        catch (NoSuchAlgorithmException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (KeyManagementException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public SSLContext getSSLContext(boolean acceptAnyCertificate, @Nullable String protocol) throws GeneralSecurityException {
        if (acceptAnyCertificate) {
            return this.looseTrustManagerSSLContext;
        }
        if (this.context == null) {
            this.context = SSLContext.getInstance((String)MoreObjects.firstNonNull((Object)protocol, (Object)TLS_PROTOCOL_DEFAULT));
            this.context.init(null, null, null);
        }
        return this.context;
    }

    private static class SingletonHolder {
        static final SslUtils instance = new SslUtils();

        private SingletonHolder() {
        }
    }

    private static class LooseTrustManager
    implements X509TrustManager {
        private LooseTrustManager() {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }
}

