/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.killbill.billing.client.model.AuditLog;
import org.killbill.billing.client.model.KillBillObject;
import org.killbill.billing.entitlement.api.BlockingStateType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockingState
extends KillBillObject {
    private UUID blockedId;
    private String stateName;
    private String service;
    private Boolean blockChange;
    private Boolean blockEntitlement;
    private Boolean blockBilling;
    private DateTime effectiveDate;
    private BlockingStateType type;

    public BlockingState() {
    }

    @JsonCreator
    public BlockingState(@JsonProperty(value="blockedId") UUID blockedId, @JsonProperty(value="stateName") String stateName, @JsonProperty(value="service") String service, @JsonProperty(value="blockChange") Boolean blockChange, @JsonProperty(value="blockEntitlement") Boolean blockEntitlement, @JsonProperty(value="blockBilling") Boolean blockBilling, @JsonProperty(value="effectiveDate") DateTime effectiveDate, @JsonProperty(value="type") BlockingStateType type, @JsonProperty(value="auditLogs") @Nullable List<AuditLog> auditLogs) {
        super(auditLogs);
        this.blockedId = blockedId;
        this.stateName = stateName;
        this.service = service;
        this.blockChange = blockChange;
        this.blockEntitlement = blockEntitlement;
        this.blockBilling = blockBilling;
        this.effectiveDate = effectiveDate;
        this.type = type;
    }

    public UUID getBlockedId() {
        return this.blockedId;
    }

    public void setBlockedId(UUID blockedId) {
        this.blockedId = blockedId;
    }

    public String getStateName() {
        return this.stateName;
    }

    public void setStateName(String stateName) {
        this.stateName = stateName;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public Boolean getBlockChange() {
        return this.blockChange;
    }

    public void setBlockChange(Boolean blockChange) {
        this.blockChange = blockChange;
    }

    public Boolean getBlockEntitlement() {
        return this.blockEntitlement;
    }

    public void setBlockEntitlement(Boolean blockEntitlement) {
        this.blockEntitlement = blockEntitlement;
    }

    public Boolean getBlockBilling() {
        return this.blockBilling;
    }

    public void setBlockBilling(Boolean blockBilling) {
        this.blockBilling = blockBilling;
    }

    public DateTime getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(DateTime effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public BlockingStateType getType() {
        return this.type;
    }

    public void setType(BlockingStateType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockingState)) {
            return false;
        }
        BlockingState that = (BlockingState)o;
        if (this.blockedId != null ? !this.blockedId.equals(that.blockedId) : that.blockedId != null) {
            return false;
        }
        if (this.stateName != null ? !this.stateName.equals(that.stateName) : that.stateName != null) {
            return false;
        }
        if (this.service != null ? !this.service.equals(that.service) : that.service != null) {
            return false;
        }
        if (this.blockChange != null ? !this.blockChange.equals(that.blockChange) : that.blockChange != null) {
            return false;
        }
        if (this.blockEntitlement != null ? !this.blockEntitlement.equals(that.blockEntitlement) : that.blockEntitlement != null) {
            return false;
        }
        if (this.blockBilling != null ? !this.blockBilling.equals(that.blockBilling) : that.blockBilling != null) {
            return false;
        }
        if (this.effectiveDate != null ? this.effectiveDate.compareTo((ReadableInstant)that.effectiveDate) != 0 : that.effectiveDate != null) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.blockedId != null ? this.blockedId.hashCode() : 0;
        result = 31 * result + (this.stateName != null ? this.stateName.hashCode() : 0);
        result = 31 * result + (this.service != null ? this.service.hashCode() : 0);
        result = 31 * result + (this.blockChange != null ? this.blockChange.hashCode() : 0);
        result = 31 * result + (this.blockEntitlement != null ? this.blockEntitlement.hashCode() : 0);
        result = 31 * result + (this.blockBilling != null ? this.blockBilling.hashCode() : 0);
        result = 31 * result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "BlockingState{blockedId=" + this.blockedId + ", stateName='" + this.stateName + '\'' + ", service='" + this.service + '\'' + ", blockChange=" + this.blockChange + ", blockEntitlement=" + this.blockEntitlement + ", blockBilling=" + this.blockBilling + ", effectiveDate=" + this.effectiveDate + ", type=" + this.type + '}';
    }
}

