/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.killbill.billing.client.model.AuditLog;
import org.killbill.billing.client.model.KillBillObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Credit
extends KillBillObject {
    private BigDecimal creditAmount;
    private UUID invoiceId;
    private String invoiceNumber;
    private LocalDate effectiveDate;
    private UUID accountId;
    private String description;
    private String currency;

    public Credit() {
    }

    @JsonCreator
    public Credit(@JsonProperty(value="creditAmount") BigDecimal creditAmount, @JsonProperty(value="currency") String currency, @JsonProperty(value="invoiceId") UUID invoiceId, @JsonProperty(value="invoiceNumber") String invoiceNumber, @JsonProperty(value="effectiveDate") LocalDate effectiveDate, @JsonProperty(value="accountId") UUID accountId, @JsonProperty(value="description") String description, @JsonProperty(value="auditLogs") @Nullable List<AuditLog> auditLogs) {
        super(auditLogs);
        this.creditAmount = creditAmount;
        this.currency = currency;
        this.invoiceId = invoiceId;
        this.invoiceNumber = invoiceNumber;
        this.effectiveDate = effectiveDate;
        this.description = description;
        this.accountId = accountId;
    }

    public BigDecimal getCreditAmount() {
        return this.creditAmount;
    }

    public void setCreditAmount(BigDecimal creditAmount) {
        this.creditAmount = creditAmount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public UUID getInvoiceId() {
        return this.invoiceId;
    }

    public void setInvoiceId(UUID invoiceId) {
        this.invoiceId = invoiceId;
    }

    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    public LocalDate getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(LocalDate effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public UUID getAccountId() {
        return this.accountId;
    }

    public void setAccountId(UUID accountId) {
        this.accountId = accountId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Credit{");
        sb.append("creditAmount=").append(this.creditAmount);
        sb.append("currency=").append(this.currency);
        sb.append(", invoiceId='").append(this.invoiceId).append('\'');
        sb.append(", invoiceNumber='").append(this.invoiceNumber).append('\'');
        sb.append(", effectiveDate=").append(this.effectiveDate);
        sb.append(", description=").append(this.description);
        sb.append(", accountId='").append(this.accountId).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Credit credit = (Credit)o;
        if (this.accountId != null ? !this.accountId.equals(credit.accountId) : credit.accountId != null) {
            return false;
        }
        if (this.creditAmount != null ? this.creditAmount.compareTo(credit.creditAmount) != 0 : credit.creditAmount != null) {
            return false;
        }
        if (this.currency != null ? !this.currency.equals(credit.currency) : credit.currency != null) {
            return false;
        }
        if (this.effectiveDate != null ? this.effectiveDate.compareTo((ReadablePartial)credit.effectiveDate) != 0 : credit.effectiveDate != null) {
            return false;
        }
        if (this.invoiceId != null ? !this.invoiceId.equals(credit.invoiceId) : credit.invoiceId != null) {
            return false;
        }
        if (this.invoiceNumber != null ? !this.invoiceNumber.equals(credit.invoiceNumber) : credit.invoiceNumber != null) {
            return false;
        }
        return !(this.description != null ? !this.description.equals(credit.description) : credit.description != null);
    }

    public int hashCode() {
        int result = this.creditAmount != null ? this.creditAmount.hashCode() : 0;
        result = 31 * result + (this.currency != null ? this.currency.hashCode() : 0);
        result = 31 * result + (this.invoiceId != null ? this.invoiceId.hashCode() : 0);
        result = 31 * result + (this.invoiceNumber != null ? this.invoiceNumber.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
        result = 31 * result + (this.accountId != null ? this.accountId.hashCode() : 0);
        return result;
    }
}

