/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.client.model.AuditLog;
import org.killbill.billing.client.model.Credit;
import org.killbill.billing.client.model.InvoiceItem;
import org.killbill.billing.client.model.KillBillObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Invoice
extends KillBillObject {
    private BigDecimal amount;
    private Currency currency;
    private UUID invoiceId;
    private LocalDate invoiceDate;
    private LocalDate targetDate;
    private Integer invoiceNumber;
    private BigDecimal balance;
    private BigDecimal creditAdj;
    private BigDecimal refundAdj;
    private UUID accountId;
    private List<InvoiceItem> items;
    private String bundleKeys;
    private List<Credit> credits;
    private String status;
    private Boolean isParentInvoice;

    public Invoice() {
    }

    @JsonCreator
    public Invoice(@JsonProperty(value="amount") BigDecimal amount, @JsonProperty(value="currency") Currency currency, @JsonProperty(value="creditAdj") BigDecimal creditAdj, @JsonProperty(value="refundAdj") BigDecimal refundAdj, @JsonProperty(value="invoiceId") UUID invoiceId, @JsonProperty(value="invoiceDate") LocalDate invoiceDate, @JsonProperty(value="targetDate") LocalDate targetDate, @JsonProperty(value="invoiceNumber") Integer invoiceNumber, @JsonProperty(value="balance") BigDecimal balance, @JsonProperty(value="accountId") UUID accountId, @JsonProperty(value="bundleKeys") String bundleKeys, @JsonProperty(value="status") String status, @JsonProperty(value="credits") List<Credit> credits, @JsonProperty(value="items") List<InvoiceItem> items, @JsonProperty(value="isParentInvoice") Boolean isParentInvoice, @JsonProperty(value="auditLogs") @Nullable List<AuditLog> auditLogs) {
        super(auditLogs);
        this.amount = amount;
        this.currency = currency;
        this.creditAdj = creditAdj;
        this.refundAdj = refundAdj;
        this.invoiceId = invoiceId;
        this.invoiceDate = invoiceDate;
        this.targetDate = targetDate;
        this.invoiceNumber = invoiceNumber;
        this.balance = balance;
        this.accountId = accountId;
        this.bundleKeys = bundleKeys;
        this.credits = credits;
        this.items = items;
        this.status = status;
        this.isParentInvoice = isParentInvoice;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public UUID getInvoiceId() {
        return this.invoiceId;
    }

    public void setInvoiceId(UUID invoiceId) {
        this.invoiceId = invoiceId;
    }

    public LocalDate getInvoiceDate() {
        return this.invoiceDate;
    }

    public void setInvoiceDate(LocalDate invoiceDate) {
        this.invoiceDate = invoiceDate;
    }

    public LocalDate getTargetDate() {
        return this.targetDate;
    }

    public void setTargetDate(LocalDate targetDate) {
        this.targetDate = targetDate;
    }

    public Integer getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public void setInvoiceNumber(Integer invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    public BigDecimal getBalance() {
        return this.balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public BigDecimal getCreditAdj() {
        return this.creditAdj;
    }

    public void setCreditAdj(BigDecimal creditAdj) {
        this.creditAdj = creditAdj;
    }

    public BigDecimal getRefundAdj() {
        return this.refundAdj;
    }

    public void setRefundAdj(BigDecimal refundAdj) {
        this.refundAdj = refundAdj;
    }

    public UUID getAccountId() {
        return this.accountId;
    }

    public void setAccountId(UUID accountId) {
        this.accountId = accountId;
    }

    public List<InvoiceItem> getItems() {
        return this.items;
    }

    public void setItems(List<InvoiceItem> items) {
        this.items = items;
    }

    public String getBundleKeys() {
        return this.bundleKeys;
    }

    public void setBundleKeys(String bundleKeys) {
        this.bundleKeys = bundleKeys;
    }

    public List<Credit> getCredits() {
        return this.credits;
    }

    public void setCredits(List<Credit> credits) {
        this.credits = credits;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Boolean getIsParentInvoice() {
        return this.isParentInvoice;
    }

    public void setIsParentInvoice(Boolean isParentInvoice) {
        this.isParentInvoice = isParentInvoice;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Invoice{");
        sb.append("amount=").append(this.amount);
        sb.append(", currency='").append(this.currency).append('\'');
        sb.append(", invoiceId='").append(this.invoiceId).append('\'');
        sb.append(", invoiceDate=").append(this.invoiceDate);
        sb.append(", targetDate=").append(this.targetDate);
        sb.append(", invoiceNumber='").append(this.invoiceNumber).append('\'');
        sb.append(", balance=").append(this.balance);
        sb.append(", creditAdj=").append(this.creditAdj);
        sb.append(", refundAdj=").append(this.refundAdj);
        sb.append(", accountId='").append(this.accountId).append('\'');
        sb.append(", items=").append(this.items);
        sb.append(", bundleKeys='").append(this.bundleKeys).append('\'');
        sb.append(", credits=").append(this.credits);
        sb.append(", status=").append(this.status);
        sb.append(", isParentInvoice=").append(this.isParentInvoice);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Invoice invoice = (Invoice)o;
        if (this.accountId != null ? !this.accountId.equals(invoice.accountId) : invoice.accountId != null) {
            return false;
        }
        if (this.amount != null ? this.amount.compareTo(invoice.amount) != 0 : invoice.amount != null) {
            return false;
        }
        if (this.balance != null ? this.balance.compareTo(invoice.balance) != 0 : invoice.balance != null) {
            return false;
        }
        if (this.bundleKeys != null ? !this.bundleKeys.equals(invoice.bundleKeys) : invoice.bundleKeys != null) {
            return false;
        }
        if (this.creditAdj != null ? this.creditAdj.compareTo(invoice.creditAdj) != 0 : invoice.creditAdj != null) {
            return false;
        }
        if (this.credits != null ? !this.credits.equals(invoice.credits) : invoice.credits != null) {
            return false;
        }
        if (this.currency != null ? !this.currency.equals((Object)invoice.currency) : invoice.currency != null) {
            return false;
        }
        if (this.invoiceDate != null ? this.invoiceDate.compareTo((ReadablePartial)invoice.invoiceDate) != 0 : invoice.invoiceDate != null) {
            return false;
        }
        if (this.invoiceId != null ? !this.invoiceId.equals(invoice.invoiceId) : invoice.invoiceId != null) {
            return false;
        }
        if (this.invoiceNumber != null ? !this.invoiceNumber.equals(invoice.invoiceNumber) : invoice.invoiceNumber != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(invoice.items) : invoice.items != null) {
            return false;
        }
        if (this.refundAdj != null ? this.refundAdj.compareTo(invoice.refundAdj) != 0 : invoice.refundAdj != null) {
            return false;
        }
        if (this.targetDate != null ? this.targetDate.compareTo((ReadablePartial)invoice.targetDate) != 0 : invoice.targetDate != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(invoice.status) : invoice.status != null) {
            return false;
        }
        return !(this.isParentInvoice != null ? !this.isParentInvoice.equals(invoice.isParentInvoice) : invoice.isParentInvoice != null);
    }

    public int hashCode() {
        int result = this.amount != null ? this.amount.hashCode() : 0;
        result = 31 * result + (this.currency != null ? this.currency.hashCode() : 0);
        result = 31 * result + (this.invoiceId != null ? this.invoiceId.hashCode() : 0);
        result = 31 * result + (this.invoiceDate != null ? this.invoiceDate.hashCode() : 0);
        result = 31 * result + (this.targetDate != null ? this.targetDate.hashCode() : 0);
        result = 31 * result + (this.invoiceNumber != null ? this.invoiceNumber.hashCode() : 0);
        result = 31 * result + (this.balance != null ? this.balance.hashCode() : 0);
        result = 31 * result + (this.creditAdj != null ? this.creditAdj.hashCode() : 0);
        result = 31 * result + (this.refundAdj != null ? this.refundAdj.hashCode() : 0);
        result = 31 * result + (this.accountId != null ? this.accountId.hashCode() : 0);
        result = 31 * result + (this.items != null ? this.items.hashCode() : 0);
        result = 31 * result + (this.bundleKeys != null ? this.bundleKeys.hashCode() : 0);
        result = 31 * result + (this.credits != null ? this.credits.hashCode() : 0);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.isParentInvoice != null ? this.isParentInvoice.hashCode() : 0);
        return result;
    }
}

