/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.killbill.billing.client.model.AuditLog;
import org.killbill.billing.client.model.KillBillObject;
import org.killbill.billing.client.model.PluginProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaymentAttempt
extends KillBillObject {
    private UUID accountId;
    private UUID paymentMethodId;
    private String paymentExternalKey;
    private UUID transactionId;
    private String transactionExternalKey;
    private String transactionType;
    private DateTime effectiveDate;
    private String stateName;
    private BigDecimal amount;
    private String currency;
    private String pluginName;
    private List<PluginProperty> pluginProperties;

    public PaymentAttempt() {
    }

    @JsonCreator
    public PaymentAttempt(@JsonProperty(value="accountId") UUID accountId, @JsonProperty(value="paymentMethodId") UUID paymentMethodId, @JsonProperty(value="paymentExternalKey") String paymentExternalKey, @JsonProperty(value="transactionId") UUID transactionId, @JsonProperty(value="transactionExternalKey") String transactionExternalKey, @JsonProperty(value="transactionType") String transactionType, @JsonProperty(value="effectiveDate") DateTime effectiveDate, @JsonProperty(value="stateName") String stateName, @JsonProperty(value="amount") BigDecimal amount, @JsonProperty(value="currency") String currency, @JsonProperty(value="pluginName") String pluginName, @JsonProperty(value="pluginProperties") @Nullable List<PluginProperty> pluginProperties, @JsonProperty(value="auditLogs") @Nullable List<AuditLog> auditLogs) {
        super(auditLogs);
        this.accountId = accountId;
        this.paymentMethodId = paymentMethodId;
        this.paymentExternalKey = paymentExternalKey;
        this.transactionId = transactionId;
        this.transactionExternalKey = transactionExternalKey;
        this.transactionType = transactionType;
        this.effectiveDate = effectiveDate;
        this.stateName = stateName;
        this.amount = amount;
        this.currency = currency;
        this.pluginName = pluginName;
        this.setPluginProperties(pluginProperties);
    }

    public UUID getAccountId() {
        return this.accountId;
    }

    public void setAccountId(UUID accountId) {
        this.accountId = accountId;
    }

    public UUID getPaymentMethodId() {
        return this.paymentMethodId;
    }

    public void setPaymentMethodId(UUID paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
    }

    public String getPaymentExternalKey() {
        return this.paymentExternalKey;
    }

    public void setPaymentExternalKey(String paymentExternalKey) {
        this.paymentExternalKey = paymentExternalKey;
    }

    public UUID getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(UUID transactionId) {
        this.transactionId = transactionId;
    }

    public String getTransactionExternalKey() {
        return this.transactionExternalKey;
    }

    public void setTransactionExternalKey(String transactionExternalKey) {
        this.transactionExternalKey = transactionExternalKey;
    }

    public String getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType;
    }

    public DateTime getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(DateTime effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public String getStateName() {
        return this.stateName;
    }

    public void setStateName(String stateName) {
        this.stateName = stateName;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public List<PluginProperty> getPluginProperties() {
        return this.pluginProperties;
    }

    public void setPluginProperties(List<PluginProperty> pluginProperties) {
        if (pluginProperties != null) {
            this.pluginProperties = pluginProperties;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PaymentAttempt{");
        sb.append("accountId=").append(this.accountId);
        sb.append(", paymentMethodId='").append(this.paymentMethodId).append('\'');
        sb.append(", paymentExternalKey='").append(this.paymentExternalKey).append('\'');
        sb.append(", transactionId='").append(this.transactionId).append('\'');
        sb.append(", transactionExternalKey='").append(this.transactionExternalKey).append('\'');
        sb.append(", transactionType='").append(this.transactionType).append('\'');
        sb.append(", effectiveDate=").append(this.effectiveDate);
        sb.append(", stateName='").append(this.stateName).append('\'');
        sb.append(", amount=").append(this.amount);
        sb.append(", currency='").append(this.currency).append('\'');
        sb.append(", pluginName='").append(this.pluginName).append('\'');
        sb.append(", pluginProperties='").append(this.pluginProperties).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentAttempt that = (PaymentAttempt)o;
        if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) {
            return false;
        }
        if (this.paymentMethodId != null ? !this.paymentMethodId.equals(that.paymentMethodId) : that.paymentMethodId != null) {
            return false;
        }
        if (this.paymentExternalKey != null ? !this.paymentExternalKey.equals(that.paymentExternalKey) : that.paymentExternalKey != null) {
            return false;
        }
        if (this.transactionId != null ? !this.transactionId.equals(that.transactionId) : that.transactionId != null) {
            return false;
        }
        if (this.transactionExternalKey != null ? !this.transactionExternalKey.equals(that.transactionExternalKey) : that.transactionExternalKey != null) {
            return false;
        }
        if (this.transactionType != null ? !this.transactionType.equals(that.transactionType) : that.transactionType != null) {
            return false;
        }
        if (this.effectiveDate != null ? this.effectiveDate.compareTo((ReadableInstant)that.effectiveDate) != 0 : that.effectiveDate != null) {
            return false;
        }
        if (this.stateName != null ? !this.stateName.equals(that.stateName) : that.stateName != null) {
            return false;
        }
        if (this.amount != null ? this.amount.compareTo(that.amount) != 0 : that.amount != null) {
            return false;
        }
        if (this.currency != null ? !this.currency.equals(that.currency) : that.currency != null) {
            return false;
        }
        if (this.pluginName != null ? !this.pluginName.equals(that.pluginName) : that.pluginName != null) {
            return false;
        }
        return !(this.pluginProperties != null ? !this.pluginProperties.equals(that.pluginProperties) : that.pluginProperties != null);
    }

    public int hashCode() {
        int result = this.accountId != null ? this.accountId.hashCode() : 0;
        result = 31 * result + (this.paymentMethodId != null ? this.paymentMethodId.hashCode() : 0);
        result = 31 * result + (this.paymentExternalKey != null ? this.paymentExternalKey.hashCode() : 0);
        result = 31 * result + (this.transactionId != null ? this.transactionId.hashCode() : 0);
        result = 31 * result + (this.transactionExternalKey != null ? this.transactionExternalKey.hashCode() : 0);
        result = 31 * result + (this.transactionType != null ? this.transactionType.hashCode() : 0);
        result = 31 * result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
        result = 31 * result + (this.stateName != null ? this.stateName.hashCode() : 0);
        result = 31 * result + (this.amount != null ? this.amount.hashCode() : 0);
        result = 31 * result + (this.currency != null ? this.currency.hashCode() : 0);
        result = 31 * result + (this.pluginName != null ? this.pluginName.hashCode() : 0);
        result = 31 * result + (this.pluginProperties != null ? this.pluginProperties.hashCode() : 0);
        return result;
    }
}

