/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import javax.annotation.Nullable;

public class PhasePriceOverride {
    private final String planName;
    private final String phaseName;
    private final String phaseType;
    private final BigDecimal fixedPrice;
    private final BigDecimal recurringPrice;

    @JsonCreator
    public PhasePriceOverride(@JsonProperty(value="planName") String planName, @JsonProperty(value="phaseName") String phaseName, @JsonProperty(value="phaseType") String phaseType, @Nullable @JsonProperty(value="fixedPrice") BigDecimal fixedPrice, @Nullable @JsonProperty(value="recurringPrice") BigDecimal recurringPrice) {
        this.planName = planName;
        this.phaseName = phaseName;
        this.phaseType = phaseType;
        this.fixedPrice = fixedPrice;
        this.recurringPrice = recurringPrice;
    }

    public String getPlanName() {
        return this.planName;
    }

    public String getPhaseName() {
        return this.phaseName;
    }

    public String getPhaseType() {
        return this.phaseType;
    }

    public BigDecimal getFixedPrice() {
        return this.fixedPrice;
    }

    public BigDecimal getRecurringPrice() {
        return this.recurringPrice;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PhasePriceOverride)) {
            return false;
        }
        PhasePriceOverride that = (PhasePriceOverride)o;
        if (this.planName != null ? !this.planName.equals(that.planName) : that.planName != null) {
            return false;
        }
        if (this.phaseName != null ? !this.phaseName.equals(that.phaseName) : that.phaseName != null) {
            return false;
        }
        if (this.phaseType != null ? !this.phaseType.equals(that.phaseType) : that.phaseType != null) {
            return false;
        }
        if (this.fixedPrice != null ? this.fixedPrice.compareTo(that.fixedPrice) != 0 : that.fixedPrice != null) {
            return false;
        }
        return !(this.recurringPrice != null ? this.recurringPrice.compareTo(that.recurringPrice) != 0 : that.recurringPrice != null);
    }

    public int hashCode() {
        int result = this.phaseName != null ? this.phaseName.hashCode() : 0;
        result = 31 * result + (this.planName != null ? this.planName.hashCode() : 0);
        result = 31 * result + (this.phaseType != null ? this.phaseType.hashCode() : 0);
        result = 31 * result + (this.fixedPrice != null ? this.fixedPrice.hashCode() : 0);
        result = 31 * result + (this.recurringPrice != null ? this.recurringPrice.hashCode() : 0);
        return result;
    }
}

