/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.List;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.ProductCategory;
import org.killbill.billing.catalog.api.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplePlan {
    private final String planId;
    private final String productName;
    private final ProductCategory productCategory;
    private final Currency currency;
    private final BigDecimal amount;
    private final BillingPeriod billingPeriod;
    private final Integer trialLength;
    private final TimeUnit trialTimeUnit;
    private final List<String> availableBaseProducts;

    @JsonCreator
    public SimplePlan(@JsonProperty(value="planId") String planId, @JsonProperty(value="productName") String productName, @JsonProperty(value="productCategory") ProductCategory productCategory, @JsonProperty(value="currency") Currency currency, @JsonProperty(value="amount") BigDecimal amount, @JsonProperty(value="billingPeriod") BillingPeriod billingPeriod, @JsonProperty(value="trialLength") Integer trialLength, @JsonProperty(value="trialTimeUnit") TimeUnit trialTimeUnit, @JsonProperty(value="availableBaseProducts") List<String> availableBaseProducts) {
        this.planId = planId;
        this.productName = productName;
        this.productCategory = productCategory;
        this.currency = currency;
        this.amount = amount;
        this.billingPeriod = billingPeriod;
        this.trialLength = trialLength;
        this.trialTimeUnit = trialTimeUnit;
        this.availableBaseProducts = availableBaseProducts;
    }

    public String getPlanId() {
        return this.planId;
    }

    public String getProductName() {
        return this.productName;
    }

    public ProductCategory getProductCategory() {
        return this.productCategory;
    }

    public List<String> getAvailableBaseProducts() {
        return this.availableBaseProducts;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public BillingPeriod getBillingPeriod() {
        return this.billingPeriod;
    }

    public Integer getTrialLength() {
        return this.trialLength;
    }

    public TimeUnit getTrialTimeUnit() {
        return this.trialTimeUnit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimplePlan)) {
            return false;
        }
        SimplePlan that = (SimplePlan)o;
        if (this.planId != null ? !this.planId.equals(that.planId) : that.planId != null) {
            return false;
        }
        if (this.productName != null ? !this.productName.equals(that.productName) : that.productName != null) {
            return false;
        }
        if (this.productCategory != null ? !this.productCategory.equals((Object)that.productCategory) : that.productCategory != null) {
            return false;
        }
        if (this.currency != that.currency) {
            return false;
        }
        if (this.amount != null ? this.amount.compareTo(that.amount) != 0 : that.amount != null) {
            return false;
        }
        if (this.billingPeriod != that.billingPeriod) {
            return false;
        }
        if (this.trialLength != null ? !this.trialLength.equals(that.trialLength) : that.trialLength != null) {
            return false;
        }
        if (this.availableBaseProducts != null ? !this.availableBaseProducts.equals(that.availableBaseProducts) : that.availableBaseProducts != null) {
            return false;
        }
        return this.trialTimeUnit == that.trialTimeUnit;
    }

    public int hashCode() {
        int result = this.planId != null ? this.planId.hashCode() : 0;
        result = 31 * result + (this.productName != null ? this.productName.hashCode() : 0);
        result = 31 * result + (this.productCategory != null ? this.productCategory.hashCode() : 0);
        result = 31 * result + (this.currency != null ? this.currency.hashCode() : 0);
        result = 31 * result + (this.amount != null ? this.amount.hashCode() : 0);
        result = 31 * result + (this.billingPeriod != null ? this.billingPeriod.hashCode() : 0);
        result = 31 * result + (this.trialLength != null ? this.trialLength.hashCode() : 0);
        result = 31 * result + (this.trialTimeUnit != null ? this.trialTimeUnit.hashCode() : 0);
        result = 31 * result + (this.availableBaseProducts != null ? this.availableBaseProducts.hashCode() : 0);
        return result;
    }
}

