/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.PhaseType;
import org.killbill.billing.catalog.api.ProductCategory;
import org.killbill.billing.client.model.AuditLog;
import org.killbill.billing.client.model.EventSubscription;
import org.killbill.billing.client.model.KillBillObject;
import org.killbill.billing.client.model.PhasePriceOverride;
import org.killbill.billing.entitlement.api.Entitlement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Subscription
extends KillBillObject {
    private UUID accountId;
    private UUID bundleId;
    private UUID subscriptionId;
    private String externalKey;
    private LocalDate startDate;
    private String productName;
    private ProductCategory productCategory;
    private BillingPeriod billingPeriod;
    private PhaseType phaseType;
    private String priceList;
    private String planName;
    private Entitlement.EntitlementState state;
    private Entitlement.EntitlementSourceType sourceType;
    private LocalDate cancelledDate;
    private LocalDate chargedThroughDate;
    private LocalDate billingStartDate;
    private LocalDate billingEndDate;
    private Integer billCycleDayLocal;
    private List<EventSubscription> events;
    private List<PhasePriceOverride> priceOverrides;

    public Subscription() {
    }

    @JsonCreator
    public Subscription(@JsonProperty(value="accountId") @Nullable UUID accountId, @JsonProperty(value="bundleId") @Nullable UUID bundleId, @JsonProperty(value="subscriptionId") @Nullable UUID subscriptionId, @JsonProperty(value="externalKey") @Nullable String externalKey, @JsonProperty(value="startDate") @Nullable LocalDate startDate, @JsonProperty(value="productName") @Nullable String productName, @JsonProperty(value="productCategory") @Nullable ProductCategory productCategory, @JsonProperty(value="billingPeriod") @Nullable BillingPeriod billingPeriod, @JsonProperty(value="phaseType") @Nullable PhaseType phaseType, @JsonProperty(value="priceList") @Nullable String priceList, @JsonProperty(value="planName") @Nullable String planName, @JsonProperty(value="state") @Nullable Entitlement.EntitlementState state, @JsonProperty(value="sourceType") @Nullable Entitlement.EntitlementSourceType sourceType, @JsonProperty(value="cancelledDate") @Nullable LocalDate cancelledDate, @JsonProperty(value="chargedThroughDate") @Nullable LocalDate chargedThroughDate, @JsonProperty(value="billingStartDate") @Nullable LocalDate billingStartDate, @JsonProperty(value="billingEndDate") @Nullable LocalDate billingEndDate, @JsonProperty(value="billCycleDayLocal") @Nullable Integer billCycleDayLocal, @JsonProperty(value="events") @Nullable List<EventSubscription> events, @JsonProperty(value="priceOverrides") @Nullable List<PhasePriceOverride> priceOverrides, @JsonProperty(value="auditLogs") @Nullable List<AuditLog> auditLogs) {
        super(auditLogs);
        this.startDate = startDate;
        this.productName = productName;
        this.productCategory = productCategory;
        this.billingPeriod = billingPeriod;
        this.phaseType = phaseType;
        this.priceList = priceList;
        this.planName = planName;
        this.state = state;
        this.sourceType = sourceType;
        this.cancelledDate = cancelledDate;
        this.chargedThroughDate = chargedThroughDate;
        this.billingStartDate = billingStartDate;
        this.billingEndDate = billingEndDate;
        this.billCycleDayLocal = billCycleDayLocal;
        this.accountId = accountId;
        this.bundleId = bundleId;
        this.subscriptionId = subscriptionId;
        this.externalKey = externalKey;
        this.events = events;
        this.priceOverrides = priceOverrides;
    }

    public UUID getAccountId() {
        return this.accountId;
    }

    public void setAccountId(UUID accountId) {
        this.accountId = accountId;
    }

    public UUID getBundleId() {
        return this.bundleId;
    }

    public void setBundleId(UUID bundleId) {
        this.bundleId = bundleId;
    }

    public UUID getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setSubscriptionId(UUID subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public String getExternalKey() {
        return this.externalKey;
    }

    public void setExternalKey(String externalKey) {
        this.externalKey = externalKey;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public ProductCategory getProductCategory() {
        return this.productCategory;
    }

    public void setProductCategory(ProductCategory productCategory) {
        this.productCategory = productCategory;
    }

    public BillingPeriod getBillingPeriod() {
        return this.billingPeriod;
    }

    public void setBillingPeriod(BillingPeriod billingPeriod) {
        this.billingPeriod = billingPeriod;
    }

    public PhaseType getPhaseType() {
        return this.phaseType;
    }

    public void setPhaseType(PhaseType phaseType) {
        this.phaseType = phaseType;
    }

    public String getPriceList() {
        return this.priceList;
    }

    public void setPriceList(String priceList) {
        this.priceList = priceList;
    }

    public String getPlanName() {
        return this.planName;
    }

    public void setPlanName(String planName) {
        this.planName = planName;
    }

    public Entitlement.EntitlementState getState() {
        return this.state;
    }

    public void setState(Entitlement.EntitlementState state) {
        this.state = state;
    }

    public Entitlement.EntitlementSourceType getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(Entitlement.EntitlementSourceType sourceType) {
        this.sourceType = sourceType;
    }

    public LocalDate getCancelledDate() {
        return this.cancelledDate;
    }

    public void setCancelledDate(LocalDate cancelledDate) {
        this.cancelledDate = cancelledDate;
    }

    public LocalDate getChargedThroughDate() {
        return this.chargedThroughDate;
    }

    public void setChargedThroughDate(LocalDate chargedThroughDate) {
        this.chargedThroughDate = chargedThroughDate;
    }

    public LocalDate getBillingStartDate() {
        return this.billingStartDate;
    }

    public void setBillingStartDate(LocalDate billingStartDate) {
        this.billingStartDate = billingStartDate;
    }

    public LocalDate getBillingEndDate() {
        return this.billingEndDate;
    }

    public void setBillingEndDate(LocalDate billingEndDate) {
        this.billingEndDate = billingEndDate;
    }

    public List<EventSubscription> getEvents() {
        return this.events;
    }

    public void setEvents(List<EventSubscription> events) {
        this.events = events;
    }

    public List<PhasePriceOverride> getPriceOverrides() {
        return this.priceOverrides;
    }

    public void setPriceOverrides(List<PhasePriceOverride> priceOverrides) {
        this.priceOverrides = priceOverrides;
    }

    public Integer getBillCycleDayLocal() {
        return this.billCycleDayLocal;
    }

    public void setBillCycleDayLocal(Integer billCycleDayLocal) {
        this.billCycleDayLocal = billCycleDayLocal;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Subscription{");
        sb.append("accountId=").append(this.accountId);
        sb.append(", bundleId=").append(this.bundleId);
        sb.append(", subscriptionId=").append(this.subscriptionId);
        sb.append(", externalKey='").append(this.externalKey).append('\'');
        sb.append(", startDate=").append(this.startDate);
        sb.append(", productName='").append(this.productName).append('\'');
        sb.append(", productCategory=").append(this.productCategory);
        sb.append(", billingPeriod=").append(this.billingPeriod);
        sb.append(", phaseType=").append(this.phaseType);
        sb.append(", priceList='").append(this.priceList).append('\'');
        sb.append(", planName='").append(this.planName).append('\'');
        sb.append(", state=").append(this.state);
        sb.append(", sourceType=").append(this.sourceType);
        sb.append(", cancelledDate=").append(this.cancelledDate);
        sb.append(", chargedThroughDate=").append(this.chargedThroughDate);
        sb.append(", billingStartDate=").append(this.billingStartDate);
        sb.append(", billingEndDate=").append(this.billingEndDate);
        sb.append(", billCycleDayLocal=").append(this.billCycleDayLocal);
        sb.append(", events=").append(this.events);
        sb.append(", priceOverrides=").append(this.priceOverrides);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subscription that = (Subscription)o;
        if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) {
            return false;
        }
        if (this.billingEndDate != null ? this.billingEndDate.compareTo((ReadablePartial)that.billingEndDate) != 0 : that.billingEndDate != null) {
            return false;
        }
        if (this.billingPeriod != that.billingPeriod) {
            return false;
        }
        if (this.billingStartDate != null ? this.billingStartDate.compareTo((ReadablePartial)that.billingStartDate) != 0 : that.billingStartDate != null) {
            return false;
        }
        if (this.bundleId != null ? !this.bundleId.equals(that.bundleId) : that.bundleId != null) {
            return false;
        }
        if (this.cancelledDate != null ? this.cancelledDate.compareTo((ReadablePartial)that.cancelledDate) != 0 : that.cancelledDate != null) {
            return false;
        }
        if (this.chargedThroughDate != null ? this.chargedThroughDate.compareTo((ReadablePartial)that.chargedThroughDate) != 0 : that.chargedThroughDate != null) {
            return false;
        }
        if (this.events != null ? !this.events.equals(that.events) : that.events != null) {
            return false;
        }
        if (this.priceOverrides != null ? !this.priceOverrides.equals(that.priceOverrides) : that.priceOverrides != null) {
            return false;
        }
        if (this.externalKey != null ? !this.externalKey.equals(that.externalKey) : that.externalKey != null) {
            return false;
        }
        if (this.phaseType != that.phaseType) {
            return false;
        }
        if (this.priceList != null ? !this.priceList.equals(that.priceList) : that.priceList != null) {
            return false;
        }
        if (this.planName != null ? !this.planName.equals(that.planName) : that.planName != null) {
            return false;
        }
        if (this.productCategory != that.productCategory) {
            return false;
        }
        if (this.productName != null ? !this.productName.equals(that.productName) : that.productName != null) {
            return false;
        }
        if (this.sourceType != that.sourceType) {
            return false;
        }
        if (this.startDate != null ? this.startDate.compareTo((ReadablePartial)that.startDate) != 0 : that.startDate != null) {
            return false;
        }
        if (this.state != that.state) {
            return false;
        }
        if (this.subscriptionId != null ? !this.subscriptionId.equals(that.subscriptionId) : that.subscriptionId != null) {
            return false;
        }
        return !(this.billCycleDayLocal != null ? !this.billCycleDayLocal.equals(that.billCycleDayLocal) : that.billCycleDayLocal != null);
    }

    public int hashCode() {
        int result = this.accountId != null ? this.accountId.hashCode() : 0;
        result = 31 * result + (this.bundleId != null ? this.bundleId.hashCode() : 0);
        result = 31 * result + (this.subscriptionId != null ? this.subscriptionId.hashCode() : 0);
        result = 31 * result + (this.externalKey != null ? this.externalKey.hashCode() : 0);
        result = 31 * result + (this.startDate != null ? this.startDate.hashCode() : 0);
        result = 31 * result + (this.productName != null ? this.productName.hashCode() : 0);
        result = 31 * result + (this.productCategory != null ? this.productCategory.hashCode() : 0);
        result = 31 * result + (this.billingPeriod != null ? this.billingPeriod.hashCode() : 0);
        result = 31 * result + (this.phaseType != null ? this.phaseType.hashCode() : 0);
        result = 31 * result + (this.priceList != null ? this.priceList.hashCode() : 0);
        result = 31 * result + (this.planName != null ? this.planName.hashCode() : 0);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + (this.sourceType != null ? this.sourceType.hashCode() : 0);
        result = 31 * result + (this.cancelledDate != null ? this.cancelledDate.hashCode() : 0);
        result = 31 * result + (this.chargedThroughDate != null ? this.chargedThroughDate.hashCode() : 0);
        result = 31 * result + (this.billingStartDate != null ? this.billingStartDate.hashCode() : 0);
        result = 31 * result + (this.billingEndDate != null ? this.billingEndDate.hashCode() : 0);
        result = 31 * result + (this.billCycleDayLocal != null ? this.billCycleDayLocal.hashCode() : 0);
        result = 31 * result + (this.events != null ? this.events.hashCode() : 0);
        result = 31 * result + (this.priceOverrides != null ? this.priceOverrides.hashCode() : 0);
        return result;
    }
}

