/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.callcontext;

import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.killbill.billing.callcontext.CallContextBase;
import org.killbill.billing.util.callcontext.CallOrigin;
import org.killbill.billing.util.callcontext.UserType;
import org.killbill.clock.Clock;

public class DefaultCallContext
extends CallContextBase {
    private final DateTime createdDate;
    private final DateTime updateDate;

    public DefaultCallContext(UUID tenantId, String userName, CallOrigin callOrigin, UserType userType, UUID userToken, Clock clock) {
        super(tenantId, userName, callOrigin, userType, userToken);
        this.updateDate = this.createdDate = clock.getUTCNow();
    }

    public DefaultCallContext(UUID tenantId, String userName, CallOrigin callOrigin, UserType userType, String reasonCode, String comment, UUID userToken, Clock clock) {
        super(tenantId, userName, callOrigin, userType, reasonCode, comment, userToken);
        this.updateDate = this.createdDate = clock.getUTCNow();
    }

    public DefaultCallContext(UUID tenantId, String userName, DateTime createdDate, String reasonCode, String comment, UUID userToken) {
        super(tenantId, userName, null, null, reasonCode, comment, userToken);
        this.createdDate = createdDate;
        this.updateDate = createdDate;
    }

    public DefaultCallContext(UUID tenantId, String userName, CallOrigin callOrigin, UserType userType, String reasonCode, String comment, UUID userToken, DateTime createdDate, DateTime updatedDate) {
        super(tenantId, userName, callOrigin, userType, reasonCode, comment, userToken);
        this.createdDate = createdDate;
        this.updateDate = updatedDate;
    }

    public DateTime getCreatedDate() {
        return this.createdDate;
    }

    public DateTime getUpdatedDate() {
        return this.createdDate;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CallContextBase");
        sb.append("{userToken=").append(this.userToken);
        sb.append(", userName='").append(this.userName).append('\'');
        sb.append(", callOrigin=").append(this.callOrigin);
        sb.append(", userType=").append(this.userType);
        sb.append(", reasonCode='").append(this.reasonCode).append('\'');
        sb.append(", comments='").append(this.comments).append('\'');
        sb.append(", createdDate='").append(this.createdDate).append('\'');
        sb.append(", updatedDate='").append(this.createdDate).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultCallContext that = (DefaultCallContext)o;
        if (this.callOrigin != that.callOrigin) {
            return false;
        }
        if (this.comments != null ? !this.comments.equals(that.comments) : that.comments != null) {
            return false;
        }
        if (this.reasonCode != null ? !this.reasonCode.equals(that.reasonCode) : that.reasonCode != null) {
            return false;
        }
        if (this.userName != null ? !this.userName.equals(that.userName) : that.userName != null) {
            return false;
        }
        if (this.userToken != null ? !this.userToken.equals(that.userToken) : that.userToken != null) {
            return false;
        }
        if (this.createdDate != null ? this.createdDate.compareTo((ReadableInstant)that.createdDate) != 0 : that.createdDate != null) {
            return false;
        }
        return this.userType == that.userType;
    }

    public int hashCode() {
        int result = this.userToken != null ? this.userToken.hashCode() : 0;
        result = 31 * result + (this.userName != null ? this.userName.hashCode() : 0);
        result = 31 * result + (this.callOrigin != null ? this.callOrigin.hashCode() : 0);
        result = 31 * result + (this.userType != null ? this.userType.hashCode() : 0);
        result = 31 * result + (this.reasonCode != null ? this.reasonCode.hashCode() : 0);
        result = 31 * result + (this.comments != null ? this.comments.hashCode() : 0);
        result = 31 * result + (this.createdDate != null ? this.createdDate.hashCode() : 0);
        return result;
    }
}

