/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.callcontext;

import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.killbill.billing.callcontext.DefaultCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.CallOrigin;
import org.killbill.billing.util.callcontext.UserType;

public class InternalCallContext
extends InternalTenantContext {
    private final UUID userToken;
    private final String createdBy;
    private final String updatedBy;
    private final CallOrigin callOrigin;
    private final UserType contextUserType;
    private final String reasonCode;
    private final String comments;
    private final DateTime createdDate;
    private final DateTime updatedDate;

    public InternalCallContext(Long tenantRecordId, @Nullable Long accountRecordId, @Nullable DateTimeZone fixedOffsetTimeZone, @Nullable DateTime referenceDateTime, UUID userToken, String userName, CallOrigin callOrigin, UserType userType, String reasonCode, String comment, DateTime createdDate, DateTime updatedDate) {
        super(tenantRecordId, accountRecordId, fixedOffsetTimeZone, referenceDateTime);
        this.userToken = userToken;
        this.createdBy = userName;
        this.updatedBy = userName;
        this.callOrigin = callOrigin;
        this.contextUserType = userType;
        this.reasonCode = reasonCode;
        this.comments = comment;
        this.createdDate = createdDate;
        this.updatedDate = updatedDate;
    }

    public InternalCallContext(Long tenantRecordId, CallContext callContext, DateTime utcNow) {
        this(tenantRecordId, null, null, null, callContext.getUserToken(), callContext.getUserName(), callContext.getCallOrigin(), callContext.getUserType(), callContext.getReasonCode(), callContext.getComments(), utcNow, utcNow);
    }

    public InternalCallContext(InternalCallContext context, Long accountRecordId, DateTimeZone fixedOffsetTimeZone, DateTime referenceDateTime, DateTime utcNow) {
        this(context.getTenantRecordId(), accountRecordId, fixedOffsetTimeZone, referenceDateTime, context.getUserToken(), context.getCreatedBy(), context.getCallOrigin(), context.getContextUserType(), context.getReasonCode(), context.getComments(), utcNow, utcNow);
    }

    public InternalCallContext(InternalCallContext context, DateTime updatedDate) {
        this(context.getTenantRecordId(), context.getAccountRecordId(), context.getFixedOffsetTimeZone(), context.getReferenceDateTime(), context.getUserToken(), context.getCreatedBy(), context.getCallOrigin(), context.getContextUserType(), context.getReasonCode(), context.getComments(), context.getCreatedDate(), updatedDate);
    }

    public CallContext toCallContext(UUID tenantId) {
        return new DefaultCallContext(tenantId, this.createdBy, this.callOrigin, this.contextUserType, this.reasonCode, this.comments, this.userToken, this.createdDate, this.updatedDate);
    }

    public UUID getUserToken() {
        return this.userToken;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public CallOrigin getCallOrigin() {
        return this.callOrigin;
    }

    public UserType getContextUserType() {
        return this.contextUserType;
    }

    public String getReasonCode() {
        return this.reasonCode;
    }

    public String getComments() {
        return this.comments;
    }

    public DateTime getCreatedDate() {
        return this.createdDate;
    }

    public DateTime getUpdatedDate() {
        return this.updatedDate;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("InternalCallContext");
        sb.append("{userToken=").append(this.userToken);
        sb.append(", createdBy='").append(this.createdBy).append('\'');
        sb.append(", updatedBy='").append(this.updatedBy).append('\'');
        sb.append(", callOrigin=").append(this.callOrigin);
        sb.append(", contextUserType=").append(this.contextUserType);
        sb.append(", reasonCode='").append(this.reasonCode).append('\'');
        sb.append(", comments='").append(this.comments).append('\'');
        sb.append(", createdDate=").append(this.createdDate);
        sb.append(", updatedDate=").append(this.updatedDate);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InternalCallContext that = (InternalCallContext)o;
        if (this.callOrigin != that.callOrigin) {
            return false;
        }
        if (this.comments != null ? !this.comments.equals(that.comments) : that.comments != null) {
            return false;
        }
        if (this.createdBy != null ? !this.createdBy.equals(that.createdBy) : that.createdBy != null) {
            return false;
        }
        if (this.createdDate != null ? !this.createdDate.equals((Object)that.createdDate) : that.createdDate != null) {
            return false;
        }
        if (this.reasonCode != null ? !this.reasonCode.equals(that.reasonCode) : that.reasonCode != null) {
            return false;
        }
        if (this.updatedBy != null ? !this.updatedBy.equals(that.updatedBy) : that.updatedBy != null) {
            return false;
        }
        if (this.updatedDate != null ? !this.updatedDate.equals((Object)that.updatedDate) : that.updatedDate != null) {
            return false;
        }
        if (this.userToken != null ? !this.userToken.equals(that.userToken) : that.userToken != null) {
            return false;
        }
        return this.contextUserType == that.contextUserType;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.userToken != null ? this.userToken.hashCode() : 0);
        result = 31 * result + (this.createdBy != null ? this.createdBy.hashCode() : 0);
        result = 31 * result + (this.updatedBy != null ? this.updatedBy.hashCode() : 0);
        result = 31 * result + (this.callOrigin != null ? this.callOrigin.hashCode() : 0);
        result = 31 * result + (this.contextUserType != null ? this.contextUserType.hashCode() : 0);
        result = 31 * result + (this.reasonCode != null ? this.reasonCode.hashCode() : 0);
        result = 31 * result + (this.comments != null ? this.comments.hashCode() : 0);
        result = 31 * result + (this.createdDate != null ? this.createdDate.hashCode() : 0);
        result = 31 * result + (this.updatedDate != null ? this.updatedDate.hashCode() : 0);
        return result;
    }
}

