/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.callcontext;

import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.killbill.billing.callcontext.DefaultTenantContext;
import org.killbill.billing.callcontext.TimeAwareContext;
import org.killbill.billing.util.callcontext.TenantContext;

public class InternalTenantContext
extends TimeAwareContext {
    protected final Long tenantRecordId;
    protected final Long accountRecordId;

    public InternalTenantContext(Long tenantRecordId, @Nullable Long accountRecordId, @Nullable DateTimeZone fixedOffsetTimeZone, @Nullable DateTime referenceDateTime) {
        super(fixedOffsetTimeZone, referenceDateTime);
        this.tenantRecordId = tenantRecordId;
        this.accountRecordId = accountRecordId;
    }

    public InternalTenantContext(Long defaultTenantRecordId) {
        this(defaultTenantRecordId, null, null, null);
    }

    public TenantContext toTenantContext(UUID tenantId) {
        return new DefaultTenantContext(tenantId);
    }

    public Long getAccountRecordId() {
        return this.accountRecordId;
    }

    public Long getTenantRecordId() {
        return this.tenantRecordId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("InternalTenantContext");
        sb.append("{accountRecordId=").append(this.getAccountRecordId());
        sb.append(", tenantRecordId=").append(this.getTenantRecordId());
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalTenantContext that = (InternalTenantContext)o;
        if (this.getAccountRecordId() != null ? !this.getAccountRecordId().equals(that.getAccountRecordId()) : that.getAccountRecordId() != null) {
            return false;
        }
        return !(this.getTenantRecordId() != null ? !this.getTenantRecordId().equals(that.getTenantRecordId()) : that.getTenantRecordId() != null);
    }

    public int hashCode() {
        int result = this.getAccountRecordId() != null ? this.getAccountRecordId().hashCode() : 0;
        result = 31 * result + (this.getTenantRecordId() != null ? this.getTenantRecordId().hashCode() : 0);
        return result;
    }
}

