/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.callcontext;

import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.killbill.clock.ClockUtil;

public class TimeAwareContext {
    private final DateTimeZone fixedOffsetTimeZone;
    private final DateTime referenceDateTime;
    private final LocalTime referenceTime;

    public TimeAwareContext(@Nullable DateTimeZone fixedOffsetTimeZone, @Nullable DateTime referenceDateTime) {
        this.fixedOffsetTimeZone = fixedOffsetTimeZone;
        this.referenceDateTime = referenceDateTime;
        this.referenceTime = this.computeReferenceTime(referenceDateTime);
    }

    public DateTime toUTCDateTime(LocalDate localDate) {
        this.validateContext();
        return ClockUtil.toUTCDateTime((LocalDate)localDate, (LocalTime)this.getReferenceTime(), (DateTimeZone)this.getFixedOffsetTimeZone());
    }

    public LocalDate toLocalDate(DateTime dateTime) {
        this.validateContext();
        return ClockUtil.toLocalDate((DateTime)dateTime, (DateTimeZone)this.getFixedOffsetTimeZone());
    }

    private void validateContext() {
        if (this.getFixedOffsetTimeZone() == null || this.getReferenceTime() == null) {
            throw new IllegalArgumentException(String.format("Context mis-configured: fixedOffsetTimeZone=%s, referenceTime=%s", this.getFixedOffsetTimeZone(), this.getReferenceTime()));
        }
    }

    DateTime getReferenceDateTime() {
        return this.referenceDateTime;
    }

    protected LocalTime computeReferenceTime(@Nullable DateTime referenceTime) {
        return referenceTime == null ? null : ClockUtil.toDateTime((DateTime)referenceTime, (DateTimeZone)this.getFixedOffsetTimeZone()).toLocalTime();
    }

    public DateTimeZone getFixedOffsetTimeZone() {
        return this.fixedOffsetTimeZone;
    }

    public LocalTime getReferenceTime() {
        return this.referenceTime;
    }
}

