/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.entity;

import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.killbill.billing.util.UUIDs;
import org.killbill.billing.util.entity.Entity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EntityBase
implements Entity {
    protected UUID id;
    protected DateTime createdDate;
    protected DateTime updatedDate;

    public EntityBase(UUID id) {
        this(id, null, null);
    }

    public EntityBase() {
        this(UUIDs.randomUUID(), null, null);
    }

    public EntityBase(UUID id, DateTime createdDate, DateTime updatedDate) {
        this.id = id;
        this.createdDate = createdDate;
        this.updatedDate = updatedDate;
    }

    public EntityBase(Entity target) {
        this.id = target.getId();
        this.createdDate = target.getCreatedDate();
        this.updatedDate = target.getUpdatedDate();
    }

    public UUID getId() {
        return this.id;
    }

    public DateTime getCreatedDate() {
        return this.createdDate;
    }

    public DateTime getUpdatedDate() {
        return this.updatedDate;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setCreatedDate(DateTime createdDate) {
        this.createdDate = createdDate;
    }

    public void setUpdatedDate(DateTime updatedDate) {
        this.updatedDate = updatedDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityBase that = (EntityBase)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.createdDate != null ? this.createdDate.compareTo((ReadableInstant)that.createdDate) != 0 : that.createdDate != null) {
            return false;
        }
        return !(this.updatedDate != null ? this.updatedDate.compareTo((ReadableInstant)that.updatedDate) != 0 : that.updatedDate != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.createdDate != null ? this.createdDate.hashCode() : 0);
        result = 31 * result + (this.updatedDate != null ? this.updatedDate.hashCode() : 0);
        return result;
    }

    protected <T> int safeCompareTo(Comparable<T> c1, T c2) {
        if (c1 == null && c2 == null) {
            return 0;
        }
        if (c1 == null) {
            return -1;
        }
        if (c2 == null) {
            return 1;
        }
        return c1.compareTo(c2);
    }
}

