/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.junction;

import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.killbill.billing.entitlement.api.BlockingState;
import org.killbill.billing.entitlement.api.BlockingStateType;
import org.killbill.billing.entity.EntityBase;
import org.killbill.billing.util.UUIDs;

public class DefaultBlockingState
extends EntityBase
implements BlockingState {
    private final UUID blockedId;
    private final String stateName;
    private final String service;
    private final boolean blockChange;
    private final boolean blockEntitlement;
    private final boolean blockBilling;
    private final DateTime effectiveDate;
    private final BlockingStateType type;
    private final Long totalOrdering;

    public DefaultBlockingState(UUID id, UUID blockedId, BlockingStateType type, String stateName, String service, boolean blockChange, boolean blockEntitlement, boolean blockBilling, DateTime effectiveDate, DateTime createDate, DateTime updatedDate, Long totalOrdering) {
        super(id, createDate, updatedDate);
        this.blockedId = blockedId;
        this.type = type;
        this.stateName = stateName;
        this.service = service;
        this.blockChange = blockChange;
        this.blockEntitlement = blockEntitlement;
        this.blockBilling = blockBilling;
        this.effectiveDate = effectiveDate;
        this.totalOrdering = totalOrdering;
    }

    public DefaultBlockingState(UUID blockedId, BlockingStateType type, String stateName, String service, boolean blockChange, boolean blockEntitlement, boolean blockBilling, DateTime effectiveDate) {
        this(UUIDs.randomUUID(), blockedId, type, stateName, service, blockChange, blockEntitlement, blockBilling, effectiveDate, null, null, 0L);
    }

    public DefaultBlockingState(BlockingState input, DateTime effectiveDate) {
        this(input.getBlockedId(), input.getType(), input.getStateName(), input.getService(), input.isBlockChange(), input.isBlockEntitlement(), input.isBlockBilling(), effectiveDate);
    }

    public UUID getBlockedId() {
        return this.blockedId;
    }

    public String getStateName() {
        return this.stateName;
    }

    public BlockingStateType getType() {
        return this.type;
    }

    public DateTime getEffectiveDate() {
        return this.effectiveDate;
    }

    public String getService() {
        return this.service;
    }

    public boolean isBlockChange() {
        return this.blockChange;
    }

    public boolean isBlockEntitlement() {
        return this.blockEntitlement;
    }

    public boolean isBlockBilling() {
        return this.blockBilling;
    }

    public Long getTotalOrdering() {
        return this.totalOrdering;
    }

    public int compareTo(BlockingState arg0) {
        int comparison = this.effectiveDate.compareTo((ReadableInstant)arg0.getEffectiveDate());
        if (comparison == 0) {
            int comparison2 = this.createdDate.compareTo((ReadableInstant)arg0.getCreatedDate());
            if (comparison2 == 0 && arg0 instanceof DefaultBlockingState) {
                DefaultBlockingState other = (DefaultBlockingState)arg0;
                if (this.totalOrdering == null) {
                    return 1;
                }
                if (other.getTotalOrdering() == null) {
                    return -1;
                }
                return this.totalOrdering.compareTo(other.getTotalOrdering());
            }
            return comparison2;
        }
        return comparison;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultBlockingState that = (DefaultBlockingState)o;
        if (this.blockBilling != that.blockBilling) {
            return false;
        }
        if (this.blockChange != that.blockChange) {
            return false;
        }
        if (this.blockEntitlement != that.blockEntitlement) {
            return false;
        }
        if (this.blockedId != null ? !this.blockedId.equals(that.blockedId) : that.blockedId != null) {
            return false;
        }
        if (this.effectiveDate != null ? this.effectiveDate.compareTo((ReadableInstant)that.effectiveDate) != 0 : that.effectiveDate != null) {
            return false;
        }
        if (this.service != null ? !this.service.equals(that.service) : that.service != null) {
            return false;
        }
        if (this.stateName != null ? !this.stateName.equals(that.stateName) : that.stateName != null) {
            return false;
        }
        if (this.totalOrdering != null ? !this.totalOrdering.equals(that.totalOrdering) : that.totalOrdering != null) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.blockedId != null ? this.blockedId.hashCode() : 0);
        result = 31 * result + (this.stateName != null ? this.stateName.hashCode() : 0);
        result = 31 * result + (this.service != null ? this.service.hashCode() : 0);
        result = 31 * result + (this.blockChange ? 1 : 0);
        result = 31 * result + (this.blockEntitlement ? 1 : 0);
        result = 31 * result + (this.blockBilling ? 1 : 0);
        result = 31 * result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.totalOrdering != null ? this.totalOrdering.hashCode() : 0);
        return result;
    }

    public String getDescription() {
        String entitlement = this.onOff(this.isBlockEntitlement());
        String billing = this.onOff(this.isBlockBilling());
        String change = this.onOff(this.isBlockChange());
        return String.format("(Change: %s, Entitlement: %s, Billing: %s)", change, entitlement, billing);
    }

    private String onOff(boolean val) {
        if (val) {
            return "Off";
        }
        return "On";
    }

    public String toString() {
        return "BlockingState [blockedId=" + this.blockedId + ", stateName=" + this.stateName + ", service=" + this.service + ", blockChange=" + this.blockChange + ", blockEntitlement=" + this.blockEntitlement + ", blockBilling=" + this.blockBilling + ", effectiveDate=" + this.effectiveDate + "]";
    }
}

