/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.subscription.api;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.api.BillingActionPolicy;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.PlanPhasePriceOverride;
import org.killbill.billing.catalog.api.PlanPhaseSpecifier;
import org.killbill.billing.catalog.api.PlanSpecifier;
import org.killbill.billing.entitlement.api.BaseEntitlementWithAddOnsSpecifier;
import org.killbill.billing.entitlement.api.EntitlementAOStatusDryRun;
import org.killbill.billing.events.EffectiveSubscriptionInternalEvent;
import org.killbill.billing.invoice.api.DryRunArguments;
import org.killbill.billing.subscription.api.SubscriptionBase;
import org.killbill.billing.subscription.api.SubscriptionBaseWithAddOns;
import org.killbill.billing.subscription.api.user.SubscriptionBaseApiException;
import org.killbill.billing.subscription.api.user.SubscriptionBaseBundle;
import org.killbill.billing.util.entity.Pagination;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface SubscriptionBaseInternalApi {
    public SubscriptionBase createSubscription(UUID var1, PlanPhaseSpecifier var2, List<PlanPhasePriceOverride> var3, DateTime var4, boolean var5, InternalCallContext var6) throws SubscriptionBaseApiException;

    public List<SubscriptionBaseWithAddOns> createBaseSubscriptionsWithAddOns(UUID var1, Iterable<BaseEntitlementWithAddOnsSpecifier> var2, InternalCallContext var3) throws SubscriptionBaseApiException;

    public void cancelBaseSubscriptions(Iterable<SubscriptionBase> var1, BillingActionPolicy var2, int var3, InternalCallContext var4) throws SubscriptionBaseApiException;

    public SubscriptionBaseBundle createBundleForAccount(UUID var1, String var2, InternalCallContext var3) throws SubscriptionBaseApiException;

    public List<SubscriptionBaseBundle> getBundlesForAccountAndKey(UUID var1, String var2, InternalTenantContext var3) throws SubscriptionBaseApiException;

    public List<SubscriptionBaseBundle> getBundlesForAccount(UUID var1, InternalTenantContext var2);

    public List<SubscriptionBaseBundle> getBundlesForKey(String var1, InternalTenantContext var2);

    public Pagination<SubscriptionBaseBundle> getBundles(Long var1, Long var2, InternalTenantContext var3);

    public Pagination<SubscriptionBaseBundle> searchBundles(String var1, Long var2, Long var3, InternalTenantContext var4);

    public Iterable<UUID> getNonAOSubscriptionIdsForKey(String var1, InternalTenantContext var2);

    public List<SubscriptionBase> getSubscriptionsForBundle(UUID var1, DryRunArguments var2, InternalTenantContext var3) throws SubscriptionBaseApiException;

    public Map<UUID, List<SubscriptionBase>> getSubscriptionsForAccount(InternalTenantContext var1) throws SubscriptionBaseApiException;

    public SubscriptionBase getBaseSubscription(UUID var1, InternalTenantContext var2) throws SubscriptionBaseApiException;

    public SubscriptionBase getSubscriptionFromId(UUID var1, InternalTenantContext var2) throws SubscriptionBaseApiException;

    public SubscriptionBaseBundle getBundleFromId(UUID var1, InternalTenantContext var2) throws SubscriptionBaseApiException;

    public UUID getAccountIdFromSubscriptionId(UUID var1, InternalTenantContext var2) throws SubscriptionBaseApiException;

    public void setChargedThroughDate(UUID var1, DateTime var2, InternalCallContext var3) throws SubscriptionBaseApiException;

    public List<EffectiveSubscriptionInternalEvent> getAllTransitions(SubscriptionBase var1, InternalTenantContext var2);

    public List<EffectiveSubscriptionInternalEvent> getBillingTransitions(SubscriptionBase var1, InternalTenantContext var2);

    public DateTime getDryRunChangePlanEffectiveDate(SubscriptionBase var1, PlanSpecifier var2, DateTime var3, BillingActionPolicy var4, List<PlanPhasePriceOverride> var5, InternalCallContext var6) throws SubscriptionBaseApiException, CatalogApiException;

    public List<EntitlementAOStatusDryRun> getDryRunChangePlanStatus(UUID var1, @Nullable String var2, DateTime var3, InternalTenantContext var4) throws SubscriptionBaseApiException;

    public void updateExternalKey(UUID var1, String var2, InternalCallContext var3);

    public void updateBCD(UUID var1, int var2, @Nullable LocalDate var3, InternalCallContext var4) throws SubscriptionBaseApiException;

    public int getDefaultBillCycleDayLocal(Map<UUID, Integer> var1, SubscriptionBase var2, SubscriptionBase var3, PlanPhaseSpecifier var4, int var5, DateTime var6, InternalTenantContext var7) throws SubscriptionBaseApiException;
}

