/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import java.util.UUID;

public abstract class UUIDs {
    private static final ThreadLocal<Random> threadRandom = new ThreadLocal<Random>(){

        @Override
        protected Random initialValue() {
            return new LightSecureRandom();
        }
    };

    public static UUID randomUUID() {
        return UUIDs.rndUUIDv4();
    }

    public static void setRandom(Random random) {
        threadRandom.set(random);
    }

    public static Random getRandom() {
        return threadRandom.get();
    }

    private static UUID rndUUIDv4() {
        Random random = threadRandom.get();
        byte[] uuid = new byte[16];
        random.nextBytes(uuid);
        uuid[6] = (byte)(uuid[6] & 0xF);
        uuid[6] = (byte)(uuid[6] | 0x40);
        uuid[8] = (byte)(uuid[8] & 0x3F);
        uuid[8] = (byte)(uuid[8] | 0x80);
        long msb = 0L;
        msb = msb << 8 | (long)(uuid[0] & 0xFF);
        msb = msb << 8 | (long)(uuid[1] & 0xFF);
        msb = msb << 8 | (long)(uuid[2] & 0xFF);
        msb = msb << 8 | (long)(uuid[3] & 0xFF);
        msb = msb << 8 | (long)(uuid[4] & 0xFF);
        msb = msb << 8 | (long)(uuid[5] & 0xFF);
        msb = msb << 8 | (long)(uuid[6] & 0xFF);
        msb = msb << 8 | (long)(uuid[7] & 0xFF);
        long lsb = 0L;
        lsb = lsb << 8 | (long)(uuid[8] & 0xFF);
        lsb = lsb << 8 | (long)(uuid[9] & 0xFF);
        lsb = lsb << 8 | (long)(uuid[10] & 0xFF);
        lsb = lsb << 8 | (long)(uuid[11] & 0xFF);
        lsb = lsb << 8 | (long)(uuid[12] & 0xFF);
        lsb = lsb << 8 | (long)(uuid[13] & 0xFF);
        lsb = lsb << 8 | (long)(uuid[14] & 0xFF);
        lsb = lsb << 8 | (long)(uuid[15] & 0xFF);
        return new UUID(msb, lsb);
    }

    private static class DigestRandomGenerator {
        private static final long CYCLE_COUNT = 10L;
        private long stateCounter;
        private long seedCounter;
        private final MessageDigest digest;
        private byte[] state;
        private byte[] seed;

        private DigestRandomGenerator(MessageDigest digest) {
            this.digest = digest;
            this.seed = new byte[digest.getDigestLength()];
            this.seedCounter = 1L;
            this.state = new byte[digest.getDigestLength()];
            this.stateCounter = 1L;
        }

        int getDigestLength() {
            return this.digest.getDigestLength();
        }

        final void addSeedMaterial(byte[] inSeed) {
            this.digestUpdate(inSeed);
            this.digestUpdate(this.seed);
            this.seed = this.digest.digest();
        }

        final void addSeedMaterial(long rSeed) {
            this.digestAddCounter(rSeed);
            this.digestUpdate(this.seed);
            this.seed = this.digest.digest();
        }

        void nextBytes(byte[] bytes) {
            this.nextBytes(bytes, 0, bytes.length);
        }

        final void nextBytes(byte[] bytes, int start, int len) {
            int stateOff = 0;
            this.generateState();
            int end = start + len;
            for (int i = start; i != end; ++i) {
                if (stateOff == this.state.length) {
                    this.generateState();
                    stateOff = 0;
                }
                bytes[i] = this.state[stateOff++];
            }
        }

        private void cycleSeed() {
            this.digestUpdate(this.seed);
            this.digestAddCounter(this.seedCounter++);
            this.seed = this.digest.digest();
        }

        private void generateState() {
            this.digestAddCounter(this.stateCounter++);
            this.digestUpdate(this.state);
            this.digestUpdate(this.seed);
            this.state = this.digest.digest();
            if (this.stateCounter % 10L == 0L) {
                this.cycleSeed();
            }
        }

        private void digestAddCounter(long seed) {
            for (int i = 0; i != 8; ++i) {
                this.digest.update((byte)seed);
                seed >>>= 8;
            }
        }

        private void digestUpdate(byte[] inSeed) {
            this.digest.update(inSeed, 0, inSeed.length);
        }
    }

    private static class LightSecureRandom
    extends Random {
        private final DigestRandomGenerator generator;

        LightSecureRandom() {
            this(LightSecureRandom.sha1Generator());
            this.setSeed(SeederHolder.seeder.generateSeed(this.generator.getDigestLength()));
        }

        LightSecureRandom(byte[] inSeed) {
            this(LightSecureRandom.sha1Generator());
            this.setSeed(inSeed);
        }

        private LightSecureRandom(DigestRandomGenerator generator) {
            super(0L);
            this.generator = generator;
        }

        private static DigestRandomGenerator sha1Generator() {
            try {
                return new DigestRandomGenerator(MessageDigest.getInstance("SHA-1"));
            }
            catch (NoSuchAlgorithmException ex) {
                throw new Error("unexpeced missing SHA-1 digest", ex);
            }
        }

        public void setSeed(long seed) {
            if (seed != 0L) {
                this.generator.addSeedMaterial(seed);
            }
        }

        public void setSeed(byte[] seed) {
            this.generator.addSeedMaterial(seed);
        }

        public void nextBytes(byte[] bytes) {
            this.generator.nextBytes(bytes);
        }

        public int nextInt() {
            byte[] intBytes = new byte[4];
            this.nextBytes(intBytes);
            int result = 0;
            for (int i = 0; i < 4; ++i) {
                result = (result << 8) + (intBytes[i] & 0xFF);
            }
            return result;
        }

        protected final int next(int numBits) {
            int size = (numBits + 7) / 8;
            byte[] bytes = new byte[size];
            this.nextBytes(bytes);
            int result = 0;
            for (int i = 0; i < size; ++i) {
                result = (result << 8) + (bytes[i] & 0xFF);
            }
            return result & (1 << numBits) - 1;
        }

        private static abstract class SeederHolder {
            static final SecureRandom seeder;

            private SeederHolder() {
            }

            static {
                SecureRandom random;
                try {
                    random = SecureRandom.getInstance("SHA1PRNG");
                }
                catch (NoSuchAlgorithmException e) {
                    random = new SecureRandom();
                }
                seeder = random;
            }
        }
    }
}

