/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.killbill.billing.GuicyKillbillTestSuiteWithEmbeddedDB;
import org.killbill.billing.account.api.AccountInternalApi;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.invoice.InvoicePluginDispatcher;
import org.killbill.billing.invoice.ParkedAccountsManager;
import org.killbill.billing.invoice.TestInvoiceHelper;
import org.killbill.billing.invoice.TestInvoiceNotificationQListener;
import org.killbill.billing.invoice.api.DefaultInvoiceService;
import org.killbill.billing.invoice.api.InvoiceInternalApi;
import org.killbill.billing.invoice.api.InvoicePaymentApi;
import org.killbill.billing.invoice.api.InvoiceService;
import org.killbill.billing.invoice.api.InvoiceUserApi;
import org.killbill.billing.invoice.dao.InvoiceDao;
import org.killbill.billing.invoice.generator.InvoiceGenerator;
import org.killbill.billing.invoice.glue.TestInvoiceModuleWithEmbeddedDb;
import org.killbill.billing.invoice.notification.NextBillingDateNotifier;
import org.killbill.billing.junction.BillingInternalApi;
import org.killbill.billing.lifecycle.api.BusService;
import org.killbill.billing.platform.api.KillbillConfigSource;
import org.killbill.billing.subscription.api.SubscriptionBaseInternalApi;
import org.killbill.billing.util.api.TagUserApi;
import org.killbill.billing.util.cache.CacheControllerDispatcher;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.config.definition.InvoiceConfig;
import org.killbill.billing.util.dao.NonEntityDao;
import org.killbill.bus.api.PersistentBus;
import org.killbill.clock.ClockMock;
import org.killbill.commons.locker.GlobalLocker;
import org.killbill.notificationq.api.NotificationQueueService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;

public abstract class InvoiceTestSuiteWithEmbeddedDB
extends GuicyKillbillTestSuiteWithEmbeddedDB {
    private static final Logger log = LoggerFactory.getLogger(InvoiceTestSuiteWithEmbeddedDB.class);
    protected static final Currency accountCurrency = Currency.USD;
    @Inject
    protected InvoiceService invoiceService;
    @Inject
    protected PersistentBus bus;
    @Inject
    protected CacheControllerDispatcher controllerDispatcher;
    @Inject
    protected InvoiceUserApi invoiceUserApi;
    @Inject
    protected InvoicePaymentApi invoicePaymentApi;
    @Inject
    protected InvoiceGenerator generator;
    @Inject
    protected BillingInternalApi billingApi;
    @Inject
    protected AccountUserApi accountUserApi;
    @Inject
    protected AccountInternalApi accountApi;
    @Inject
    protected SubscriptionBaseInternalApi subscriptionApi;
    @Inject
    protected BusService busService;
    @Inject
    protected InvoiceDao invoiceDao;
    @Inject
    protected NonEntityDao nonEntityDao;
    @Inject
    protected TagUserApi tagUserApi;
    @Inject
    protected GlobalLocker locker;
    @Inject
    protected ClockMock clock;
    @Inject
    protected InternalCallContextFactory internalCallContextFactory;
    @Inject
    protected InvoiceInternalApi invoiceInternalApi;
    @Inject
    protected NextBillingDateNotifier nextBillingDateNotifier;
    @Inject
    protected NotificationQueueService notificationQueueService;
    @Inject
    protected TestInvoiceHelper invoiceUtil;
    @Inject
    protected TestInvoiceNotificationQListener testInvoiceNotificationQListener;
    @Inject
    protected InvoicePluginDispatcher invoicePluginDispatcher;
    @Inject
    protected InvoiceConfig invoiceConfig;
    @Inject
    protected ParkedAccountsManager parkedAccountsManager;

    protected KillbillConfigSource getConfigSource() {
        return this.getConfigSource("/resource.properties");
    }

    @BeforeClass(groups={"slow"})
    protected void beforeClass() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new TestInvoiceModuleWithEmbeddedDb(this.configSource)});
        injector.injectMembers((Object)this);
    }

    @BeforeMethod(groups={"slow"})
    public void beforeMethod() throws Exception {
        super.beforeMethod();
        this.controllerDispatcher.clearAll();
        this.bus.start();
        this.restartInvoiceService(this.invoiceService);
        this.clock.resetDeltaFromReality();
    }

    private void restartInvoiceService(InvoiceService invoiceService) throws Exception {
        ((DefaultInvoiceService)invoiceService).initialize();
        ((DefaultInvoiceService)invoiceService).start();
    }

    private void stopInvoiceService(InvoiceService invoiceService) throws Exception {
        ((DefaultInvoiceService)invoiceService).stop();
    }

    @AfterMethod(groups={"slow"})
    public void afterMethod() throws Exception {
        this.bus.stop();
        this.stopInvoiceService(this.invoiceService);
    }
}

