/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.invoice.InvoiceTestSuiteNoDB;
import org.killbill.billing.invoice.api.Invoice;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.invoice.api.formatters.InvoiceFormatterFactory;
import org.killbill.billing.invoice.template.HtmlInvoice;
import org.killbill.billing.invoice.template.HtmlInvoiceGenerator;
import org.killbill.billing.invoice.template.formatters.DefaultInvoiceFormatterFactory;
import org.killbill.billing.util.email.templates.MustacheTemplateEngine;
import org.killbill.billing.util.email.templates.TemplateEngine;
import org.killbill.billing.util.template.translation.TranslatorConfig;
import org.mockito.Mockito;
import org.skife.config.ConfigurationObjectFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestHtmlInvoiceGenerator
extends InvoiceTestSuiteNoDB {
    private HtmlInvoiceGenerator g;

    @BeforeClass(groups={"fast"})
    public void beforeClass() throws Exception {
        super.beforeClass();
        TranslatorConfig config = (TranslatorConfig)new ConfigurationObjectFactory(this.skifeConfigSource).build(TranslatorConfig.class);
        MustacheTemplateEngine templateEngine = new MustacheTemplateEngine();
        DefaultInvoiceFormatterFactory factory = new DefaultInvoiceFormatterFactory();
        this.g = new HtmlInvoiceGenerator((InvoiceFormatterFactory)factory, (TemplateEngine)templateEngine, config, null, this.resourceBundleFactory, null);
    }

    @Test(groups={"fast"})
    public void testGenerateInvoice() throws Exception {
        HtmlInvoice output = this.g.generateInvoice(this.createAccount(), this.createInvoice(), false, (InternalTenantContext)this.internalCallContext);
        Assert.assertNotNull((Object)output);
        Assert.assertNotNull((Object)output.getBody());
        Assert.assertEquals((String)output.getSubject(), (String)"Your invoice");
    }

    @Test(groups={"fast"})
    public void testGenerateEmptyInvoice() throws Exception {
        Invoice invoice = (Invoice)Mockito.mock(Invoice.class);
        HtmlInvoice output = this.g.generateInvoice(this.createAccount(), invoice, false, (InternalTenantContext)this.internalCallContext);
        Assert.assertNotNull((Object)output);
        Assert.assertNotNull((Object)output.getBody());
        Assert.assertEquals((String)output.getSubject(), (String)"Your invoice");
    }

    @Test(groups={"fast"})
    public void testGenerateNullInvoice() throws Exception {
        HtmlInvoice output = this.g.generateInvoice(this.createAccount(), null, false, (InternalTenantContext)this.internalCallContext);
        Assert.assertNull((Object)output);
    }

    private Account createAccount() {
        Account account = (Account)Mockito.mock(Account.class);
        Mockito.when((Object)account.getExternalKey()).thenReturn((Object)"1234abcd");
        Mockito.when((Object)account.getName()).thenReturn((Object)"Jim Smith");
        Mockito.when((Object)account.getFirstNameLength()).thenReturn((Object)3);
        Mockito.when((Object)account.getEmail()).thenReturn((Object)"jim.smith@mail.com");
        Mockito.when((Object)account.getLocale()).thenReturn((Object)Locale.US.toString());
        Mockito.when((Object)account.getAddress1()).thenReturn((Object)"123 Some Street");
        Mockito.when((Object)account.getAddress2()).thenReturn((Object)"Apt 456");
        Mockito.when((Object)account.getCity()).thenReturn((Object)"Some City");
        Mockito.when((Object)account.getStateOrProvince()).thenReturn((Object)"Some State");
        Mockito.when((Object)account.getPostalCode()).thenReturn((Object)"12345-6789");
        Mockito.when((Object)account.getCountry()).thenReturn((Object)"USA");
        Mockito.when((Object)account.getPhone()).thenReturn((Object)"123-456-7890");
        return account;
    }

    private Invoice createInvoice() {
        LocalDate startDate = new LocalDate((Object)new DateTime().minusMonths(1), DateTimeZone.UTC);
        LocalDate endDate = new LocalDate(DateTimeZone.UTC);
        BigDecimal price1 = new BigDecimal("29.95");
        BigDecimal price2 = new BigDecimal("59.95");
        Invoice dummyInvoice = (Invoice)Mockito.mock(Invoice.class);
        Mockito.when((Object)dummyInvoice.getInvoiceDate()).thenReturn((Object)startDate);
        Mockito.when((Object)dummyInvoice.getInvoiceNumber()).thenReturn((Object)42);
        Mockito.when((Object)dummyInvoice.getCurrency()).thenReturn((Object)Currency.USD);
        Mockito.when((Object)dummyInvoice.getChargedAmount()).thenReturn((Object)price1.add(price2));
        Mockito.when((Object)dummyInvoice.getPaidAmount()).thenReturn((Object)BigDecimal.ZERO);
        Mockito.when((Object)dummyInvoice.getBalance()).thenReturn((Object)price1.add(price2));
        ArrayList<InvoiceItem> items = new ArrayList<InvoiceItem>();
        items.add(this.createInvoiceItem(price1, "Domain 1", startDate, endDate, "ning-plus"));
        items.add(this.createInvoiceItem(price2, "Domain 2", startDate, endDate, "ning-pro"));
        Mockito.when((Object)dummyInvoice.getInvoiceItems()).thenReturn(items);
        return dummyInvoice;
    }

    private InvoiceItem createInvoiceItem(BigDecimal amount, String networkName, LocalDate startDate, LocalDate endDate, String planName) {
        InvoiceItem item = (InvoiceItem)Mockito.mock(InvoiceItem.class);
        Mockito.when((Object)item.getAmount()).thenReturn((Object)amount);
        Mockito.when((Object)item.getStartDate()).thenReturn((Object)startDate);
        Mockito.when((Object)item.getEndDate()).thenReturn((Object)endDate);
        Mockito.when((Object)item.getPlanName()).thenReturn((Object)planName);
        Mockito.when((Object)item.getDescription()).thenReturn((Object)networkName);
        return item;
    }
}

