/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.MockPlan;
import org.killbill.billing.catalog.MockPlanPhase;
import org.killbill.billing.catalog.api.BillingMode;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.PhaseType;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.invoice.InvoiceDispatcher;
import org.killbill.billing.invoice.InvoiceTestSuiteWithEmbeddedDB;
import org.killbill.billing.invoice.MockBillingEventSet;
import org.killbill.billing.invoice.TestInvoiceHelper;
import org.killbill.billing.invoice.api.DryRunArguments;
import org.killbill.billing.invoice.api.Invoice;
import org.killbill.billing.invoice.api.InvoiceApiException;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.invoice.api.InvoiceItemType;
import org.killbill.billing.invoice.api.InvoiceNotifier;
import org.killbill.billing.invoice.dao.InvoiceItemModelDao;
import org.killbill.billing.invoice.dao.InvoiceModelDao;
import org.killbill.billing.invoice.notification.NullInvoiceNotifier;
import org.killbill.billing.subscription.api.SubscriptionBase;
import org.killbill.billing.subscription.api.SubscriptionBaseTransitionType;
import org.killbill.billing.subscription.api.user.SubscriptionBaseApiException;
import org.killbill.billing.util.api.TagDefinitionApiException;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.tag.Tag;
import org.killbill.billing.util.tag.dao.SystemTags;
import org.killbill.clock.Clock;
import org.mockito.Mockito;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestInvoiceDispatcher
extends InvoiceTestSuiteWithEmbeddedDB {
    private Account account;
    private SubscriptionBase subscription;
    private InternalCallContext context;
    private InvoiceDispatcher dispatcher;

    @BeforeMethod(groups={"slow"})
    public void beforeMethod() throws Exception {
        super.beforeMethod();
        this.account = this.invoiceUtil.createAccount(this.callContext);
        this.subscription = this.invoiceUtil.createSubscription();
        this.context = this.internalCallContextFactory.createInternalCallContext(this.account.getId(), this.callContext);
        NullInvoiceNotifier invoiceNotifier = new NullInvoiceNotifier();
        this.dispatcher = new InvoiceDispatcher(this.generator, this.accountApi, this.billingApi, this.subscriptionApi, this.invoiceDao, this.internalCallContextFactory, (InvoiceNotifier)invoiceNotifier, this.invoicePluginDispatcher, this.locker, this.busService.getBus(), this.notificationQueueService, this.invoiceConfig, (Clock)this.clock, this.parkedAccountsManager);
    }

    @Test(groups={"slow"})
    public void testDryRunInvoice() throws InvoiceApiException, AccountApiException, CatalogApiException, SubscriptionBaseApiException {
        UUID accountId = this.account.getId();
        MockBillingEventSet events = new MockBillingEventSet();
        MockPlan plan = MockPlan.createBicycleNoTrialEvergreen1USD();
        MockPlanPhase planPhase = MockPlanPhase.create1USDMonthlyEvergreen();
        DateTime effectiveDate = this.clock.getUTCNow().minusDays(1);
        Currency currency = Currency.USD;
        BigDecimal fixedPrice = null;
        events.add(this.invoiceUtil.createMockBillingEvent(this.account, this.subscription, effectiveDate, (Plan)plan, (PlanPhase)planPhase, fixedPrice, BigDecimal.ONE, currency, BillingPeriod.MONTHLY, 1, BillingMode.IN_ADVANCE, "", 1L, SubscriptionBaseTransitionType.CREATE));
        Mockito.when((Object)this.billingApi.getBillingEventsForAccountAndUpdateAccountBCD((UUID)Mockito.any(), (DryRunArguments)Mockito.any(), (InternalCallContext)Mockito.any())).thenReturn((Object)events);
        LocalDate target = this.internalCallContext.toLocalDate(effectiveDate);
        NullInvoiceNotifier invoiceNotifier = new NullInvoiceNotifier();
        Invoice invoice = this.dispatcher.processAccountFromNotificationOrBusEvent(accountId, target, (DryRunArguments)new TestInvoiceHelper.DryRunFutureDateArguments(), this.context);
        Assert.assertNotNull((Object)invoice);
        List invoices = this.invoiceDao.getInvoicesByAccount((InternalTenantContext)this.context);
        Assert.assertEquals((int)invoices.size(), (int)0);
        invoice = this.dispatcher.processAccountFromNotificationOrBusEvent(accountId, target, (DryRunArguments)new TestInvoiceHelper.DryRunFutureDateArguments(), this.context);
        Assert.assertNotNull((Object)invoice);
        invoices = this.invoiceDao.getInvoicesByAccount((InternalTenantContext)this.context);
        Assert.assertEquals((int)invoices.size(), (int)0);
        invoice = this.dispatcher.processAccountFromNotificationOrBusEvent(accountId, target, null, this.context);
        Assert.assertNotNull((Object)invoice);
        invoices = this.invoiceDao.getInvoicesByAccount((InternalTenantContext)this.context);
        Assert.assertEquals((int)invoices.size(), (int)1);
    }

    @Test(groups={"slow"})
    public void testWithParking() throws InvoiceApiException, AccountApiException, CatalogApiException, SubscriptionBaseApiException, TagDefinitionApiException {
        UUID accountId = this.account.getId();
        MockBillingEventSet events = new MockBillingEventSet();
        MockPlan plan = MockPlan.createBicycleNoTrialEvergreen1USD();
        MockPlanPhase planPhase = MockPlanPhase.create1USDMonthlyEvergreen();
        DateTime effectiveDate = this.clock.getUTCNow().minusDays(1);
        Currency currency = Currency.USD;
        BigDecimal fixedPrice = null;
        events.add(this.invoiceUtil.createMockBillingEvent(this.account, this.subscription, effectiveDate, (Plan)plan, (PlanPhase)planPhase, fixedPrice, BigDecimal.ONE, currency, BillingPeriod.MONTHLY, 1, BillingMode.IN_ADVANCE, "", 1L, SubscriptionBaseTransitionType.CREATE));
        Mockito.when((Object)this.billingApi.getBillingEventsForAccountAndUpdateAccountBCD((UUID)Mockito.any(), (DryRunArguments)Mockito.any(), (InternalCallContext)Mockito.any())).thenReturn((Object)events);
        LocalDate target = this.internalCallContext.toLocalDate(effectiveDate);
        NullInvoiceNotifier invoiceNotifier = new NullInvoiceNotifier();
        Assert.assertTrue((boolean)this.tagUserApi.getTagsForAccount(accountId, true, (TenantContext)this.callContext).isEmpty());
        InvoiceModelDao invoiceModelDao = new InvoiceModelDao(accountId, target, target, currency, false);
        InvoiceItemModelDao invoiceItemModelDao1 = new InvoiceItemModelDao(this.clock.getUTCNow(), InvoiceItemType.RECURRING, invoiceModelDao.getId(), accountId, this.subscription.getBundleId(), this.subscription.getId(), "Bad data", plan.getName(), planPhase.getName(), null, effectiveDate.toLocalDate(), effectiveDate.plusMonths(1).toLocalDate(), BigDecimal.TEN, BigDecimal.ONE, currency, null);
        InvoiceItemModelDao invoiceItemModelDao2 = new InvoiceItemModelDao(this.clock.getUTCNow(), InvoiceItemType.RECURRING, invoiceModelDao.getId(), accountId, this.subscription.getBundleId(), this.subscription.getId(), "Bad data", plan.getName(), planPhase.getName(), null, effectiveDate.plusDays(1).toLocalDate(), effectiveDate.plusMonths(1).toLocalDate(), BigDecimal.TEN, BigDecimal.ONE, currency, null);
        invoiceModelDao.addInvoiceItem(invoiceItemModelDao1);
        invoiceModelDao.addInvoiceItem(invoiceItemModelDao2);
        this.invoiceDao.createInvoices((List)ImmutableList.of((Object)invoiceModelDao), this.context);
        try {
            this.dispatcher.processAccountFromNotificationOrBusEvent(accountId, target, (DryRunArguments)new TestInvoiceHelper.DryRunFutureDateArguments(), this.context);
            Assert.fail();
        }
        catch (InvoiceApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.UNEXPECTED_ERROR.getCode());
            Assert.assertTrue((boolean)e.getCause().getMessage().startsWith("Double billing detected"));
        }
        Assert.assertEquals((int)this.invoiceDao.getInvoicesByAccount((InternalTenantContext)this.context).size(), (int)1);
        Assert.assertTrue((boolean)this.tagUserApi.getTagsForAccount(accountId, true, (TenantContext)this.callContext).isEmpty());
        try {
            this.dispatcher.processAccountFromNotificationOrBusEvent(accountId, target, null, this.context);
            Assert.fail();
        }
        catch (InvoiceApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.UNEXPECTED_ERROR.getCode());
            Assert.assertTrue((boolean)e.getCause().getMessage().startsWith("Double billing detected"));
        }
        Assert.assertEquals((int)this.invoiceDao.getInvoicesByAccount((InternalTenantContext)this.context).size(), (int)1);
        List tags = this.tagUserApi.getTagsForAccount(accountId, false, (TenantContext)this.callContext);
        Assert.assertEquals((int)tags.size(), (int)1);
        Assert.assertEquals((Object)((Tag)tags.get(0)).getTagDefinitionId(), (Object)SystemTags.PARK_TAG_DEFINITION_ID);
        Invoice nullInvoice1 = this.dispatcher.processAccountFromNotificationOrBusEvent(accountId, target, null, this.context);
        Assert.assertNull((Object)nullInvoice1);
        try {
            this.dispatcher.processAccount(true, accountId, target, null, this.context);
            Assert.fail();
        }
        catch (InvoiceApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.UNEXPECTED_ERROR.getCode());
            Assert.assertTrue((boolean)e.getCause().getMessage().startsWith("Double billing detected"));
        }
        Assert.assertEquals((int)this.invoiceDao.getInvoicesByAccount((InternalTenantContext)this.context).size(), (int)1);
        Assert.assertEquals((Collection)this.tagUserApi.getTagsForAccount(accountId, false, (TenantContext)this.callContext), (Collection)tags);
        this.dbi.withHandle((HandleCallback)new HandleCallback<Void>(){

            public Void withHandle(Handle handle) throws Exception {
                handle.execute("delete from invoices", new Object[0]);
                handle.execute("delete from invoice_items", new Object[0]);
                return null;
            }
        });
        Invoice nullInvoice2 = this.dispatcher.processAccountFromNotificationOrBusEvent(accountId, target, (DryRunArguments)new TestInvoiceHelper.DryRunFutureDateArguments(), this.context);
        Assert.assertNull((Object)nullInvoice2);
        Invoice invoice1 = this.dispatcher.processAccount(true, accountId, target, (DryRunArguments)new TestInvoiceHelper.DryRunFutureDateArguments(), this.context);
        Assert.assertNotNull((Object)invoice1);
        Assert.assertEquals((int)this.invoiceDao.getInvoicesByAccount((InternalTenantContext)this.context).size(), (int)0);
        Assert.assertEquals((int)this.tagUserApi.getTagsForAccount(accountId, false, (TenantContext)this.callContext).size(), (int)1);
        Invoice invoice2 = this.dispatcher.processAccount(true, accountId, target, null, this.context);
        Assert.assertNotNull((Object)invoice2);
        Assert.assertEquals((int)this.invoiceDao.getInvoicesByAccount((InternalTenantContext)this.context).size(), (int)1);
        Assert.assertEquals((int)this.tagUserApi.getTagsForAccount(accountId, false, (TenantContext)this.callContext).size(), (int)0);
        Assert.assertEquals((int)this.tagUserApi.getTagsForAccount(accountId, true, (TenantContext)this.callContext).size(), (int)1);
    }

    @Test(groups={"slow"})
    public void testWithOverdueEvents() throws Exception {
        MockBillingEventSet events = new MockBillingEventSet();
        MockPlan bicycleTrialEvergreen1USD = MockPlan.createBicycleTrialEvergreen1USD();
        events.add(this.invoiceUtil.createMockBillingEvent(this.account, this.subscription, new DateTime((Object)"2012-05-01T00:03:42.000Z"), (Plan)bicycleTrialEvergreen1USD, (PlanPhase)new MockPlanPhase((Plan)bicycleTrialEvergreen1USD, PhaseType.TRIAL), BigDecimal.ZERO, null, this.account.getCurrency(), BillingPeriod.NO_BILLING_PERIOD, 31, BillingMode.IN_ADVANCE, "CREATE", 1L, SubscriptionBaseTransitionType.CREATE));
        events.add(this.invoiceUtil.createMockBillingEvent(this.account, this.subscription, new DateTime((Object)"2012-05-31T00:03:42.000Z"), (Plan)bicycleTrialEvergreen1USD, (PlanPhase)new MockPlanPhase((Plan)bicycleTrialEvergreen1USD, PhaseType.EVERGREEN), null, new BigDecimal("249.95"), this.account.getCurrency(), BillingPeriod.MONTHLY, 31, BillingMode.IN_ADVANCE, "PHASE", 2L, SubscriptionBaseTransitionType.PHASE));
        events.add(this.invoiceUtil.createMockBillingEvent(this.account, this.subscription, new DateTime((Object)"2012-07-15T00:00:00.000Z"), (Plan)bicycleTrialEvergreen1USD, (PlanPhase)new MockPlanPhase((Plan)bicycleTrialEvergreen1USD, PhaseType.EVERGREEN), null, null, this.account.getCurrency(), BillingPeriod.NO_BILLING_PERIOD, 31, BillingMode.IN_ADVANCE, "", 0L, SubscriptionBaseTransitionType.START_BILLING_DISABLED));
        events.add(this.invoiceUtil.createMockBillingEvent(this.account, this.subscription, new DateTime((Object)"2012-07-25T00:00:00.000Z"), (Plan)bicycleTrialEvergreen1USD, (PlanPhase)new MockPlanPhase((Plan)bicycleTrialEvergreen1USD, PhaseType.EVERGREEN), null, new BigDecimal("249.95"), this.account.getCurrency(), BillingPeriod.MONTHLY, 31, BillingMode.IN_ADVANCE, "", 1L, SubscriptionBaseTransitionType.END_BILLING_DISABLED));
        MockPlan jetTrialEvergreen1000USD = MockPlan.createJetTrialEvergreen1000USD();
        events.add(this.invoiceUtil.createMockBillingEvent(this.account, this.subscription, new DateTime((Object)"2012-07-25T00:04:00.000Z"), (Plan)jetTrialEvergreen1000USD, (PlanPhase)new MockPlanPhase((Plan)jetTrialEvergreen1000USD, PhaseType.EVERGREEN), null, new BigDecimal("1000"), this.account.getCurrency(), BillingPeriod.MONTHLY, 31, BillingMode.IN_ADVANCE, "CHANGE", 3L, SubscriptionBaseTransitionType.CHANGE));
        Mockito.when((Object)this.billingApi.getBillingEventsForAccountAndUpdateAccountBCD((UUID)Mockito.any(), (DryRunArguments)Mockito.any(), (InternalCallContext)Mockito.any())).thenReturn((Object)events);
        Invoice invoice = this.dispatcher.processAccountFromNotificationOrBusEvent(this.account.getId(), new LocalDate((Object)"2012-07-30"), null, this.context);
        Assert.assertNotNull((Object)invoice);
        List invoiceItems = invoice.getInvoiceItems();
        Assert.assertEquals((int)invoiceItems.size(), (int)4);
        Assert.assertEquals((Object)((InvoiceItem)invoiceItems.get(0)).getInvoiceItemType(), (Object)InvoiceItemType.FIXED);
        Assert.assertEquals((Object)((InvoiceItem)invoiceItems.get(0)).getStartDate(), (Object)new LocalDate((Object)"2012-05-01"));
        Assert.assertNull((Object)((InvoiceItem)invoiceItems.get(0)).getEndDate());
        Assert.assertEquals((int)((InvoiceItem)invoiceItems.get(0)).getAmount().compareTo(BigDecimal.ZERO), (int)0);
        Assert.assertNull((Object)((InvoiceItem)invoiceItems.get(0)).getRate());
        Assert.assertEquals((Object)((InvoiceItem)invoiceItems.get(1)).getInvoiceItemType(), (Object)InvoiceItemType.RECURRING);
        Assert.assertEquals((Object)((InvoiceItem)invoiceItems.get(1)).getStartDate(), (Object)new LocalDate((Object)"2012-05-31"));
        Assert.assertEquals((Object)((InvoiceItem)invoiceItems.get(1)).getEndDate(), (Object)new LocalDate((Object)"2012-06-30"));
        Assert.assertEquals((Object)((InvoiceItem)invoiceItems.get(1)).getAmount(), (Object)new BigDecimal("249.95"));
        Assert.assertEquals((Object)((InvoiceItem)invoiceItems.get(1)).getRate(), (Object)new BigDecimal("249.95"));
        Assert.assertEquals((Object)((InvoiceItem)invoiceItems.get(2)).getInvoiceItemType(), (Object)InvoiceItemType.RECURRING);
        Assert.assertEquals((Object)((InvoiceItem)invoiceItems.get(2)).getStartDate(), (Object)new LocalDate((Object)"2012-06-30"));
        Assert.assertEquals((Object)((InvoiceItem)invoiceItems.get(2)).getEndDate(), (Object)new LocalDate((Object)"2012-07-15"));
        Assert.assertEquals((Object)((InvoiceItem)invoiceItems.get(2)).getAmount(), (Object)new BigDecimal("124.98"));
        Assert.assertEquals((Object)((InvoiceItem)invoiceItems.get(2)).getRate(), (Object)new BigDecimal("249.95"));
        Assert.assertEquals((Object)((InvoiceItem)invoiceItems.get(3)).getInvoiceItemType(), (Object)InvoiceItemType.RECURRING);
        Assert.assertEquals((Object)((InvoiceItem)invoiceItems.get(3)).getStartDate(), (Object)new LocalDate((Object)"2012-07-25"));
        Assert.assertEquals((Object)((InvoiceItem)invoiceItems.get(3)).getEndDate(), (Object)new LocalDate((Object)"2012-07-31"));
        Assert.assertEquals((Object)((InvoiceItem)invoiceItems.get(3)).getAmount(), (Object)new BigDecimal("193.55"));
        Assert.assertEquals((Object)((InvoiceItem)invoiceItems.get(3)).getRate(), (Object)new BigDecimal("1000"));
        for (InvoiceItem item : invoiceItems) {
            Assert.assertEquals((Object)item.getAccountId(), (Object)this.account.getId());
            Assert.assertEquals((Object)item.getBundleId(), (Object)this.subscription.getBundleId());
            Assert.assertEquals((Object)item.getCurrency(), (Object)this.account.getCurrency());
            Assert.assertEquals((Object)item.getInvoiceId(), (Object)invoice.getId());
            Assert.assertNull((Object)item.getLinkedItemId());
            Assert.assertEquals((Object)item.getSubscriptionId(), (Object)this.subscription.getId());
        }
    }
}

