/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.killbill.billing.GuicyKillbillTestSuite;
import org.killbill.billing.GuicyKillbillTestSuiteNoDB;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.account.api.AccountData;
import org.killbill.billing.account.api.AccountInternalApi;
import org.killbill.billing.account.api.AccountUserApi;
import org.killbill.billing.account.api.ImmutableAccountInternalApi;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.callcontext.MutableInternalCallContext;
import org.killbill.billing.catalog.MockPlan;
import org.killbill.billing.catalog.MockPlanPhase;
import org.killbill.billing.catalog.api.BillingActionPolicy;
import org.killbill.billing.catalog.api.BillingMode;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.PlanPhasePriceOverride;
import org.killbill.billing.catalog.api.PlanPhaseSpecifier;
import org.killbill.billing.catalog.api.Usage;
import org.killbill.billing.entitlement.api.SubscriptionEventType;
import org.killbill.billing.entity.EntityPersistenceException;
import org.killbill.billing.invoice.InvoiceDispatcher;
import org.killbill.billing.invoice.InvoicePluginDispatcher;
import org.killbill.billing.invoice.MockBillingEventSet;
import org.killbill.billing.invoice.ParkedAccountsManager;
import org.killbill.billing.invoice.api.DryRunArguments;
import org.killbill.billing.invoice.api.DryRunType;
import org.killbill.billing.invoice.api.Invoice;
import org.killbill.billing.invoice.api.InvoiceApiException;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.invoice.api.InvoiceNotifier;
import org.killbill.billing.invoice.api.InvoicePayment;
import org.killbill.billing.invoice.dao.InvoiceDao;
import org.killbill.billing.invoice.dao.InvoiceItemModelDao;
import org.killbill.billing.invoice.dao.InvoiceItemSqlDao;
import org.killbill.billing.invoice.dao.InvoiceModelDao;
import org.killbill.billing.invoice.dao.InvoiceModelDaoHelper;
import org.killbill.billing.invoice.dao.InvoicePaymentModelDao;
import org.killbill.billing.invoice.dao.InvoicePaymentSqlDao;
import org.killbill.billing.invoice.dao.InvoiceSqlDao;
import org.killbill.billing.invoice.generator.InvoiceGenerator;
import org.killbill.billing.invoice.notification.NullInvoiceNotifier;
import org.killbill.billing.junction.BillingEvent;
import org.killbill.billing.junction.BillingInternalApi;
import org.killbill.billing.lifecycle.api.BusService;
import org.killbill.billing.mock.MockAccountBuilder;
import org.killbill.billing.subscription.api.SubscriptionBase;
import org.killbill.billing.subscription.api.SubscriptionBaseInternalApi;
import org.killbill.billing.subscription.api.SubscriptionBaseTransitionType;
import org.killbill.billing.subscription.api.user.SubscriptionBaseApiException;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.config.definition.InvoiceConfig;
import org.killbill.billing.util.dao.NonEntityDao;
import org.killbill.billing.util.entity.dao.EntityModelDao;
import org.killbill.clock.Clock;
import org.killbill.commons.locker.GlobalLocker;
import org.killbill.notificationq.api.NotificationQueueService;
import org.mockito.Mockito;
import org.skife.jdbi.v2.IDBI;
import org.testng.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestInvoiceHelper {
    public static final Currency accountCurrency = Currency.USD;
    public static final BigDecimal ZERO = new BigDecimal("0.0").setScale(9);
    public static final BigDecimal ONE_HALF = new BigDecimal("0.5").setScale(9);
    public static final BigDecimal ONE = new BigDecimal("1.0").setScale(9);
    public static final BigDecimal ONE_AND_A_HALF = new BigDecimal("1.5").setScale(9);
    public static final BigDecimal TWO = new BigDecimal("2.0").setScale(9);
    public static final BigDecimal THREE = new BigDecimal("3.0").setScale(9);
    public static final BigDecimal FOUR = new BigDecimal("4.0").setScale(9);
    public static final BigDecimal FIVE = new BigDecimal("5.0").setScale(9);
    public static final BigDecimal SIX = new BigDecimal("6.0").setScale(9);
    public static final BigDecimal SEVEN = new BigDecimal("7.0").setScale(9);
    public static final BigDecimal EIGHT = new BigDecimal("8.0").setScale(9);
    public static final BigDecimal TEN = new BigDecimal("10.0").setScale(9);
    public static final BigDecimal ELEVEN = new BigDecimal("11.0").setScale(9);
    public static final BigDecimal TWELVE = new BigDecimal("12.0").setScale(9);
    public static final BigDecimal THIRTEEN = new BigDecimal("13.0").setScale(9);
    public static final BigDecimal FOURTEEN = new BigDecimal("14.0").setScale(9);
    public static final BigDecimal FIFTEEN = new BigDecimal("15.0").setScale(9);
    public static final BigDecimal NINETEEN = new BigDecimal("19.0").setScale(9);
    public static final BigDecimal TWENTY = new BigDecimal("20.0").setScale(9);
    public static final BigDecimal TWENTY_FOUR = new BigDecimal("24.0").setScale(9);
    public static final BigDecimal TWENTY_FIVE = new BigDecimal("25.0").setScale(9);
    public static final BigDecimal TWENTY_EIGHT = new BigDecimal("28.0").setScale(9);
    public static final BigDecimal TWENTY_NINE = new BigDecimal("29.0").setScale(9);
    public static final BigDecimal THIRTY = new BigDecimal("30.0").setScale(9);
    public static final BigDecimal THIRTY_ONE = new BigDecimal("31.0").setScale(9);
    public static final BigDecimal THIRTY_THREE = new BigDecimal("33.0").setScale(9);
    public static final BigDecimal FORTY = new BigDecimal("40.0").setScale(9);
    public static final BigDecimal FORTY_SEVEN = new BigDecimal("47.0").setScale(9);
    public static final BigDecimal SIXTY_SIX = new BigDecimal("66.0").setScale(9);
    public static final BigDecimal SEVENTY_FIVE = new BigDecimal("75.0").setScale(9);
    public static final BigDecimal EIGHTY_NINE = new BigDecimal("89.0").setScale(9);
    public static final BigDecimal NINETY = new BigDecimal("90.0").setScale(9);
    public static final BigDecimal NINETY_ONE = new BigDecimal("91.0").setScale(9);
    public static final BigDecimal NINETY_TWO = new BigDecimal("92.0").setScale(9);
    public static final BigDecimal ONE_HUNDRED = new BigDecimal("100.0").setScale(9);
    public static final BigDecimal THREE_HUNDRED_AND_FOURTY_NINE = new BigDecimal("349.0").setScale(9);
    public static final BigDecimal THREE_HUNDRED_AND_FIFTY_FOUR = new BigDecimal("354.0").setScale(9);
    public static final BigDecimal THREE_HUNDRED_AND_SIXTY_FIVE = new BigDecimal("365.0").setScale(9);
    public static final BigDecimal THREE_HUNDRED_AND_SIXTY_SIX = new BigDecimal("366.0").setScale(9);
    private final InvoiceGenerator generator;
    private final BillingInternalApi billingApi;
    private final AccountInternalApi accountApi;
    private final ImmutableAccountInternalApi immutableAccountApi;
    private final InvoicePluginDispatcher invoicePluginDispatcher;
    private final AccountUserApi accountUserApi;
    private final SubscriptionBaseInternalApi subscriptionApi;
    private final BusService busService;
    private final InvoiceDao invoiceDao;
    private final GlobalLocker locker;
    private final Clock clock;
    private final NonEntityDao nonEntityDao;
    private final ParkedAccountsManager parkedAccountsManager;
    private final MutableInternalCallContext internalCallContext;
    private final InternalCallContextFactory internalCallContextFactory;
    private final InvoiceConfig invoiceConfig;
    private final NotificationQueueService notificationQueueService;
    private final InvoicePaymentSqlDao invoicePaymentSqlDao;
    private final InvoiceItemSqlDao invoiceItemSqlDao;
    private final InvoiceSqlDao invoiceSqlDao;

    @Inject
    public TestInvoiceHelper(InvoiceGenerator generator, IDBI dbi, BillingInternalApi billingApi, AccountInternalApi accountApi, ImmutableAccountInternalApi immutableAccountApi, InvoicePluginDispatcher invoicePluginDispatcher, AccountUserApi accountUserApi, SubscriptionBaseInternalApi subscriptionApi, BusService busService, InvoiceDao invoiceDao, GlobalLocker locker, Clock clock, NonEntityDao nonEntityDao, NotificationQueueService notificationQueueService, MutableInternalCallContext internalCallContext, InvoiceConfig invoiceConfig, ParkedAccountsManager parkedAccountsManager, InternalCallContextFactory internalCallContextFactory) {
        this.generator = generator;
        this.billingApi = billingApi;
        this.accountApi = accountApi;
        this.immutableAccountApi = immutableAccountApi;
        this.invoicePluginDispatcher = invoicePluginDispatcher;
        this.accountUserApi = accountUserApi;
        this.subscriptionApi = subscriptionApi;
        this.busService = busService;
        this.invoiceDao = invoiceDao;
        this.locker = locker;
        this.clock = clock;
        this.nonEntityDao = nonEntityDao;
        this.notificationQueueService = notificationQueueService;
        this.parkedAccountsManager = parkedAccountsManager;
        this.internalCallContext = internalCallContext;
        this.internalCallContextFactory = internalCallContextFactory;
        this.invoiceSqlDao = (InvoiceSqlDao)dbi.onDemand(InvoiceSqlDao.class);
        this.invoiceItemSqlDao = (InvoiceItemSqlDao)dbi.onDemand(InvoiceItemSqlDao.class);
        this.invoicePaymentSqlDao = (InvoicePaymentSqlDao)dbi.onDemand(InvoicePaymentSqlDao.class);
        this.invoiceConfig = invoiceConfig;
    }

    public UUID generateRegularInvoice(Account account, LocalDate targetDate, CallContext callContext) throws Exception {
        BigDecimal fixedPrice = null;
        BigDecimal recurringPrice = BigDecimal.ONE;
        return this.generateRegularInvoice(account, fixedPrice, recurringPrice, targetDate, callContext);
    }

    public UUID generateRegularInvoice(Account account, BigDecimal fixedPrice, BigDecimal recurringPrice, LocalDate targetDate, CallContext callContext) throws Exception {
        SubscriptionBase subscription = (SubscriptionBase)Mockito.mock(SubscriptionBase.class);
        Mockito.when((Object)subscription.getId()).thenReturn((Object)UUID.randomUUID());
        Mockito.when((Object)subscription.getBundleId()).thenReturn((Object)new UUID(0L, 0L));
        MockBillingEventSet events = new MockBillingEventSet();
        MockPlan plan = MockPlan.createBicycleNoTrialEvergreen1USD();
        MockPlanPhase planPhase = MockPlanPhase.create1USDMonthlyEvergreen();
        DateTime effectiveDate = new DateTime().minusDays(1);
        Currency currency = Currency.USD;
        events.add(this.createMockBillingEvent(account, subscription, effectiveDate, (Plan)plan, (PlanPhase)planPhase, fixedPrice, recurringPrice, currency, BillingPeriod.MONTHLY, 1, BillingMode.IN_ADVANCE, "", 1L, SubscriptionBaseTransitionType.CREATE));
        Mockito.when((Object)this.billingApi.getBillingEventsForAccountAndUpdateAccountBCD((UUID)Mockito.any(), (DryRunArguments)Mockito.any(), (InternalCallContext)Mockito.any())).thenReturn((Object)events);
        InternalCallContext context = this.internalCallContextFactory.createInternalCallContext(account.getId(), callContext);
        Invoice invoice = this.generateInvoice(account.getId(), targetDate, new DryRunFutureDateArguments(), context);
        Assert.assertNotNull((Object)invoice);
        List invoices = this.invoiceDao.getInvoicesByAccount((InternalTenantContext)context);
        Assert.assertEquals((int)invoices.size(), (int)0);
        invoice = this.generateInvoice(account.getId(), targetDate, null, context);
        Assert.assertNotNull((Object)invoice);
        invoices = this.invoiceDao.getInvoicesByAccount((InternalTenantContext)context);
        Assert.assertEquals((int)invoices.size(), (int)1);
        return invoice.getId();
    }

    public Invoice generateInvoice(UUID accountId, @Nullable LocalDate targetDate, @Nullable DryRunArguments dryRunArguments, InternalCallContext internalCallContext) throws InvoiceApiException {
        NullInvoiceNotifier invoiceNotifier = new NullInvoiceNotifier();
        InvoiceDispatcher dispatcher = new InvoiceDispatcher(this.generator, this.accountApi, this.billingApi, this.subscriptionApi, this.invoiceDao, this.internalCallContextFactory, (InvoiceNotifier)invoiceNotifier, this.invoicePluginDispatcher, this.locker, this.busService.getBus(), this.notificationQueueService, this.invoiceConfig, this.clock, this.parkedAccountsManager);
        return dispatcher.processAccountFromNotificationOrBusEvent(accountId, targetDate, dryRunArguments, internalCallContext);
    }

    public SubscriptionBase createSubscription() throws SubscriptionBaseApiException {
        UUID uuid = UUID.randomUUID();
        UUID bundleId = UUID.randomUUID();
        SubscriptionBase subscription = (SubscriptionBase)Mockito.mock(SubscriptionBase.class);
        Mockito.when((Object)subscription.getId()).thenReturn((Object)uuid);
        Mockito.when((Object)subscription.getBundleId()).thenReturn((Object)bundleId);
        Mockito.when((Object)this.subscriptionApi.getSubscriptionFromId((UUID)Mockito.any(), (InternalTenantContext)Mockito.any())).thenReturn((Object)subscription);
        return subscription;
    }

    public Account createAccount(CallContext callContext) throws AccountApiException {
        Account accountData = new MockAccountBuilder().name(UUID.randomUUID().toString().substring(1, 8)).firstNameLength(6).email(UUID.randomUUID().toString().substring(1, 8)).phone(UUID.randomUUID().toString().substring(1, 8)).migrated(false).isNotifiedForInvoices(true).externalKey(UUID.randomUUID().toString().substring(1, 8)).billingCycleDayLocal(31).currency(accountCurrency).paymentMethodId(UUID.randomUUID()).timeZone(DateTimeZone.UTC).createdDate(this.clock.getUTCNow()).build();
        Account account = this.isFastTest() ? GuicyKillbillTestSuiteNoDB.createMockAccount((Account)accountData, (AccountUserApi)this.accountUserApi, (AccountInternalApi)this.accountApi, (ImmutableAccountInternalApi)this.immutableAccountApi, (NonEntityDao)this.nonEntityDao, (Clock)this.clock, (InternalCallContextFactory)this.internalCallContextFactory, (CallContext)callContext, (MutableInternalCallContext)this.internalCallContext) : this.accountUserApi.createAccount((AccountData)accountData, callContext);
        GuicyKillbillTestSuite.refreshCallContext((UUID)account.getId(), (Clock)this.clock, (InternalCallContextFactory)this.internalCallContextFactory, (TenantContext)callContext, (MutableInternalCallContext)this.internalCallContext);
        return account;
    }

    public void createInvoiceItem(InvoiceItem invoiceItem, InternalCallContext internalCallContext) throws EntityPersistenceException {
        this.invoiceItemSqlDao.create((EntityModelDao)new InvoiceItemModelDao(invoiceItem), internalCallContext);
    }

    public InvoiceItemModelDao getInvoiceItemById(UUID invoiceItemId, InternalCallContext internalCallContext) {
        return (InvoiceItemModelDao)this.invoiceItemSqlDao.getById(invoiceItemId.toString(), (InternalTenantContext)internalCallContext);
    }

    public List<InvoiceItemModelDao> getInvoiceItemBySubscriptionId(UUID subscriptionId, InternalCallContext internalCallContext) {
        return this.invoiceItemSqlDao.getInvoiceItemsBySubscription(subscriptionId.toString(), (InternalTenantContext)internalCallContext);
    }

    public List<InvoiceItemModelDao> getInvoiceItemByAccountId(InternalCallContext internalCallContext) {
        return this.invoiceItemSqlDao.getByAccountRecordId((InternalTenantContext)internalCallContext);
    }

    public List<InvoiceItemModelDao> getInvoiceItemByInvoiceId(UUID invoiceId, InternalCallContext internalCallContext) {
        return this.invoiceItemSqlDao.getInvoiceItemsByInvoice(invoiceId.toString(), (InternalTenantContext)internalCallContext);
    }

    public void createInvoice(Invoice invoice, InternalCallContext internalCallContext) throws EntityPersistenceException {
        InvoiceModelDao invoiceModelDao = new InvoiceModelDao(invoice);
        ImmutableList invoiceItemModelDaos = ImmutableList.copyOf((Collection)Collections2.transform((Collection)invoice.getInvoiceItems(), (Function)new Function<InvoiceItem, InvoiceItemModelDao>(){

            public InvoiceItemModelDao apply(InvoiceItem input) {
                return new InvoiceItemModelDao(input);
            }
        }));
        this.invoiceSqlDao.create((EntityModelDao)invoiceModelDao, internalCallContext);
        for (InvoiceItem invoiceItem : invoice.getInvoiceItems()) {
            this.createInvoiceItem(invoiceItem, internalCallContext);
        }
    }

    public void createPayment(InvoicePayment invoicePayment, InternalCallContext internalCallContext) {
        try {
            this.invoicePaymentSqlDao.create((EntityModelDao)new InvoicePaymentModelDao(invoicePayment), internalCallContext);
        }
        catch (EntityPersistenceException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public void verifyInvoice(UUID invoiceId, double balance, double cbaAmount, InternalTenantContext context) throws InvoiceApiException {
        InvoiceModelDao invoice = (InvoiceModelDao)this.invoiceDao.getById(invoiceId, context);
        Assert.assertEquals((Object)InvoiceModelDaoHelper.getRawBalanceForRegularInvoice((InvoiceModelDao)invoice).doubleValue(), (Object)balance);
        Assert.assertEquals((Object)InvoiceModelDaoHelper.getCBAAmount((InvoiceModelDao)invoice).doubleValue(), (Object)cbaAmount);
    }

    public void checkInvoicesEqual(InvoiceModelDao retrievedInvoice, Invoice invoice) {
        Assert.assertEquals((Object)retrievedInvoice.getId(), (Object)invoice.getId());
        Assert.assertEquals((Object)retrievedInvoice.getAccountId(), (Object)invoice.getAccountId());
        Assert.assertEquals((Object)retrievedInvoice.getCurrency(), (Object)invoice.getCurrency());
        Assert.assertEquals((Object)retrievedInvoice.getInvoiceDate(), (Object)invoice.getInvoiceDate());
        Assert.assertEquals((Object)retrievedInvoice.getTargetDate(), (Object)invoice.getTargetDate());
        Assert.assertEquals((int)retrievedInvoice.getInvoiceItems().size(), (int)invoice.getInvoiceItems().size());
        Assert.assertEquals((int)retrievedInvoice.getInvoicePayments().size(), (int)invoice.getPayments().size());
    }

    public LocalDate buildDate(int year, int month, int day) {
        return new LocalDate(year, month, day);
    }

    public BillingEvent createMockBillingEvent(@Nullable Account account, final SubscriptionBase subscription, final DateTime effectiveDate, final Plan plan, final PlanPhase planPhase, final @Nullable BigDecimal fixedPrice, final @Nullable BigDecimal recurringPrice, final Currency currency, final BillingPeriod billingPeriod, final int billCycleDayLocal, BillingMode billingMode, final String description, final long totalOrdering, final SubscriptionBaseTransitionType type) {
        Account mockAccount = (Account)Mockito.mock(Account.class);
        Mockito.when((Object)mockAccount.getTimeZone()).thenReturn((Object)DateTimeZone.UTC);
        return new BillingEvent(){

            public int getBillCycleDayLocal() {
                return billCycleDayLocal;
            }

            public SubscriptionBase getSubscription() {
                return subscription;
            }

            public DateTime getEffectiveDate() {
                return effectiveDate;
            }

            public PlanPhase getPlanPhase() {
                return planPhase;
            }

            public Plan getPlan() {
                return plan;
            }

            public BillingPeriod getBillingPeriod() {
                return billingPeriod;
            }

            public String getDescription() {
                return description;
            }

            public BigDecimal getFixedPrice() {
                return fixedPrice;
            }

            public BigDecimal getRecurringPrice(DateTime effectiveDate2) {
                return recurringPrice;
            }

            public Currency getCurrency() {
                return currency;
            }

            public SubscriptionBaseTransitionType getTransitionType() {
                return type;
            }

            public Long getTotalOrdering() {
                return totalOrdering;
            }

            public List<Usage> getUsages() {
                return Collections.emptyList();
            }

            public int compareTo(BillingEvent e1) {
                if (!this.getSubscription().getId().equals(e1.getSubscription().getId())) {
                    return this.getSubscription().getId().compareTo(e1.getSubscription().getId());
                }
                if (!this.getEffectiveDate().equals((Object)e1.getEffectiveDate())) {
                    return this.getEffectiveDate().compareTo((ReadableInstant)e1.getEffectiveDate());
                }
                return this.getTotalOrdering().compareTo(e1.getTotalOrdering());
            }
        };
    }

    private boolean isFastTest() {
        return Mockito.mockingDetails((Object)this.accountApi).isMock();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DryRunFutureDateArguments
    implements DryRunArguments {
        public DryRunType getDryRunType() {
            return DryRunType.TARGET_DATE;
        }

        public PlanPhaseSpecifier getPlanPhaseSpecifier() {
            return null;
        }

        public SubscriptionEventType getAction() {
            return null;
        }

        public UUID getSubscriptionId() {
            return null;
        }

        public LocalDate getEffectiveDate() {
            return null;
        }

        public UUID getBundleId() {
            return null;
        }

        public BillingActionPolicy getBillingActionPolicy() {
            return null;
        }

        public List<PlanPhasePriceOverride> getPlanPhasePriceOverrides() {
            return null;
        }
    }
}

